/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.graphstream.stream.file.FileSinkBase;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.stylesheet.Rule;
import org.graphstream.ui.graphicGraph.stylesheet.StyleSheet;

public class FileSinkUnstyledSVG
extends FileSinkBase {
    protected PrintWriter out;
    protected HashMap<String, Point3> nodePos = new HashMap();

    @Override
    public void end() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    @Override
    protected void outputHeader() throws IOException {
        this.out = (PrintWriter)this.output;
        this.out.printf("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>%n", new Object[0]);
        this.out.printf("<svg xmlns:svg=\"http://www.w3.org/2000/svg\" width=\"100%%\" height=\"100%%\">%n", new Object[0]);
    }

    @Override
    protected void outputEndOfFile() throws IOException {
        this.outputNodes();
        this.out.printf("</svg>%n", new Object[0]);
    }

    @Override
    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
    }

    @Override
    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
    }

    @Override
    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) {
    }

    @Override
    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void graphAttributeRemoved(String graphId, long timeId, String attribute) {
    }

    @Override
    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        this.setNodePos(nodeId, attribute, value);
    }

    @Override
    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.setNodePos(nodeId, attribute, newValue);
    }

    @Override
    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) {
    }

    @Override
    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        Point3 p0 = this.nodePos.get(fromNodeId);
        Point3 p1 = this.nodePos.get(toNodeId);
        if (p0 != null && p1 != null) {
            this.out.printf("  <g id=\"%s\">%n", edgeId);
            this.out.printf("    <line x1=\"%f\" y1=\"%f\" x2=\"%f\" y2=\"%f\"/>%n", p0.x, p0.y, p1.x, p1.y);
            this.out.printf("  </g>%n", new Object[0]);
        }
    }

    @Override
    public void edgeRemoved(String graphId, long timeId, String edgeId) {
    }

    @Override
    public void graphCleared(String graphId, long timeId) {
    }

    @Override
    public void nodeAdded(String graphId, long timeId, String nodeId) {
        this.nodePos.put(nodeId, new Point3());
    }

    @Override
    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        this.nodePos.remove(nodeId);
    }

    @Override
    public void stepBegins(String graphId, long timeId, double time) {
    }

    protected void setNodePos(String nodeId, String attribute, Object value) {
        double z;
        double y;
        double x;
        Point3 p = this.nodePos.get(nodeId);
        if (p == null) {
            x = Math.random();
            y = Math.random();
            z = 0.0;
        } else {
            x = p.x;
            y = p.y;
            z = p.z;
        }
        if (attribute.equals("x")) {
            if (value instanceof Number) {
                x = ((Number)value).floatValue();
            }
        } else if (attribute.equals("y")) {
            if (value instanceof Number) {
                y = ((Number)value).floatValue();
            }
        } else if (attribute.equals("z")) {
            if (value instanceof Number) {
                z = ((Number)value).floatValue();
            }
        } else if (attribute.equals("xy")) {
            Object[] xy;
            if (value instanceof Object[] && (xy = (Object[])value).length > 1) {
                x = ((Number)xy[0]).floatValue();
                y = ((Number)xy[1]).floatValue();
            }
        } else if (attribute.equals("xyz") && value instanceof Object[]) {
            Object[] xyz = (Object[])value;
            if (xyz.length > 1) {
                x = ((Number)xyz[0]).floatValue();
                y = ((Number)xyz[1]).floatValue();
            }
            if (xyz.length > 2) {
                z = ((Number)xyz[2]).floatValue();
            }
        }
        this.nodePos.put(nodeId, new Point3(x, y, z));
    }

    protected void outputStyle(String styleSheet) {
        String style = null;
        if (styleSheet != null) {
            StyleSheet ssheet = new StyleSheet();
            try {
                if (styleSheet.startsWith("url(")) {
                    styleSheet = styleSheet.substring(5);
                    int pos = styleSheet.lastIndexOf(41);
                    styleSheet = styleSheet.substring(0, pos);
                    ssheet.parseFromFile(styleSheet);
                } else {
                    ssheet.parseFromString(styleSheet);
                }
                style = this.styleSheetToSVG(ssheet);
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var3_3 = null;
            }
        }
        if (style == null) {
            style = "circle { fill: grey; stroke: none; } line { stroke-width: 1; stroke: black; }";
        }
        this.out.printf("<defs><style type=\"text/css\"><![CDATA[%n", new Object[0]);
        this.out.printf("    %s%n", style);
        this.out.printf("]]></style></defs>%n", new Object[0]);
    }

    protected void outputNodes() {
        for (String key : this.nodePos.keySet()) {
            Point3 pos = this.nodePos.get(key);
            this.out.printf("  <g id=\"%s\">%n", key);
            this.out.printf("    <circle cx=\"%f\" cy=\"%f\" r=\"4\"/>%n", pos.x, pos.y);
            this.out.printf("  </g>%n", new Object[0]);
        }
    }

    protected String styleSheetToSVG(StyleSheet sheet) {
        StringBuilder out = new StringBuilder();
        this.addRule(out, sheet.getDefaultGraphRule());
        return out.toString();
    }

    protected void addRule(StringBuilder out, Rule rule) {
    }

    protected static enum What {
        NODE,
        EDGE,
        OTHER;

    }
}

