/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.modules.releve.model.Field;
import genj.gedcom.PropertySex;
import java.util.ResourceBundle;

public class FieldSex
extends Field {
    public static String unknownLabel = ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.label.Unknown");
    public static String maleLabel = ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.label.Male");
    public static String femaleLabel = ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.label.Female");
    public static final int UNKNOWN = 0;
    public static final int MALE = 1;
    public static final int FEMALE = 2;
    public static final String UNKNOWN_STRING = "";
    public static final String MALE_STRING = "M";
    public static final String FEMALE_STRING = "F";
    private int sex = 0;

    @Override
    public String getValue() {
        if (this.sex == 1) {
            return MALE_STRING;
        }
        if (this.sex == 2) {
            return FEMALE_STRING;
        }
        return UNKNOWN_STRING;
    }

    @Override
    public void setValue(String value) {
        String newValue = value.toUpperCase();
        this.sex = maleLabel.toUpperCase().equals(newValue) || MALE_STRING.equals(newValue) || "MALE".equals(newValue) ? 1 : (femaleLabel.toUpperCase().equals(newValue) || FEMALE_STRING.equals(newValue) || "FEMALE".equals(newValue) ? 2 : 0);
    }

    public String toString() {
        switch (this.sex) {
            case 1: {
                return maleLabel;
            }
            case 2: {
                return femaleLabel;
            }
        }
        return unknownLabel;
    }

    @Override
    public boolean equalsProperty(Object that) {
        if (that instanceof PropertySex) {
            PropertySex propertySex = (PropertySex)that;
            return this.sex == propertySex.getSex();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public static String convertValue(int intValue) {
        if (intValue == 1) {
            return MALE_STRING;
        }
        if (intValue == 2) {
            return FEMALE_STRING;
        }
        return UNKNOWN_STRING;
    }

    public static String getOppositeString(String inValue) {
        if (MALE_STRING.equals(inValue)) {
            return FEMALE_STRING;
        }
        if (FEMALE_STRING.equals(inValue)) {
            return FEMALE_STRING;
        }
        return UNKNOWN_STRING;
    }
}

