/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <cairo.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpcolor/gimpcolor.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpimage-color-profile.h"
#include "core/gimpimage.h"
#include "core/gimpparamspecs.h"

#include "gimppdb.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
image_get_color_profile_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  GBytes *profile_data = NULL;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpColorProfile *profile;

      profile = gimp_image_get_color_profile (image);

      if (profile)
        {
          const guint8 *data;
          gsize         length;

          data = gimp_color_profile_get_icc_profile (profile, &length);

          profile_data = g_bytes_new (data, length);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_boxed (gimp_value_array_index (return_vals, 1), profile_data);

  return return_vals;
}

static GimpValueArray *
image_get_effective_color_profile_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  GBytes *profile_data = NULL;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpColorProfile *profile;

      profile = gimp_color_managed_get_color_profile (GIMP_COLOR_MANAGED (image));

      if (profile)
        {
          const guint8 *data;
          gsize         length;

          data = gimp_color_profile_get_icc_profile (profile, &length);

          profile_data = g_bytes_new (data, length);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_boxed (gimp_value_array_index (return_vals, 1), profile_data);

  return return_vals;
}

static GimpValueArray *
image_set_color_profile_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GBytes *color_profile;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  color_profile = g_value_get_boxed (gimp_value_array_index (args, 1));

  if (success)
    {
      if (color_profile)
        {
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_icc_profile (g_bytes_get_data (color_profile, NULL),
                                                             g_bytes_get_size (color_profile),
                                                             error);

          if (profile)
            {
              success = gimp_image_assign_color_profile (image, profile,
                                                         progress, error);
              g_object_unref (profile);
            }
          else
            success = FALSE;
        }
      else
        {
          success = gimp_image_assign_color_profile (image, NULL,
                                                     progress, error);
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_set_color_profile_from_file_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GFile *file;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  file = g_value_get_object (gimp_value_array_index (args, 1));

  if (success)
    {
      if (file)
        {
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_file (file, error);

          if (profile)
            {
              success = gimp_image_assign_color_profile (image, profile,
                                                         progress, error);
              g_object_unref (profile);
            }
          else
            success = FALSE;
        }
      else
        {
          success = gimp_image_assign_color_profile (image, NULL,
                                                     progress, error);
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_get_simulation_profile_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  GBytes *profile_data = NULL;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpColorProfile *profile;

      profile = gimp_image_get_simulation_profile (image);

      if (profile)
        {
          const guint8 *data;
          gsize         length;

          data = gimp_color_profile_get_icc_profile (profile, &length);

          profile_data = g_bytes_new (data, length);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_boxed (gimp_value_array_index (return_vals, 1), profile_data);

  return return_vals;
}

static GimpValueArray *
image_set_simulation_profile_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GBytes *color_profile;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  color_profile = g_value_get_boxed (gimp_value_array_index (args, 1));

  if (success)
    {
      if (color_profile)
        {
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_icc_profile (g_bytes_get_data (color_profile, NULL),
                                                             g_bytes_get_size (color_profile),
                                                             error);

          if (profile)
            {
              gimp_image_set_simulation_profile (image, profile);
              g_object_unref (profile);
            }
          else
            {
              success = FALSE;
            }
        }
      else
        {
          gimp_image_set_simulation_profile (image, NULL);
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_set_simulation_profile_from_file_invoker (GimpProcedure         *procedure,
                                                Gimp                  *gimp,
                                                GimpContext           *context,
                                                GimpProgress          *progress,
                                                const GimpValueArray  *args,
                                                GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GFile *file;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  file = g_value_get_object (gimp_value_array_index (args, 1));

  if (success)
    {
      if (file)
        {
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_file (file, error);

          if (profile)
            {
              gimp_image_set_simulation_profile (image, profile);
              g_object_unref (profile);
            }
          else
            {
              success = FALSE;
            }
        }
      else
        {
          gimp_image_set_simulation_profile (image, NULL);
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_get_simulation_intent_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gint intent = 0;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      intent = gimp_image_get_simulation_intent (image);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), intent);

  return return_vals;
}

static GimpValueArray *
image_set_simulation_intent_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint intent;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  intent = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_image_set_simulation_intent (image, intent);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_get_simulation_bpc_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gboolean bpc = FALSE;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      bpc = gimp_image_get_simulation_bpc (image);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), bpc);

  return return_vals;
}

static GimpValueArray *
image_set_simulation_bpc_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gboolean bpc;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  bpc = g_value_get_boolean (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_image_set_simulation_bpc (image, bpc);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_convert_color_profile_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GBytes *color_profile;
  gint intent;
  gboolean bpc;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  color_profile = g_value_get_boxed (gimp_value_array_index (args, 1));
  intent = g_value_get_enum (gimp_value_array_index (args, 2));
  bpc = g_value_get_boolean (gimp_value_array_index (args, 3));

  if (success)
    {
      if (color_profile)
        {
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_icc_profile (g_bytes_get_data (color_profile, NULL),
                                                             g_bytes_get_size (color_profile),
                                                             error);

          if (profile)
            {
              success = gimp_image_convert_color_profile (image, profile,
                                                          intent, bpc,
                                                          progress, error);
              g_object_unref (profile);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_convert_color_profile_from_file_invoker (GimpProcedure         *procedure,
                                               Gimp                  *gimp,
                                               GimpContext           *context,
                                               GimpProgress          *progress,
                                               const GimpValueArray  *args,
                                               GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GFile *file;
  gint intent;
  gboolean bpc;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  file = g_value_get_object (gimp_value_array_index (args, 1));
  intent = g_value_get_enum (gimp_value_array_index (args, 2));
  bpc = g_value_get_boolean (gimp_value_array_index (args, 3));

  if (success)
    {
      if (file)
        {
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_file (file, error);

          if (profile)
            {
              success = gimp_image_convert_color_profile (image, profile,
                                                          intent, bpc,
                                                          progress, error);
              g_object_unref (profile);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_image_color_profile_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-image-get-color-profile
   */
  procedure = gimp_procedure_new (image_get_color_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-get-color-profile");
  gimp_procedure_set_static_help (procedure,
                                  "Returns the image's color profile",
                                  "This procedure returns the image's color profile, or NULL if the image has no color profile assigned.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2015");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boxed ("profile-data",
                                                       "profile data",
                                                       "The image's serialized color profile.",
                                                       G_TYPE_BYTES,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-get-effective-color-profile
   */
  procedure = gimp_procedure_new (image_get_effective_color_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-get-effective-color-profile");
  gimp_procedure_set_static_help (procedure,
                                  "Returns the color profile that is used for the image",
                                  "This procedure returns the color profile that is actually used for this image, which is the profile returned by 'gimp-image-get-color-profile' if the image has a profile assigned, or a generated default RGB or grayscale profile, according to the image's type.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2015");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boxed ("profile-data",
                                                       "profile data",
                                                       "The image's serialized color profile.",
                                                       G_TYPE_BYTES,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-set-color-profile
   */
  procedure = gimp_procedure_new (image_set_color_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-set-color-profile");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the image's color profile",
                                  "This procedure sets the image's color profile, or unsets it if NULL is passed as 'color_profile'. This procedure does no color conversion. However, it will change the pixel format of all layers to contain the babl space matching the profile. You must call this procedure before adding layers to the image.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2015");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boxed ("color-profile",
                                                   "color profile",
                                                   "The new serialized color profile",
                                                   G_TYPE_BYTES,
                                                   GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-set-color-profile-from-file
   */
  procedure = gimp_procedure_new (image_set_color_profile_from_file_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-set-color-profile-from-file");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the image's color profile from an ICC file",
                                  "This procedure sets the image's color profile from a file containing an ICC profile, or unsets it if NULL is passed as 'file'. This procedure does no color conversion. However, it will change the pixel format of all layers to contain the babl space matching the profile. You must call this procedure before adding layers to the image.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2015");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The file containing the new color profile",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-get-simulation-profile
   */
  procedure = gimp_procedure_new (image_get_simulation_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-get-simulation-profile");
  gimp_procedure_set_static_help (procedure,
                                  "Returns the image's simulation color profile",
                                  "This procedure returns the image's simulation color profile, or NULL if the image has no simulation color profile assigned.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2022");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boxed ("profile-data",
                                                       "profile data",
                                                       "The image's serialized simulation color profile.",
                                                       G_TYPE_BYTES,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-set-simulation-profile
   */
  procedure = gimp_procedure_new (image_set_simulation_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-set-simulation-profile");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the image's simulation color profile",
                                  "This procedure sets the image's simulation color profile, or unsets it if NULL is passed as 'color_profile'. This procedure does no color conversion.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2022");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boxed ("color-profile",
                                                   "color profile",
                                                   "The new serialized simulation color profile",
                                                   G_TYPE_BYTES,
                                                   GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-set-simulation-profile-from-file
   */
  procedure = gimp_procedure_new (image_set_simulation_profile_from_file_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-set-simulation-profile-from-file");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the image's simulation color profile from an ICC file",
                                  "This procedure sets the image's simulation color profile from a file containing an ICC profile, or unsets it if NULL is passed as 'file'. This procedure does no color conversion.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2022");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The file containing the new simulation color profile",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-get-simulation-intent
   */
  procedure = gimp_procedure_new (image_get_simulation_intent_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-get-simulation-intent");
  gimp_procedure_set_static_help (procedure,
                                  "Returns the image's simulation rendering intent",
                                  "This procedure returns the image's simulation rendering intent.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2022");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("intent",
                                                      "intent",
                                                      "The image's simulation rendering intent.",
                                                      GIMP_TYPE_COLOR_RENDERING_INTENT,
                                                      GIMP_COLOR_RENDERING_INTENT_PERCEPTUAL,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-set-simulation-intent
   */
  procedure = gimp_procedure_new (image_set_simulation_intent_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-set-simulation-intent");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the image's simulation rendering intent",
                                  "This procedure sets the image's simulation rendering intent.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2022");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("intent",
                                                  "intent",
                                                  "A GimpColorRenderingIntent",
                                                  GIMP_TYPE_COLOR_RENDERING_INTENT,
                                                  GIMP_COLOR_RENDERING_INTENT_PERCEPTUAL,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-get-simulation-bpc
   */
  procedure = gimp_procedure_new (image_get_simulation_bpc_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-get-simulation-bpc");
  gimp_procedure_set_static_help (procedure,
                                  "Returns whether the image has Black Point Compensation enabled for its simulation",
                                  "This procedure returns whether the image has Black Point Compensation enabled for its simulation",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2022");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("bpc",
                                                         "bpc",
                                                         "The Black Point Compensation status.",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-set-simulation-bpc
   */
  procedure = gimp_procedure_new (image_set_simulation_bpc_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-set-simulation-bpc");
  gimp_procedure_set_static_help (procedure,
                                  "Sets whether the image has Black Point Compensation enabled for its simulation",
                                  "This procedure whether the image has Black Point Compensation enabled for its simulation",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2022");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("bpc",
                                                     "bpc",
                                                     "The Black Point Compensation status.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-convert-color-profile
   */
  procedure = gimp_procedure_new (image_convert_color_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-convert-color-profile");
  gimp_procedure_set_static_help (procedure,
                                  "Convert the image's layers to a color profile",
                                  "This procedure converts from the image's color profile (or the default RGB or grayscale profile if none is set) to the given color profile. Only RGB and grayscale color profiles are accepted, according to the image's type.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2015");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boxed ("color-profile",
                                                   "color profile",
                                                   "The serialized color profile",
                                                   G_TYPE_BYTES,
                                                   GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("intent",
                                                  "intent",
                                                  "Rendering intent",
                                                  GIMP_TYPE_COLOR_RENDERING_INTENT,
                                                  GIMP_COLOR_RENDERING_INTENT_PERCEPTUAL,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("bpc",
                                                     "bpc",
                                                     "Black point compensation",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-convert-color-profile-from-file
   */
  procedure = gimp_procedure_new (image_convert_color_profile_from_file_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-convert-color-profile-from-file");
  gimp_procedure_set_static_help (procedure,
                                  "Convert the image's layers to a color profile",
                                  "This procedure converts from the image's color profile (or the default RGB or grayscale profile if none is set) to an ICC profile specified by 'file'. Only RGB and grayscale color profiles are accepted, according to the image's type.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2015");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The file containing the new color profile",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("intent",
                                                  "intent",
                                                  "Rendering intent",
                                                  GIMP_TYPE_COLOR_RENDERING_INTENT,
                                                  GIMP_COLOR_RENDERING_INTENT_PERCEPTUAL,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("bpc",
                                                     "bpc",
                                                     "Black point compensation",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
