---
title: Plugin: Android Boot
---

## Introduction

This plugin is used to update hardware that use partitions to store their firmware on.

## Firmware Format

The daemon will decompress the cabinet archive and extract a firmware blob as a Raw Disk File
in the IMG format. The firmware blob will be flashed to the partition. Fastboot devices are similar
but are flashed in fastboot mode using an external device. This plugin is similar but can be used
to flash from the device itself rather than external device.

This plugin supports the following protocol ID:

* `com.google.android_boot`

## GUID Generation

The GUID is generated by combining the partition UUID of the block device, its label and optionally boot slot
when using an Android A/B partitioning scheme, e.g.

* `DRIVE\UUID_c49183ed-aaec-9bf5-760a-66330fbcffc1&LABEL_label&SLOT_a`
* `DRIVE\UUID_c49183ed-aaec-9bf5-760a-66330fbcffc1&LABEL_label`
* `DRIVE\UUID_c49183ed-aaec-9bf5-760a-66330fbcffc1`

## Update Behavior

The block device is erased in chunks, written and then read back to verify.

## Quirk Use

This plugin uses the following plugin-specific quirk:

### AndroidBootVersionProperty

Property to parse from `/proc/cmdline` to retrieve the bootloader version.

Since: 1.8.5

### AndroidBootPartitionMaxSize

Maximum size the firmware may use of a partition.

Since: 1.8.5

## Vendor ID Security

The vendor ID is set through the `android-boot.quirk` file.

## External Interface Access

This plugin requires read/write access to `/dev/block`.

## Version Considerations

This plugin has been available since fwupd version `1.8.5`.
