/*  gbk.h - tables for Unicode to/from ECI 31 GBK (excl. GB 2312), generated by "tools/gen_zueci_mb_h.php" from
    "https://unicode.org/Public/MAPPINGS/VENDORS/MICSFT/WINDOWS/CP936.TXT" */
/*
    libzueci - an open source UTF-8 ECI library adapted from libzint
    Copyright (C) 2022 gitlost
 */
/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef ZUECI_GBK_H
#define ZUECI_GBK_H

#ifndef ZUECI_EMBED_NO_TO_ECI
/* Unicode usage bit-flags for URO (U+4E00-U+9FFF) block */
static const zueci_u16 zueci_gbk_uro_u[1307] = {
    0x8074, 0x8084, 0xC24B, 0x10AA, 0x0457, 0x0CA2, 0xFDBC, 0xBFF4,
    0x04BF, 0x72C1, 0x8408, 0x73D3, 0x9100, 0x1C05, 0xE2C5, 0x5712,
    0x19FD, 0x307C, 0x730A, 0xCAAA, 0x1FB7, 0x0054, 0x6D46, 0x27A6,
    0x54E7, 0xD76D, 0x2816, 0x7FDF, 0x3BC7, 0x0A7C, 0x18B5, 0xBAF5,
    0x4FFF, 0x68EB, 0x889D, 0xABFF, 0x2E77, 0xEBDF, 0xEFDF, 0x373F,
    0xDEDE, 0xFFFF, 0xEC57, 0xF3FB, 0x7FFF, 0xFBBF, 0x8F3F, 0xF7D7,
    0xF73F, 0xFFFB, 0xFFFD, 0x7FFF, 0xD484, 0xEB8D, 0x86DB, 0xC404,
    0xCCD8, 0xE51B, 0x67CA, 0xC710, 0x652E, 0xD7FD, 0x57EC, 0x4096,
    0x9A30, 0xD039, 0x94EE, 0x5036, 0xCBF0, 0xAFAC, 0x795D, 0x5FFB,
    0xFEF9, 0x17F6, 0xC0F0, 0x3FF1, 0xF577, 0x7EBA, 0xFFEF, 0x39FE,
    0x5E9E, 0xD91E, 0xBBB4, 0x31FF, 0x3855, 0x2B11, 0x3520, 0x7A44,
    0xC58B, 0x5ADF, 0xBC93, 0x77BF, 0xC0F9, 0x742D, 0x0086, 0xC410,
    0x08A5, 0x1710, 0x0434, 0xA4C9, 0xF2B6, 0xE402, 0xFEAB, 0xC611,
    0x27AA, 0xD18A, 0x4027, 0x56E5, 0x0C28, 0x0940, 0x981F, 0x4BF3,
    0x7D3D, 0xF7EC, 0x2B62, 0x2F74, 0xF9A5, 0xEF9E, 0x8B0D, 0xA61F,
    0x7060, 0x4CED, 0xFF7F, 0x9555, 0xCDCF, 0x4FA1, 0x6285, 0x9F53,
    0x2CFC, 0x36FF, 0xCF67, 0x75A9, 0x8FFF, 0xEC6F, 0xE0EB, 0xE7BD,
    0x3F9F, 0xFFF7, 0x7FF7, 0xEF7F, 0xFBFF, 0x136F, 0xD7E8, 0x19CC,
    0xF8A7, 0x6FFF, 0x08F7, 0xB1F6, 0x0B7A, 0x037C, 0x50AC, 0xE737,
    0xE783, 0xF7F3, 0x9520, 0xFEEB, 0x37F3, 0x58CB, 0x5FEE, 0xD8EF,
    0xD73A, 0xBDDD, 0xFBEC, 0xFFDE, 0xCFEF, 0xBEED, 0xE7DF, 0xBFFF,
    0xFDD4, 0x39F3, 0xFCFF, 0xEFFF, 0xFFDD, 0xFFDD, 0xA7EF, 0xFDB6,
    0x5F6B, 0x698F, 0x114F, 0xE86D, 0x3469, 0xFA0D, 0xFFDA, 0xDCA7,
    0xDA21, 0xBD33, 0x30C7, 0xB5FB, 0xF3BF, 0xCA60, 0xEED7, 0x75FF,
    0xEC05, 0x6EF5, 0xFDD6, 0xEFA9, 0xF9BE, 0xFBDF, 0xFB7B, 0x7B0F,
    0xFFFF, 0xF3FB, 0xFBFF, 0xBED3, 0xEDF9, 0xEEAB, 0xF5B4, 0xFFFD,
    0xFDFF, 0xFF3F, 0xFFFF, 0xFF6B, 0xFFFE, 0x4044, 0xE983, 0xDBD4,
    0x6444, 0x8057, 0xF380, 0x1C86, 0xEF0B, 0x1FF2, 0xBECD, 0x60FE,
    0x79AD, 0xCA8D, 0xEF4B, 0x00ED, 0x30D8, 0xBDDC, 0x3F94, 0x79FD,
    0xCEF9, 0xE02C, 0xC5F3, 0x5E55, 0xF7ED, 0xFDFB, 0xDA8D, 0xF7FE,
    0xBF33, 0xB7AF, 0x9D2F, 0x9FEF, 0xE37F, 0xD6FF, 0x65FF, 0xFFEF,
    0xFFFB, 0xDDFF, 0xFFFF, 0xFF7F, 0xDFDF, 0x97FF, 0x3419, 0x9F61,
    0x6E91, 0xC08C, 0x9F3F, 0xC67D, 0xEFCB, 0xB7CF, 0xFFF9, 0x42A3,
    0x732E, 0x2904, 0xDF1E, 0xBC17, 0xF9FF, 0xF7B1, 0xFAFF, 0x3B2F,
    0x72E0, 0x7655, 0x591E, 0xE9FD, 0xFFFE, 0xDE12, 0xC9A9, 0xE574,
    0xE048, 0xEC5A, 0x9AFD, 0xCF5F, 0x4D87, 0xDC38, 0x936C, 0x16DD,
    0x1B80, 0xC58B, 0x701C, 0x67DF, 0xD7F1, 0xD9DA, 0x4063, 0x40B6,
    0xCDE7, 0x53AB, 0x46B6, 0xE6E9, 0xF39F, 0x4ADD, 0x043E, 0xF9A6,
    0x1CBC, 0x7BDF, 0xF726, 0x7FFF, 0xAAFF, 0xDFDD, 0xFE7B, 0xFF5E,
    0xB7FF, 0xDFEF, 0xEC7F, 0xBF7F, 0xF2FB, 0xFFE9, 0xFFBF, 0x7FDF,
    0x02BF, 0x7218, 0xABC9, 0x1F67, 0x8474, 0xF6E1, 0x0137, 0x2DB6,
    0xF9EE, 0x7211, 0xE6C8, 0x45DD, 0x880B, 0x6022, 0x0C13, 0x0F25,
    0xBC79, 0x13BD, 0x72C0, 0xD9FB, 0x0593, 0x3FDE, 0x9D71, 0xF33D,
    0x287A, 0xFEBA, 0x8852, 0xAA66, 0x1DAF, 0xBFBA, 0xD9F4, 0x5EAB,
    0x67D8, 0xA7E6, 0xCBBC, 0x5BEF, 0xFA0D, 0xBEEB, 0xDD7F, 0xF8FF,
    0xFF4B, 0xBD99, 0x8DEF, 0xEA5E, 0x9FDA, 0xBE7A, 0xFFAB, 0xFFFF,
    0xFDFE, 0xFEFB, 0x37DF, 0x348F, 0x6CDF, 0x959D, 0xE7B3, 0xFF6A,
    0xE77F, 0x6574, 0x554D, 0xCDFE, 0x2785, 0xFF3B, 0x0C1A, 0xFB3C,
    0x2BB2, 0x5DC7, 0x5E5E, 0xAF8D, 0x67F5, 0x7B03, 0x3EAD, 0xBB2E,
    0xEF6B, 0xDF3D, 0xBE7F, 0xBDEF, 0xFFFF, 0xC5FF, 0xFDBF, 0x2D62,
    0xD0FE, 0x574E, 0x42BF, 0xDBCD, 0x2CB2, 0x2FB4, 0x58DC, 0x2F52,
    0xF56D, 0x8A5E, 0x5253, 0xFE16, 0x7FE5, 0x88E0, 0x6DDA, 0x5FE4,
    0x205E, 0xDF35, 0xF9FD, 0x8C73, 0xA880, 0xFFC4, 0xF400, 0xFF2F,
    0x7F95, 0xFF77, 0x5E3B, 0xFFD6, 0xD5FA, 0xFADB, 0xBFF6, 0xE9DC,
    0x97DD, 0x7FFA, 0xDFEE, 0x5DEE, 0xFFFB, 0x9B6F, 0xB7B6, 0xEC7D,
    0xDC2A, 0xE6CF, 0xD67F, 0xF76D, 0xABFD, 0x77EE, 0xDFFE, 0x5FFB,
    0xFBFF, 0x7E7F, 0x7AFD, 0x9FDD, 0xFF6F, 0xF4FE, 0xFFDD, 0xEDFD,
    0xBFEE, 0xFF7C, 0xE5FE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFF60, 0xB97B, 0xED37, 0xFDFF, 0xFB03, 0xE5FF,
    0xD121, 0xF3B3, 0xFBFD, 0x7F47, 0x57D9, 0xF503, 0x73FD, 0xDDD7,
    0x5F1F, 0x7084, 0x3829, 0xDECA, 0xF938, 0x074E, 0xF8EC, 0x9DAA,
    0x6C91, 0x75E6, 0x9105, 0x04F1, 0xE9CF, 0xB706, 0x32D0, 0x8214,
    0xA76D, 0xB17B, 0xB35F, 0x85D1, 0x1215, 0xA9E1, 0x39B6, 0xEE6F,
    0xACDB, 0x17C5, 0x3024, 0x7EDB, 0xE70E, 0x9CBD, 0xA7AC, 0xE575,
    0x8BDF, 0xDB2C, 0x55C4, 0xFAEB, 0x9FE7, 0x76A7, 0xB7FF, 0x3FFF,
    0x7D97, 0x6EFE, 0x7B5B, 0xD329, 0x7779, 0x3B45, 0xFC88, 0xFDEF,
    0x7DBB, 0xFFC7, 0x51EE, 0xBFB5, 0xD73F, 0xAEFF, 0x9FBB, 0xEAEB,
    0x8CEF, 0xEFFF, 0xFF7D, 0xFDB7, 0xFDFA, 0xBFF9, 0x3FFC, 0xFFFF,
    0xFFFF, 0xF3FD, 0xFFF7, 0xFDDF, 0x6FFF, 0xBFFF, 0x47FF, 0x2E9E,
    0xB9DE, 0xCD8B, 0x07FF, 0xC475, 0xFAF0, 0x74FF, 0x442F, 0xDD7F,
    0xF9FF, 0xF896, 0x7FBF, 0xFFBC, 0xABDF, 0xAFFF, 0xBE2F, 0xDAF3,
    0x7BEF, 0x7CEF, 0xEEFE, 0xFDD7, 0xBFF7, 0xFFCF, 0xBF5E, 0xFDFF,
    0xFFBF, 0xDFFF, 0xEAFF, 0x541C, 0xCE7F, 0x55BB, 0x3D39, 0x39DB,
    0x53EC, 0x7FFB, 0x4FFF, 0xFC2E, 0x9EE1, 0xBD7A, 0x0CFC, 0xE260,
    0xBBF5, 0x8717, 0xA1D9, 0x3C6D, 0xDFFF, 0xFF7A, 0x4FFE, 0xBFFF,
    0xB56F, 0x77BD, 0x35FB, 0xF372, 0x58FA, 0xBDFC, 0xDD5E, 0xFFFB,
    0x7997, 0xF3FE, 0xAA9B, 0xEF86, 0xFFFD, 0x215F, 0xDFFF, 0xBF3E,
    0xB774, 0xAFFE, 0xFC7F, 0xFBFF, 0xFFFF, 0xAFFB, 0x3FA2, 0x7F2F,
    0x5FEF, 0x68F5, 0x44DF, 0xB250, 0x26DE, 0xE1EF, 0xFB9F, 0x7CEB,
    0x77B7, 0x5929, 0x27C4, 0x8CC0, 0xD843, 0xB68B, 0xF223, 0x6DEC,
    0xEBD4, 0x745E, 0xD18A, 0x2EC6, 0xCFF6, 0xAFAF, 0x77F7, 0x96FF,
    0xB62B, 0xFDB5, 0xBFEF, 0x7FE9, 0x1A9B, 0x7628, 0x3FDF, 0xACE9,
    0xD46D, 0x79FF, 0x5CBA, 0xEA1F, 0xFF74, 0xF3FC, 0xE691, 0x1DFF,
    0x8FCE, 0x7FF9, 0xE95A, 0x57D6, 0xDFFF, 0xE77F, 0x8553, 0x1EB7,
    0xCDF8, 0x4A29, 0xCD17, 0xA06E, 0xAF5E, 0xDF1A, 0x83FF, 0xEF7F,
    0x8D7F, 0x6275, 0xFF55, 0xBDE0, 0xF1DD, 0xFDCE, 0xEEFF, 0xFB6B,
    0xFFDD, 0xBFF7, 0xFFEF, 0xA3EF, 0xFCBC, 0x0337, 0x5E5A, 0xFA7F,
    0x7BCC, 0xFBFF, 0xFF7F, 0x91F7, 0xD5B4, 0x7ED9, 0x5527, 0xD6FE,
    0x97B2, 0xBB6F, 0xFFF6, 0x4577, 0xFFBF, 0xFF7D, 0xFFFF, 0x782E,
    0xDEA4, 0x4E19, 0xCE9E, 0x7FF7, 0xF7FF, 0x3DBF, 0x5F96, 0x59FF,
    0x72A7, 0xB5CD, 0xA28E, 0xAAF5, 0x655F, 0xD2A8, 0xBFFA, 0xB559,
    0xDFDE, 0xCF4E, 0xC039, 0xFEED, 0xEF3D, 0xD9F5, 0xBB9D, 0xAF7D,
    0x677F, 0x7FBF, 0xFB3F, 0x7EFF, 0xDFFC, 0xFFFF, 0xFFFF, 0xC7E7,
    0xFDFF, 0x0E59, 0xBBCB, 0x8DF1, 0xCA5D, 0x6D1F, 0x7EFE, 0xF6FF,
    0xFBFF, 0xFFFF, 0x777A, 0xFFFF, 0xFFFF, 0xFFFF, 0xBFFF, 0xFF7F,
    0xFFFF, 0xFFFF, 0xBFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xF7FF, 0xFF7D, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFB, 0x77FF, 0x4000, 0x1810, 0x0000, 0x0040, 0x1010, 0x0200,
    0x0400, 0x4001, 0x0000, 0xFA80, 0xFFCB, 0x7A4C, 0xB8F9, 0xBDE9,
    0xABFD, 0x1BEF, 0x7F6D, 0x4CFA, 0xABDD, 0x7ECF, 0xBD9C, 0xE7F4,
    0xC784, 0xEC0A, 0xF81A, 0x5615, 0xC3B3, 0xFAEB, 0xF9FF, 0x7FFD,
    0xE526, 0x42B7, 0x11C8, 0x0B69, 0x8FA0, 0x813F, 0x404D, 0xCAA0,
    0x19BB, 0xBAA0, 0x6FFF, 0xBEB9, 0xE2BF, 0xF9C4, 0x9D5E, 0x01EC,
    0x7AFA, 0xC6FD, 0xFAB7, 0xF3F7, 0xEBB0, 0xFFFF, 0xCB77, 0xA7E7,
    0xCF88, 0x27EA, 0x42F1, 0xB404, 0x756F, 0x7AFF, 0x3EFF, 0x19E2,
    0x12EB, 0x4C79, 0x008D, 0x9C64, 0x026D, 0x2641, 0x7784, 0xF56D,
    0x2C01, 0xE34D, 0x467F, 0xE885, 0x7D36, 0x23E8, 0x0004, 0xC67F,
    0xBD9F, 0xA6F3, 0xF0FE, 0xC820, 0x6B5C, 0x4EAF, 0xF9DC, 0xDCF8,
    0x07A5, 0xCEFD, 0xFE0F, 0xCEFD, 0xFFBF, 0xE17D, 0xC5F5, 0xFA95,
    0xA47B, 0xED7F, 0x7FFD, 0x58EB, 0xD9ED, 0x5FB4, 0xEF96, 0x6FFE,
    0xEFFF, 0x7B75, 0xE7FD, 0xC07F, 0xF8F7, 0xBDBF, 0xFEEF, 0xB1EB,
    0x7F4F, 0xE7FF, 0x3AEF, 0xFD7E, 0x7DFD, 0xEFD6, 0xFDEF, 0x77FF,
    0xFFDF, 0xFFBD, 0xFD7F, 0xEEFF, 0x1FFF, 0xBBEC, 0xA7FB, 0x01FD,
    0xC3F8, 0xCFD7, 0x6867, 0xFB8C, 0x312E, 0x34EC, 0x9DEF, 0xBCE0,
    0xD872, 0xAA53, 0xBDD1, 0x376D, 0xAC7F, 0xFD77, 0xBFC6, 0x87AE,
    0xD6D3, 0x7F77, 0x46FF, 0xDBD7, 0xF3BE, 0xF7F1, 0xBBDE, 0xBDFF,
    0xFBF7, 0xF797, 0xFFF9, 0xEDFB, 0xCFCE, 0xFD6F, 0xA4C1, 0x1F7A,
    0xD6C9, 0xEFBB, 0xD7EB, 0xEF7D, 0xBD99, 0x7CCB, 0xFEC3, 0xACE4,
    0xFBFB, 0xF1F2, 0xF3DD, 0xFFAE, 0xFFED, 0x3FFF, 0xFFBF, 0x77FF,
    0xFFB5, 0xFFFF, 0xFFFF, 0xFFFF, 0x2009, 0xABB8, 0x7797, 0xFFF7,
    0xFF7E, 0xFFFF, 0xFFFF, 0xBFFF, 0xFEFF, 0xFFFF, 0xFFFF, 0xFDFF,
    0xF9FF, 0xFFF7, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFF7F, 0xFFFF, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEFBF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1000, 0x0802, 0x0080, 0x0001, 0x0400, 0x0000,
    0x0200, 0x4000, 0x0000, 0xFF00, 0xED3D, 0xFBDF, 0xF3F9, 0xF8F7,
    0xE9DB, 0xFEEF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x1FFF, 0x0001, 0x0000, 0x0000, 0x8086, 0xD720, 0xFF06,
    0xF3CD, 0x7FED, 0xFFF7, 0x2AC5, 0x27A7, 0x133D, 0x62E7, 0xD057,
    0x69DF, 0x1FEF, 0x29F3, 0xD9DD, 0xF068, 0xFDF9, 0x4DBF, 0x6FAA,
    0x7F5D, 0xAFEE, 0x67FF, 0xFBFB, 0xBFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x043F, 0x0000,
    0x1001, 0x2004, 0xF4F7, 0x9DBC, 0xBE49, 0x04C4, 0x908B, 0xDC76,
    0x5180, 0x1328, 0x1FB8, 0xA69F, 0x5F69, 0xF670, 0x9ED3, 0x5FCF,
    0xF6F2, 0xD555, 0x2BB1, 0xB084, 0x3B4D, 0xC774, 0x5639, 0x9EEF,
    0xFFEB, 0xBDFF, 0x7FF3, 0xFDFD, 0x01B7, 0x9B7A, 0x29C1, 0x1C08,
    0xC55F, 0xF3F8, 0x1BF3, 0xFBCF, 0x097F, 0xEFFD, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFEF,
    0xBFFF, 0xFFFF, 0xBFFF, 0xFFFF, 0xFEFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xBFFF, 0xFFFF, 0xFFFF, 0xFBFF, 0xFFFF,
    0x7FFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFBFF, 0xFFBF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xBFFF, 0xFFFF, 0xFFFF, 0xF7FF, 0xFFFF,
    0x001F, 0x0142, 0x0000, 0x0000, 0x8080, 0x0418, 0x0040, 0x0800,
    0x0000, 0x1000, 0x0081, 0x2008, 0x0908, 0x0420, 0x4001, 0x7FB0,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x10FF, 0x8000,
    0x0080, 0x4908, 0xBBF9, 0x4781, 0xC40A, 0x77CE, 0xE869, 0xFF0B,
    0x569F, 0xEC6E, 0xFF7F, 0x8DB6, 0x0D0C, 0xFFDB, 0x78FE, 0xBD37,
    0x1C2C, 0xAFB7, 0xDBFF, 0xBCFA, 0xFFFF, 0xB5B3, 0xFDD8, 0xEFA7,
    0xD7DF, 0xFEE9, 0x57F6, 0xFFEB, 0xFFFF, 0xFFFF, 0xC13F, 0xFF97,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x001F,
    0x4800, 0x0224, 0xFF08, 0xFFFF, 0xBFFF, 0x38D1, 0xFE7F, 0xFFFF,
    0xDFFF, 0xFFFE, 0xBFFF, 0xFFFF, 0xFFFF, 0xFFCF, 0x0057, 0x4B08,
    0x520C, 0xFC00, 0xFEDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0FFF, 0x0004,
    0x6208, 0x0230, 0xFE40, 0xEA3C, 0xE7D8, 0x7EF5, 0x57BD, 0xF5FF,
    0x7EF7, 0x7FF7, 0x7FF7, 0xE7FB, 0x5C41, 0xFFED, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x6FFF,
    0x9619, 0x23C8, 0x9400, 0xC200, 0x0307, 0x0C06, 0xFFFB, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x7FFF, 0x4090, 0x1811, 0x2001, 0xA25D, 0xC027, 0x3FF4,
    0xF67B, 0x5FF3, 0xFFBF, 0x96EF, 0x1DEF, 0x46ED, 0x795A, 0xA5FF,
    0x97FF, 0xFD76, 0x6FFA, 0x957F, 0xFFEF, 0xFFFC, 0xFFFF, 0x7FFF,
    0xE006, 0x71FF, 0x003E,
};

/* Multibyte indexes for URO (U+4E00-U+9FFF) block */
static const zueci_u16 zueci_gbk_uro_mb_ind[1307] = {
      134,   139,   142,   149,   154,   160,   165,   177,
      189,   197,   204,   207,   217,   220,   225,   233,
      240,   250,   257,   264,   272,   283,   286,   294,
      302,   311,   322,   327,   341,   351,   358,   365,
      376,   389,   398,   405,   418,   428,   441,   455,
      466,   478,   494,   504,   517,   532,   546,   557,
      570,   583,   598,   613,   628,   634,   644,   653,
      657,   665,   674,   683,   689,   697,   710,   720,
      725,   731,   738,   747,   753,   762,   772,   782,
      795,   808,   818,   824,   835,   847,   858,   873,
      884,   894,   903,   913,   924,   931,   937,   942,
      949,   957,   968,   977,   990,   998,  1006,  1009,
     1013,  1018,  1023,  1027,  1034,  1044,  1049,  1061,
     1067,  1075,  1082,  1087,  1096,  1100,  1103,  1111,
     1121,  1132,  1144,  1151,  1160,  1170,  1182,  1189,
     1198,  1203,  1212,  1227,  1235,  1246,  1254,  1260,
     1270,  1279,  1291,  1302,  1311,  1324,  1335,  1344,
     1356,  1368,  1383,  1397,  1411,  1426,  1435,  1445,
     1452,  1462,  1476,  1484,  1494,  1502,  1509,  1515,
     1526,  1535,  1548,  1553,  1566,  1577,  1585,  1597,
     1608,  1618,  1630,  1642,  1656,  1669,  1681,  1694,
     1709,  1720,  1730,  1744,  1759,  1773,  1787,  1799,
     1811,  1822,  1831,  1838,  1847,  1854,  1863,  1876,
     1886,  1893,  1903,  1910,  1922,  1935,  1941,  1953,
     1966,  1973,  1984,  1996,  2007,  2019,  2033,  2046,
     2056,  2072,  2085,  2100,  2111,  2123,  2134,  2144,
     2159,  2174,  2188,  2204,  2217,  2232,  2235,  2243,
     2253,  2258,  2264,  2271,  2277,  2287,  2297,  2308,
     2317,  2327,  2335,  2346,  2352,  2358,  2369,  2378,
     2390,  2401,  2407,  2417,  2426,  2439,  2453,  2462,
     2476,  2487,  2499,  2509,  2522,  2534,  2547,  2559,
     2574,  2589,  2603,  2619,  2634,  2648,  2661,  2667,
     2676,  2684,  2689,  2701,  2711,  2723,  2735,  2749,
     2755,  2764,  2768,  2779,  2788,  2802,  2813,  2827,
     2837,  2844,  2853,  2861,  2873,  2888,  2896,  2904,
     2913,  2918,  2927,  2938,  2950,  2958,  2966,  2974,
     2983,  2988,  2996,  3002,  3014,  3025,  3035,  3040,
     3046,  3057,  3066,  3074,  3084,  3096,  3105,  3111,
     3121,  3129,  3142,  3152,  3167,  3179,  3192,  3205,
     3218,  3232,  3246,  3258,  3272,  3284,  3297,  3312,
     3326,  3334,  3340,  3349,  3359,  3365,  3375,  3381,
     3390,  3402,  3408,  3416,  3425,  3430,  3434,  3439,
     3446,  3456,  3465,  3471,  3483,  3489,  3501,  3510,
     3521,  3528,  3540,  3545,  3553,  3563,  3575,  3585,
     3595,  3604,  3614,  3624,  3636,  3645,  3657,  3670,
     3683,  3695,  3705,  3716,  3726,  3737,  3748,  3761,
     3777,  3791,  3805,  3817,  3825,  3836,  3845,  3856,
     3868,  3881,  3889,  3897,  3909,  3916,  3929,  3934,
     3945,  3953,  3963,  3973,  3983,  3994,  4002,  4012,
     4022,  4034,  4046,  4059,  4072,  4088,  4100,  4114,
     4121,  4131,  4140,  4149,  4160,  4167,  4176,  4184,
     4192,  4203,  4211,  4218,  4228,  4240,  4245,  4255,
     4265,  4271,  4282,  4295,  4303,  4307,  4318,  4323,
     4336,  4347,  4361,  4371,  4384,  4395,  4407,  4420,
     4430,  4441,  4454,  4467,  4478,  4493,  4504,  4515,
     4526,  4534,  4545,  4557,  4569,  4581,  4593,  4607,
     4620,  4635,  4648,  4660,  4672,  4686,  4698,  4712,
     4725,  4738,  4751,  4763,  4779,  4795,  4811,  4827,
     4843,  4859,  4875,  4885,  4896,  4907,  4922,  4931,
     4944,  4950,  4961,  4975,  4986,  4996,  5004,  5016,
     5028,  5039,  5044,  5050,  5060,  5069,  5076,  5086,
     5095,  5102,  5112,  5117,  5123,  5134,  5142,  5148,
     5152,  5162,  5172,  5183,  5190,  5195,  5203,  5212,
     5224,  5234,  5242,  5246,  5258,  5267,  5277,  5286,
     5296,  5307,  5316,  5323,  5335,  5347,  5357,  5371,
     5385,  5396,  5408,  5419,  5427,  5438,  5446,  5454,
     5468,  5480,  5493,  5502,  5514,  5526,  5539,  5551,
     5562,  5572,  5587,  5601,  5614,  5627,  5640,  5652,
     5668,  5684,  5697,  5712,  5726,  5740,  5755,  5767,
     5776,  5787,  5796,  5807,  5815,  5825,  5837,  5844,
     5857,  5871,  5880,  5894,  5907,  5919,  5933,  5944,
     5955,  5968,  5980,  5993,  6006,  6020,  6034,  6046,
     6061,  6076,  6091,  6104,  6110,  6122,  6132,  6141,
     6151,  6160,  6174,  6187,  6197,  6206,  6217,  6225,
     6231,  6243,  6251,  6259,  6268,  6283,  6296,  6308,
     6323,  6334,  6346,  6357,  6367,  6376,  6388,  6399,
     6414,  6424,  6437,  6446,  6456,  6471,  6479,  6494,
     6506,  6516,  6529,  6542,  6557,  6573,  6586,  6595,
     6607,  6620,  6629,  6638,  6644,  6653,  6664,  6677,
     6688,  6700,  6707,  6714,  6719,  6726,  6735,  6743,
     6753,  6763,  6772,  6779,  6787,  6799,  6811,  6824,
     6836,  6845,  6857,  6871,  6883,  6891,  6898,  6911,
     6920,  6929,  6942,  6951,  6961,  6973,  6985,  6993,
     7005,  7015,  7028,  7037,  7047,  7062,  7075,  7082,
     7092,  7102,  7108,  7117,  7124,  7135,  7145,  7156,
     7170,  7181,  7189,  7201,  7210,  7221,  7233,  7247,
     7259,  7273,  7287,  7302,  7313,  7324,  7331,  7340,
     7353,  7363,  7378,  7393,  7403,  7412,  7423,  7431,
     7443,  7452,  7464,  7478,  7487,  7502,  7516,  7532,
     7540,  7549,  7556,  7566,  7580,  7595,  7607,  7617,
     7629,  7638,  7648,  7655,  7665,  7675,  7682,  7695,
     7704,  7717,  7727,  7733,  7746,  7758,  7769,  7780,
     7792,  7804,  7818,  7831,  7845,  7858,  7874,  7890,
     7901,  7916,  7923,  7934,  7943,  7952,  7962,  7975,
     7989,  8004,  8020,  8031,  8047,  8063,  8079,  8094,
     8109,  8125,  8141,  8155,  8171,  8187,  8203,  8219,
     8235,  8251,  8267,  8283,  8298,  8312,  8328,  8344,
     8360,  8375,  8389,  8390,  8393,  8393,  8394,  8396,
     8397,  8398,  8400,  8400,  8407,  8420,  8428,  8438,
     8449,  8461,  8472,  8484,  8493,  8504,  8516,  8526,
     8537,  8544,  8551,  8559,  8566,  8575,  8587,  8601,
     8615,  8623,  8631,  8636,  8643,  8650,  8658,  8663,
     8669,  8678,  8685,  8699,  8710,  8721,  8730,  8740,
     8746,  8757,  8768,  8780,  8793,  8802,  8818,  8829,
     8840,  8848,  8857,  8864,  8869,  8880,  8893,  8906,
     8913,  8921,  8929,  8933,  8940,  8946,  8951,  8959,
     8970,  8974,  8983,  8993,  9000,  9010,  9017,  9018,
     9029,  9041,  9051,  9062,  9066,  9075,  9085,  9096,
     9106,  9113,  9125,  9136,  9148,  9163,  9173,  9183,
     9193,  9202,  9215,  9229,  9238,  9249,  9259,  9270,
     9283,  9298,  9309,  9322,  9331,  9343,  9356,  9370,
     9380,  9392,  9406,  9417,  9430,  9443,  9455,  9469,
     9483,  9498,  9512,  9526,  9540,  9553,  9564,  9576,
     9584,  9593,  9605,  9613,  9623,  9630,  9638,  9650,
     9658,  9666,  9674,  9684,  9694,  9705,  9718,  9729,
     9738,  9748,  9761,  9772,  9784,  9796,  9808,  9820,
     9834,  9848,  9860,  9874,  9887,  9898,  9911,  9917,
     9927,  9936,  9949,  9961,  9974,  9984,  9994, 10005,
    10013, 10027, 10037, 10049, 10062, 10076, 10090, 10105,
    10119, 10132, 10148, 10164, 10180, 10183, 10192, 10203,
    10218, 10232, 10248, 10264, 10279, 10294, 10310, 10326,
    10341, 10355, 10370, 10386, 10402, 10418, 10434, 10450,
    10466, 10481, 10497, 10512, 10528, 10544, 10560, 10574,
    10590, 10606, 10622, 10623, 10625, 10626, 10627, 10628,
    10628, 10629, 10630, 10630, 10638, 10649, 10663, 10675,
    10687, 10698, 10712, 10728, 10744, 10760, 10776, 10792,
    10808, 10824, 10837, 10838, 10838, 10838, 10842, 10849,
    10859, 10870, 10883, 10898, 10905, 10914, 10922, 10931,
    10939, 10950, 10962, 10971, 10982, 10989, 11002, 11013,
    11023, 11035, 11047, 11060, 11074, 11089, 11105, 11121,
    11137, 11153, 11169, 11185, 11201, 11217, 11233, 11240,
    11240, 11242, 11244, 11256, 11266, 11275, 11279, 11285,
    11295, 11299, 11304, 11313, 11323, 11333, 11342, 11352,
    11364, 11375, 11384, 11392, 11397, 11406, 11415, 11423,
    11435, 11449, 11463, 11476, 11490, 11497, 11507, 11513,
    11517, 11527, 11538, 11548, 11561, 11570, 11584, 11600,
    11616, 11632, 11648, 11664, 11680, 11696, 11712, 11728,
    11743, 11758, 11774, 11789, 11805, 11820, 11836, 11852,
    11868, 11884, 11900, 11916, 11931, 11947, 11963, 11978,
    11994, 12009, 12025, 12041, 12057, 12072, 12087, 12103,
    12119, 12135, 12151, 12167, 12182, 12198, 12214, 12229,
    12245, 12250, 12253, 12253, 12253, 12255, 12258, 12259,
    12260, 12260, 12261, 12263, 12265, 12268, 12270, 12272,
    12282, 12298, 12314, 12330, 12346, 12362, 12378, 12387,
    12388, 12389, 12393, 12405, 12411, 12416, 12427, 12435,
    12446, 12456, 12466, 12481, 12490, 12495, 12509, 12520,
    12531, 12537, 12549, 12563, 12574, 12590, 12600, 12611,
    12623, 12636, 12648, 12659, 12673, 12689, 12705, 12714,
    12727, 12743, 12759, 12775, 12791, 12807, 12823, 12839,
    12844, 12846, 12849, 12858, 12874, 12889, 12896, 12910,
    12926, 12941, 12956, 12971, 12987, 13003, 13017, 13022,
    13027, 13032, 13038, 13052, 13068, 13084, 13100, 13116,
    13132, 13148, 13164, 13180, 13196, 13212, 13228, 13240,
    13241, 13245, 13248, 13256, 13265, 13275, 13287, 13298,
    13312, 13325, 13339, 13353, 13366, 13372, 13386, 13402,
    13418, 13434, 13450, 13466, 13482, 13498, 13514, 13530,
    13546, 13562, 13578, 13594, 13610, 13626, 13642, 13658,
    13672, 13679, 13685, 13688, 13691, 13696, 13700, 13715,
    13731, 13747, 13763, 13779, 13795, 13811, 13827, 13843,
    13859, 13875, 13891, 13907, 13923, 13939, 13955, 13971,
    13987, 14003, 14018, 14021, 14025, 14027, 14035, 14041,
    14052, 14064, 14076, 14091, 14102, 14113, 14122, 14131,
    14143, 14156, 14168, 14180, 14191, 14206, 14220, 14236,
    14251, 14256, 14268,
};
#endif /* ZUECI_EMBED_NO_TO_ECI */

#ifndef ZUECI_EMBED_NO_TO_ECI
/* Unicode codepoints sorted */
static const zueci_u16 zueci_gbk_u_u[209] = {
    0x00B7, 0x0144, 0x0148, 0x0251, 0x0261, 0x02CA, 0x02CB, 0x02D9,
    0x2010, 0x2013, 0x2014, 0x2015, 0x2025, 0x2035, 0x2105, 0x2109,
    0x2121, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176,
    0x2177, 0x2178, 0x2179, 0x2196, 0x2197, 0x2198, 0x2199, 0x2215,
    0x221F, 0x2223, 0x2252, 0x2266, 0x2267, 0x2295, 0x22BF, 0x2550,
    0x2551, 0x2552, 0x2553, 0x2554, 0x2555, 0x2556, 0x2557, 0x2558,
    0x2559, 0x255A, 0x255B, 0x255C, 0x255D, 0x255E, 0x255F, 0x2560,
    0x2561, 0x2562, 0x2563, 0x2564, 0x2565, 0x2566, 0x2567, 0x2568,
    0x2569, 0x256A, 0x256B, 0x256C, 0x256D, 0x256E, 0x256F, 0x2570,
    0x2571, 0x2572, 0x2573, 0x2581, 0x2582, 0x2583, 0x2584, 0x2585,
    0x2586, 0x2587, 0x2588, 0x2589, 0x258A, 0x258B, 0x258C, 0x258D,
    0x258E, 0x258F, 0x2593, 0x2594, 0x2595, 0x25BC, 0x25BD, 0x25E2,
    0x25E3, 0x25E4, 0x25E5, 0x2609, 0x3006, 0x3007, 0x3012, 0x301D,
    0x301E, 0x3021, 0x3022, 0x3023, 0x3024, 0x3025, 0x3026, 0x3027,
    0x3028, 0x3029, 0x309B, 0x309C, 0x309D, 0x309E, 0x30FC, 0x30FD,
    0x30FE, 0x3231, 0x32A3, 0x338E, 0x338F, 0x339C, 0x339D, 0x339E,
    0x33A1, 0x33C4, 0x33CE, 0x33D1, 0x33D2, 0x33D5, 0xF92C, 0xF979,
    0xF995, 0xF9E7, 0xF9F1, 0xFA0C, 0xFA0D, 0xFA0E, 0xFA0F, 0xFA11,
    0xFA13, 0xFA14, 0xFA18, 0xFA1F, 0xFA20, 0xFA21, 0xFA23, 0xFA24,
    0xFA27, 0xFA28, 0xFA29, 0xFE30, 0xFE31, 0xFE33, 0xFE34, 0xFE35,
    0xFE36, 0xFE37, 0xFE38, 0xFE39, 0xFE3A, 0xFE3B, 0xFE3C, 0xFE3D,
    0xFE3E, 0xFE3F, 0xFE40, 0xFE41, 0xFE42, 0xFE43, 0xFE44, 0xFE49,
    0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D, 0xFE4E, 0xFE4F, 0xFE50, 0xFE51,
    0xFE52, 0xFE54, 0xFE55, 0xFE56, 0xFE57, 0xFE59, 0xFE5A, 0xFE5B,
    0xFE5C, 0xFE5D, 0xFE5E, 0xFE5F, 0xFE60, 0xFE61, 0xFE62, 0xFE63,
    0xFE64, 0xFE65, 0xFE66, 0xFE68, 0xFE69, 0xFE6A, 0xFE6B, 0xFFE2,
    0xFFE4,
};
#endif /* ZUECI_EMBED_NO_TO_ECI */

#ifndef ZUECI_EMBED_NO_TO_ECI
/* Multibyte values sorted in Unicode order */
static const zueci_u16 zueci_gbk_u_mb[14348] = {
    0xA1A4, 0xA8BD, 0xA8BE, 0xA8BB, 0xA8C0, 0xA840, 0xA841, 0xA842,
    0xA95C, 0xA843, 0xA1AA, 0xA844, 0xA845, 0xA846, 0xA847, 0xA848,
    0xA959, 0xA2A1, 0xA2A2, 0xA2A3, 0xA2A4, 0xA2A5, 0xA2A6, 0xA2A7,
    0xA2A8, 0xA2A9, 0xA2AA, 0xA849, 0xA84A, 0xA84B, 0xA84C, 0xA84D,
    0xA84E, 0xA84F, 0xA850, 0xA851, 0xA852, 0xA892, 0xA853, 0xA854,
    0xA855, 0xA856, 0xA857, 0xA858, 0xA859, 0xA85A, 0xA85B, 0xA85C,
    0xA85D, 0xA85E, 0xA85F, 0xA860, 0xA861, 0xA862, 0xA863, 0xA864,
    0xA865, 0xA866, 0xA867, 0xA868, 0xA869, 0xA86A, 0xA86B, 0xA86C,
    0xA86D, 0xA86E, 0xA86F, 0xA870, 0xA871, 0xA872, 0xA873, 0xA874,
    0xA875, 0xA876, 0xA877, 0xA878, 0xA879, 0xA87A, 0xA87B, 0xA87C,
    0xA87D, 0xA87E, 0xA880, 0xA881, 0xA882, 0xA883, 0xA884, 0xA885,
    0xA886, 0xA887, 0xA888, 0xA889, 0xA88A, 0xA88B, 0xA88C, 0xA88D,
    0xA88E, 0xA88F, 0xA890, 0xA891, 0xA965, 0xA996, 0xA893, 0xA894,
    0xA895, 0xA940, 0xA941, 0xA942, 0xA943, 0xA944, 0xA945, 0xA946,
    0xA947, 0xA948, 0xA961, 0xA962, 0xA966, 0xA967, 0xA960, 0xA963,
    0xA964, 0xA95A, 0xA949, 0xA94A, 0xA94B, 0xA94C, 0xA94D, 0xA94E,
    0xA94F, 0xA950, 0xA951, 0xA952, 0xA953, 0xA954, 0x8140, 0x8141,
    0x8142, 0x8143, 0x8144, 0x8145, 0x8146, 0x8147, 0x8148, 0x8149,
    0x814A, 0x814B, 0x814C, 0x814D, 0x814E, 0x814F, 0x8150, 0x8151,
    0x8152, 0x8153, 0x8154, 0x8155, 0x8156, 0x8157, 0x8158, 0x8159,
    0x815A, 0x815B, 0x815C, 0x815D, 0x815E, 0x815F, 0x8160, 0x8161,
    0x8162, 0x8163, 0x8164, 0x8165, 0x8166, 0x8167, 0x8168, 0x8169,
    0x816A, 0x816B, 0x816C, 0x816D, 0x816E, 0x816F, 0x8170, 0x8171,
    0x8172, 0x8173, 0x8174, 0x8175, 0x8176, 0x8177, 0x8178, 0x8179,
    0x817A, 0x817B, 0x817C, 0x817D, 0x817E, 0x8180, 0x8181, 0x8182,
    0x8183, 0x8184, 0x8185, 0x8186, 0x8187, 0x8188, 0x8189, 0x818A,
    0x818B, 0x818C, 0x818D, 0x818E, 0x818F, 0x8190, 0x8191, 0x8192,
    0x8193, 0x8194, 0x8195, 0x8196, 0x8197, 0x8198, 0x8199, 0x819A,
    0x819B, 0x819C, 0x819D, 0x819E, 0x819F, 0x81A0, 0x81A1, 0x81A2,
    0x81A3, 0x81A4, 0x81A5, 0x81A6, 0x81A7, 0x81A8, 0x81A9, 0x81AA,
    0x81AB, 0x81AC, 0x81AD, 0x81AE, 0x81AF, 0x81B0, 0x81B1, 0x81B2,
    0x81B3, 0x81B4, 0x81B5, 0x81B6, 0x81B7, 0x81B8, 0x81B9, 0x81BA,
    0x81BB, 0x81BC, 0x81BD, 0x81BE, 0x81BF, 0x81C0, 0x81C1, 0x81C2,
    0x81C3, 0x81C4, 0x81C5, 0x81C6, 0x81C7, 0x81C8, 0x81C9, 0x81CA,
    0x81CB, 0x81CC, 0x81CD, 0x81CE, 0x81CF, 0x81D0, 0x81D1, 0x81D2,
    0x81D3, 0x81D4, 0x81D5, 0x81D6, 0x81D7, 0x81D8, 0x81D9, 0x81DA,
    0x81DB, 0x81DC, 0x81DD, 0x81DE, 0x81DF, 0x81E0, 0x81E1, 0x81E2,
    0x81E3, 0x81E4, 0x81E5, 0x81E6, 0x81E7, 0x81E8, 0x81E9, 0x81EA,
    0x81EB, 0x81EC, 0x81ED, 0x81EE, 0x81EF, 0x81F0, 0x81F1, 0x81F2,
    0x81F3, 0x81F4, 0x81F5, 0x81F6, 0x81F7, 0x81F8, 0x81F9, 0x81FA,
    0x81FB, 0x81FC, 0x81FD, 0x81FE, 0x8240, 0x8241, 0x8242, 0x8243,
    0x8244, 0x8245, 0x8246, 0x8247, 0x8248, 0x8249, 0x824A, 0x824B,
    0x824C, 0x824D, 0x824E, 0x824F, 0x8250, 0x8251, 0x8252, 0x8253,
    0x8254, 0x8255, 0x8256, 0x8257, 0x8258, 0x8259, 0x825A, 0x825B,
    0x825C, 0x825D, 0x825E, 0x825F, 0x8260, 0x8261, 0x8262, 0x8263,
    0x8264, 0x8265, 0x8266, 0x8267, 0x8268, 0x8269, 0x826A, 0x826B,
    0x826C, 0x826D, 0x826E, 0x826F, 0x8270, 0x8271, 0x8272, 0x8273,
    0x8274, 0x8275, 0x8276, 0x8277, 0x8278, 0x8279, 0x827A, 0x827B,
    0x827C, 0x827D, 0x827E, 0x8280, 0x8281, 0x8282, 0x8283, 0x8284,
    0x8285, 0x8286, 0x8287, 0x8288, 0x8289, 0x828A, 0x828B, 0x828C,
    0x828D, 0x828E, 0x828F, 0x8290, 0x8291, 0x8292, 0x8293, 0x8294,
    0x8295, 0x8296, 0x8297, 0x8298, 0x8299, 0x829A, 0x829B, 0x829C,
    0x829D, 0x829E, 0x829F, 0x82A0, 0x82A1, 0x82A2, 0x82A3, 0x82A4,
    0x82A5, 0x82A6, 0x82A7, 0x82A8, 0x82A9, 0x82AA, 0x82AB, 0x82AC,
    0x82AD, 0x82AE, 0x82AF, 0x82B0, 0x82B1, 0x82B2, 0x82B3, 0x82B4,
    0x82B5, 0x82B6, 0x82B7, 0x82B8, 0x82B9, 0x82BA, 0x82BB, 0x82BC,
    0x82BD, 0x82BE, 0x82BF, 0x82C0, 0x82C1, 0x82C2, 0x82C3, 0x82C4,
    0x82C5, 0x82C6, 0x82C7, 0x82C8, 0x82C9, 0x82CA, 0x82CB, 0x82CC,
    0x82CD, 0x82CE, 0x82CF, 0x82D0, 0x82D1, 0x82D2, 0x82D3, 0x82D4,
    0x82D5, 0x82D6, 0x82D7, 0x82D8, 0x82D9, 0x82DA, 0x82DB, 0x82DC,
    0x82DD, 0x82DE, 0x82DF, 0x82E0, 0x82E1, 0x82E2, 0x82E3, 0x82E4,
    0x82E5, 0x82E6, 0x82E7, 0x82E8, 0x82E9, 0x82EA, 0x82EB, 0x82EC,
    0x82ED, 0x82EE, 0x82EF, 0x82F0, 0x82F1, 0x82F2, 0x82F3, 0x82F4,
    0x82F5, 0x82F6, 0x82F7, 0x82F8, 0x82F9, 0x82FA, 0x82FB, 0x82FC,
    0x82FD, 0x82FE, 0x8340, 0x8341, 0x8342, 0x8343, 0x8344, 0x8345,
    0x8346, 0x8347, 0x8348, 0x8349, 0x834A, 0x834B, 0x834C, 0x834D,
    0x834E, 0x834F, 0x8350, 0x8351, 0x8352, 0x8353, 0x8354, 0x8355,
    0x8356, 0x8357, 0x8358, 0x8359, 0x835A, 0x835B, 0x835C, 0x835D,
    0x835E, 0x835F, 0x8360, 0x8361, 0x8362, 0x8363, 0x8364, 0x8365,
    0x8366, 0x8367, 0x8368, 0x8369, 0x836A, 0x836B, 0x836C, 0x836D,
    0x836E, 0x836F, 0x8370, 0x8371, 0x8372, 0x8373, 0x8374, 0x8375,
    0x8376, 0x8377, 0x8378, 0x8379, 0x837A, 0x837B, 0x837C, 0x837D,
    0x837E, 0x8380, 0x8381, 0x8382, 0x8383, 0x8384, 0x8385, 0x8386,
    0x8387, 0x8388, 0x8389, 0x838A, 0x838B, 0x838C, 0x838D, 0x838E,
    0x838F, 0x8390, 0x8391, 0x8392, 0x8393, 0x8394, 0x8395, 0x8396,
    0x8397, 0x8398, 0x8399, 0x839A, 0x839B, 0x839C, 0x839D, 0x839E,
    0x839F, 0x83A0, 0x83A1, 0x83A2, 0x83A3, 0x83A4, 0x83A5, 0x83A6,
    0x83A7, 0x83A8, 0x83A9, 0x83AA, 0x83AB, 0x83AC, 0x83AD, 0x83AE,
    0x83AF, 0x83B0, 0x83B1, 0x83B2, 0x83B3, 0x83B4, 0x83B5, 0x83B6,
    0x83B7, 0x83B8, 0x83B9, 0x83BA, 0x83BB, 0x83BC, 0x83BD, 0x83BE,
    0x83BF, 0x83C0, 0x83C1, 0x83C2, 0x83C3, 0x83C4, 0x83C5, 0x83C6,
    0x83C7, 0x83C8, 0x83C9, 0x83CA, 0x83CB, 0x83CC, 0x83CD, 0x83CE,
    0x83CF, 0x83D0, 0x83D1, 0x83D2, 0x83D3, 0x83D4, 0x83D5, 0x83D6,
    0x83D7, 0x83D8, 0x83D9, 0x83DA, 0x83DB, 0x83DC, 0x83DD, 0x83DE,
    0x83DF, 0x83E0, 0x83E1, 0x83E2, 0x83E3, 0x83E4, 0x83E5, 0x83E6,
    0x83E7, 0x83E8, 0x83E9, 0x83EA, 0x83EB, 0x83EC, 0x83ED, 0x83EE,
    0x83EF, 0x83F0, 0x83F1, 0x83F2, 0x83F3, 0x83F4, 0x83F5, 0x83F6,
    0x83F7, 0x83F8, 0x83F9, 0x83FA, 0x83FB, 0x83FC, 0x83FD, 0x83FE,
    0x8440, 0x8441, 0x8442, 0x8443, 0x8444, 0x8445, 0x8446, 0x8447,
    0x8448, 0x8449, 0x844A, 0x844B, 0x844C, 0x844D, 0x844E, 0x844F,
    0x8450, 0x8451, 0x8452, 0x8453, 0x8454, 0x8455, 0x8456, 0x8457,
    0x8458, 0x8459, 0x845A, 0x845B, 0x845C, 0x845D, 0x845E, 0x845F,
    0x8460, 0x8461, 0x8462, 0x8463, 0x8464, 0x8465, 0x8466, 0x8467,
    0x8468, 0x8469, 0x846A, 0x846B, 0x846C, 0x846D, 0x846E, 0x846F,
    0x8470, 0x8471, 0x8472, 0x8473, 0x8474, 0x8475, 0x8476, 0x8477,
    0x8478, 0x8479, 0x847A, 0x847B, 0x847C, 0x847D, 0x847E, 0x8480,
    0x8481, 0x8482, 0x8483, 0x8484, 0x8485, 0x8486, 0x8487, 0x8488,
    0x8489, 0x848A, 0x848B, 0x848C, 0x848D, 0x848E, 0x848F, 0x8490,
    0x8491, 0x8492, 0x8493, 0x8494, 0x8495, 0x8496, 0x8497, 0x8498,
    0x8499, 0x849A, 0x849B, 0x849C, 0x849D, 0x849E, 0x849F, 0x84A0,
    0x84A1, 0x84A2, 0x84A3, 0x84A4, 0x84A5, 0x84A6, 0x84A7, 0x84A8,
    0x84A9, 0x84AA, 0x84AB, 0x84AC, 0x84AD, 0x84AE, 0x84AF, 0x84B0,
    0x84B1, 0x84B2, 0x84B3, 0x84B4, 0x84B5, 0x84B6, 0x84B7, 0x84B8,
    0x84B9, 0x84BA, 0x84BB, 0x84BC, 0x84BD, 0x84BE, 0x84BF, 0x84C0,
    0x84C1, 0x84C2, 0x84C3, 0x84C4, 0x84C5, 0x84C6, 0x84C7, 0x84C8,
    0x84C9, 0x84CA, 0x84CB, 0x84CC, 0x84CD, 0x84CE, 0x84CF, 0x84D0,
    0x84D1, 0x84D2, 0x84D3, 0x84D4, 0x84D5, 0x84D6, 0x84D7, 0x84D8,
    0x84D9, 0x84DA, 0x84DB, 0x84DC, 0x84DD, 0x84DE, 0x84DF, 0x84E0,
    0x84E1, 0x84E2, 0x84E3, 0x84E4, 0x84E5, 0x84E6, 0x84E7, 0x84E8,
    0x84E9, 0x84EA, 0x84EB, 0x84EC, 0x84ED, 0x84EE, 0x84EF, 0x84F0,
    0x84F1, 0x84F2, 0x84F3, 0x84F4, 0x84F5, 0x84F6, 0x84F7, 0x84F8,
    0x84F9, 0x84FA, 0x84FB, 0x84FC, 0x84FD, 0x84FE, 0x8540, 0x8541,
    0x8542, 0x8543, 0x8544, 0x8545, 0x8546, 0x8547, 0x8548, 0x8549,
    0x854A, 0x854B, 0x854C, 0x854D, 0x854E, 0x854F, 0x8550, 0x8551,
    0x8552, 0x8553, 0x8554, 0x8555, 0x8556, 0x8557, 0x8558, 0x8559,
    0x855A, 0x855B, 0x855C, 0x855D, 0x855E, 0x855F, 0x8560, 0x8561,
    0x8562, 0x8563, 0x8564, 0x8565, 0x8566, 0x8567, 0x8568, 0x8569,
    0x856A, 0x856B, 0x856C, 0x856D, 0x856E, 0x856F, 0x8570, 0x8571,
    0x8572, 0x8573, 0x8574, 0x8575, 0x8576, 0x8577, 0x8578, 0x8579,
    0x857A, 0x857B, 0x857C, 0x857D, 0x857E, 0x8580, 0x8581, 0x8582,
    0x8583, 0x8584, 0x8585, 0x8586, 0x8587, 0x8588, 0x8589, 0x858A,
    0x858B, 0x858C, 0x858D, 0x858E, 0x858F, 0x8590, 0x8591, 0x8592,
    0x8593, 0x8594, 0x8595, 0x8596, 0x8597, 0x8598, 0x8599, 0x859A,
    0x859B, 0x859C, 0x859D, 0x859E, 0x859F, 0x85A0, 0x85A1, 0x85A2,
    0x85A3, 0x85A4, 0x85A5, 0x85A6, 0x85A7, 0x85A8, 0x85A9, 0x85AA,
    0x85AB, 0x85AC, 0x85AD, 0x85AE, 0x85AF, 0x85B0, 0x85B1, 0x85B2,
    0x85B3, 0x85B4, 0x85B5, 0x85B6, 0x85B7, 0x85B8, 0x85B9, 0x85BA,
    0x85BB, 0x85BC, 0x85BD, 0x85BE, 0x85BF, 0x85C0, 0x85C1, 0x85C2,
    0x85C3, 0x85C4, 0x85C5, 0x85C6, 0x85C7, 0x85C8, 0x85C9, 0x85CA,
    0x85CB, 0x85CC, 0x85CD, 0x85CE, 0x85CF, 0x85D0, 0x85D1, 0x85D2,
    0x85D3, 0x85D4, 0x85D5, 0x85D6, 0x85D7, 0x85D8, 0x85D9, 0x85DA,
    0x85DB, 0x85DC, 0x85DD, 0x85DE, 0x85DF, 0x85E0, 0x85E1, 0x85E2,
    0x85E3, 0x85E4, 0x85E5, 0x85E6, 0x85E7, 0x85E8, 0x85E9, 0x85EA,
    0x85EB, 0x85EC, 0x85ED, 0x85EE, 0x85EF, 0x85F0, 0x85F1, 0x85F2,
    0x85F3, 0x85F4, 0x85F5, 0x85F6, 0x85F7, 0x85F8, 0x85F9, 0x85FA,
    0x85FB, 0x85FC, 0x85FD, 0x85FE, 0x8640, 0x8641, 0x8642, 0x8643,
    0x8644, 0x8645, 0x8646, 0x8647, 0x8648, 0x8649, 0x864A, 0x864B,
    0x864C, 0x864D, 0x864E, 0x864F, 0x8650, 0x8651, 0x8652, 0x8653,
    0x8654, 0x8655, 0x8656, 0x8657, 0x8658, 0x8659, 0x865A, 0x865B,
    0x865C, 0x865D, 0x865E, 0x865F, 0x8660, 0x8661, 0x8662, 0x8663,
    0x8664, 0x8665, 0x8666, 0x8667, 0x8668, 0x8669, 0x866A, 0x866B,
    0x866C, 0x866D, 0x866E, 0x866F, 0x8670, 0x8671, 0x8672, 0x8673,
    0x8674, 0x8675, 0x8676, 0x8677, 0x8678, 0x8679, 0x867A, 0x867B,
    0x867C, 0x867D, 0x867E, 0x8680, 0x8681, 0x8682, 0x8683, 0x8684,
    0x8685, 0x8686, 0x8687, 0x8688, 0x8689, 0x868A, 0x868B, 0x868C,
    0x868D, 0x868E, 0x868F, 0x8690, 0x8691, 0x8692, 0x8693, 0x8694,
    0x8695, 0x8696, 0x8697, 0x8698, 0x8699, 0x869A, 0x869B, 0x869C,
    0x869D, 0x869E, 0x869F, 0x86A0, 0x86A1, 0x86A2, 0x86A3, 0x86A4,
    0x86A5, 0x86A6, 0x86A7, 0x86A8, 0x86A9, 0x86AA, 0x86AB, 0x86AC,
    0x86AD, 0x86AE, 0x86AF, 0x86B0, 0x86B1, 0x86B2, 0x86B3, 0x86B4,
    0x86B5, 0x86B6, 0x86B7, 0x86B8, 0x86B9, 0x86BA, 0x86BB, 0x86BC,
    0x86BD, 0x86BE, 0x86BF, 0x86C0, 0x86C1, 0x86C2, 0x86C3, 0x86C4,
    0x86C5, 0x86C6, 0x86C7, 0x86C8, 0x86C9, 0x86CA, 0x86CB, 0x86CC,
    0x86CD, 0x86CE, 0x86CF, 0x86D0, 0x86D1, 0x86D2, 0x86D3, 0x86D4,
    0x86D5, 0x86D6, 0x86D7, 0x86D8, 0x86D9, 0x86DA, 0x86DB, 0x86DC,
    0x86DD, 0x86DE, 0x86DF, 0x86E0, 0x86E1, 0x86E2, 0x86E3, 0x86E4,
    0x86E5, 0x86E6, 0x86E7, 0x86E8, 0x86E9, 0x86EA, 0x86EB, 0x86EC,
    0x86ED, 0x86EE, 0x86EF, 0x86F0, 0x86F1, 0x86F2, 0x86F3, 0x86F4,
    0x86F5, 0x86F6, 0x86F7, 0x86F8, 0x86F9, 0x86FA, 0x86FB, 0x86FC,
    0x86FD, 0x86FE, 0x8740, 0x8741, 0x8742, 0x8743, 0x8744, 0x8745,
    0x8746, 0x8747, 0x8748, 0x8749, 0x874A, 0x874B, 0x874C, 0x874D,
    0x874E, 0x874F, 0x8750, 0x8751, 0x8752, 0x8753, 0x8754, 0x8755,
    0x8756, 0x8757, 0x8758, 0x8759, 0x875A, 0x875B, 0x875C, 0x875D,
    0x875E, 0x875F, 0x8760, 0x8761, 0x8762, 0x8763, 0x8764, 0x8765,
    0x8766, 0x8767, 0x8768, 0x8769, 0x876A, 0x876B, 0x876C, 0x876D,
    0x876E, 0x876F, 0x8770, 0x8771, 0x8772, 0x8773, 0x8774, 0x8775,
    0x8776, 0x8777, 0x8778, 0x8779, 0x877A, 0x877B, 0x877C, 0x877D,
    0x877E, 0x8780, 0x8781, 0x8782, 0x8783, 0x8784, 0x8785, 0x8786,
    0x8787, 0x8788, 0x8789, 0x878A, 0x878B, 0x878C, 0x878D, 0x878E,
    0x878F, 0x8790, 0x8791, 0x8792, 0x8793, 0x8794, 0x8795, 0x8796,
    0x8797, 0x8798, 0x8799, 0x879A, 0x879B, 0x879C, 0x879D, 0x879E,
    0x879F, 0x87A0, 0x87A1, 0x87A2, 0x87A3, 0x87A4, 0x87A5, 0x87A6,
    0x87A7, 0x87A8, 0x87A9, 0x87AA, 0x87AB, 0x87AC, 0x87AD, 0x87AE,
    0x87AF, 0x87B0, 0x87B1, 0x87B2, 0x87B3, 0x87B4, 0x87B5, 0x87B6,
    0x87B7, 0x87B8, 0x87B9, 0x87BA, 0x87BB, 0x87BC, 0x87BD, 0x87BE,
    0x87BF, 0x87C0, 0x87C1, 0x87C2, 0x87C3, 0x87C4, 0x87C5, 0x87C6,
    0x87C7, 0x87C8, 0x87C9, 0x87CA, 0x87CB, 0x87CC, 0x87CD, 0x87CE,
    0x87CF, 0x87D0, 0x87D1, 0x87D2, 0x87D3, 0x87D4, 0x87D5, 0x87D6,
    0x87D7, 0x87D8, 0x87D9, 0x87DA, 0x87DB, 0x87DC, 0x87DD, 0x87DE,
    0x87DF, 0x87E0, 0x87E1, 0x87E2, 0x87E3, 0x87E4, 0x87E5, 0x87E6,
    0x87E7, 0x87E8, 0x87E9, 0x87EA, 0x87EB, 0x87EC, 0x87ED, 0x87EE,
    0x87EF, 0x87F0, 0x87F1, 0x87F2, 0x87F3, 0x87F4, 0x87F5, 0x87F6,
    0x87F7, 0x87F8, 0x87F9, 0x87FA, 0x87FB, 0x87FC, 0x87FD, 0x87FE,
    0x8840, 0x8841, 0x8842, 0x8843, 0x8844, 0x8845, 0x8846, 0x8847,
    0x8848, 0x8849, 0x884A, 0x884B, 0x884C, 0x884D, 0x884E, 0x884F,
    0x8850, 0x8851, 0x8852, 0x8853, 0x8854, 0x8855, 0x8856, 0x8857,
    0x8858, 0x8859, 0x885A, 0x885B, 0x885C, 0x885D, 0x885E, 0x885F,
    0x8860, 0x8861, 0x8862, 0x8863, 0x8864, 0x8865, 0x8866, 0x8867,
    0x8868, 0x8869, 0x886A, 0x886B, 0x886C, 0x886D, 0x886E, 0x886F,
    0x8870, 0x8871, 0x8872, 0x8873, 0x8874, 0x8875, 0x8876, 0x8877,
    0x8878, 0x8879, 0x887A, 0x887B, 0x887C, 0x887D, 0x887E, 0x8880,
    0x8881, 0x8882, 0x8883, 0x8884, 0x8885, 0x8886, 0x8887, 0x8888,
    0x8889, 0x888A, 0x888B, 0x888C, 0x888D, 0x888E, 0x888F, 0x8890,
    0x8891, 0x8892, 0x8893, 0x8894, 0x8895, 0x8896, 0x8897, 0x8898,
    0x8899, 0x889A, 0x889B, 0x889C, 0x889D, 0x889E, 0x889F, 0x88A0,
    0x88A1, 0x88A2, 0x88A3, 0x88A4, 0x88A5, 0x88A6, 0x88A7, 0x88A8,
    0x88A9, 0x88AA, 0x88AB, 0x88AC, 0x88AD, 0x88AE, 0x88AF, 0x88B0,
    0x88B1, 0x88B2, 0x88B3, 0x88B4, 0x88B5, 0x88B6, 0x88B7, 0x88B8,
    0x88B9, 0x88BA, 0x88BB, 0x88BC, 0x88BD, 0x88BE, 0x88BF, 0x88C0,
    0x88C1, 0x88C2, 0x88C3, 0x88C4, 0x88C5, 0x88C6, 0x88C7, 0x88C8,
    0x88C9, 0x88CA, 0x88CB, 0x88CC, 0x88CD, 0x88CE, 0x88CF, 0x88D0,
    0x88D1, 0x88D2, 0x88D3, 0x88D4, 0x88D5, 0x88D6, 0x88D7, 0x88D8,
    0x88D9, 0x88DA, 0x88DB, 0x88DC, 0x88DD, 0x88DE, 0x88DF, 0x88E0,
    0x88E1, 0x88E2, 0x88E3, 0x88E4, 0x88E5, 0x88E6, 0x88E7, 0x88E8,
    0x88E9, 0x88EA, 0x88EB, 0x88EC, 0x88ED, 0x88EE, 0x88EF, 0x88F0,
    0x88F1, 0x88F2, 0x88F3, 0x88F4, 0x88F5, 0x88F6, 0x88F7, 0x88F8,
    0x88F9, 0x88FA, 0x88FB, 0x88FC, 0x88FD, 0x88FE, 0x8940, 0x8941,
    0x8942, 0x8943, 0x8944, 0x8945, 0x8946, 0x8947, 0x8948, 0x8949,
    0x894A, 0x894B, 0x894C, 0x894D, 0x894E, 0x894F, 0x8950, 0x8951,
    0x8952, 0x8953, 0x8954, 0x8955, 0x8956, 0x8957, 0x8958, 0x8959,
    0x895A, 0x895B, 0x895C, 0x895D, 0x895E, 0x895F, 0x8960, 0x8961,
    0x8962, 0x8963, 0x8964, 0x8965, 0x8966, 0x8967, 0x8968, 0x8969,
    0x896A, 0x896B, 0x896C, 0x896D, 0x896E, 0x896F, 0x8970, 0x8971,
    0x8972, 0x8973, 0x8974, 0x8975, 0x8976, 0x8977, 0x8978, 0x8979,
    0x897A, 0x897B, 0x897C, 0x897D, 0x897E, 0x8980, 0x8981, 0x8982,
    0x8983, 0x8984, 0x8985, 0x8986, 0x8987, 0x8988, 0x8989, 0x898A,
    0x898B, 0x898C, 0x898D, 0x898E, 0x898F, 0x8990, 0x8991, 0x8992,
    0x8993, 0x8994, 0x8995, 0x8996, 0x8997, 0x8998, 0x8999, 0x899A,
    0x899B, 0x899C, 0x899D, 0x899E, 0x899F, 0x89A0, 0x89A1, 0x89A2,
    0x89A3, 0x89A4, 0x89A5, 0x89A6, 0x89A7, 0x89A8, 0x89A9, 0x89AA,
    0x89AB, 0x89AC, 0x89AD, 0x89AE, 0x89AF, 0x89B0, 0x89B1, 0x89B2,
    0x89B3, 0x89B4, 0x89B5, 0x89B6, 0x89B7, 0x89B8, 0x89B9, 0x89BA,
    0x89BB, 0x89BC, 0x89BD, 0x89BE, 0x89BF, 0x89C0, 0x89C1, 0x89C2,
    0x89C3, 0x89C4, 0x89C5, 0x89C6, 0x89C7, 0x89C8, 0x89C9, 0x89CA,
    0x89CB, 0x89CC, 0x89CD, 0x89CE, 0x89CF, 0x89D0, 0x89D1, 0x89D2,
    0x89D3, 0x89D4, 0x89D5, 0x89D6, 0x89D7, 0x89D8, 0x89D9, 0x89DA,
    0x89DB, 0x89DC, 0x89DD, 0x89DE, 0x89DF, 0x89E0, 0x89E1, 0x89E2,
    0x89E3, 0x89E4, 0x89E5, 0x89E6, 0x89E7, 0x89E8, 0x89E9, 0x89EA,
    0x89EB, 0x89EC, 0x89ED, 0x89EE, 0x89EF, 0x89F0, 0x89F1, 0x89F2,
    0x89F3, 0x89F4, 0x89F5, 0x89F6, 0x89F7, 0x89F8, 0x89F9, 0x89FA,
    0x89FB, 0x89FC, 0x89FD, 0x89FE, 0x8A40, 0x8A41, 0x8A42, 0x8A43,
    0x8A44, 0x8A45, 0x8A46, 0x8A47, 0x8A48, 0x8A49, 0x8A4A, 0x8A4B,
    0x8A4C, 0x8A4D, 0x8A4E, 0x8A4F, 0x8A50, 0x8A51, 0x8A52, 0x8A53,
    0x8A54, 0x8A55, 0x8A56, 0x8A57, 0x8A58, 0x8A59, 0x8A5A, 0x8A5B,
    0x8A5C, 0x8A5D, 0x8A5E, 0x8A5F, 0x8A60, 0x8A61, 0x8A62, 0x8A63,
    0x8A64, 0x8A65, 0x8A66, 0x8A67, 0x8A68, 0x8A69, 0x8A6A, 0x8A6B,
    0x8A6C, 0x8A6D, 0x8A6E, 0x8A6F, 0x8A70, 0x8A71, 0x8A72, 0x8A73,
    0x8A74, 0x8A75, 0x8A76, 0x8A77, 0x8A78, 0x8A79, 0x8A7A, 0x8A7B,
    0x8A7C, 0x8A7D, 0x8A7E, 0x8A80, 0x8A81, 0x8A82, 0x8A83, 0x8A84,
    0x8A85, 0x8A86, 0x8A87, 0x8A88, 0x8A89, 0x8A8A, 0x8A8B, 0x8A8C,
    0x8A8D, 0x8A8E, 0x8A8F, 0x8A90, 0x8A91, 0x8A92, 0x8A93, 0x8A94,
    0x8A95, 0x8A96, 0x8A97, 0x8A98, 0x8A99, 0x8A9A, 0x8A9B, 0x8A9C,
    0x8A9D, 0x8A9E, 0x8A9F, 0x8AA0, 0x8AA1, 0x8AA2, 0x8AA3, 0x8AA4,
    0x8AA5, 0x8AA6, 0x8AA7, 0x8AA8, 0x8AA9, 0x8AAA, 0x8AAB, 0x8AAC,
    0x8AAD, 0x8AAE, 0x8AAF, 0x8AB0, 0x8AB1, 0x8AB2, 0x8AB3, 0x8AB4,
    0x8AB5, 0x8AB6, 0x8AB7, 0x8AB8, 0x8AB9, 0x8ABA, 0x8ABB, 0x8ABC,
    0x8ABD, 0x8ABE, 0x8ABF, 0x8AC0, 0x8AC1, 0x8AC2, 0x8AC3, 0x8AC4,
    0x8AC5, 0x8AC6, 0x8AC7, 0x8AC8, 0x8AC9, 0x8ACA, 0x8ACB, 0x8ACC,
    0x8ACD, 0x8ACE, 0x8ACF, 0x8AD0, 0x8AD1, 0x8AD2, 0x8AD3, 0x8AD4,
    0x8AD5, 0x8AD6, 0x8AD7, 0x8AD8, 0x8AD9, 0x8ADA, 0x8ADB, 0x8ADC,
    0x8ADD, 0x8ADE, 0x8ADF, 0x8AE0, 0x8AE1, 0x8AE2, 0x8AE3, 0x8AE4,
    0x8AE5, 0x8AE6, 0x8AE7, 0x8AE8, 0x8AE9, 0x8AEA, 0x8AEB, 0x8AEC,
    0x8AED, 0x8AEE, 0x8AEF, 0x8AF0, 0x8AF1, 0x8AF2, 0x8AF3, 0x8AF4,
    0x8AF5, 0x8AF6, 0x8AF7, 0x8AF8, 0x8AF9, 0x8AFA, 0x8AFB, 0x8AFC,
    0x8AFD, 0x8AFE, 0x8B40, 0x8B41, 0x8B42, 0x8B43, 0x8B44, 0x8B45,
    0x8B46, 0x8B47, 0x8B48, 0x8B49, 0x8B4A, 0x8B4B, 0x8B4C, 0x8B4D,
    0x8B4E, 0x8B4F, 0x8B50, 0x8B51, 0x8B52, 0x8B53, 0x8B54, 0x8B55,
    0x8B56, 0x8B57, 0x8B58, 0x8B59, 0x8B5A, 0x8B5B, 0x8B5C, 0x8B5D,
    0x8B5E, 0x8B5F, 0x8B60, 0x8B61, 0x8B62, 0x8B63, 0x8B64, 0x8B65,
    0x8B66, 0x8B67, 0x8B68, 0x8B69, 0x8B6A, 0x8B6B, 0x8B6C, 0x8B6D,
    0x8B6E, 0x8B6F, 0x8B70, 0x8B71, 0x8B72, 0x8B73, 0x8B74, 0x8B75,
    0x8B76, 0x8B77, 0x8B78, 0x8B79, 0x8B7A, 0x8B7B, 0x8B7C, 0x8B7D,
    0x8B7E, 0x8B80, 0x8B81, 0x8B82, 0x8B83, 0x8B84, 0x8B85, 0x8B86,
    0x8B87, 0x8B88, 0x8B89, 0x8B8A, 0x8B8B, 0x8B8C, 0x8B8D, 0x8B8E,
    0x8B8F, 0x8B90, 0x8B91, 0x8B92, 0x8B93, 0x8B94, 0x8B95, 0x8B96,
    0x8B97, 0x8B98, 0x8B99, 0x8B9A, 0x8B9B, 0x8B9C, 0x8B9D, 0x8B9E,
    0x8B9F, 0x8BA0, 0x8BA1, 0x8BA2, 0x8BA3, 0x8BA4, 0x8BA5, 0x8BA6,
    0x8BA7, 0x8BA8, 0x8BA9, 0x8BAA, 0x8BAB, 0x8BAC, 0x8BAD, 0x8BAE,
    0x8BAF, 0x8BB0, 0x8BB1, 0x8BB2, 0x8BB3, 0x8BB4, 0x8BB5, 0x8BB6,
    0x8BB7, 0x8BB8, 0x8BB9, 0x8BBA, 0x8BBB, 0x8BBC, 0x8BBD, 0x8BBE,
    0x8BBF, 0x8BC0, 0x8BC1, 0x8BC2, 0x8BC3, 0x8BC4, 0x8BC5, 0x8BC6,
    0x8BC7, 0x8BC8, 0x8BC9, 0x8BCA, 0x8BCB, 0x8BCC, 0x8BCD, 0x8BCE,
    0x8BCF, 0x8BD0, 0x8BD1, 0x8BD2, 0x8BD3, 0x8BD4, 0x8BD5, 0x8BD6,
    0x8BD7, 0x8BD8, 0x8BD9, 0x8BDA, 0x8BDB, 0x8BDC, 0x8BDD, 0x8BDE,
    0x8BDF, 0x8BE0, 0x8BE1, 0x8BE2, 0x8BE3, 0x8BE4, 0x8BE5, 0x8BE6,
    0x8BE7, 0x8BE8, 0x8BE9, 0x8BEA, 0x8BEB, 0x8BEC, 0x8BED, 0x8BEE,
    0x8BEF, 0x8BF0, 0x8BF1, 0x8BF2, 0x8BF3, 0x8BF4, 0x8BF5, 0x8BF6,
    0x8BF7, 0x8BF8, 0x8BF9, 0x8BFA, 0x8BFB, 0x8BFC, 0x8BFD, 0x8BFE,
    0x8C40, 0x8C41, 0x8C42, 0x8C43, 0x8C44, 0x8C45, 0x8C46, 0x8C47,
    0x8C48, 0x8C49, 0x8C4A, 0x8C4B, 0x8C4C, 0x8C4D, 0x8C4E, 0x8C4F,
    0x8C50, 0x8C51, 0x8C52, 0x8C53, 0x8C54, 0x8C55, 0x8C56, 0x8C57,
    0x8C58, 0x8C59, 0x8C5A, 0x8C5B, 0x8C5C, 0x8C5D, 0x8C5E, 0x8C5F,
    0x8C60, 0x8C61, 0x8C62, 0x8C63, 0x8C64, 0x8C65, 0x8C66, 0x8C67,
    0x8C68, 0x8C69, 0x8C6A, 0x8C6B, 0x8C6C, 0x8C6D, 0x8C6E, 0x8C6F,
    0x8C70, 0x8C71, 0x8C72, 0x8C73, 0x8C74, 0x8C75, 0x8C76, 0x8C77,
    0x8C78, 0x8C79, 0x8C7A, 0x8C7B, 0x8C7C, 0x8C7D, 0x8C7E, 0x8C80,
    0x8C81, 0x8C82, 0x8C83, 0x8C84, 0x8C85, 0x8C86, 0x8C87, 0x8C88,
    0x8C89, 0x8C8A, 0x8C8B, 0x8C8C, 0x8C8D, 0x8C8E, 0x8C8F, 0x8C90,
    0x8C91, 0x8C92, 0x8C93, 0x8C94, 0x8C95, 0x8C96, 0x8C97, 0x8C98,
    0x8C99, 0x8C9A, 0x8C9B, 0x8C9C, 0x8C9D, 0x8C9E, 0x8C9F, 0x8CA0,
    0x8CA1, 0x8CA2, 0x8CA3, 0x8CA4, 0x8CA5, 0x8CA6, 0x8CA7, 0x8CA8,
    0x8CA9, 0x8CAA, 0x8CAB, 0x8CAC, 0x8CAD, 0x8CAE, 0x8CAF, 0x8CB0,
    0x8CB1, 0x8CB2, 0x8CB3, 0x8CB4, 0x8CB5, 0x8CB6, 0x8CB7, 0x8CB8,
    0x8CB9, 0x8CBA, 0x8CBB, 0x8CBC, 0x8CBD, 0x8CBE, 0x8CBF, 0x8CC0,
    0x8CC1, 0x8CC2, 0x8CC3, 0x8CC4, 0x8CC5, 0x8CC6, 0x8CC7, 0x8CC8,
    0x8CC9, 0x8CCA, 0x8CCB, 0x8CCC, 0x8CCD, 0x8CCE, 0x8CCF, 0x8CD0,
    0x8CD1, 0x8CD2, 0x8CD3, 0x8CD4, 0x8CD5, 0x8CD6, 0x8CD7, 0x8CD8,
    0x8CD9, 0x8CDA, 0x8CDB, 0x8CDC, 0x8CDD, 0x8CDE, 0x8CDF, 0x8CE0,
    0x8CE1, 0x8CE2, 0x8CE3, 0x8CE4, 0x8CE5, 0x8CE6, 0x8CE7, 0x8CE8,
    0x8CE9, 0x8CEA, 0x8CEB, 0x8CEC, 0x8CED, 0x8CEE, 0x8CEF, 0x8CF0,
    0x8CF1, 0x8CF2, 0x8CF3, 0x8CF4, 0x8CF5, 0x8CF6, 0x8CF7, 0x8CF8,
    0x8CF9, 0x8CFA, 0x8CFB, 0x8CFC, 0x8CFD, 0x8CFE, 0x8D40, 0x8D41,
    0x8D42, 0x8D43, 0x8D44, 0x8D45, 0x8D46, 0x8D47, 0x8D48, 0x8D49,
    0x8D4A, 0x8D4B, 0x8D4C, 0x8D4D, 0x8D4E, 0x8D4F, 0x8D50, 0x8D51,
    0x8D52, 0x8D53, 0x8D54, 0x8D55, 0x8D56, 0x8D57, 0x8D58, 0x8D59,
    0x8D5A, 0x8D5B, 0x8D5C, 0x8D5D, 0x8D5E, 0x8D5F, 0x8D60, 0x8D61,
    0x8D62, 0x8D63, 0x8D64, 0x8D65, 0x8D66, 0x8D67, 0x8D68, 0x8D69,
    0x8D6A, 0x8D6B, 0x8D6C, 0x8D6D, 0x8D6E, 0x8D6F, 0x8D70, 0x8D71,
    0x8D72, 0x8D73, 0x8D74, 0x8D75, 0x8D76, 0x8D77, 0x8D78, 0x8D79,
    0x8D7A, 0x8D7B, 0x8D7C, 0x8D7D, 0x8D7E, 0x8D80, 0x8D81, 0x8D82,
    0x8D83, 0x8D84, 0x8D85, 0x8D86, 0x8D87, 0x8D88, 0x8D89, 0x8D8A,
    0x8D8B, 0x8D8C, 0x8D8D, 0x8D8E, 0x8D8F, 0x8D90, 0x8D91, 0x8D92,
    0x8D93, 0x8D94, 0x8D95, 0x8D96, 0x8D97, 0x8D98, 0x8D99, 0x8D9A,
    0x8D9B, 0x8D9C, 0x8D9D, 0x8D9E, 0x8D9F, 0x8DA0, 0x8DA1, 0x8DA2,
    0x8DA3, 0x8DA4, 0x8DA5, 0x8DA6, 0x8DA7, 0x8DA8, 0x8DA9, 0x8DAA,
    0x8DAB, 0x8DAC, 0x8DAD, 0x8DAE, 0x8DAF, 0x8DB0, 0x8DB1, 0x8DB2,
    0x8DB3, 0x8DB4, 0x8DB5, 0x8DB6, 0x8DB7, 0x8DB8, 0x8DB9, 0x8DBA,
    0x8DBB, 0x8DBC, 0x8DBD, 0x8DBE, 0x8DBF, 0x8DC0, 0x8DC1, 0x8DC2,
    0x8DC3, 0x8DC4, 0x8DC5, 0x8DC6, 0x8DC7, 0x8DC8, 0x8DC9, 0x8DCA,
    0x8DCB, 0x8DCC, 0x8DCD, 0x8DCE, 0x8DCF, 0x8DD0, 0x8DD1, 0x8DD2,
    0x8DD3, 0x8DD4, 0x8DD5, 0x8DD6, 0x8DD7, 0x8DD8, 0x8DD9, 0x8DDA,
    0x8DDB, 0x8DDC, 0x8DDD, 0x8DDE, 0x8DDF, 0x8DE0, 0x8DE1, 0x8DE2,
    0x8DE3, 0x8DE4, 0x8DE5, 0x8DE6, 0x8DE7, 0x8DE8, 0x8DE9, 0x8DEA,
    0x8DEB, 0x8DEC, 0x8DED, 0x8DEE, 0x8DEF, 0x8DF0, 0x8DF1, 0x8DF2,
    0x8DF3, 0x8DF4, 0x8DF5, 0x8DF6, 0x8DF7, 0x8DF8, 0x8DF9, 0x8DFA,
    0x8DFB, 0x8DFC, 0x8DFD, 0x8DFE, 0x8E40, 0x8E41, 0x8E42, 0x8E43,
    0x8E44, 0x8E45, 0x8E46, 0x8E47, 0x8E48, 0x8E49, 0x8E4A, 0x8E4B,
    0x8E4C, 0x8E4D, 0x8E4E, 0x8E4F, 0x8E50, 0x8E51, 0x8E52, 0x8E53,
    0x8E54, 0x8E55, 0x8E56, 0x8E57, 0x8E58, 0x8E59, 0x8E5A, 0x8E5B,
    0x8E5C, 0x8E5D, 0x8E5E, 0x8E5F, 0x8E60, 0x8E61, 0x8E62, 0x8E63,
    0x8E64, 0x8E65, 0x8E66, 0x8E67, 0x8E68, 0x8E69, 0x8E6A, 0x8E6B,
    0x8E6C, 0x8E6D, 0x8E6E, 0x8E6F, 0x8E70, 0x8E71, 0x8E72, 0x8E73,
    0x8E74, 0x8E75, 0x8E76, 0x8E77, 0x8E78, 0x8E79, 0x8E7A, 0x8E7B,
    0x8E7C, 0x8E7D, 0x8E7E, 0x8E80, 0x8E81, 0x8E82, 0x8E83, 0x8E84,
    0x8E85, 0x8E86, 0x8E87, 0x8E88, 0x8E89, 0x8E8A, 0x8E8B, 0x8E8C,
    0x8E8D, 0x8E8E, 0x8E8F, 0x8E90, 0x8E91, 0x8E92, 0x8E93, 0x8E94,
    0x8E95, 0x8E96, 0x8E97, 0x8E98, 0x8E99, 0x8E9A, 0x8E9B, 0x8E9C,
    0x8E9D, 0x8E9E, 0x8E9F, 0x8EA0, 0x8EA1, 0x8EA2, 0x8EA3, 0x8EA4,
    0x8EA5, 0x8EA6, 0x8EA7, 0x8EA8, 0x8EA9, 0x8EAA, 0x8EAB, 0x8EAC,
    0x8EAD, 0x8EAE, 0x8EAF, 0x8EB0, 0x8EB1, 0x8EB2, 0x8EB3, 0x8EB4,
    0x8EB5, 0x8EB6, 0x8EB7, 0x8EB8, 0x8EB9, 0x8EBA, 0x8EBB, 0x8EBC,
    0x8EBD, 0x8EBE, 0x8EBF, 0x8EC0, 0x8EC1, 0x8EC2, 0x8EC3, 0x8EC4,
    0x8EC5, 0x8EC6, 0x8EC7, 0x8EC8, 0x8EC9, 0x8ECA, 0x8ECB, 0x8ECC,
    0x8ECD, 0x8ECE, 0x8ECF, 0x8ED0, 0x8ED1, 0x8ED2, 0x8ED3, 0x8ED4,
    0x8ED5, 0x8ED6, 0x8ED7, 0x8ED8, 0x8ED9, 0x8EDA, 0x8EDB, 0x8EDC,
    0x8EDD, 0x8EDE, 0x8EDF, 0x8EE0, 0x8EE1, 0x8EE2, 0x8EE3, 0x8EE4,
    0x8EE5, 0x8EE6, 0x8EE7, 0x8EE8, 0x8EE9, 0x8EEA, 0x8EEB, 0x8EEC,
    0x8EED, 0x8EEE, 0x8EEF, 0x8EF0, 0x8EF1, 0x8EF2, 0x8EF3, 0x8EF4,
    0x8EF5, 0x8EF6, 0x8EF7, 0x8EF8, 0x8EF9, 0x8EFA, 0x8EFB, 0x8EFC,
    0x8EFD, 0x8EFE, 0x8F40, 0x8F41, 0x8F42, 0x8F43, 0x8F44, 0x8F45,
    0x8F46, 0x8F47, 0x8F48, 0x8F49, 0x8F4A, 0x8F4B, 0x8F4C, 0x8F4D,
    0x8F4E, 0x8F4F, 0x8F50, 0x8F51, 0x8F52, 0x8F53, 0x8F54, 0x8F55,
    0x8F56, 0x8F57, 0x8F58, 0x8F59, 0x8F5A, 0x8F5B, 0x8F5C, 0x8F5D,
    0x8F5E, 0x8F5F, 0x8F60, 0x8F61, 0x8F62, 0x8F63, 0x8F64, 0x8F65,
    0x8F66, 0x8F67, 0x8F68, 0x8F69, 0x8F6A, 0x8F6B, 0x8F6C, 0x8F6D,
    0x8F6E, 0x8F6F, 0x8F70, 0x8F71, 0x8F72, 0x8F73, 0x8F74, 0x8F75,
    0x8F76, 0x8F77, 0x8F78, 0x8F79, 0x8F7A, 0x8F7B, 0x8F7C, 0x8F7D,
    0x8F7E, 0x8F80, 0x8F81, 0x8F82, 0x8F83, 0x8F84, 0x8F85, 0x8F86,
    0x8F87, 0x8F88, 0x8F89, 0x8F8A, 0x8F8B, 0x8F8C, 0x8F8D, 0x8F8E,
    0x8F8F, 0x8F90, 0x8F91, 0x8F92, 0x8F93, 0x8F94, 0x8F95, 0x8F96,
    0x8F97, 0x8F98, 0x8F99, 0x8F9A, 0x8F9B, 0x8F9C, 0x8F9D, 0x8F9E,
    0x8F9F, 0x8FA0, 0x8FA1, 0x8FA2, 0x8FA3, 0x8FA4, 0x8FA5, 0x8FA6,
    0x8FA7, 0x8FA8, 0x8FA9, 0x8FAA, 0x8FAB, 0x8FAC, 0x8FAD, 0x8FAE,
    0x8FAF, 0x8FB0, 0x8FB1, 0x8FB2, 0x8FB3, 0x8FB4, 0x8FB5, 0x8FB6,
    0x8FB7, 0x8FB8, 0x8FB9, 0x8FBA, 0x8FBB, 0x8FBC, 0x8FBD, 0x8FBE,
    0x8FBF, 0x8FC0, 0x8FC1, 0x8FC2, 0x8FC3, 0x8FC4, 0x8FC5, 0x8FC6,
    0x8FC7, 0x8FC8, 0x8FC9, 0x8FCA, 0x8FCB, 0x8FCC, 0x8FCD, 0x8FCE,
    0x8FCF, 0x8FD0, 0x8FD1, 0x8FD2, 0x8FD3, 0x8FD4, 0x8FD5, 0x8FD6,
    0x8FD7, 0x8FD8, 0x8FD9, 0x8FDA, 0x8FDB, 0x8FDC, 0x8FDD, 0x8FDE,
    0x8FDF, 0x8FE0, 0x8FE1, 0x8FE2, 0x8FE3, 0x8FE4, 0x8FE5, 0x8FE6,
    0x8FE7, 0x8FE8, 0x8FE9, 0x8FEA, 0x8FEB, 0x8FEC, 0x8FED, 0x8FEE,
    0x8FEF, 0x8FF0, 0x8FF1, 0x8FF2, 0x8FF3, 0x8FF4, 0x8FF5, 0x8FF6,
    0x8FF7, 0x8FF8, 0x8FF9, 0x8FFA, 0x8FFB, 0x8FFC, 0x8FFD, 0x8FFE,
    0x9040, 0x9041, 0x9042, 0x9043, 0x9044, 0x9045, 0x9046, 0x9047,
    0x9048, 0x9049, 0x904A, 0x904B, 0x904C, 0x904D, 0x904E, 0x904F,
    0x9050, 0x9051, 0x9052, 0x9053, 0x9054, 0x9055, 0x9056, 0x9057,
    0x9058, 0x9059, 0x905A, 0x905B, 0x905C, 0x905D, 0x905E, 0x905F,
    0x9060, 0x9061, 0x9062, 0x9063, 0x9064, 0x9065, 0x9066, 0x9067,
    0x9068, 0x9069, 0x906A, 0x906B, 0x906C, 0x906D, 0x906E, 0x906F,
    0x9070, 0x9071, 0x9072, 0x9073, 0x9074, 0x9075, 0x9076, 0x9077,
    0x9078, 0x9079, 0x907A, 0x907B, 0x907C, 0x907D, 0x907E, 0x9080,
    0x9081, 0x9082, 0x9083, 0x9084, 0x9085, 0x9086, 0x9087, 0x9088,
    0x9089, 0x908A, 0x908B, 0x908C, 0x908D, 0x908E, 0x908F, 0x9090,
    0x9091, 0x9092, 0x9093, 0x9094, 0x9095, 0x9096, 0x9097, 0x9098,
    0x9099, 0x909A, 0x909B, 0x909C, 0x909D, 0x909E, 0x909F, 0x90A0,
    0x90A1, 0x90A2, 0x90A3, 0x90A4, 0x90A5, 0x90A6, 0x90A7, 0x90A8,
    0x90A9, 0x90AA, 0x90AB, 0x90AC, 0x90AD, 0x90AE, 0x90AF, 0x90B0,
    0x90B1, 0x90B2, 0x90B3, 0x90B4, 0x90B5, 0x90B6, 0x90B7, 0x90B8,
    0x90B9, 0x90BA, 0x90BB, 0x90BC, 0x90BD, 0x90BE, 0x90BF, 0x90C0,
    0x90C1, 0x90C2, 0x90C3, 0x90C4, 0x90C5, 0x90C6, 0x90C7, 0x90C8,
    0x90C9, 0x90CA, 0x90CB, 0x90CC, 0x90CD, 0x90CE, 0x90CF, 0x90D0,
    0x90D1, 0x90D2, 0x90D3, 0x90D4, 0x90D5, 0x90D6, 0x90D7, 0x90D8,
    0x90D9, 0x90DA, 0x90DB, 0x90DC, 0x90DD, 0x90DE, 0x90DF, 0x90E0,
    0x90E1, 0x90E2, 0x90E3, 0x90E4, 0x90E5, 0x90E6, 0x90E7, 0x90E8,
    0x90E9, 0x90EA, 0x90EB, 0x90EC, 0x90ED, 0x90EE, 0x90EF, 0x90F0,
    0x90F1, 0x90F2, 0x90F3, 0x90F4, 0x90F5, 0x90F6, 0x90F7, 0x90F8,
    0x90F9, 0x90FA, 0x90FB, 0x90FC, 0x90FD, 0x90FE, 0x9140, 0x9141,
    0x9142, 0x9143, 0x9144, 0x9145, 0x9146, 0x9147, 0x9148, 0x9149,
    0x914A, 0x914B, 0x914C, 0x914D, 0x914E, 0x914F, 0x9150, 0x9151,
    0x9152, 0x9153, 0x9154, 0x9155, 0x9156, 0x9157, 0x9158, 0x9159,
    0x915A, 0x915B, 0x915C, 0x915D, 0x915E, 0x915F, 0x9160, 0x9161,
    0x9162, 0x9163, 0x9164, 0x9165, 0x9166, 0x9167, 0x9168, 0x9169,
    0x916A, 0x916B, 0x916C, 0x916D, 0x916E, 0x916F, 0x9170, 0x9171,
    0x9172, 0x9173, 0x9174, 0x9175, 0x9176, 0x9177, 0x9178, 0x9179,
    0x917A, 0x917B, 0x917C, 0x917D, 0x917E, 0x9180, 0x9181, 0x9182,
    0x9183, 0x9184, 0x9185, 0x9186, 0x9187, 0x9188, 0x9189, 0x918A,
    0x918B, 0x918C, 0x918D, 0x918E, 0x918F, 0x9190, 0x9191, 0x9192,
    0x9193, 0x9194, 0x9195, 0x9196, 0x9197, 0x9198, 0x9199, 0x919A,
    0x919B, 0x919C, 0x919D, 0x919E, 0x919F, 0x91A0, 0x91A1, 0x91A2,
    0x91A3, 0x91A4, 0x91A5, 0x91A6, 0x91A7, 0x91A8, 0x91A9, 0x91AA,
    0x91AB, 0x91AC, 0x91AD, 0x91AE, 0x91AF, 0x91B0, 0x91B1, 0x91B2,
    0x91B3, 0x91B4, 0x91B5, 0x91B6, 0x91B7, 0x91B8, 0x91B9, 0x91BA,
    0x91BB, 0x91BC, 0x91BD, 0x91BE, 0x91BF, 0x91C0, 0x91C1, 0x91C2,
    0x91C3, 0x91C4, 0x91C5, 0x91C6, 0x91C7, 0x91C8, 0x91C9, 0x91CA,
    0x91CB, 0x91CC, 0x91CD, 0x91CE, 0x91CF, 0x91D0, 0x91D1, 0x91D2,
    0x91D3, 0x91D4, 0x91D5, 0x91D6, 0x91D7, 0x91D8, 0x91D9, 0x91DA,
    0x91DB, 0x91DC, 0x91DD, 0x91DE, 0x91DF, 0x91E0, 0x91E1, 0x91E2,
    0x91E3, 0x91E4, 0x91E5, 0x91E6, 0x91E7, 0x91E8, 0x91E9, 0x91EA,
    0x91EB, 0x91EC, 0x91ED, 0x91EE, 0x91EF, 0x91F0, 0x91F1, 0x91F2,
    0x91F3, 0x91F4, 0x91F5, 0x91F6, 0x91F7, 0x91F8, 0x91F9, 0x91FA,
    0x91FB, 0x91FC, 0x91FD, 0x91FE, 0x9240, 0x9241, 0x9242, 0x9243,
    0x9244, 0x9245, 0x9246, 0x9247, 0x9248, 0x9249, 0x924A, 0x924B,
    0x924C, 0x924D, 0x924E, 0x924F, 0x9250, 0x9251, 0x9252, 0x9253,
    0x9254, 0x9255, 0x9256, 0x9257, 0x9258, 0x9259, 0x925A, 0x925B,
    0x925C, 0x925D, 0x925E, 0x925F, 0x9260, 0x9261, 0x9262, 0x9263,
    0x9264, 0x9265, 0x9266, 0x9267, 0x9268, 0x9269, 0x926A, 0x926B,
    0x926C, 0x926D, 0x926E, 0x926F, 0x9270, 0x9271, 0x9272, 0x9273,
    0x9274, 0x9275, 0x9276, 0x9277, 0x9278, 0x9279, 0x927A, 0x927B,
    0x927C, 0x927D, 0x927E, 0x9280, 0x9281, 0x9282, 0x9283, 0x9284,
    0x9285, 0x9286, 0x9287, 0x9288, 0x9289, 0x928A, 0x928B, 0x928C,
    0x928D, 0x928E, 0x928F, 0x9290, 0x9291, 0x9292, 0x9293, 0x9294,
    0x9295, 0x9296, 0x9297, 0x9298, 0x9299, 0x929A, 0x929B, 0x929C,
    0x929D, 0x929E, 0x929F, 0x92A0, 0x92A1, 0x92A2, 0x92A3, 0x92A4,
    0x92A5, 0x92A6, 0x92A7, 0x92A8, 0x92A9, 0x92AA, 0x92AB, 0x92AC,
    0x92AD, 0x92AE, 0x92AF, 0x92B0, 0x92B1, 0x92B2, 0x92B3, 0x92B4,
    0x92B5, 0x92B6, 0x92B7, 0x92B8, 0x92B9, 0x92BA, 0x92BB, 0x92BC,
    0x92BD, 0x92BE, 0x92BF, 0x92C0, 0x92C1, 0x92C2, 0x92C3, 0x92C4,
    0x92C5, 0x92C6, 0x92C7, 0x92C8, 0x92C9, 0x92CA, 0x92CB, 0x92CC,
    0x92CD, 0x92CE, 0x92CF, 0x92D0, 0x92D1, 0x92D2, 0x92D3, 0x92D4,
    0x92D5, 0x92D6, 0x92D7, 0x92D8, 0x92D9, 0x92DA, 0x92DB, 0x92DC,
    0x92DD, 0x92DE, 0x92DF, 0x92E0, 0x92E1, 0x92E2, 0x92E3, 0x92E4,
    0x92E5, 0x92E6, 0x92E7, 0x92E8, 0x92E9, 0x92EA, 0x92EB, 0x92EC,
    0x92ED, 0x92EE, 0x92EF, 0x92F0, 0x92F1, 0x92F2, 0x92F3, 0x92F4,
    0x92F5, 0x92F6, 0x92F7, 0x92F8, 0x92F9, 0x92FA, 0x92FB, 0x92FC,
    0x92FD, 0x92FE, 0x9340, 0x9341, 0x9342, 0x9343, 0x9344, 0x9345,
    0x9346, 0x9347, 0x9348, 0x9349, 0x934A, 0x934B, 0x934C, 0x934D,
    0x934E, 0x934F, 0x9350, 0x9351, 0x9352, 0x9353, 0x9354, 0x9355,
    0x9356, 0x9357, 0x9358, 0x9359, 0x935A, 0x935B, 0x935C, 0x935D,
    0x935E, 0x935F, 0x9360, 0x9361, 0x9362, 0x9363, 0x9364, 0x9365,
    0x9366, 0x9367, 0x9368, 0x9369, 0x936A, 0x936B, 0x936C, 0x936D,
    0x936E, 0x936F, 0x9370, 0x9371, 0x9372, 0x9373, 0x9374, 0x9375,
    0x9376, 0x9377, 0x9378, 0x9379, 0x937A, 0x937B, 0x937C, 0x937D,
    0x937E, 0x9380, 0x9381, 0x9382, 0x9383, 0x9384, 0x9385, 0x9386,
    0x9387, 0x9388, 0x9389, 0x938A, 0x938B, 0x938C, 0x938D, 0x938E,
    0x938F, 0x9390, 0x9391, 0x9392, 0x9393, 0x9394, 0x9395, 0x9396,
    0x9397, 0x9398, 0x9399, 0x939A, 0x939B, 0x939C, 0x939D, 0x939E,
    0x939F, 0x93A0, 0x93A1, 0x93A2, 0x93A3, 0x93A4, 0x93A5, 0x93A6,
    0x93A7, 0x93A8, 0x93A9, 0x93AA, 0x93AB, 0x93AC, 0x93AD, 0x93AE,
    0x93AF, 0x93B0, 0x93B1, 0x93B2, 0x93B3, 0x93B4, 0x93B5, 0x93B6,
    0x93B7, 0x93B8, 0x93B9, 0x93BA, 0x93BB, 0x93BC, 0x93BD, 0x93BE,
    0x93BF, 0x93C0, 0x93C1, 0x93C2, 0x93C3, 0x93C4, 0x93C5, 0x93C6,
    0x93C7, 0x93C8, 0x93C9, 0x93CA, 0x93CB, 0x93CC, 0x93CD, 0x93CE,
    0x93CF, 0x93D0, 0x93D1, 0x93D2, 0x93D3, 0x93D4, 0x93D5, 0x93D6,
    0x93D7, 0x93D8, 0x93D9, 0x93DA, 0x93DB, 0x93DC, 0x93DD, 0x93DE,
    0x93DF, 0x93E0, 0x93E1, 0x93E2, 0x93E3, 0x93E4, 0x93E5, 0x93E6,
    0x93E7, 0x93E8, 0x93E9, 0x93EA, 0x93EB, 0x93EC, 0x93ED, 0x93EE,
    0x93EF, 0x93F0, 0x93F1, 0x93F2, 0x93F3, 0x93F4, 0x93F5, 0x93F6,
    0x93F7, 0x93F8, 0x93F9, 0x93FA, 0x93FB, 0x93FC, 0x93FD, 0x93FE,
    0x9440, 0x9441, 0x9442, 0x9443, 0x9444, 0x9445, 0x9446, 0x9447,
    0x9448, 0x9449, 0x944A, 0x944B, 0x944C, 0x944D, 0x944E, 0x944F,
    0x9450, 0x9451, 0x9452, 0x9453, 0x9454, 0x9455, 0x9456, 0x9457,
    0x9458, 0x9459, 0x945A, 0x945B, 0x945C, 0x945D, 0x945E, 0x945F,
    0x9460, 0x9461, 0x9462, 0x9463, 0x9464, 0x9465, 0x9466, 0x9467,
    0x9468, 0x9469, 0x946A, 0x946B, 0x946C, 0x946D, 0x946E, 0x946F,
    0x9470, 0x9471, 0x9472, 0x9473, 0x9474, 0x9475, 0x9476, 0x9477,
    0x9478, 0x9479, 0x947A, 0x947B, 0x947C, 0x947D, 0x947E, 0x9480,
    0x9481, 0x9482, 0x9483, 0x9484, 0x9485, 0x9486, 0x9487, 0x9488,
    0x9489, 0x948A, 0x948B, 0x948C, 0x948D, 0x948E, 0x948F, 0x9490,
    0x9491, 0x9492, 0x9493, 0x9494, 0x9495, 0x9496, 0x9497, 0x9498,
    0x9499, 0x949A, 0x949B, 0x949C, 0x949D, 0x949E, 0x949F, 0x94A0,
    0x94A1, 0x94A2, 0x94A3, 0x94A4, 0x94A5, 0x94A6, 0x94A7, 0x94A8,
    0x94A9, 0x94AA, 0x94AB, 0x94AC, 0x94AD, 0x94AE, 0x94AF, 0x94B0,
    0x94B1, 0x94B2, 0x94B3, 0x94B4, 0x94B5, 0x94B6, 0x94B7, 0x94B8,
    0x94B9, 0x94BA, 0x94BB, 0x94BC, 0x94BD, 0x94BE, 0x94BF, 0x94C0,
    0x94C1, 0x94C2, 0x94C3, 0x94C4, 0x94C5, 0x94C6, 0x94C7, 0x94C8,
    0x94C9, 0x94CA, 0x94CB, 0x94CC, 0x94CD, 0x94CE, 0x94CF, 0x94D0,
    0x94D1, 0x94D2, 0x94D3, 0x94D4, 0x94D5, 0x94D6, 0x94D7, 0x94D8,
    0x94D9, 0x94DA, 0x94DB, 0x94DC, 0x94DD, 0x94DE, 0x94DF, 0x94E0,
    0x94E1, 0x94E2, 0x94E3, 0x94E4, 0x94E5, 0x94E6, 0x94E7, 0x94E8,
    0x94E9, 0x94EA, 0x94EB, 0x94EC, 0x94ED, 0x94EE, 0x94EF, 0x94F0,
    0x94F1, 0x94F2, 0x94F3, 0x94F4, 0x94F5, 0x94F6, 0x94F7, 0x94F8,
    0x94F9, 0x94FA, 0x94FB, 0x94FC, 0x94FD, 0x94FE, 0x9540, 0x9541,
    0x9542, 0x9543, 0x9544, 0x9545, 0x9546, 0x9547, 0x9548, 0x9549,
    0x954A, 0x954B, 0x954C, 0x954D, 0x954E, 0x954F, 0x9550, 0x9551,
    0x9552, 0x9553, 0x9554, 0x9555, 0x9556, 0x9557, 0x9558, 0x9559,
    0x955A, 0x955B, 0x955C, 0x955D, 0x955E, 0x955F, 0x9560, 0x9561,
    0x9562, 0x9563, 0x9564, 0x9565, 0x9566, 0x9567, 0x9568, 0x9569,
    0x956A, 0x956B, 0x956C, 0x956D, 0x956E, 0x956F, 0x9570, 0x9571,
    0x9572, 0x9573, 0x9574, 0x9575, 0x9576, 0x9577, 0x9578, 0x9579,
    0x957A, 0x957B, 0x957C, 0x957D, 0x957E, 0x9580, 0x9581, 0x9582,
    0x9583, 0x9584, 0x9585, 0x9586, 0x9587, 0x9588, 0x9589, 0x958A,
    0x958B, 0x958C, 0x958D, 0x958E, 0x958F, 0x9590, 0x9591, 0x9592,
    0x9593, 0x9594, 0x9595, 0x9596, 0x9597, 0x9598, 0x9599, 0x959A,
    0x959B, 0x959C, 0x959D, 0x959E, 0x959F, 0x95A0, 0x95A1, 0x95A2,
    0x95A3, 0x95A4, 0x95A5, 0x95A6, 0x95A7, 0x95A8, 0x95A9, 0x95AA,
    0x95AB, 0x95AC, 0x95AD, 0x95AE, 0x95AF, 0x95B0, 0x95B1, 0x95B2,
    0x95B3, 0x95B4, 0x95B5, 0x95B6, 0x95B7, 0x95B8, 0x95B9, 0x95BA,
    0x95BB, 0x95BC, 0x95BD, 0x95BE, 0x95BF, 0x95C0, 0x95C1, 0x95C2,
    0x95C3, 0x95C4, 0x95C5, 0x95C6, 0x95C7, 0x95C8, 0x95C9, 0x95CA,
    0x95CB, 0x95CC, 0x95CD, 0x95CE, 0x95CF, 0x95D0, 0x95D1, 0x95D2,
    0x95D3, 0x95D4, 0x95D5, 0x95D6, 0x95D7, 0x95D8, 0x95D9, 0x95DA,
    0x95DB, 0x95DC, 0x95DD, 0x95DE, 0x95DF, 0x95E0, 0x95E1, 0x95E2,
    0x95E3, 0x95E4, 0x95E5, 0x95E6, 0x95E7, 0x95E8, 0x95E9, 0x95EA,
    0x95EB, 0x95EC, 0x95ED, 0x95EE, 0x95EF, 0x95F0, 0x95F1, 0x95F2,
    0x95F3, 0x95F4, 0x95F5, 0x95F6, 0x95F7, 0x95F8, 0x95F9, 0x95FA,
    0x95FB, 0x95FC, 0x95FD, 0x95FE, 0x9640, 0x9641, 0x9642, 0x9643,
    0x9644, 0x9645, 0x9646, 0x9647, 0x9648, 0x9649, 0x964A, 0x964B,
    0x964C, 0x964D, 0x964E, 0x964F, 0x9650, 0x9651, 0x9652, 0x9653,
    0x9654, 0x9655, 0x9656, 0x9657, 0x9658, 0x9659, 0x965A, 0x965B,
    0x965C, 0x965D, 0x965E, 0x965F, 0x9660, 0x9661, 0x9662, 0x9663,
    0x9664, 0x9665, 0x9666, 0x9667, 0x9668, 0x9669, 0x966A, 0x966B,
    0x966C, 0x966D, 0x966E, 0x966F, 0x9670, 0x9671, 0x9672, 0x9673,
    0x9674, 0x9675, 0x9676, 0x9677, 0x9678, 0x9679, 0x967A, 0x967B,
    0x967C, 0x967D, 0x967E, 0x9680, 0x9681, 0x9682, 0x9683, 0x9684,
    0x9685, 0x9686, 0x9687, 0x9688, 0x9689, 0x968A, 0x968B, 0x968C,
    0x968D, 0x968E, 0x968F, 0x9690, 0x9691, 0x9692, 0x9693, 0x9694,
    0x9695, 0x9696, 0x9697, 0x9698, 0x9699, 0x969A, 0x969B, 0x969C,
    0x969D, 0x969E, 0x969F, 0x96A0, 0x96A1, 0x96A2, 0x96A3, 0x96A4,
    0x96A5, 0x96A6, 0x96A7, 0x96A8, 0x96A9, 0x96AA, 0x96AB, 0x96AC,
    0x96AD, 0x96AE, 0x96AF, 0x96B0, 0x96B1, 0x96B2, 0x96B3, 0x96B4,
    0x96B5, 0x96B6, 0x96B7, 0x96B8, 0x96B9, 0x96BA, 0x96BB, 0x96BC,
    0x96BD, 0x96BE, 0x96BF, 0x96C0, 0x96C1, 0x96C2, 0x96C3, 0x96C4,
    0x96C5, 0x96C6, 0x96C7, 0x96C8, 0x96C9, 0x96CA, 0x96CB, 0x96CC,
    0x96CD, 0x96CE, 0x96CF, 0x96D0, 0x96D1, 0x96D2, 0x96D3, 0x96D4,
    0x96D5, 0x96D6, 0x96D7, 0x96D8, 0x96D9, 0x96DA, 0x96DB, 0x96DC,
    0x96DD, 0x96DE, 0x96DF, 0x96E0, 0x96E1, 0x96E2, 0x96E3, 0x96E4,
    0x96E5, 0x96E6, 0x96E7, 0x96E8, 0x96E9, 0x96EA, 0x96EB, 0x96EC,
    0x96ED, 0x96EE, 0x96EF, 0x96F0, 0x96F1, 0x96F2, 0x96F3, 0x96F4,
    0x96F5, 0x96F6, 0x96F7, 0x96F8, 0x96F9, 0x96FA, 0x96FB, 0x96FC,
    0x96FD, 0x96FE, 0x9740, 0x9741, 0x9742, 0x9743, 0x9744, 0x9745,
    0x9746, 0x9747, 0x9748, 0x9749, 0x974A, 0x974B, 0x974C, 0x974D,
    0x974E, 0x974F, 0x9750, 0x9751, 0x9752, 0x9753, 0x9754, 0x9755,
    0x9756, 0x9757, 0x9758, 0x9759, 0x975A, 0x975B, 0x975C, 0x975D,
    0x975E, 0x975F, 0x9760, 0x9761, 0x9762, 0x9763, 0x9764, 0x9765,
    0x9766, 0x9767, 0x9768, 0x9769, 0x976A, 0x976B, 0x976C, 0x976D,
    0x976E, 0x976F, 0x9770, 0x9771, 0x9772, 0x9773, 0x9774, 0x9775,
    0x9776, 0x9777, 0x9778, 0x9779, 0x977A, 0x977B, 0x977C, 0x977D,
    0x977E, 0x9780, 0x9781, 0x9782, 0x9783, 0x9784, 0x9785, 0x9786,
    0x9787, 0x9788, 0x9789, 0x978A, 0x978B, 0x978C, 0x978D, 0x978E,
    0x978F, 0x9790, 0x9791, 0x9792, 0x9793, 0x9794, 0x9795, 0x9796,
    0x9797, 0x9798, 0x9799, 0x979A, 0x979B, 0x979C, 0x979D, 0x979E,
    0x979F, 0x97A0, 0x97A1, 0x97A2, 0x97A3, 0x97A4, 0x97A5, 0x97A6,
    0x97A7, 0x97A8, 0x97A9, 0x97AA, 0x97AB, 0x97AC, 0x97AD, 0x97AE,
    0x97AF, 0x97B0, 0x97B1, 0x97B2, 0x97B3, 0x97B4, 0x97B5, 0x97B6,
    0x97B7, 0x97B8, 0x97B9, 0x97BA, 0x97BB, 0x97BC, 0x97BD, 0x97BE,
    0x97BF, 0x97C0, 0x97C1, 0x97C2, 0x97C3, 0x97C4, 0x97C5, 0x97C6,
    0x97C7, 0x97C8, 0x97C9, 0x97CA, 0x97CB, 0x97CC, 0x97CD, 0x97CE,
    0x97CF, 0x97D0, 0x97D1, 0x97D2, 0x97D3, 0x97D4, 0x97D5, 0x97D6,
    0x97D7, 0x97D8, 0x97D9, 0x97DA, 0x97DB, 0x97DC, 0x97DD, 0x97DE,
    0x97DF, 0x97E0, 0x97E1, 0x97E2, 0x97E3, 0x97E4, 0x97E5, 0x97E6,
    0x97E7, 0x97E8, 0x97E9, 0x97EA, 0x97EB, 0x97EC, 0x97ED, 0x97EE,
    0x97EF, 0x97F0, 0x97F1, 0x97F2, 0x97F3, 0x97F4, 0x97F5, 0x97F6,
    0x97F7, 0x97F8, 0x97F9, 0x97FA, 0x97FB, 0x97FC, 0x97FD, 0x97FE,
    0x9840, 0x9841, 0x9842, 0x9843, 0x9844, 0x9845, 0x9846, 0x9847,
    0x9848, 0x9849, 0x984A, 0x984B, 0x984C, 0x984D, 0x984E, 0x984F,
    0x9850, 0x9851, 0x9852, 0x9853, 0x9854, 0x9855, 0x9856, 0x9857,
    0x9858, 0x9859, 0x985A, 0x985B, 0x985C, 0x985D, 0x985E, 0x985F,
    0x9860, 0x9861, 0x9862, 0x9863, 0x9864, 0x9865, 0x9866, 0x9867,
    0x9868, 0x9869, 0x986A, 0x986B, 0x986C, 0x986D, 0x986E, 0x986F,
    0x9870, 0x9871, 0x9872, 0x9873, 0x9874, 0x9875, 0x9876, 0x9877,
    0x9878, 0x9879, 0x987A, 0x987B, 0x987C, 0x987D, 0x987E, 0x9880,
    0x9881, 0x9882, 0x9883, 0x9884, 0x9885, 0x9886, 0x9887, 0x9888,
    0x9889, 0x988A, 0x988B, 0x988C, 0x988D, 0x988E, 0x988F, 0x9890,
    0x9891, 0x9892, 0x9893, 0x9894, 0x9895, 0x9896, 0x9897, 0x9898,
    0x9899, 0x989A, 0x989B, 0x989C, 0x989D, 0x989E, 0x989F, 0x98A0,
    0x98A1, 0x98A2, 0x98A3, 0x98A4, 0x98A5, 0x98A6, 0x98A7, 0x98A8,
    0x98A9, 0x98AA, 0x98AB, 0x98AC, 0x98AD, 0x98AE, 0x98AF, 0x98B0,
    0x98B1, 0x98B2, 0x98B3, 0x98B4, 0x98B5, 0x98B6, 0x98B7, 0x98B8,
    0x98B9, 0x98BA, 0x98BB, 0x98BC, 0x98BD, 0x98BE, 0x98BF, 0x98C0,
    0x98C1, 0x98C2, 0x98C3, 0x98C4, 0x98C5, 0x98C6, 0x98C7, 0x98C8,
    0x98C9, 0x98CA, 0x98CB, 0x98CC, 0x98CD, 0x98CE, 0x98CF, 0x98D0,
    0x98D1, 0x98D2, 0x98D3, 0x98D4, 0x98D5, 0x98D6, 0x98D7, 0x98D8,
    0x98D9, 0x98DA, 0x98DB, 0x98DC, 0x98DD, 0x98DE, 0x98DF, 0x98E0,
    0x98E1, 0x98E2, 0x98E3, 0x98E4, 0x98E5, 0x98E6, 0x98E7, 0x98E8,
    0x98E9, 0x98EA, 0x98EB, 0x98EC, 0x98ED, 0x98EE, 0x98EF, 0x98F0,
    0x98F1, 0x98F2, 0x98F3, 0x98F4, 0x98F5, 0x98F6, 0x98F7, 0x98F8,
    0x98F9, 0x98FA, 0x98FB, 0x98FC, 0x98FD, 0x98FE, 0x9940, 0x9941,
    0x9942, 0x9943, 0x9944, 0x9945, 0x9946, 0x9947, 0x9948, 0x9949,
    0x994A, 0x994B, 0x994C, 0x994D, 0x994E, 0x994F, 0x9950, 0x9951,
    0x9952, 0x9953, 0x9954, 0x9955, 0x9956, 0x9957, 0x9958, 0x9959,
    0x995A, 0x995B, 0x995C, 0x995D, 0x995E, 0x995F, 0x9960, 0x9961,
    0x9962, 0x9963, 0x9964, 0x9965, 0x9966, 0x9967, 0x9968, 0x9969,
    0x996A, 0x996B, 0x996C, 0x996D, 0x996E, 0x996F, 0x9970, 0x9971,
    0x9972, 0x9973, 0x9974, 0x9975, 0x9976, 0x9977, 0x9978, 0x9979,
    0x997A, 0x997B, 0x997C, 0x997D, 0x997E, 0x9980, 0x9981, 0x9982,
    0x9983, 0x9984, 0x9985, 0x9986, 0x9987, 0x9988, 0x9989, 0x998A,
    0x998B, 0x998C, 0x998D, 0x998E, 0x998F, 0x9990, 0x9991, 0x9992,
    0x9993, 0x9994, 0x9995, 0x9996, 0x9997, 0x9998, 0x9999, 0x999A,
    0x999B, 0x999C, 0x999D, 0x999E, 0x999F, 0x99A0, 0x99A1, 0x99A2,
    0x99A3, 0x99A4, 0x99A5, 0x99A6, 0x99A7, 0x99A8, 0x99A9, 0x99AA,
    0x99AB, 0x99AC, 0x99AD, 0x99AE, 0x99AF, 0x99B0, 0x99B1, 0x99B2,
    0x99B3, 0x99B4, 0x99B5, 0x99B6, 0x99B7, 0x99B8, 0x99B9, 0x99BA,
    0x99BB, 0x99BC, 0x99BD, 0x99BE, 0x99BF, 0x99C0, 0x99C1, 0x99C2,
    0x99C3, 0x99C4, 0x99C5, 0x99C6, 0x99C7, 0x99C8, 0x99C9, 0x99CA,
    0x99CB, 0x99CC, 0x99CD, 0x99CE, 0x99CF, 0x99D0, 0x99D1, 0x99D2,
    0x99D3, 0x99D4, 0x99D5, 0x99D6, 0x99D7, 0x99D8, 0x99D9, 0x99DA,
    0x99DB, 0x99DC, 0x99DD, 0x99DE, 0x99DF, 0x99E0, 0x99E1, 0x99E2,
    0x99E3, 0x99E4, 0x99E5, 0x99E6, 0x99E7, 0x99E8, 0x99E9, 0x99EA,
    0x99EB, 0x99EC, 0x99ED, 0x99EE, 0x99EF, 0x99F0, 0x99F1, 0x99F2,
    0x99F3, 0x99F4, 0x99F5, 0x99F6, 0x99F7, 0x99F8, 0x99F9, 0x99FA,
    0x99FB, 0x99FC, 0x99FD, 0x99FE, 0x9A40, 0x9A41, 0x9A42, 0x9A43,
    0x9A44, 0x9A45, 0x9A46, 0x9A47, 0x9A48, 0x9A49, 0x9A4A, 0x9A4B,
    0x9A4C, 0x9A4D, 0x9A4E, 0x9A4F, 0x9A50, 0x9A51, 0x9A52, 0x9A53,
    0x9A54, 0x9A55, 0x9A56, 0x9A57, 0x9A58, 0x9A59, 0x9A5A, 0x9A5B,
    0x9A5C, 0x9A5D, 0x9A5E, 0x9A5F, 0x9A60, 0x9A61, 0x9A62, 0x9A63,
    0x9A64, 0x9A65, 0x9A66, 0x9A67, 0x9A68, 0x9A69, 0x9A6A, 0x9A6B,
    0x9A6C, 0x9A6D, 0x9A6E, 0x9A6F, 0x9A70, 0x9A71, 0x9A72, 0x9A73,
    0x9A74, 0x9A75, 0x9A76, 0x9A77, 0x9A78, 0x9A79, 0x9A7A, 0x9A7B,
    0x9A7C, 0x9A7D, 0x9A7E, 0x9A80, 0x9A81, 0x9A82, 0x9A83, 0x9A84,
    0x9A85, 0x9A86, 0x9A87, 0x9A88, 0x9A89, 0x9A8A, 0x9A8B, 0x9A8C,
    0x9A8D, 0x9A8E, 0x9A8F, 0x9A90, 0x9A91, 0x9A92, 0x9A93, 0x9A94,
    0x9A95, 0x9A96, 0x9A97, 0x9A98, 0x9A99, 0x9A9A, 0x9A9B, 0x9A9C,
    0x9A9D, 0x9A9E, 0x9A9F, 0x9AA0, 0x9AA1, 0x9AA2, 0x9AA3, 0x9AA4,
    0x9AA5, 0x9AA6, 0x9AA7, 0x9AA8, 0x9AA9, 0x9AAA, 0x9AAB, 0x9AAC,
    0x9AAD, 0x9AAE, 0x9AAF, 0x9AB0, 0x9AB1, 0x9AB2, 0x9AB3, 0x9AB4,
    0x9AB5, 0x9AB6, 0x9AB7, 0x9AB8, 0x9AB9, 0x9ABA, 0x9ABB, 0x9ABC,
    0x9ABD, 0x9ABE, 0x9ABF, 0x9AC0, 0x9AC1, 0x9AC2, 0x9AC3, 0x9AC4,
    0x9AC5, 0x9AC6, 0x9AC7, 0x9AC8, 0x9AC9, 0x9ACA, 0x9ACB, 0x9ACC,
    0x9ACD, 0x9ACE, 0x9ACF, 0x9AD0, 0x9AD1, 0x9AD2, 0x9AD3, 0x9AD4,
    0x9AD5, 0x9AD6, 0x9AD7, 0x9AD8, 0x9AD9, 0x9ADA, 0x9ADB, 0x9ADC,
    0x9ADD, 0x9ADE, 0x9ADF, 0x9AE0, 0x9AE1, 0x9AE2, 0x9AE3, 0x9AE4,
    0x9AE5, 0x9AE6, 0x9AE7, 0x9AE8, 0x9AE9, 0x9AEA, 0x9AEB, 0x9AEC,
    0x9AED, 0x9AEE, 0x9AEF, 0x9AF0, 0x9AF1, 0x9AF2, 0x9AF3, 0x9AF4,
    0x9AF5, 0x9AF6, 0x9AF7, 0x9AF8, 0x9AF9, 0x9AFA, 0x9AFB, 0x9AFC,
    0x9AFD, 0x9AFE, 0x9B40, 0x9B41, 0x9B42, 0x9B43, 0x9B44, 0x9B45,
    0x9B46, 0x9B47, 0x9B48, 0x9B49, 0x9B4A, 0x9B4B, 0x9B4C, 0x9B4D,
    0x9B4E, 0x9B4F, 0x9B50, 0x9B51, 0x9B52, 0x9B53, 0x9B54, 0x9B55,
    0x9B56, 0x9B57, 0x9B58, 0x9B59, 0x9B5A, 0x9B5B, 0x9B5C, 0x9B5D,
    0x9B5E, 0x9B5F, 0x9B60, 0x9B61, 0x9B62, 0x9B63, 0x9B64, 0x9B65,
    0x9B66, 0x9B67, 0x9B68, 0x9B69, 0x9B6A, 0x9B6B, 0x9B6C, 0x9B6D,
    0x9B6E, 0x9B6F, 0x9B70, 0x9B71, 0x9B72, 0x9B73, 0x9B74, 0x9B75,
    0x9B76, 0x9B77, 0x9B78, 0x9B79, 0x9B7A, 0x9B7B, 0x9B7C, 0x9B7D,
    0x9B7E, 0x9B80, 0x9B81, 0x9B82, 0x9B83, 0x9B84, 0x9B85, 0x9B86,
    0x9B87, 0x9B88, 0x9B89, 0x9B8A, 0x9B8B, 0x9B8C, 0x9B8D, 0x9B8E,
    0x9B8F, 0x9B90, 0x9B91, 0x9B92, 0x9B93, 0x9B94, 0x9B95, 0x9B96,
    0x9B97, 0x9B98, 0x9B99, 0x9B9A, 0x9B9B, 0x9B9C, 0x9B9D, 0x9B9E,
    0x9B9F, 0x9BA0, 0x9BA1, 0x9BA2, 0x9BA3, 0x9BA4, 0x9BA5, 0x9BA6,
    0x9BA7, 0x9BA8, 0x9BA9, 0x9BAA, 0x9BAB, 0x9BAC, 0x9BAD, 0x9BAE,
    0x9BAF, 0x9BB0, 0x9BB1, 0x9BB2, 0x9BB3, 0x9BB4, 0x9BB5, 0x9BB6,
    0x9BB7, 0x9BB8, 0x9BB9, 0x9BBA, 0x9BBB, 0x9BBC, 0x9BBD, 0x9BBE,
    0x9BBF, 0x9BC0, 0x9BC1, 0x9BC2, 0x9BC3, 0x9BC4, 0x9BC5, 0x9BC6,
    0x9BC7, 0x9BC8, 0x9BC9, 0x9BCA, 0x9BCB, 0x9BCC, 0x9BCD, 0x9BCE,
    0x9BCF, 0x9BD0, 0x9BD1, 0x9BD2, 0x9BD3, 0x9BD4, 0x9BD5, 0x9BD6,
    0x9BD7, 0x9BD8, 0x9BD9, 0x9BDA, 0x9BDB, 0x9BDC, 0x9BDD, 0x9BDE,
    0x9BDF, 0x9BE0, 0x9BE1, 0x9BE2, 0x9BE3, 0x9BE4, 0x9BE5, 0x9BE6,
    0x9BE7, 0x9BE8, 0x9BE9, 0x9BEA, 0x9BEB, 0x9BEC, 0x9BED, 0x9BEE,
    0x9BEF, 0x9BF0, 0x9BF1, 0x9BF2, 0x9BF3, 0x9BF4, 0x9BF5, 0x9BF6,
    0x9BF7, 0x9BF8, 0x9BF9, 0x9BFA, 0x9BFB, 0x9BFC, 0x9BFD, 0x9BFE,
    0x9C40, 0x9C41, 0x9C42, 0x9C43, 0x9C44, 0x9C45, 0x9C46, 0x9C47,
    0x9C48, 0x9C49, 0x9C4A, 0x9C4B, 0x9C4C, 0x9C4D, 0x9C4E, 0x9C4F,
    0x9C50, 0x9C51, 0x9C52, 0x9C53, 0x9C54, 0x9C55, 0x9C56, 0x9C57,
    0x9C58, 0x9C59, 0x9C5A, 0x9C5B, 0x9C5C, 0x9C5D, 0x9C5E, 0x9C5F,
    0x9C60, 0x9C61, 0x9C62, 0x9C63, 0x9C64, 0x9C65, 0x9C66, 0x9C67,
    0x9C68, 0x9C69, 0x9C6A, 0x9C6B, 0x9C6C, 0x9C6D, 0x9C6E, 0x9C6F,
    0x9C70, 0x9C71, 0x9C72, 0x9C73, 0x9C74, 0x9C75, 0x9C76, 0x9C77,
    0x9C78, 0x9C79, 0x9C7A, 0x9C7B, 0x9C7C, 0x9C7D, 0x9C7E, 0x9C80,
    0x9C81, 0x9C82, 0x9C83, 0x9C84, 0x9C85, 0x9C86, 0x9C87, 0x9C88,
    0x9C89, 0x9C8A, 0x9C8B, 0x9C8C, 0x9C8D, 0x9C8E, 0x9C8F, 0x9C90,
    0x9C91, 0x9C92, 0x9C93, 0x9C94, 0x9C95, 0x9C96, 0x9C97, 0x9C98,
    0x9C99, 0x9C9A, 0x9C9B, 0x9C9C, 0x9C9D, 0x9C9E, 0x9C9F, 0x9CA0,
    0x9CA1, 0x9CA2, 0x9CA3, 0x9CA4, 0x9CA5, 0x9CA6, 0x9CA7, 0x9CA8,
    0x9CA9, 0x9CAA, 0x9CAB, 0x9CAC, 0x9CAD, 0x9CAE, 0x9CAF, 0x9CB0,
    0x9CB1, 0x9CB2, 0x9CB3, 0x9CB4, 0x9CB5, 0x9CB6, 0x9CB7, 0x9CB8,
    0x9CB9, 0x9CBA, 0x9CBB, 0x9CBC, 0x9CBD, 0x9CBE, 0x9CBF, 0x9CC0,
    0x9CC1, 0x9CC2, 0x9CC3, 0x9CC4, 0x9CC5, 0x9CC6, 0x9CC7, 0x9CC8,
    0x9CC9, 0x9CCA, 0x9CCB, 0x9CCC, 0x9CCD, 0x9CCE, 0x9CCF, 0x9CD0,
    0x9CD1, 0x9CD2, 0x9CD3, 0x9CD4, 0x9CD5, 0x9CD6, 0x9CD7, 0x9CD8,
    0x9CD9, 0x9CDA, 0x9CDB, 0x9CDC, 0x9CDD, 0x9CDE, 0x9CDF, 0x9CE0,
    0x9CE1, 0x9CE2, 0x9CE3, 0x9CE4, 0x9CE5, 0x9CE6, 0x9CE7, 0x9CE8,
    0x9CE9, 0x9CEA, 0x9CEB, 0x9CEC, 0x9CED, 0x9CEE, 0x9CEF, 0x9CF0,
    0x9CF1, 0x9CF2, 0x9CF3, 0x9CF4, 0x9CF5, 0x9CF6, 0x9CF7, 0x9CF8,
    0x9CF9, 0x9CFA, 0x9CFB, 0x9CFC, 0x9CFD, 0x9CFE, 0x9D40, 0x9D41,
    0x9D42, 0x9D43, 0x9D44, 0x9D45, 0x9D46, 0x9D47, 0x9D48, 0x9D49,
    0x9D4A, 0x9D4B, 0x9D4C, 0x9D4D, 0x9D4E, 0x9D4F, 0x9D50, 0x9D51,
    0x9D52, 0x9D53, 0x9D54, 0x9D55, 0x9D56, 0x9D57, 0x9D58, 0x9D59,
    0x9D5A, 0x9D5B, 0x9D5C, 0x9D5D, 0x9D5E, 0x9D5F, 0x9D60, 0x9D61,
    0x9D62, 0x9D63, 0x9D64, 0x9D65, 0x9D66, 0x9D67, 0x9D68, 0x9D69,
    0x9D6A, 0x9D6B, 0x9D6C, 0x9D6D, 0x9D6E, 0x9D6F, 0x9D70, 0x9D71,
    0x9D72, 0x9D73, 0x9D74, 0x9D75, 0x9D76, 0x9D77, 0x9D78, 0x9D79,
    0x9D7A, 0x9D7B, 0x9D7C, 0x9D7D, 0x9D7E, 0x9D80, 0x9D81, 0x9D82,
    0x9D83, 0x9D84, 0x9D85, 0x9D86, 0x9D87, 0x9D88, 0x9D89, 0x9D8A,
    0x9D8B, 0x9D8C, 0x9D8D, 0x9D8E, 0x9D8F, 0x9D90, 0x9D91, 0x9D92,
    0x9D93, 0x9D94, 0x9D95, 0x9D96, 0x9D97, 0x9D98, 0x9D99, 0x9D9A,
    0x9D9B, 0x9D9C, 0x9D9D, 0x9D9E, 0x9D9F, 0x9DA0, 0x9DA1, 0x9DA2,
    0x9DA3, 0x9DA4, 0x9DA5, 0x9DA6, 0x9DA7, 0x9DA8, 0x9DA9, 0x9DAA,
    0x9DAB, 0x9DAC, 0x9DAD, 0x9DAE, 0x9DAF, 0x9DB0, 0x9DB1, 0x9DB2,
    0x9DB3, 0x9DB4, 0x9DB5, 0x9DB6, 0x9DB7, 0x9DB8, 0x9DB9, 0x9DBA,
    0x9DBB, 0x9DBC, 0x9DBD, 0x9DBE, 0x9DBF, 0x9DC0, 0x9DC1, 0x9DC2,
    0x9DC3, 0x9DC4, 0x9DC5, 0x9DC6, 0x9DC7, 0x9DC8, 0x9DC9, 0x9DCA,
    0x9DCB, 0x9DCC, 0x9DCD, 0x9DCE, 0x9DCF, 0x9DD0, 0x9DD1, 0x9DD2,
    0x9DD3, 0x9DD4, 0x9DD5, 0x9DD6, 0x9DD7, 0x9DD8, 0x9DD9, 0x9DDA,
    0x9DDB, 0x9DDC, 0x9DDD, 0x9DDE, 0x9DDF, 0x9DE0, 0x9DE1, 0x9DE2,
    0x9DE3, 0x9DE4, 0x9DE5, 0x9DE6, 0x9DE7, 0x9DE8, 0x9DE9, 0x9DEA,
    0x9DEB, 0x9DEC, 0x9DED, 0x9DEE, 0x9DEF, 0x9DF0, 0x9DF1, 0x9DF2,
    0x9DF3, 0x9DF4, 0x9DF5, 0x9DF6, 0x9DF7, 0x9DF8, 0x9DF9, 0x9DFA,
    0x9DFB, 0x9DFC, 0x9DFD, 0x9DFE, 0x9E40, 0x9E41, 0x9E42, 0x9E43,
    0x9E44, 0x9E45, 0x9E46, 0x9E47, 0x9E48, 0x9E49, 0x9E4A, 0x9E4B,
    0x9E4C, 0x9E4D, 0x9E4E, 0x9E4F, 0x9E50, 0x9E51, 0x9E52, 0x9E53,
    0x9E54, 0x9E55, 0x9E56, 0x9E57, 0x9E58, 0x9E59, 0x9E5A, 0x9E5B,
    0x9E5C, 0x9E5D, 0x9E5E, 0x9E5F, 0x9E60, 0x9E61, 0x9E62, 0x9E63,
    0x9E64, 0x9E65, 0x9E66, 0x9E67, 0x9E68, 0x9E69, 0x9E6A, 0x9E6B,
    0x9E6C, 0x9E6D, 0x9E6E, 0x9E6F, 0x9E70, 0x9E71, 0x9E72, 0x9E73,
    0x9E74, 0x9E75, 0x9E76, 0x9E77, 0x9E78, 0x9E79, 0x9E7A, 0x9E7B,
    0x9E7C, 0x9E7D, 0x9E7E, 0x9E80, 0x9E81, 0x9E82, 0x9E83, 0x9E84,
    0x9E85, 0x9E86, 0x9E87, 0x9E88, 0x9E89, 0x9E8A, 0x9E8B, 0x9E8C,
    0x9E8D, 0x9E8E, 0x9E8F, 0x9E90, 0x9E91, 0x9E92, 0x9E93, 0x9E94,
    0x9E95, 0x9E96, 0x9E97, 0x9E98, 0x9E99, 0x9E9A, 0x9E9B, 0x9E9C,
    0x9E9D, 0x9E9E, 0x9E9F, 0x9EA0, 0x9EA1, 0x9EA2, 0x9EA3, 0x9EA4,
    0x9EA5, 0x9EA6, 0x9EA7, 0x9EA8, 0x9EA9, 0x9EAA, 0x9EAB, 0x9EAC,
    0x9EAD, 0x9EAE, 0x9EAF, 0x9EB0, 0x9EB1, 0x9EB2, 0x9EB3, 0x9EB4,
    0x9EB5, 0x9EB6, 0x9EB7, 0x9EB8, 0x9EB9, 0x9EBA, 0x9EBB, 0x9EBC,
    0x9EBD, 0x9EBE, 0x9EBF, 0x9EC0, 0x9EC1, 0x9EC2, 0x9EC3, 0x9EC4,
    0x9EC5, 0x9EC6, 0x9EC7, 0x9EC8, 0x9EC9, 0x9ECA, 0x9ECB, 0x9ECC,
    0x9ECD, 0x9ECE, 0x9ECF, 0x9ED0, 0x9ED1, 0x9ED2, 0x9ED3, 0x9ED4,
    0x9ED5, 0x9ED6, 0x9ED7, 0x9ED8, 0x9ED9, 0x9EDA, 0x9EDB, 0x9EDC,
    0x9EDD, 0x9EDE, 0x9EDF, 0x9EE0, 0x9EE1, 0x9EE2, 0x9EE3, 0x9EE4,
    0x9EE5, 0x9EE6, 0x9EE7, 0x9EE8, 0x9EE9, 0x9EEA, 0x9EEB, 0x9EEC,
    0x9EED, 0x9EEE, 0x9EEF, 0x9EF0, 0x9EF1, 0x9EF2, 0x9EF3, 0x9EF4,
    0x9EF5, 0x9EF6, 0x9EF7, 0x9EF8, 0x9EF9, 0x9EFA, 0x9EFB, 0x9EFC,
    0x9EFD, 0x9EFE, 0x9F40, 0x9F41, 0x9F42, 0x9F43, 0x9F44, 0x9F45,
    0x9F46, 0x9F47, 0x9F48, 0x9F49, 0x9F4A, 0x9F4B, 0x9F4C, 0x9F4D,
    0x9F4E, 0x9F4F, 0x9F50, 0x9F51, 0x9F52, 0x9F53, 0x9F54, 0x9F55,
    0x9F56, 0x9F57, 0x9F58, 0x9F59, 0x9F5A, 0x9F5B, 0x9F5C, 0x9F5D,
    0x9F5E, 0x9F5F, 0x9F60, 0x9F61, 0x9F62, 0x9F63, 0x9F64, 0x9F65,
    0x9F66, 0x9F67, 0x9F68, 0x9F69, 0x9F6A, 0x9F6B, 0x9F6C, 0x9F6D,
    0x9F6E, 0x9F6F, 0x9F70, 0x9F71, 0x9F72, 0x9F73, 0x9F74, 0x9F75,
    0x9F76, 0x9F77, 0x9F78, 0x9F79, 0x9F7A, 0x9F7B, 0x9F7C, 0x9F7D,
    0x9F7E, 0x9F80, 0x9F81, 0x9F82, 0x9F83, 0x9F84, 0x9F85, 0x9F86,
    0x9F87, 0x9F88, 0x9F89, 0x9F8A, 0x9F8B, 0x9F8C, 0x9F8D, 0x9F8E,
    0x9F8F, 0x9F90, 0x9F91, 0x9F92, 0x9F93, 0x9F94, 0x9F95, 0x9F96,
    0x9F97, 0x9F98, 0x9F99, 0x9F9A, 0x9F9B, 0x9F9C, 0x9F9D, 0x9F9E,
    0x9F9F, 0x9FA0, 0x9FA1, 0x9FA2, 0x9FA3, 0x9FA4, 0x9FA5, 0x9FA6,
    0x9FA7, 0x9FA8, 0x9FA9, 0x9FAA, 0x9FAB, 0x9FAC, 0x9FAD, 0x9FAE,
    0x9FAF, 0x9FB0, 0x9FB1, 0x9FB2, 0x9FB3, 0x9FB4, 0x9FB5, 0x9FB6,
    0x9FB7, 0x9FB8, 0x9FB9, 0x9FBA, 0x9FBB, 0x9FBC, 0x9FBD, 0x9FBE,
    0x9FBF, 0x9FC0, 0x9FC1, 0x9FC2, 0x9FC3, 0x9FC4, 0x9FC5, 0x9FC6,
    0x9FC7, 0x9FC8, 0x9FC9, 0x9FCA, 0x9FCB, 0x9FCC, 0x9FCD, 0x9FCE,
    0x9FCF, 0x9FD0, 0x9FD1, 0x9FD2, 0x9FD3, 0x9FD4, 0x9FD5, 0x9FD6,
    0x9FD7, 0x9FD8, 0x9FD9, 0x9FDA, 0x9FDB, 0x9FDC, 0x9FDD, 0x9FDE,
    0x9FDF, 0x9FE0, 0x9FE1, 0x9FE2, 0x9FE3, 0x9FE4, 0x9FE5, 0x9FE6,
    0x9FE7, 0x9FE8, 0x9FE9, 0x9FEA, 0x9FEB, 0x9FEC, 0x9FED, 0x9FEE,
    0x9FEF, 0x9FF0, 0x9FF1, 0x9FF2, 0x9FF3, 0x9FF4, 0x9FF5, 0x9FF6,
    0x9FF7, 0x9FF8, 0x9FF9, 0x9FFA, 0x9FFB, 0x9FFC, 0x9FFD, 0x9FFE,
    0xA040, 0xA041, 0xA042, 0xA043, 0xA044, 0xA045, 0xA046, 0xA047,
    0xA048, 0xA049, 0xA04A, 0xA04B, 0xA04C, 0xA04D, 0xA04E, 0xA04F,
    0xA050, 0xA051, 0xA052, 0xA053, 0xA054, 0xA055, 0xA056, 0xA057,
    0xA058, 0xA059, 0xA05A, 0xA05B, 0xA05C, 0xA05D, 0xA05E, 0xA05F,
    0xA060, 0xA061, 0xA062, 0xA063, 0xA064, 0xA065, 0xA066, 0xA067,
    0xA068, 0xA069, 0xA06A, 0xA06B, 0xA06C, 0xA06D, 0xA06E, 0xA06F,
    0xA070, 0xA071, 0xA072, 0xA073, 0xA074, 0xA075, 0xA076, 0xA077,
    0xA078, 0xA079, 0xA07A, 0xA07B, 0xA07C, 0xA07D, 0xA07E, 0xA080,
    0xA081, 0xA082, 0xA083, 0xA084, 0xA085, 0xA086, 0xA087, 0xA088,
    0xA089, 0xA08A, 0xA08B, 0xA08C, 0xA08D, 0xA08E, 0xA08F, 0xA090,
    0xA091, 0xA092, 0xA093, 0xA094, 0xA095, 0xA096, 0xA097, 0xA098,
    0xA099, 0xA09A, 0xA09B, 0xA09C, 0xA09D, 0xA09E, 0xA09F, 0xA0A0,
    0xA0A1, 0xA0A2, 0xA0A3, 0xA0A4, 0xA0A5, 0xA0A6, 0xA0A7, 0xA0A8,
    0xA0A9, 0xA0AA, 0xA0AB, 0xA0AC, 0xA0AD, 0xA0AE, 0xA0AF, 0xA0B0,
    0xA0B1, 0xA0B2, 0xA0B3, 0xA0B4, 0xA0B5, 0xA0B6, 0xA0B7, 0xA0B8,
    0xA0B9, 0xA0BA, 0xA0BB, 0xA0BC, 0xA0BD, 0xA0BE, 0xA0BF, 0xA0C0,
    0xA0C1, 0xA0C2, 0xA0C3, 0xA0C4, 0xA0C5, 0xA0C6, 0xA0C7, 0xA0C8,
    0xA0C9, 0xA0CA, 0xA0CB, 0xA0CC, 0xA0CD, 0xA0CE, 0xA0CF, 0xA0D0,
    0xA0D1, 0xA0D2, 0xA0D3, 0xA0D4, 0xA0D5, 0xA0D6, 0xA0D7, 0xA0D8,
    0xA0D9, 0xA0DA, 0xA0DB, 0xA0DC, 0xA0DD, 0xA0DE, 0xA0DF, 0xA0E0,
    0xA0E1, 0xA0E2, 0xA0E3, 0xA0E4, 0xA0E5, 0xA0E6, 0xA0E7, 0xA0E8,
    0xA0E9, 0xA0EA, 0xA0EB, 0xA0EC, 0xA0ED, 0xA0EE, 0xA0EF, 0xA0F0,
    0xA0F1, 0xA0F2, 0xA0F3, 0xA0F4, 0xA0F5, 0xA0F6, 0xA0F7, 0xA0F8,
    0xA0F9, 0xA0FA, 0xA0FB, 0xA0FC, 0xA0FD, 0xA0FE, 0xAA40, 0xAA41,
    0xAA42, 0xAA43, 0xAA44, 0xAA45, 0xAA46, 0xAA47, 0xAA48, 0xAA49,
    0xAA4A, 0xAA4B, 0xAA4C, 0xAA4D, 0xAA4E, 0xAA4F, 0xAA50, 0xAA51,
    0xAA52, 0xAA53, 0xAA54, 0xAA55, 0xAA56, 0xAA57, 0xAA58, 0xAA59,
    0xAA5A, 0xAA5B, 0xAA5C, 0xAA5D, 0xAA5E, 0xAA5F, 0xAA60, 0xAA61,
    0xAA62, 0xAA63, 0xAA64, 0xAA65, 0xAA66, 0xAA67, 0xAA68, 0xAA69,
    0xAA6A, 0xAA6B, 0xAA6C, 0xAA6D, 0xAA6E, 0xAA6F, 0xAA70, 0xAA71,
    0xAA72, 0xAA73, 0xAA74, 0xAA75, 0xAA76, 0xAA77, 0xAA78, 0xAA79,
    0xAA7A, 0xAA7B, 0xAA7C, 0xAA7D, 0xAA7E, 0xAA80, 0xAA81, 0xAA82,
    0xAA83, 0xAA84, 0xAA85, 0xAA86, 0xAA87, 0xAA88, 0xAA89, 0xAA8A,
    0xAA8B, 0xAA8C, 0xAA8D, 0xAA8E, 0xAA8F, 0xAA90, 0xAA91, 0xAA92,
    0xAA93, 0xAA94, 0xAA95, 0xAA96, 0xAA97, 0xAA98, 0xAA99, 0xAA9A,
    0xAA9B, 0xAA9C, 0xAA9D, 0xAA9E, 0xAA9F, 0xAAA0, 0xAB40, 0xAB41,
    0xAB42, 0xAB43, 0xAB44, 0xAB45, 0xAB46, 0xAB47, 0xAB48, 0xAB49,
    0xAB4A, 0xAB4B, 0xAB4C, 0xAB4D, 0xAB4E, 0xAB4F, 0xAB50, 0xAB51,
    0xAB52, 0xAB53, 0xAB54, 0xAB55, 0xAB56, 0xAB57, 0xAB58, 0xAB59,
    0xAB5A, 0xAB5B, 0xAB5C, 0xAB5D, 0xAB5E, 0xAB5F, 0xAB60, 0xAB61,
    0xAB62, 0xAB63, 0xAB64, 0xAB65, 0xAB66, 0xAB67, 0xAB68, 0xAB69,
    0xAB6A, 0xAB6B, 0xAB6C, 0xAB6D, 0xAB6E, 0xAB6F, 0xAB70, 0xAB71,
    0xAB72, 0xAB73, 0xAB74, 0xAB75, 0xAB76, 0xAB77, 0xAB78, 0xAB79,
    0xAB7A, 0xAB7B, 0xAB7C, 0xAB7D, 0xAB7E, 0xAB80, 0xAB81, 0xAB82,
    0xAB83, 0xAB84, 0xAB85, 0xAB86, 0xAB87, 0xAB88, 0xAB89, 0xAB8A,
    0xAB8B, 0xAB8C, 0xAB8D, 0xAB8E, 0xAB8F, 0xAB90, 0xAB91, 0xAB92,
    0xAB93, 0xAB94, 0xAB95, 0xAB96, 0xAB97, 0xAB98, 0xAB99, 0xAB9A,
    0xAB9B, 0xAB9C, 0xAB9D, 0xAB9E, 0xAB9F, 0xABA0, 0xAC40, 0xAC41,
    0xAC42, 0xAC43, 0xAC44, 0xAC45, 0xAC46, 0xAC47, 0xAC48, 0xAC49,
    0xAC4A, 0xAC4B, 0xAC4C, 0xAC4D, 0xAC4E, 0xAC4F, 0xAC50, 0xAC51,
    0xAC52, 0xAC53, 0xAC54, 0xAC55, 0xAC56, 0xAC57, 0xAC58, 0xAC59,
    0xAC5A, 0xAC5B, 0xAC5C, 0xAC5D, 0xAC5E, 0xAC5F, 0xAC60, 0xAC61,
    0xAC62, 0xAC63, 0xAC64, 0xAC65, 0xAC66, 0xAC67, 0xAC68, 0xAC69,
    0xAC6A, 0xAC6B, 0xAC6C, 0xAC6D, 0xAC6E, 0xAC6F, 0xAC70, 0xAC71,
    0xAC72, 0xAC73, 0xAC74, 0xAC75, 0xAC76, 0xAC77, 0xAC78, 0xAC79,
    0xAC7A, 0xAC7B, 0xAC7C, 0xAC7D, 0xAC7E, 0xAC80, 0xAC81, 0xAC82,
    0xAC83, 0xAC84, 0xAC85, 0xAC86, 0xAC87, 0xAC88, 0xAC89, 0xAC8A,
    0xAC8B, 0xAC8C, 0xAC8D, 0xAC8E, 0xAC8F, 0xAC90, 0xAC91, 0xAC92,
    0xAC93, 0xAC94, 0xAC95, 0xAC96, 0xAC97, 0xAC98, 0xAC99, 0xAC9A,
    0xAC9B, 0xAC9C, 0xAC9D, 0xAC9E, 0xAC9F, 0xACA0, 0xAD40, 0xAD41,
    0xAD42, 0xAD43, 0xAD44, 0xAD45, 0xAD46, 0xAD47, 0xAD48, 0xAD49,
    0xAD4A, 0xAD4B, 0xAD4C, 0xAD4D, 0xAD4E, 0xAD4F, 0xAD50, 0xAD51,
    0xAD52, 0xAD53, 0xAD54, 0xAD55, 0xAD56, 0xAD57, 0xAD58, 0xAD59,
    0xAD5A, 0xAD5B, 0xAD5C, 0xAD5D, 0xAD5E, 0xAD5F, 0xAD60, 0xAD61,
    0xAD62, 0xAD63, 0xAD64, 0xAD65, 0xAD66, 0xAD67, 0xAD68, 0xAD69,
    0xAD6A, 0xAD6B, 0xAD6C, 0xAD6D, 0xAD6E, 0xAD6F, 0xAD70, 0xAD71,
    0xAD72, 0xAD73, 0xAD74, 0xAD75, 0xAD76, 0xAD77, 0xAD78, 0xAD79,
    0xAD7A, 0xAD7B, 0xAD7C, 0xAD7D, 0xAD7E, 0xAD80, 0xAD81, 0xAD82,
    0xAD83, 0xAD84, 0xAD85, 0xAD86, 0xAD87, 0xAD88, 0xAD89, 0xAD8A,
    0xAD8B, 0xAD8C, 0xAD8D, 0xAD8E, 0xAD8F, 0xAD90, 0xAD91, 0xAD92,
    0xAD93, 0xAD94, 0xAD95, 0xAD96, 0xAD97, 0xAD98, 0xAD99, 0xAD9A,
    0xAD9B, 0xAD9C, 0xAD9D, 0xAD9E, 0xAD9F, 0xADA0, 0xAE40, 0xAE41,
    0xAE42, 0xAE43, 0xAE44, 0xAE45, 0xAE46, 0xAE47, 0xAE48, 0xAE49,
    0xAE4A, 0xAE4B, 0xAE4C, 0xAE4D, 0xAE4E, 0xAE4F, 0xAE50, 0xAE51,
    0xAE52, 0xAE53, 0xAE54, 0xAE55, 0xAE56, 0xAE57, 0xAE58, 0xAE59,
    0xAE5A, 0xAE5B, 0xAE5C, 0xAE5D, 0xAE5E, 0xAE5F, 0xAE60, 0xAE61,
    0xAE62, 0xAE63, 0xAE64, 0xAE65, 0xAE66, 0xAE67, 0xAE68, 0xAE69,
    0xAE6A, 0xAE6B, 0xAE6C, 0xAE6D, 0xAE6E, 0xAE6F, 0xAE70, 0xAE71,
    0xAE72, 0xAE73, 0xAE74, 0xAE75, 0xAE76, 0xAE77, 0xAE78, 0xAE79,
    0xAE7A, 0xAE7B, 0xAE7C, 0xAE7D, 0xAE7E, 0xAE80, 0xAE81, 0xAE82,
    0xAE83, 0xAE84, 0xAE85, 0xAE86, 0xAE87, 0xAE88, 0xAE89, 0xAE8A,
    0xAE8B, 0xAE8C, 0xAE8D, 0xAE8E, 0xAE8F, 0xAE90, 0xAE91, 0xAE92,
    0xAE93, 0xAE94, 0xAE95, 0xAE96, 0xAE97, 0xAE98, 0xAE99, 0xAE9A,
    0xAE9B, 0xAE9C, 0xAE9D, 0xAE9E, 0xAE9F, 0xAEA0, 0xAF40, 0xAF41,
    0xAF42, 0xAF43, 0xAF44, 0xAF45, 0xAF46, 0xAF47, 0xAF48, 0xAF49,
    0xAF4A, 0xAF4B, 0xAF4C, 0xAF4D, 0xAF4E, 0xAF4F, 0xAF50, 0xAF51,
    0xAF52, 0xAF53, 0xAF54, 0xAF55, 0xAF56, 0xAF57, 0xAF58, 0xAF59,
    0xAF5A, 0xAF5B, 0xAF5C, 0xAF5D, 0xAF5E, 0xAF5F, 0xAF60, 0xAF61,
    0xAF62, 0xAF63, 0xAF64, 0xAF65, 0xAF66, 0xAF67, 0xAF68, 0xAF69,
    0xAF6A, 0xAF6B, 0xAF6C, 0xAF6D, 0xAF6E, 0xAF6F, 0xAF70, 0xAF71,
    0xAF72, 0xAF73, 0xAF74, 0xAF75, 0xAF76, 0xAF77, 0xAF78, 0xAF79,
    0xAF7A, 0xAF7B, 0xAF7C, 0xAF7D, 0xAF7E, 0xAF80, 0xAF81, 0xAF82,
    0xAF83, 0xAF84, 0xAF85, 0xAF86, 0xAF87, 0xAF88, 0xAF89, 0xAF8A,
    0xAF8B, 0xAF8C, 0xAF8D, 0xAF8E, 0xAF8F, 0xAF90, 0xAF91, 0xAF92,
    0xAF93, 0xAF94, 0xAF95, 0xAF96, 0xAF97, 0xAF98, 0xAF99, 0xAF9A,
    0xAF9B, 0xAF9C, 0xAF9D, 0xAF9E, 0xAF9F, 0xAFA0, 0xB040, 0xB041,
    0xB042, 0xB043, 0xB044, 0xB045, 0xB046, 0xB047, 0xB048, 0xB049,
    0xB04A, 0xB04B, 0xB04C, 0xB04D, 0xB04E, 0xB04F, 0xB050, 0xB051,
    0xB052, 0xB053, 0xB054, 0xB055, 0xB056, 0xB057, 0xB058, 0xB059,
    0xB05A, 0xB05B, 0xB05C, 0xB05D, 0xB05E, 0xB05F, 0xB060, 0xB061,
    0xB062, 0xB063, 0xB064, 0xB065, 0xB066, 0xB067, 0xB068, 0xB069,
    0xB06A, 0xB06B, 0xB06C, 0xB06D, 0xB06E, 0xB06F, 0xB070, 0xB071,
    0xB072, 0xB073, 0xB074, 0xB075, 0xB076, 0xB077, 0xB078, 0xB079,
    0xB07A, 0xB07B, 0xB07C, 0xB07D, 0xB07E, 0xB080, 0xB081, 0xB082,
    0xB083, 0xB084, 0xB085, 0xB086, 0xB087, 0xB088, 0xB089, 0xB08A,
    0xB08B, 0xB08C, 0xB08D, 0xB08E, 0xB08F, 0xB090, 0xB091, 0xB092,
    0xB093, 0xB094, 0xB095, 0xB096, 0xB097, 0xB098, 0xB099, 0xB09A,
    0xB09B, 0xB09C, 0xB09D, 0xB09E, 0xB09F, 0xB0A0, 0xB140, 0xB141,
    0xB142, 0xB143, 0xB144, 0xB145, 0xB146, 0xB147, 0xB148, 0xB149,
    0xB14A, 0xB14B, 0xB14C, 0xB14D, 0xB14E, 0xB14F, 0xB150, 0xB151,
    0xB152, 0xB153, 0xB154, 0xB155, 0xB156, 0xB157, 0xB158, 0xB159,
    0xB15A, 0xB15B, 0xB15C, 0xB15D, 0xB15E, 0xB15F, 0xB160, 0xB161,
    0xB162, 0xB163, 0xB164, 0xB165, 0xB166, 0xB167, 0xB168, 0xB169,
    0xB16A, 0xB16B, 0xB16C, 0xB16D, 0xB16E, 0xB16F, 0xB170, 0xB171,
    0xB172, 0xB173, 0xB174, 0xB175, 0xB176, 0xB177, 0xB178, 0xB179,
    0xB17A, 0xB17B, 0xB17C, 0xB17D, 0xB17E, 0xB180, 0xB181, 0xB182,
    0xB183, 0xB184, 0xB185, 0xB186, 0xB187, 0xB188, 0xB189, 0xB18A,
    0xB18B, 0xB18C, 0xB18D, 0xB18E, 0xB18F, 0xB190, 0xB191, 0xB192,
    0xB193, 0xB194, 0xB195, 0xB196, 0xB197, 0xB198, 0xB199, 0xB19A,
    0xB19B, 0xB19C, 0xB19D, 0xB19E, 0xB19F, 0xB1A0, 0xB240, 0xB241,
    0xB242, 0xB243, 0xB244, 0xB245, 0xB246, 0xB247, 0xB248, 0xB249,
    0xB24A, 0xB24B, 0xB24C, 0xB24D, 0xB24E, 0xB24F, 0xB250, 0xB251,
    0xB252, 0xB253, 0xB254, 0xB255, 0xB256, 0xB257, 0xB258, 0xB259,
    0xB25A, 0xB25B, 0xB25C, 0xB25D, 0xB25E, 0xB25F, 0xB260, 0xB261,
    0xB262, 0xB263, 0xB264, 0xB265, 0xB266, 0xB267, 0xB268, 0xB269,
    0xB26A, 0xB26B, 0xB26C, 0xB26D, 0xB26E, 0xB26F, 0xB270, 0xB271,
    0xB272, 0xB273, 0xB274, 0xB275, 0xB276, 0xB277, 0xB278, 0xB279,
    0xB27A, 0xB27B, 0xB27C, 0xB27D, 0xB27E, 0xB280, 0xB281, 0xB282,
    0xB283, 0xB284, 0xB285, 0xB286, 0xB287, 0xB288, 0xB289, 0xB28A,
    0xB28B, 0xB28C, 0xB28D, 0xB28E, 0xB28F, 0xB290, 0xB291, 0xB292,
    0xB293, 0xB294, 0xB295, 0xB296, 0xB297, 0xB298, 0xB299, 0xB29A,
    0xB29B, 0xB29C, 0xB29D, 0xB29E, 0xB29F, 0xB2A0, 0xB340, 0xB341,
    0xB342, 0xB343, 0xB344, 0xB345, 0xB346, 0xB347, 0xB348, 0xB349,
    0xB34A, 0xB34B, 0xB34C, 0xB34D, 0xB34E, 0xB34F, 0xB350, 0xB351,
    0xB352, 0xB353, 0xB354, 0xB355, 0xB356, 0xB357, 0xB358, 0xB359,
    0xB35A, 0xB35B, 0xB35C, 0xB35D, 0xB35E, 0xB35F, 0xB360, 0xB361,
    0xB362, 0xB363, 0xB364, 0xB365, 0xB366, 0xB367, 0xB368, 0xB369,
    0xB36A, 0xB36B, 0xB36C, 0xB36D, 0xB36E, 0xB36F, 0xB370, 0xB371,
    0xB372, 0xB373, 0xB374, 0xB375, 0xB376, 0xB377, 0xB378, 0xB379,
    0xB37A, 0xB37B, 0xB37C, 0xB37D, 0xB37E, 0xB380, 0xB381, 0xB382,
    0xB383, 0xB384, 0xB385, 0xB386, 0xB387, 0xB388, 0xB389, 0xB38A,
    0xB38B, 0xB38C, 0xB38D, 0xB38E, 0xB38F, 0xB390, 0xB391, 0xB392,
    0xB393, 0xB394, 0xB395, 0xB396, 0xB397, 0xB398, 0xB399, 0xB39A,
    0xB39B, 0xB39C, 0xB39D, 0xB39E, 0xB39F, 0xB3A0, 0xB440, 0xB441,
    0xB442, 0xB443, 0xB444, 0xB445, 0xB446, 0xB447, 0xB448, 0xB449,
    0xB44A, 0xB44B, 0xB44C, 0xB44D, 0xB44E, 0xB44F, 0xB450, 0xB451,
    0xB452, 0xB453, 0xB454, 0xB455, 0xB456, 0xB457, 0xB458, 0xB459,
    0xB45A, 0xB45B, 0xB45C, 0xB45D, 0xB45E, 0xB45F, 0xB460, 0xB461,
    0xB462, 0xB463, 0xB464, 0xB465, 0xB466, 0xB467, 0xB468, 0xB469,
    0xB46A, 0xB46B, 0xB46C, 0xB46D, 0xB46E, 0xB46F, 0xB470, 0xB471,
    0xB472, 0xB473, 0xB474, 0xB475, 0xB476, 0xB477, 0xB478, 0xB479,
    0xB47A, 0xB47B, 0xB47C, 0xB47D, 0xB47E, 0xB480, 0xB481, 0xB482,
    0xB483, 0xB484, 0xB485, 0xB486, 0xB487, 0xB488, 0xB489, 0xB48A,
    0xB48B, 0xB48C, 0xB48D, 0xB48E, 0xB48F, 0xB490, 0xB491, 0xB492,
    0xB493, 0xB494, 0xB495, 0xB496, 0xB497, 0xB498, 0xB499, 0xB49A,
    0xB49B, 0xB49C, 0xB49D, 0xB49E, 0xB49F, 0xB4A0, 0xB540, 0xB541,
    0xB542, 0xB543, 0xB544, 0xB545, 0xB546, 0xB547, 0xB548, 0xB549,
    0xB54A, 0xB54B, 0xB54C, 0xB54D, 0xB54E, 0xB54F, 0xB550, 0xB551,
    0xB552, 0xB553, 0xB554, 0xB555, 0xB556, 0xB557, 0xB558, 0xB559,
    0xB55A, 0xB55B, 0xB55C, 0xB55D, 0xB55E, 0xB55F, 0xB560, 0xB561,
    0xB562, 0xB563, 0xB564, 0xB565, 0xB566, 0xB567, 0xB568, 0xB569,
    0xB56A, 0xB56B, 0xB56C, 0xB56D, 0xB56E, 0xB56F, 0xB570, 0xB571,
    0xB572, 0xB573, 0xB574, 0xB575, 0xB576, 0xB577, 0xB578, 0xB579,
    0xB57A, 0xB57B, 0xB57C, 0xB57D, 0xB57E, 0xB580, 0xB581, 0xB582,
    0xB583, 0xB584, 0xB585, 0xB586, 0xB587, 0xB588, 0xB589, 0xB58A,
    0xB58B, 0xB58C, 0xB58D, 0xB58E, 0xB58F, 0xB590, 0xB591, 0xB592,
    0xB593, 0xB594, 0xB595, 0xB596, 0xB597, 0xB598, 0xB599, 0xB59A,
    0xB59B, 0xB59C, 0xB59D, 0xB59E, 0xB59F, 0xB5A0, 0xB640, 0xB641,
    0xB642, 0xB643, 0xB644, 0xB645, 0xB646, 0xB647, 0xB648, 0xB649,
    0xB64A, 0xB64B, 0xB64C, 0xB64D, 0xB64E, 0xB64F, 0xB650, 0xB651,
    0xB652, 0xB653, 0xB654, 0xB655, 0xB656, 0xB657, 0xB658, 0xB659,
    0xB65A, 0xB65B, 0xB65C, 0xB65D, 0xB65E, 0xB65F, 0xB660, 0xB661,
    0xB662, 0xB663, 0xB664, 0xB665, 0xB666, 0xB667, 0xB668, 0xB669,
    0xB66A, 0xB66B, 0xB66C, 0xB66D, 0xB66E, 0xB66F, 0xB670, 0xB671,
    0xB672, 0xB673, 0xB674, 0xB675, 0xB676, 0xB677, 0xB678, 0xB679,
    0xB67A, 0xB67B, 0xB67C, 0xB67D, 0xB67E, 0xB680, 0xB681, 0xB682,
    0xB683, 0xB684, 0xB685, 0xB686, 0xB687, 0xB688, 0xB689, 0xB68A,
    0xB68B, 0xB68C, 0xB68D, 0xB68E, 0xB68F, 0xB690, 0xB691, 0xB692,
    0xB693, 0xB694, 0xB695, 0xB696, 0xB697, 0xB698, 0xB699, 0xB69A,
    0xB69B, 0xB69C, 0xB69D, 0xB69E, 0xB69F, 0xB6A0, 0xB740, 0xB741,
    0xB742, 0xB743, 0xB744, 0xB745, 0xB746, 0xB747, 0xB748, 0xB749,
    0xB74A, 0xB74B, 0xB74C, 0xB74D, 0xB74E, 0xB74F, 0xB750, 0xB751,
    0xB752, 0xB753, 0xB754, 0xB755, 0xB756, 0xB757, 0xB758, 0xB759,
    0xB75A, 0xB75B, 0xB75C, 0xB75D, 0xB75E, 0xB75F, 0xB760, 0xB761,
    0xB762, 0xB763, 0xB764, 0xB765, 0xB766, 0xB767, 0xB768, 0xB769,
    0xB76A, 0xB76B, 0xB76C, 0xB76D, 0xB76E, 0xB76F, 0xB770, 0xB771,
    0xB772, 0xB773, 0xB774, 0xB775, 0xB776, 0xB777, 0xB778, 0xB779,
    0xB77A, 0xB77B, 0xB77C, 0xB77D, 0xB77E, 0xB780, 0xB781, 0xB782,
    0xB783, 0xB784, 0xB785, 0xB786, 0xB787, 0xB788, 0xB789, 0xB78A,
    0xB78B, 0xB78C, 0xB78D, 0xB78E, 0xB78F, 0xB790, 0xB791, 0xB792,
    0xB793, 0xB794, 0xB795, 0xB796, 0xB797, 0xB798, 0xB799, 0xB79A,
    0xB79B, 0xB79C, 0xB79D, 0xB79E, 0xB79F, 0xB7A0, 0xB840, 0xB841,
    0xB842, 0xB843, 0xB844, 0xB845, 0xB846, 0xB847, 0xB848, 0xB849,
    0xB84A, 0xB84B, 0xB84C, 0xB84D, 0xB84E, 0xB84F, 0xB850, 0xB851,
    0xB852, 0xB853, 0xB854, 0xB855, 0xB856, 0xB857, 0xB858, 0xB859,
    0xB85A, 0xB85B, 0xB85C, 0xB85D, 0xB85E, 0xB85F, 0xB860, 0xB861,
    0xB862, 0xB863, 0xB864, 0xB865, 0xB866, 0xB867, 0xB868, 0xB869,
    0xB86A, 0xB86B, 0xB86C, 0xB86D, 0xB86E, 0xB86F, 0xB870, 0xB871,
    0xB872, 0xB873, 0xB874, 0xB875, 0xB876, 0xB877, 0xB878, 0xB879,
    0xB87A, 0xB87B, 0xB87C, 0xB87D, 0xB87E, 0xB880, 0xB881, 0xB882,
    0xB883, 0xB884, 0xB885, 0xB886, 0xB887, 0xB888, 0xB889, 0xB88A,
    0xB88B, 0xB88C, 0xB88D, 0xB88E, 0xB88F, 0xB890, 0xB891, 0xB892,
    0xB893, 0xB894, 0xB895, 0xB896, 0xB897, 0xB898, 0xB899, 0xB89A,
    0xB89B, 0xB89C, 0xB89D, 0xB89E, 0xB89F, 0xB8A0, 0xB940, 0xB941,
    0xB942, 0xB943, 0xB944, 0xB945, 0xB946, 0xB947, 0xB948, 0xB949,
    0xB94A, 0xB94B, 0xB94C, 0xB94D, 0xB94E, 0xB94F, 0xB950, 0xB951,
    0xB952, 0xB953, 0xB954, 0xB955, 0xB956, 0xB957, 0xB958, 0xB959,
    0xB95A, 0xB95B, 0xB95C, 0xB95D, 0xB95E, 0xB95F, 0xB960, 0xB961,
    0xB962, 0xB963, 0xB964, 0xB965, 0xB966, 0xB967, 0xB968, 0xB969,
    0xB96A, 0xB96B, 0xB96C, 0xB96D, 0xB96E, 0xB96F, 0xB970, 0xB971,
    0xB972, 0xB973, 0xB974, 0xB975, 0xB976, 0xB977, 0xB978, 0xB979,
    0xB97A, 0xB97B, 0xB97C, 0xB97D, 0xB97E, 0xB980, 0xB981, 0xB982,
    0xB983, 0xB984, 0xB985, 0xB986, 0xB987, 0xB988, 0xB989, 0xB98A,
    0xB98B, 0xB98C, 0xB98D, 0xB98E, 0xB98F, 0xB990, 0xB991, 0xB992,
    0xB993, 0xB994, 0xB995, 0xB996, 0xB997, 0xB998, 0xB999, 0xB99A,
    0xB99B, 0xB99C, 0xB99D, 0xB99E, 0xB99F, 0xB9A0, 0xBA40, 0xBA41,
    0xBA42, 0xBA43, 0xBA44, 0xBA45, 0xBA46, 0xBA47, 0xBA48, 0xBA49,
    0xBA4A, 0xBA4B, 0xBA4C, 0xBA4D, 0xBA4E, 0xBA4F, 0xBA50, 0xBA51,
    0xBA52, 0xBA53, 0xBA54, 0xBA55, 0xBA56, 0xBA57, 0xBA58, 0xBA59,
    0xBA5A, 0xBA5B, 0xBA5C, 0xBA5D, 0xBA5E, 0xBA5F, 0xBA60, 0xBA61,
    0xBA62, 0xBA63, 0xBA64, 0xBA65, 0xBA66, 0xBA67, 0xBA68, 0xBA69,
    0xBA6A, 0xBA6B, 0xBA6C, 0xBA6D, 0xBA6E, 0xBA6F, 0xBA70, 0xBA71,
    0xBA72, 0xBA73, 0xBA74, 0xBA75, 0xBA76, 0xBA77, 0xBA78, 0xBA79,
    0xBA7A, 0xBA7B, 0xBA7C, 0xBA7D, 0xBA7E, 0xBA80, 0xBA81, 0xBA82,
    0xBA83, 0xBA84, 0xBA85, 0xBA86, 0xBA87, 0xBA88, 0xBA89, 0xBA8A,
    0xBA8B, 0xBA8C, 0xBA8D, 0xBA8E, 0xBA8F, 0xBA90, 0xBA91, 0xBA92,
    0xBA93, 0xBA94, 0xBA95, 0xBA96, 0xBA97, 0xBA98, 0xBA99, 0xBA9A,
    0xBA9B, 0xBA9C, 0xBA9D, 0xBA9E, 0xBA9F, 0xBAA0, 0xBB40, 0xBB41,
    0xBB42, 0xBB43, 0xBB44, 0xBB45, 0xBB46, 0xBB47, 0xBB48, 0xBB49,
    0xBB4A, 0xBB4B, 0xBB4C, 0xBB4D, 0xBB4E, 0xBB4F, 0xBB50, 0xBB51,
    0xBB52, 0xBB53, 0xBB54, 0xBB55, 0xBB56, 0xBB57, 0xBB58, 0xBB59,
    0xBB5A, 0xBB5B, 0xBB5C, 0xBB5D, 0xBB5E, 0xBB5F, 0xBB60, 0xBB61,
    0xBB62, 0xBB63, 0xBB64, 0xBB65, 0xBB66, 0xBB67, 0xBB68, 0xBB69,
    0xBB6A, 0xBB6B, 0xBB6C, 0xBB6D, 0xBB6E, 0xBB6F, 0xBB70, 0xBB71,
    0xBB72, 0xBB73, 0xBB74, 0xBB75, 0xBB76, 0xBB77, 0xBB78, 0xBB79,
    0xBB7A, 0xBB7B, 0xBB7C, 0xBB7D, 0xBB7E, 0xBB80, 0xBB81, 0xBB82,
    0xBB83, 0xBB84, 0xBB85, 0xBB86, 0xBB87, 0xBB88, 0xBB89, 0xBB8A,
    0xBB8B, 0xBB8C, 0xBB8D, 0xBB8E, 0xBB8F, 0xBB90, 0xBB91, 0xBB92,
    0xBB93, 0xBB94, 0xBB95, 0xBB96, 0xBB97, 0xBB98, 0xBB99, 0xBB9A,
    0xBB9B, 0xBB9C, 0xBB9D, 0xBB9E, 0xBB9F, 0xBBA0, 0xBC40, 0xBC41,
    0xBC42, 0xBC43, 0xBC44, 0xBC45, 0xBC46, 0xBC47, 0xBC48, 0xBC49,
    0xBC4A, 0xBC4B, 0xBC4C, 0xBC4D, 0xBC4E, 0xBC4F, 0xBC50, 0xBC51,
    0xBC52, 0xBC53, 0xBC54, 0xBC55, 0xBC56, 0xBC57, 0xBC58, 0xBC59,
    0xBC5A, 0xBC5B, 0xBC5C, 0xBC5D, 0xBC5E, 0xBC5F, 0xBC60, 0xBC61,
    0xBC62, 0xBC63, 0xBC64, 0xBC65, 0xBC66, 0xBC67, 0xBC68, 0xBC69,
    0xBC6A, 0xBC6B, 0xBC6C, 0xBC6D, 0xBC6E, 0xBC6F, 0xBC70, 0xBC71,
    0xBC72, 0xBC73, 0xBC74, 0xBC75, 0xBC76, 0xBC77, 0xBC78, 0xBC79,
    0xBC7A, 0xBC7B, 0xBC7C, 0xBC7D, 0xBC7E, 0xBC80, 0xBC81, 0xBC82,
    0xBC83, 0xBC84, 0xBC85, 0xBC86, 0xBC87, 0xBC88, 0xBC89, 0xBC8A,
    0xBC8B, 0xBC8C, 0xBC8D, 0xBC8E, 0xBC8F, 0xBC90, 0xBC91, 0xBC92,
    0xBC93, 0xBC94, 0xBC95, 0xBC96, 0xBC97, 0xBC98, 0xBC99, 0xBC9A,
    0xBC9B, 0xBC9C, 0xBC9D, 0xBC9E, 0xBC9F, 0xBCA0, 0xBD40, 0xBD41,
    0xBD42, 0xBD43, 0xBD44, 0xBD45, 0xBD46, 0xBD47, 0xBD48, 0xBD49,
    0xBD4A, 0xBD4B, 0xBD4C, 0xBD4D, 0xBD4E, 0xBD4F, 0xBD50, 0xBD51,
    0xBD52, 0xBD53, 0xBD54, 0xBD55, 0xBD56, 0xBD57, 0xBD58, 0xBD59,
    0xBD5A, 0xBD5B, 0xBD5C, 0xBD5D, 0xBD5E, 0xBD5F, 0xBD60, 0xBD61,
    0xBD62, 0xBD63, 0xBD64, 0xBD65, 0xBD66, 0xBD67, 0xBD68, 0xBD69,
    0xBD6A, 0xBD6B, 0xBD6C, 0xBD6D, 0xBD6E, 0xBD6F, 0xBD70, 0xBD71,
    0xBD72, 0xBD73, 0xBD74, 0xBD75, 0xBD76, 0xBD77, 0xBD78, 0xBD79,
    0xBD7A, 0xBD7B, 0xBD7C, 0xBD7D, 0xBD7E, 0xBD80, 0xBD81, 0xBD82,
    0xBD83, 0xBD84, 0xBD85, 0xBD86, 0xBD87, 0xBD88, 0xBD89, 0xBD8A,
    0xBD8B, 0xBD8C, 0xBD8D, 0xBD8E, 0xBD8F, 0xBD90, 0xBD91, 0xBD92,
    0xBD93, 0xBD94, 0xBD95, 0xBD96, 0xBD97, 0xBD98, 0xBD99, 0xBD9A,
    0xBD9B, 0xBD9C, 0xBD9D, 0xBD9E, 0xBD9F, 0xBDA0, 0xBE40, 0xBE41,
    0xBE42, 0xBE43, 0xBE44, 0xBE45, 0xBE46, 0xBE47, 0xBE48, 0xBE49,
    0xBE4A, 0xBE4B, 0xBE4C, 0xBE4D, 0xBE4E, 0xBE4F, 0xBE50, 0xBE51,
    0xBE52, 0xBE53, 0xBE54, 0xBE55, 0xBE56, 0xBE57, 0xBE58, 0xBE59,
    0xBE5A, 0xBE5B, 0xBE5C, 0xBE5D, 0xBE5E, 0xBE5F, 0xBE60, 0xBE61,
    0xBE62, 0xBE63, 0xBE64, 0xBE65, 0xBE66, 0xBE67, 0xBE68, 0xBE69,
    0xBE6A, 0xBE6B, 0xBE6C, 0xBE6D, 0xBE6E, 0xBE6F, 0xBE70, 0xBE71,
    0xBE72, 0xBE73, 0xBE74, 0xBE75, 0xBE76, 0xBE77, 0xBE78, 0xBE79,
    0xBE7A, 0xBE7B, 0xBE7C, 0xBE7D, 0xBE7E, 0xBE80, 0xBE81, 0xBE82,
    0xBE83, 0xBE84, 0xBE85, 0xBE86, 0xBE87, 0xBE88, 0xBE89, 0xBE8A,
    0xBE8B, 0xBE8C, 0xBE8D, 0xBE8E, 0xBE8F, 0xBE90, 0xBE91, 0xBE92,
    0xBE93, 0xBE94, 0xBE95, 0xBE96, 0xBE97, 0xBE98, 0xBE99, 0xBE9A,
    0xBE9B, 0xBE9C, 0xBE9D, 0xBE9E, 0xBE9F, 0xBEA0, 0xBF40, 0xBF41,
    0xBF42, 0xBF43, 0xBF44, 0xBF45, 0xBF46, 0xBF47, 0xBF48, 0xBF49,
    0xBF4A, 0xBF4B, 0xBF4C, 0xBF4D, 0xBF4E, 0xBF4F, 0xBF50, 0xBF51,
    0xBF52, 0xBF53, 0xBF54, 0xBF55, 0xBF56, 0xBF57, 0xBF58, 0xBF59,
    0xBF5A, 0xBF5B, 0xBF5C, 0xBF5D, 0xBF5E, 0xBF5F, 0xBF60, 0xBF61,
    0xBF62, 0xBF63, 0xBF64, 0xBF65, 0xBF66, 0xBF67, 0xBF68, 0xBF69,
    0xBF6A, 0xBF6B, 0xBF6C, 0xBF6D, 0xBF6E, 0xBF6F, 0xBF70, 0xBF71,
    0xBF72, 0xBF73, 0xBF74, 0xBF75, 0xBF76, 0xBF77, 0xBF78, 0xBF79,
    0xBF7A, 0xBF7B, 0xBF7C, 0xBF7D, 0xBF7E, 0xBF80, 0xBF81, 0xBF82,
    0xBF83, 0xBF84, 0xBF85, 0xBF86, 0xBF87, 0xBF88, 0xBF89, 0xBF8A,
    0xBF8B, 0xBF8C, 0xBF8D, 0xBF8E, 0xBF8F, 0xBF90, 0xBF91, 0xBF92,
    0xBF93, 0xBF94, 0xBF95, 0xBF96, 0xBF97, 0xBF98, 0xBF99, 0xBF9A,
    0xBF9B, 0xBF9C, 0xBF9D, 0xBF9E, 0xBF9F, 0xBFA0, 0xC040, 0xC041,
    0xC042, 0xC043, 0xC044, 0xC045, 0xC046, 0xC047, 0xC048, 0xC049,
    0xC04A, 0xC04B, 0xC04C, 0xC04D, 0xC04E, 0xC04F, 0xC050, 0xC051,
    0xC052, 0xC053, 0xC054, 0xC055, 0xC056, 0xC057, 0xC058, 0xC059,
    0xC05A, 0xC05B, 0xC05C, 0xC05D, 0xC05E, 0xC05F, 0xC060, 0xC061,
    0xC062, 0xC063, 0xC064, 0xC065, 0xC066, 0xC067, 0xC068, 0xC069,
    0xC06A, 0xC06B, 0xC06C, 0xC06D, 0xC06E, 0xC06F, 0xC070, 0xC071,
    0xC072, 0xC073, 0xC074, 0xC075, 0xC076, 0xC077, 0xC078, 0xC079,
    0xC07A, 0xC07B, 0xC07C, 0xC07D, 0xC07E, 0xC080, 0xC081, 0xC082,
    0xC083, 0xC084, 0xC085, 0xC086, 0xC087, 0xC088, 0xC089, 0xC08A,
    0xC08B, 0xC08C, 0xC08D, 0xC08E, 0xC08F, 0xC090, 0xC091, 0xC092,
    0xC093, 0xC094, 0xC095, 0xC096, 0xC097, 0xC098, 0xC099, 0xC09A,
    0xC09B, 0xC09C, 0xC09D, 0xC09E, 0xC09F, 0xC0A0, 0xC140, 0xC141,
    0xC142, 0xC143, 0xC144, 0xC145, 0xC146, 0xC147, 0xC148, 0xC149,
    0xC14A, 0xC14B, 0xC14C, 0xC14D, 0xC14E, 0xC14F, 0xC150, 0xC151,
    0xC152, 0xC153, 0xC154, 0xC155, 0xC156, 0xC157, 0xC158, 0xC159,
    0xC15A, 0xC15B, 0xC15C, 0xC15D, 0xC15E, 0xC15F, 0xC160, 0xC161,
    0xC162, 0xC163, 0xC164, 0xC165, 0xC166, 0xC167, 0xC168, 0xC169,
    0xC16A, 0xC16B, 0xC16C, 0xC16D, 0xC16E, 0xC16F, 0xC170, 0xC171,
    0xC172, 0xC173, 0xC174, 0xC175, 0xC176, 0xC177, 0xC178, 0xC179,
    0xC17A, 0xC17B, 0xC17C, 0xC17D, 0xC17E, 0xC180, 0xC181, 0xC182,
    0xC183, 0xC184, 0xC185, 0xC186, 0xC187, 0xC188, 0xC189, 0xC18A,
    0xC18B, 0xC18C, 0xC18D, 0xC18E, 0xC18F, 0xC190, 0xC191, 0xC192,
    0xC193, 0xC194, 0xC195, 0xC196, 0xC197, 0xC198, 0xC199, 0xC19A,
    0xC19B, 0xC19C, 0xC19D, 0xC19E, 0xC19F, 0xC1A0, 0xC240, 0xC241,
    0xC242, 0xC243, 0xC244, 0xC245, 0xC246, 0xC247, 0xC248, 0xC249,
    0xC24A, 0xC24B, 0xC24C, 0xC24D, 0xC24E, 0xC24F, 0xC250, 0xC251,
    0xC252, 0xC253, 0xC254, 0xC255, 0xC256, 0xC257, 0xC258, 0xC259,
    0xC25A, 0xC25B, 0xC25C, 0xC25D, 0xC25E, 0xC25F, 0xC260, 0xC261,
    0xC262, 0xC263, 0xC264, 0xC265, 0xC266, 0xC267, 0xC268, 0xC269,
    0xC26A, 0xC26B, 0xC26C, 0xC26D, 0xC26E, 0xC26F, 0xC270, 0xC271,
    0xC272, 0xC273, 0xC274, 0xC275, 0xC276, 0xC277, 0xC278, 0xC279,
    0xC27A, 0xC27B, 0xC27C, 0xC27D, 0xC27E, 0xC280, 0xC281, 0xC282,
    0xC283, 0xC284, 0xC285, 0xC286, 0xC287, 0xC288, 0xC289, 0xC28A,
    0xC28B, 0xC28C, 0xC28D, 0xC28E, 0xC28F, 0xC290, 0xC291, 0xC292,
    0xC293, 0xC294, 0xC295, 0xC296, 0xC297, 0xC298, 0xC299, 0xC29A,
    0xC29B, 0xC29C, 0xC29D, 0xC29E, 0xC29F, 0xC2A0, 0xC340, 0xC341,
    0xC342, 0xC343, 0xC344, 0xC345, 0xC346, 0xC347, 0xC348, 0xC349,
    0xC34A, 0xC34B, 0xC34C, 0xC34D, 0xC34E, 0xC34F, 0xC350, 0xC351,
    0xC352, 0xC353, 0xC354, 0xC355, 0xC356, 0xC357, 0xC358, 0xC359,
    0xC35A, 0xC35B, 0xC35C, 0xC35D, 0xC35E, 0xC35F, 0xC360, 0xC361,
    0xC362, 0xC363, 0xC364, 0xC365, 0xC366, 0xC367, 0xC368, 0xC369,
    0xC36A, 0xC36B, 0xC36C, 0xC36D, 0xC36E, 0xC36F, 0xC370, 0xC371,
    0xC372, 0xC373, 0xC374, 0xC375, 0xC376, 0xC377, 0xC378, 0xC379,
    0xC37A, 0xC37B, 0xC37C, 0xC37D, 0xC37E, 0xC380, 0xC381, 0xC382,
    0xC383, 0xC384, 0xC385, 0xC386, 0xC387, 0xC388, 0xC389, 0xC38A,
    0xC38B, 0xC38C, 0xC38D, 0xC38E, 0xC38F, 0xC390, 0xC391, 0xC392,
    0xC393, 0xC394, 0xC395, 0xC396, 0xC397, 0xC398, 0xC399, 0xC39A,
    0xC39B, 0xC39C, 0xC39D, 0xC39E, 0xC39F, 0xC3A0, 0xC440, 0xC441,
    0xC442, 0xC443, 0xC444, 0xC445, 0xC446, 0xC447, 0xC448, 0xC449,
    0xC44A, 0xC44B, 0xC44C, 0xC44D, 0xC44E, 0xC44F, 0xC450, 0xC451,
    0xC452, 0xC453, 0xC454, 0xC455, 0xC456, 0xC457, 0xC458, 0xC459,
    0xC45A, 0xC45B, 0xC45C, 0xC45D, 0xC45E, 0xC45F, 0xC460, 0xC461,
    0xC462, 0xC463, 0xC464, 0xC465, 0xC466, 0xC467, 0xC468, 0xC469,
    0xC46A, 0xC46B, 0xC46C, 0xC46D, 0xC46E, 0xC46F, 0xC470, 0xC471,
    0xC472, 0xC473, 0xC474, 0xC475, 0xC476, 0xC477, 0xC478, 0xC479,
    0xC47A, 0xC47B, 0xC47C, 0xC47D, 0xC47E, 0xC480, 0xC481, 0xC482,
    0xC483, 0xC484, 0xC485, 0xC486, 0xC487, 0xC488, 0xC489, 0xC48A,
    0xC48B, 0xC48C, 0xC48D, 0xC48E, 0xC48F, 0xC490, 0xC491, 0xC492,
    0xC493, 0xC494, 0xC495, 0xC496, 0xC497, 0xC498, 0xC499, 0xC49A,
    0xC49B, 0xC49C, 0xC49D, 0xC49E, 0xC49F, 0xC4A0, 0xC540, 0xC541,
    0xC542, 0xC543, 0xC544, 0xC545, 0xC546, 0xC547, 0xC548, 0xC549,
    0xC54A, 0xC54B, 0xC54C, 0xC54D, 0xC54E, 0xC54F, 0xC550, 0xC551,
    0xC552, 0xC553, 0xC554, 0xC555, 0xC556, 0xC557, 0xC558, 0xC559,
    0xC55A, 0xC55B, 0xC55C, 0xC55D, 0xC55E, 0xC55F, 0xC560, 0xC561,
    0xC562, 0xC563, 0xC564, 0xC565, 0xC566, 0xC567, 0xC568, 0xC569,
    0xC56A, 0xC56B, 0xC56C, 0xC56D, 0xC56E, 0xC56F, 0xC570, 0xC571,
    0xC572, 0xC573, 0xC574, 0xC575, 0xC576, 0xC577, 0xC578, 0xC579,
    0xC57A, 0xC57B, 0xC57C, 0xC57D, 0xC57E, 0xC580, 0xC581, 0xC582,
    0xC583, 0xC584, 0xC585, 0xC586, 0xC587, 0xC588, 0xC589, 0xC58A,
    0xC58B, 0xC58C, 0xC58D, 0xC58E, 0xC58F, 0xC590, 0xC591, 0xC592,
    0xC593, 0xC594, 0xC595, 0xC596, 0xC597, 0xC598, 0xC599, 0xC59A,
    0xC59B, 0xC59C, 0xC59D, 0xC59E, 0xC59F, 0xC5A0, 0xC640, 0xC641,
    0xC642, 0xC643, 0xC644, 0xC645, 0xC646, 0xC647, 0xC648, 0xC649,
    0xC64A, 0xC64B, 0xC64C, 0xC64D, 0xC64E, 0xC64F, 0xC650, 0xC651,
    0xC652, 0xC653, 0xC654, 0xC655, 0xC656, 0xC657, 0xC658, 0xC659,
    0xC65A, 0xC65B, 0xC65C, 0xC65D, 0xC65E, 0xC65F, 0xC660, 0xC661,
    0xC662, 0xC663, 0xC664, 0xC665, 0xC666, 0xC667, 0xC668, 0xC669,
    0xC66A, 0xC66B, 0xC66C, 0xC66D, 0xC66E, 0xC66F, 0xC670, 0xC671,
    0xC672, 0xC673, 0xC674, 0xC675, 0xC676, 0xC677, 0xC678, 0xC679,
    0xC67A, 0xC67B, 0xC67C, 0xC67D, 0xC67E, 0xC680, 0xC681, 0xC682,
    0xC683, 0xC684, 0xC685, 0xC686, 0xC687, 0xC688, 0xC689, 0xC68A,
    0xC68B, 0xC68C, 0xC68D, 0xC68E, 0xC68F, 0xC690, 0xC691, 0xC692,
    0xC693, 0xC694, 0xC695, 0xC696, 0xC697, 0xC698, 0xC699, 0xC69A,
    0xC69B, 0xC69C, 0xC69D, 0xC69E, 0xC69F, 0xC6A0, 0xC740, 0xC741,
    0xC742, 0xC743, 0xC744, 0xC745, 0xC746, 0xC747, 0xC748, 0xC749,
    0xC74A, 0xC74B, 0xC74C, 0xC74D, 0xC74E, 0xC74F, 0xC750, 0xC751,
    0xC752, 0xC753, 0xC754, 0xC755, 0xC756, 0xC757, 0xC758, 0xC759,
    0xC75A, 0xC75B, 0xC75C, 0xC75D, 0xC75E, 0xC75F, 0xC760, 0xC761,
    0xC762, 0xC763, 0xC764, 0xC765, 0xC766, 0xC767, 0xC768, 0xC769,
    0xC76A, 0xC76B, 0xC76C, 0xC76D, 0xC76E, 0xC76F, 0xC770, 0xC771,
    0xC772, 0xC773, 0xC774, 0xC775, 0xC776, 0xC777, 0xC778, 0xC779,
    0xC77A, 0xC77B, 0xC77C, 0xC77D, 0xC77E, 0xC780, 0xC781, 0xC782,
    0xC783, 0xC784, 0xC785, 0xC786, 0xC787, 0xC788, 0xC789, 0xC78A,
    0xC78B, 0xC78C, 0xC78D, 0xC78E, 0xC78F, 0xC790, 0xC791, 0xC792,
    0xC793, 0xC794, 0xC795, 0xC796, 0xC797, 0xC798, 0xC799, 0xC79A,
    0xC79B, 0xC79C, 0xC79D, 0xC79E, 0xC79F, 0xC7A0, 0xC840, 0xC841,
    0xC842, 0xC843, 0xC844, 0xC845, 0xC846, 0xC847, 0xC848, 0xC849,
    0xC84A, 0xC84B, 0xC84C, 0xC84D, 0xC84E, 0xC84F, 0xC850, 0xC851,
    0xC852, 0xC853, 0xC854, 0xC855, 0xC856, 0xC857, 0xC858, 0xC859,
    0xC85A, 0xC85B, 0xC85C, 0xC85D, 0xC85E, 0xC85F, 0xC860, 0xC861,
    0xC862, 0xC863, 0xC864, 0xC865, 0xC866, 0xC867, 0xC868, 0xC869,
    0xC86A, 0xC86B, 0xC86C, 0xC86D, 0xC86E, 0xC86F, 0xC870, 0xC871,
    0xC872, 0xC873, 0xC874, 0xC875, 0xC876, 0xC877, 0xC878, 0xC879,
    0xC87A, 0xC87B, 0xC87C, 0xC87D, 0xC87E, 0xC880, 0xC881, 0xC882,
    0xC883, 0xC884, 0xC885, 0xC886, 0xC887, 0xC888, 0xC889, 0xC88A,
    0xC88B, 0xC88C, 0xC88D, 0xC88E, 0xC88F, 0xC890, 0xC891, 0xC892,
    0xC893, 0xC894, 0xC895, 0xC896, 0xC897, 0xC898, 0xC899, 0xC89A,
    0xC89B, 0xC89C, 0xC89D, 0xC89E, 0xC89F, 0xC8A0, 0xC940, 0xC941,
    0xC942, 0xC943, 0xC944, 0xC945, 0xC946, 0xC947, 0xC948, 0xC949,
    0xC94A, 0xC94B, 0xC94C, 0xC94D, 0xC94E, 0xC94F, 0xC950, 0xC951,
    0xC952, 0xC953, 0xC954, 0xC955, 0xC956, 0xC957, 0xC958, 0xC959,
    0xC95A, 0xC95B, 0xC95C, 0xC95D, 0xC95E, 0xC95F, 0xC960, 0xC961,
    0xC962, 0xC963, 0xC964, 0xC965, 0xC966, 0xC967, 0xC968, 0xC969,
    0xC96A, 0xC96B, 0xC96C, 0xC96D, 0xC96E, 0xC96F, 0xC970, 0xC971,
    0xC972, 0xC973, 0xC974, 0xC975, 0xC976, 0xC977, 0xC978, 0xC979,
    0xC97A, 0xC97B, 0xC97C, 0xC97D, 0xC97E, 0xC980, 0xC981, 0xC982,
    0xC983, 0xC984, 0xC985, 0xC986, 0xC987, 0xC988, 0xC989, 0xC98A,
    0xC98B, 0xC98C, 0xC98D, 0xC98E, 0xC98F, 0xC990, 0xC991, 0xC992,
    0xC993, 0xC994, 0xC995, 0xC996, 0xC997, 0xC998, 0xC999, 0xC99A,
    0xC99B, 0xC99C, 0xC99D, 0xC99E, 0xC99F, 0xC9A0, 0xCA40, 0xCA41,
    0xCA42, 0xCA43, 0xCA44, 0xCA45, 0xCA46, 0xCA47, 0xCA48, 0xCA49,
    0xCA4A, 0xCA4B, 0xCA4C, 0xCA4D, 0xCA4E, 0xCA4F, 0xCA50, 0xCA51,
    0xCA52, 0xCA53, 0xCA54, 0xCA55, 0xCA56, 0xCA57, 0xCA58, 0xCA59,
    0xCA5A, 0xCA5B, 0xCA5C, 0xCA5D, 0xCA5E, 0xCA5F, 0xCA60, 0xCA61,
    0xCA62, 0xCA63, 0xCA64, 0xCA65, 0xCA66, 0xCA67, 0xCA68, 0xCA69,
    0xCA6A, 0xCA6B, 0xCA6C, 0xCA6D, 0xCA6E, 0xCA6F, 0xCA70, 0xCA71,
    0xCA72, 0xCA73, 0xCA74, 0xCA75, 0xCA76, 0xCA77, 0xCA78, 0xCA79,
    0xCA7A, 0xCA7B, 0xCA7C, 0xCA7D, 0xCA7E, 0xCA80, 0xCA81, 0xCA82,
    0xCA83, 0xCA84, 0xCA85, 0xCA86, 0xCA87, 0xCA88, 0xCA89, 0xCA8A,
    0xCA8B, 0xCA8C, 0xCA8D, 0xCA8E, 0xCA8F, 0xCA90, 0xCA91, 0xCA92,
    0xCA93, 0xCA94, 0xCA95, 0xCA96, 0xCA97, 0xCA98, 0xCA99, 0xCA9A,
    0xCA9B, 0xCA9C, 0xCA9D, 0xCA9E, 0xCA9F, 0xCAA0, 0xCB40, 0xCB41,
    0xCB42, 0xCB43, 0xCB44, 0xCB45, 0xCB46, 0xCB47, 0xCB48, 0xCB49,
    0xCB4A, 0xCB4B, 0xCB4C, 0xCB4D, 0xCB4E, 0xCB4F, 0xCB50, 0xCB51,
    0xCB52, 0xCB53, 0xCB54, 0xCB55, 0xCB56, 0xCB57, 0xCB58, 0xCB59,
    0xCB5A, 0xCB5B, 0xCB5C, 0xCB5D, 0xCB5E, 0xCB5F, 0xCB60, 0xCB61,
    0xCB62, 0xCB63, 0xCB64, 0xCB65, 0xCB66, 0xCB67, 0xCB68, 0xCB69,
    0xCB6A, 0xCB6B, 0xCB6C, 0xCB6D, 0xCB6E, 0xCB6F, 0xCB70, 0xCB71,
    0xCB72, 0xCB73, 0xCB74, 0xCB75, 0xCB76, 0xCB77, 0xCB78, 0xCB79,
    0xCB7A, 0xCB7B, 0xCB7C, 0xCB7D, 0xCB7E, 0xCB80, 0xCB81, 0xCB82,
    0xCB83, 0xCB84, 0xCB85, 0xCB86, 0xCB87, 0xCB88, 0xCB89, 0xCB8A,
    0xCB8B, 0xCB8C, 0xCB8D, 0xCB8E, 0xCB8F, 0xCB90, 0xCB91, 0xCB92,
    0xCB93, 0xCB94, 0xCB95, 0xCB96, 0xCB97, 0xCB98, 0xCB99, 0xCB9A,
    0xCB9B, 0xCB9C, 0xCB9D, 0xCB9E, 0xCB9F, 0xCBA0, 0xCC40, 0xCC41,
    0xCC42, 0xCC43, 0xCC44, 0xCC45, 0xCC46, 0xCC47, 0xCC48, 0xCC49,
    0xCC4A, 0xCC4B, 0xCC4C, 0xCC4D, 0xCC4E, 0xCC4F, 0xCC50, 0xCC51,
    0xCC52, 0xCC53, 0xCC54, 0xCC55, 0xCC56, 0xCC57, 0xCC58, 0xCC59,
    0xCC5A, 0xCC5B, 0xCC5C, 0xCC5D, 0xCC5E, 0xCC5F, 0xCC60, 0xCC61,
    0xCC62, 0xCC63, 0xCC64, 0xCC65, 0xCC66, 0xCC67, 0xCC68, 0xCC69,
    0xCC6A, 0xCC6B, 0xCC6C, 0xCC6D, 0xCC6E, 0xCC6F, 0xCC70, 0xCC71,
    0xCC72, 0xCC73, 0xCC74, 0xCC75, 0xCC76, 0xCC77, 0xCC78, 0xCC79,
    0xCC7A, 0xCC7B, 0xCC7C, 0xCC7D, 0xCC7E, 0xCC80, 0xCC81, 0xCC82,
    0xCC83, 0xCC84, 0xCC85, 0xCC86, 0xCC87, 0xCC88, 0xCC89, 0xCC8A,
    0xCC8B, 0xCC8C, 0xCC8D, 0xCC8E, 0xCC8F, 0xCC90, 0xCC91, 0xCC92,
    0xCC93, 0xCC94, 0xCC95, 0xCC96, 0xCC97, 0xCC98, 0xCC99, 0xCC9A,
    0xCC9B, 0xCC9C, 0xCC9D, 0xCC9E, 0xCC9F, 0xCCA0, 0xCD40, 0xCD41,
    0xCD42, 0xCD43, 0xCD44, 0xCD45, 0xCD46, 0xCD47, 0xCD48, 0xCD49,
    0xCD4A, 0xCD4B, 0xCD4C, 0xCD4D, 0xCD4E, 0xCD4F, 0xCD50, 0xCD51,
    0xCD52, 0xCD53, 0xCD54, 0xCD55, 0xCD56, 0xCD57, 0xCD58, 0xCD59,
    0xCD5A, 0xCD5B, 0xCD5C, 0xCD5D, 0xCD5E, 0xCD5F, 0xCD60, 0xCD61,
    0xCD62, 0xCD63, 0xCD64, 0xCD65, 0xCD66, 0xCD67, 0xCD68, 0xCD69,
    0xCD6A, 0xCD6B, 0xCD6C, 0xCD6D, 0xCD6E, 0xCD6F, 0xCD70, 0xCD71,
    0xCD72, 0xCD73, 0xCD74, 0xCD75, 0xCD76, 0xCD77, 0xCD78, 0xCD79,
    0xCD7A, 0xCD7B, 0xCD7C, 0xCD7D, 0xCD7E, 0xCD80, 0xCD81, 0xCD82,
    0xCD83, 0xCD84, 0xCD85, 0xCD86, 0xCD87, 0xCD88, 0xCD89, 0xCD8A,
    0xCD8B, 0xCD8C, 0xCD8D, 0xCD8E, 0xCD8F, 0xCD90, 0xCD91, 0xCD92,
    0xCD93, 0xCD94, 0xCD95, 0xCD96, 0xCD97, 0xCD98, 0xCD99, 0xCD9A,
    0xCD9B, 0xCD9C, 0xCD9D, 0xCD9E, 0xCD9F, 0xCDA0, 0xCE40, 0xCE41,
    0xCE42, 0xCE43, 0xCE44, 0xCE45, 0xCE46, 0xCE47, 0xCE48, 0xCE49,
    0xCE4A, 0xCE4B, 0xCE4C, 0xCE4D, 0xCE4E, 0xCE4F, 0xCE50, 0xCE51,
    0xCE52, 0xCE53, 0xCE54, 0xCE55, 0xCE56, 0xCE57, 0xCE58, 0xCE59,
    0xCE5A, 0xCE5B, 0xCE5C, 0xCE5D, 0xCE5E, 0xCE5F, 0xCE60, 0xCE61,
    0xCE62, 0xCE63, 0xCE64, 0xCE65, 0xCE66, 0xCE67, 0xCE68, 0xCE69,
    0xCE6A, 0xCE6B, 0xCE6C, 0xCE6D, 0xCE6E, 0xCE6F, 0xCE70, 0xCE71,
    0xCE72, 0xCE73, 0xCE74, 0xCE75, 0xCE76, 0xCE77, 0xCE78, 0xCE79,
    0xCE7A, 0xCE7B, 0xCE7C, 0xCE7D, 0xCE7E, 0xCE80, 0xCE81, 0xCE82,
    0xCE83, 0xCE84, 0xCE85, 0xCE86, 0xCE87, 0xCE88, 0xCE89, 0xCE8A,
    0xCE8B, 0xCE8C, 0xCE8D, 0xCE8E, 0xCE8F, 0xCE90, 0xCE91, 0xCE92,
    0xCE93, 0xCE94, 0xCE95, 0xCE96, 0xCE97, 0xCE98, 0xCE99, 0xCE9A,
    0xCE9B, 0xCE9C, 0xCE9D, 0xCE9E, 0xCE9F, 0xCEA0, 0xCF40, 0xCF41,
    0xCF42, 0xCF43, 0xCF44, 0xCF45, 0xCF46, 0xCF47, 0xCF48, 0xCF49,
    0xCF4A, 0xCF4B, 0xCF4C, 0xCF4D, 0xCF4E, 0xCF4F, 0xCF50, 0xCF51,
    0xCF52, 0xCF53, 0xCF54, 0xCF55, 0xCF56, 0xCF57, 0xCF58, 0xCF59,
    0xCF5A, 0xCF5B, 0xCF5C, 0xCF5D, 0xCF5E, 0xCF5F, 0xCF60, 0xCF61,
    0xCF62, 0xCF63, 0xCF64, 0xCF65, 0xCF66, 0xCF67, 0xCF68, 0xCF69,
    0xCF6A, 0xCF6B, 0xCF6C, 0xCF6D, 0xCF6E, 0xCF6F, 0xCF70, 0xCF71,
    0xCF72, 0xCF73, 0xCF74, 0xCF75, 0xCF76, 0xCF77, 0xCF78, 0xCF79,
    0xCF7A, 0xCF7B, 0xCF7C, 0xCF7D, 0xCF7E, 0xCF80, 0xCF81, 0xCF82,
    0xCF83, 0xCF84, 0xCF85, 0xCF86, 0xCF87, 0xCF88, 0xCF89, 0xCF8A,
    0xCF8B, 0xCF8C, 0xCF8D, 0xCF8E, 0xCF8F, 0xCF90, 0xCF91, 0xCF92,
    0xCF93, 0xCF94, 0xCF95, 0xCF96, 0xCF97, 0xCF98, 0xCF99, 0xCF9A,
    0xCF9B, 0xCF9C, 0xCF9D, 0xCF9E, 0xCF9F, 0xCFA0, 0xD040, 0xD041,
    0xD042, 0xD043, 0xD044, 0xD045, 0xD046, 0xD047, 0xD048, 0xD049,
    0xD04A, 0xD04B, 0xD04C, 0xD04D, 0xD04E, 0xD04F, 0xD050, 0xD051,
    0xD052, 0xD053, 0xD054, 0xD055, 0xD056, 0xD057, 0xD058, 0xD059,
    0xD05A, 0xD05B, 0xD05C, 0xD05D, 0xD05E, 0xD05F, 0xD060, 0xD061,
    0xD062, 0xD063, 0xD064, 0xD065, 0xD066, 0xD067, 0xD068, 0xD069,
    0xD06A, 0xD06B, 0xD06C, 0xD06D, 0xD06E, 0xD06F, 0xD070, 0xD071,
    0xD072, 0xD073, 0xD074, 0xD075, 0xD076, 0xD077, 0xD078, 0xD079,
    0xD07A, 0xD07B, 0xD07C, 0xD07D, 0xD07E, 0xD080, 0xD081, 0xD082,
    0xD083, 0xD084, 0xD085, 0xD086, 0xD087, 0xD088, 0xD089, 0xD08A,
    0xD08B, 0xD08C, 0xD08D, 0xD08E, 0xD08F, 0xD090, 0xD091, 0xD092,
    0xD093, 0xD094, 0xD095, 0xD096, 0xD097, 0xD098, 0xD099, 0xD09A,
    0xD09B, 0xD09C, 0xD09D, 0xD09E, 0xD09F, 0xD0A0, 0xD140, 0xD141,
    0xD142, 0xD143, 0xD144, 0xD145, 0xD146, 0xD147, 0xD148, 0xD149,
    0xD14A, 0xD14B, 0xD14C, 0xD14D, 0xD14E, 0xD14F, 0xD150, 0xD151,
    0xD152, 0xD153, 0xD154, 0xD155, 0xD156, 0xD157, 0xD158, 0xD159,
    0xD15A, 0xD15B, 0xD15C, 0xD15D, 0xD15E, 0xD15F, 0xD160, 0xD161,
    0xD162, 0xD163, 0xD164, 0xD165, 0xD166, 0xD167, 0xD168, 0xD169,
    0xD16A, 0xD16B, 0xD16C, 0xD16D, 0xD16E, 0xD16F, 0xD170, 0xD171,
    0xD172, 0xD173, 0xD174, 0xD175, 0xD176, 0xD177, 0xD178, 0xD179,
    0xD17A, 0xD17B, 0xD17C, 0xD17D, 0xD17E, 0xD180, 0xD181, 0xD182,
    0xD183, 0xD184, 0xD185, 0xD186, 0xD187, 0xD188, 0xD189, 0xD18A,
    0xD18B, 0xD18C, 0xD18D, 0xD18E, 0xD18F, 0xD190, 0xD191, 0xD192,
    0xD193, 0xD194, 0xD195, 0xD196, 0xD197, 0xD198, 0xD199, 0xD19A,
    0xD19B, 0xD19C, 0xD19D, 0xD19E, 0xD19F, 0xD1A0, 0xD240, 0xD241,
    0xD242, 0xD243, 0xD244, 0xD245, 0xD246, 0xD247, 0xD248, 0xD249,
    0xD24A, 0xD24B, 0xD24C, 0xD24D, 0xD24E, 0xD24F, 0xD250, 0xD251,
    0xD252, 0xD253, 0xD254, 0xD255, 0xD256, 0xD257, 0xD258, 0xD259,
    0xD25A, 0xD25B, 0xD25C, 0xD25D, 0xD25E, 0xD25F, 0xD260, 0xD261,
    0xD262, 0xD263, 0xD264, 0xD265, 0xD266, 0xD267, 0xD268, 0xD269,
    0xD26A, 0xD26B, 0xD26C, 0xD26D, 0xD26E, 0xD26F, 0xD270, 0xD271,
    0xD272, 0xD273, 0xD274, 0xD275, 0xD276, 0xD277, 0xD278, 0xD279,
    0xD27A, 0xD27B, 0xD27C, 0xD27D, 0xD27E, 0xD280, 0xD281, 0xD282,
    0xD283, 0xD284, 0xD285, 0xD286, 0xD287, 0xD288, 0xD289, 0xD28A,
    0xD28B, 0xD28C, 0xD28D, 0xD28E, 0xD28F, 0xD290, 0xD291, 0xD292,
    0xD293, 0xD294, 0xD295, 0xD296, 0xD297, 0xD298, 0xD299, 0xD29A,
    0xD29B, 0xD29C, 0xD29D, 0xD29E, 0xD29F, 0xD2A0, 0xD340, 0xD341,
    0xD342, 0xD343, 0xD344, 0xD345, 0xD346, 0xD347, 0xD348, 0xD349,
    0xD34A, 0xD34B, 0xD34C, 0xD34D, 0xD34E, 0xD34F, 0xD350, 0xD351,
    0xD352, 0xD353, 0xD354, 0xD355, 0xD356, 0xD357, 0xD358, 0xD359,
    0xD35A, 0xD35B, 0xD35C, 0xD35D, 0xD35E, 0xD35F, 0xD360, 0xD361,
    0xD362, 0xD363, 0xD364, 0xD365, 0xD366, 0xD367, 0xD368, 0xD369,
    0xD36A, 0xD36B, 0xD36C, 0xD36D, 0xD36E, 0xD36F, 0xD370, 0xD371,
    0xD372, 0xD373, 0xD374, 0xD375, 0xD376, 0xD377, 0xD378, 0xD379,
    0xD37A, 0xD37B, 0xD37C, 0xD37D, 0xD37E, 0xD380, 0xD381, 0xD382,
    0xD383, 0xD384, 0xD385, 0xD386, 0xD387, 0xD388, 0xD389, 0xD38A,
    0xD38B, 0xD38C, 0xD38D, 0xD38E, 0xD38F, 0xD390, 0xD391, 0xD392,
    0xD393, 0xD394, 0xD395, 0xD396, 0xD397, 0xD398, 0xD399, 0xD39A,
    0xD39B, 0xD39C, 0xD39D, 0xD39E, 0xD39F, 0xD3A0, 0xD440, 0xD441,
    0xD442, 0xD443, 0xD444, 0xD445, 0xD446, 0xD447, 0xD448, 0xD449,
    0xD44A, 0xD44B, 0xD44C, 0xD44D, 0xD44E, 0xD44F, 0xD450, 0xD451,
    0xD452, 0xD453, 0xD454, 0xD455, 0xD456, 0xD457, 0xD458, 0xD459,
    0xD45A, 0xD45B, 0xD45C, 0xD45D, 0xD45E, 0xD45F, 0xD460, 0xD461,
    0xD462, 0xD463, 0xD464, 0xD465, 0xD466, 0xD467, 0xD468, 0xD469,
    0xD46A, 0xD46B, 0xD46C, 0xD46D, 0xD46E, 0xD46F, 0xD470, 0xD471,
    0xD472, 0xD473, 0xD474, 0xD475, 0xD476, 0xD477, 0xD478, 0xD479,
    0xD47A, 0xD47B, 0xD47C, 0xD47D, 0xD47E, 0xD480, 0xD481, 0xD482,
    0xD483, 0xD484, 0xD485, 0xD486, 0xD487, 0xD488, 0xD489, 0xD48A,
    0xD48B, 0xD48C, 0xD48D, 0xD48E, 0xD48F, 0xD490, 0xD491, 0xD492,
    0xD493, 0xD494, 0xD495, 0xD496, 0xD497, 0xD498, 0xD499, 0xD49A,
    0xD49B, 0xD49C, 0xD49D, 0xD49E, 0xD49F, 0xD4A0, 0xD540, 0xD541,
    0xD542, 0xD543, 0xD544, 0xD545, 0xD546, 0xD547, 0xD548, 0xD549,
    0xD54A, 0xD54B, 0xD54C, 0xD54D, 0xD54E, 0xD54F, 0xD550, 0xD551,
    0xD552, 0xD553, 0xD554, 0xD555, 0xD556, 0xD557, 0xD558, 0xD559,
    0xD55A, 0xD55B, 0xD55C, 0xD55D, 0xD55E, 0xD55F, 0xD560, 0xD561,
    0xD562, 0xD563, 0xD564, 0xD565, 0xD566, 0xD567, 0xD568, 0xD569,
    0xD56A, 0xD56B, 0xD56C, 0xD56D, 0xD56E, 0xD56F, 0xD570, 0xD571,
    0xD572, 0xD573, 0xD574, 0xD575, 0xD576, 0xD577, 0xD578, 0xD579,
    0xD57A, 0xD57B, 0xD57C, 0xD57D, 0xD57E, 0xD580, 0xD581, 0xD582,
    0xD583, 0xD584, 0xD585, 0xD586, 0xD587, 0xD588, 0xD589, 0xD58A,
    0xD58B, 0xD58C, 0xD58D, 0xD58E, 0xD58F, 0xD590, 0xD591, 0xD592,
    0xD593, 0xD594, 0xD595, 0xD596, 0xD597, 0xD598, 0xD599, 0xD59A,
    0xD59B, 0xD59C, 0xD59D, 0xD59E, 0xD59F, 0xD5A0, 0xD640, 0xD641,
    0xD642, 0xD643, 0xD644, 0xD645, 0xD646, 0xD647, 0xD648, 0xD649,
    0xD64A, 0xD64B, 0xD64C, 0xD64D, 0xD64E, 0xD64F, 0xD650, 0xD651,
    0xD652, 0xD653, 0xD654, 0xD655, 0xD656, 0xD657, 0xD658, 0xD659,
    0xD65A, 0xD65B, 0xD65C, 0xD65D, 0xD65E, 0xD65F, 0xD660, 0xD661,
    0xD662, 0xD663, 0xD664, 0xD665, 0xD666, 0xD667, 0xD668, 0xD669,
    0xD66A, 0xD66B, 0xD66C, 0xD66D, 0xD66E, 0xD66F, 0xD670, 0xD671,
    0xD672, 0xD673, 0xD674, 0xD675, 0xD676, 0xD677, 0xD678, 0xD679,
    0xD67A, 0xD67B, 0xD67C, 0xD67D, 0xD67E, 0xD680, 0xD681, 0xD682,
    0xD683, 0xD684, 0xD685, 0xD686, 0xD687, 0xD688, 0xD689, 0xD68A,
    0xD68B, 0xD68C, 0xD68D, 0xD68E, 0xD68F, 0xD690, 0xD691, 0xD692,
    0xD693, 0xD694, 0xD695, 0xD696, 0xD697, 0xD698, 0xD699, 0xD69A,
    0xD69B, 0xD69C, 0xD69D, 0xD69E, 0xD69F, 0xD6A0, 0xD740, 0xD741,
    0xD742, 0xD743, 0xD744, 0xD745, 0xD746, 0xD747, 0xD748, 0xD749,
    0xD74A, 0xD74B, 0xD74C, 0xD74D, 0xD74E, 0xD74F, 0xD750, 0xD751,
    0xD752, 0xD753, 0xD754, 0xD755, 0xD756, 0xD757, 0xD758, 0xD759,
    0xD75A, 0xD75B, 0xD75C, 0xD75D, 0xD75E, 0xD75F, 0xD760, 0xD761,
    0xD762, 0xD763, 0xD764, 0xD765, 0xD766, 0xD767, 0xD768, 0xD769,
    0xD76A, 0xD76B, 0xD76C, 0xD76D, 0xD76E, 0xD76F, 0xD770, 0xD771,
    0xD772, 0xD773, 0xD774, 0xD775, 0xD776, 0xD777, 0xD778, 0xD779,
    0xD77A, 0xD77B, 0xD77C, 0xD77D, 0xD77E, 0xD780, 0xD781, 0xD782,
    0xD783, 0xD784, 0xD785, 0xD786, 0xD787, 0xD788, 0xD789, 0xD78A,
    0xD78B, 0xD78C, 0xD78D, 0xD78E, 0xD78F, 0xD790, 0xD791, 0xD792,
    0xD793, 0xD794, 0xD795, 0xD796, 0xD797, 0xD798, 0xD799, 0xD79A,
    0xD79B, 0xD79C, 0xD79D, 0xD79E, 0xD79F, 0xD7A0, 0xD840, 0xD841,
    0xD842, 0xD843, 0xD844, 0xD845, 0xD846, 0xD847, 0xD848, 0xD849,
    0xD84A, 0xD84B, 0xD84C, 0xD84D, 0xD84E, 0xD84F, 0xD850, 0xD851,
    0xD852, 0xD853, 0xD854, 0xD855, 0xD856, 0xD857, 0xD858, 0xD859,
    0xD85A, 0xD85B, 0xD85C, 0xD85D, 0xD85E, 0xD85F, 0xD860, 0xD861,
    0xD862, 0xD863, 0xD864, 0xD865, 0xD866, 0xD867, 0xD868, 0xD869,
    0xD86A, 0xD86B, 0xD86C, 0xD86D, 0xD86E, 0xD86F, 0xD870, 0xD871,
    0xD872, 0xD873, 0xD874, 0xD875, 0xD876, 0xD877, 0xD878, 0xD879,
    0xD87A, 0xD87B, 0xD87C, 0xD87D, 0xD87E, 0xD880, 0xD881, 0xD882,
    0xD883, 0xD884, 0xD885, 0xD886, 0xD887, 0xD888, 0xD889, 0xD88A,
    0xD88B, 0xD88C, 0xD88D, 0xD88E, 0xD88F, 0xD890, 0xD891, 0xD892,
    0xD893, 0xD894, 0xD895, 0xD896, 0xD897, 0xD898, 0xD899, 0xD89A,
    0xD89B, 0xD89C, 0xD89D, 0xD89E, 0xD89F, 0xD8A0, 0xD940, 0xD941,
    0xD942, 0xD943, 0xD944, 0xD945, 0xD946, 0xD947, 0xD948, 0xD949,
    0xD94A, 0xD94B, 0xD94C, 0xD94D, 0xD94E, 0xD94F, 0xD950, 0xD951,
    0xD952, 0xD953, 0xD954, 0xD955, 0xD956, 0xD957, 0xD958, 0xD959,
    0xD95A, 0xD95B, 0xD95C, 0xD95D, 0xD95E, 0xD95F, 0xD960, 0xD961,
    0xD962, 0xD963, 0xD964, 0xD965, 0xD966, 0xD967, 0xD968, 0xD969,
    0xD96A, 0xD96B, 0xD96C, 0xD96D, 0xD96E, 0xD96F, 0xD970, 0xD971,
    0xD972, 0xD973, 0xD974, 0xD975, 0xD976, 0xD977, 0xD978, 0xD979,
    0xD97A, 0xD97B, 0xD97C, 0xD97D, 0xD97E, 0xD980, 0xD981, 0xD982,
    0xD983, 0xD984, 0xD985, 0xD986, 0xD987, 0xD988, 0xD989, 0xD98A,
    0xD98B, 0xD98C, 0xD98D, 0xD98E, 0xD98F, 0xD990, 0xD991, 0xD992,
    0xD993, 0xD994, 0xD995, 0xD996, 0xD997, 0xD998, 0xD999, 0xD99A,
    0xD99B, 0xD99C, 0xD99D, 0xD99E, 0xD99F, 0xD9A0, 0xDA40, 0xDA41,
    0xDA42, 0xDA43, 0xDA44, 0xDA45, 0xDA46, 0xDA47, 0xDA48, 0xDA49,
    0xDA4A, 0xDA4B, 0xDA4C, 0xDA4D, 0xDA4E, 0xDA4F, 0xDA50, 0xDA51,
    0xDA52, 0xDA53, 0xDA54, 0xDA55, 0xDA56, 0xDA57, 0xDA58, 0xDA59,
    0xDA5A, 0xDA5B, 0xDA5C, 0xDA5D, 0xDA5E, 0xDA5F, 0xDA60, 0xDA61,
    0xDA62, 0xDA63, 0xDA64, 0xDA65, 0xDA66, 0xDA67, 0xDA68, 0xDA69,
    0xDA6A, 0xDA6B, 0xDA6C, 0xDA6D, 0xDA6E, 0xDA6F, 0xDA70, 0xDA71,
    0xDA72, 0xDA73, 0xDA74, 0xDA75, 0xDA76, 0xDA77, 0xDA78, 0xDA79,
    0xDA7A, 0xDA7B, 0xDA7C, 0xDA7D, 0xDA7E, 0xDA80, 0xDA81, 0xDA82,
    0xDA83, 0xDA84, 0xDA85, 0xDA86, 0xDA87, 0xDA88, 0xDA89, 0xDA8A,
    0xDA8B, 0xDA8C, 0xDA8D, 0xDA8E, 0xDA8F, 0xDA90, 0xDA91, 0xDA92,
    0xDA93, 0xDA94, 0xDA95, 0xDA96, 0xDA97, 0xDA98, 0xDA99, 0xDA9A,
    0xDA9B, 0xDA9C, 0xDA9D, 0xDA9E, 0xDA9F, 0xDAA0, 0xDB40, 0xDB41,
    0xDB42, 0xDB43, 0xDB44, 0xDB45, 0xDB46, 0xDB47, 0xDB48, 0xDB49,
    0xDB4A, 0xDB4B, 0xDB4C, 0xDB4D, 0xDB4E, 0xDB4F, 0xDB50, 0xDB51,
    0xDB52, 0xDB53, 0xDB54, 0xDB55, 0xDB56, 0xDB57, 0xDB58, 0xDB59,
    0xDB5A, 0xDB5B, 0xDB5C, 0xDB5D, 0xDB5E, 0xDB5F, 0xDB60, 0xDB61,
    0xDB62, 0xDB63, 0xDB64, 0xDB65, 0xDB66, 0xDB67, 0xDB68, 0xDB69,
    0xDB6A, 0xDB6B, 0xDB6C, 0xDB6D, 0xDB6E, 0xDB6F, 0xDB70, 0xDB71,
    0xDB72, 0xDB73, 0xDB74, 0xDB75, 0xDB76, 0xDB77, 0xDB78, 0xDB79,
    0xDB7A, 0xDB7B, 0xDB7C, 0xDB7D, 0xDB7E, 0xDB80, 0xDB81, 0xDB82,
    0xDB83, 0xDB84, 0xDB85, 0xDB86, 0xDB87, 0xDB88, 0xDB89, 0xDB8A,
    0xDB8B, 0xDB8C, 0xDB8D, 0xDB8E, 0xDB8F, 0xDB90, 0xDB91, 0xDB92,
    0xDB93, 0xDB94, 0xDB95, 0xDB96, 0xDB97, 0xDB98, 0xDB99, 0xDB9A,
    0xDB9B, 0xDB9C, 0xDB9D, 0xDB9E, 0xDB9F, 0xDBA0, 0xDC40, 0xDC41,
    0xDC42, 0xDC43, 0xDC44, 0xDC45, 0xDC46, 0xDC47, 0xDC48, 0xDC49,
    0xDC4A, 0xDC4B, 0xDC4C, 0xDC4D, 0xDC4E, 0xDC4F, 0xDC50, 0xDC51,
    0xDC52, 0xDC53, 0xDC54, 0xDC55, 0xDC56, 0xDC57, 0xDC58, 0xDC59,
    0xDC5A, 0xDC5B, 0xDC5C, 0xDC5D, 0xDC5E, 0xDC5F, 0xDC60, 0xDC61,
    0xDC62, 0xDC63, 0xDC64, 0xDC65, 0xDC66, 0xDC67, 0xDC68, 0xDC69,
    0xDC6A, 0xDC6B, 0xDC6C, 0xDC6D, 0xDC6E, 0xDC6F, 0xDC70, 0xDC71,
    0xDC72, 0xDC73, 0xDC74, 0xDC75, 0xDC76, 0xDC77, 0xDC78, 0xDC79,
    0xDC7A, 0xDC7B, 0xDC7C, 0xDC7D, 0xDC7E, 0xDC80, 0xDC81, 0xDC82,
    0xDC83, 0xDC84, 0xDC85, 0xDC86, 0xDC87, 0xDC88, 0xDC89, 0xDC8A,
    0xDC8B, 0xDC8C, 0xDC8D, 0xDC8E, 0xDC8F, 0xDC90, 0xDC91, 0xDC92,
    0xDC93, 0xDC94, 0xDC95, 0xDC96, 0xDC97, 0xDC98, 0xDC99, 0xDC9A,
    0xDC9B, 0xDC9C, 0xDC9D, 0xDC9E, 0xDC9F, 0xDCA0, 0xDD40, 0xDD41,
    0xDD42, 0xDD43, 0xDD44, 0xDD45, 0xDD46, 0xDD47, 0xDD48, 0xDD49,
    0xDD4A, 0xDD4B, 0xDD4C, 0xDD4D, 0xDD4E, 0xDD4F, 0xDD50, 0xDD51,
    0xDD52, 0xDD53, 0xDD54, 0xDD55, 0xDD56, 0xDD57, 0xDD58, 0xDD59,
    0xDD5A, 0xDD5B, 0xDD5C, 0xDD5D, 0xDD5E, 0xDD5F, 0xDD60, 0xDD61,
    0xDD62, 0xDD63, 0xDD64, 0xDD65, 0xDD66, 0xDD67, 0xDD68, 0xDD69,
    0xDD6A, 0xDD6B, 0xDD6C, 0xDD6D, 0xDD6E, 0xDD6F, 0xDD70, 0xDD71,
    0xDD72, 0xDD73, 0xDD74, 0xDD75, 0xDD76, 0xDD77, 0xDD78, 0xDD79,
    0xDD7A, 0xDD7B, 0xDD7C, 0xDD7D, 0xDD7E, 0xDD80, 0xDD81, 0xDD82,
    0xDD83, 0xDD84, 0xDD85, 0xDD86, 0xDD87, 0xDD88, 0xDD89, 0xDD8A,
    0xDD8B, 0xDD8C, 0xDD8D, 0xDD8E, 0xDD8F, 0xDD90, 0xDD91, 0xDD92,
    0xDD93, 0xDD94, 0xDD95, 0xDD96, 0xDD97, 0xDD98, 0xDD99, 0xDD9A,
    0xDD9B, 0xDD9C, 0xDD9D, 0xDD9E, 0xDD9F, 0xDDA0, 0xDE40, 0xDE41,
    0xDE42, 0xDE43, 0xDE44, 0xDE45, 0xDE46, 0xDE47, 0xDE48, 0xDE49,
    0xDE4A, 0xDE4B, 0xDE4C, 0xDE4D, 0xDE4E, 0xDE4F, 0xDE50, 0xDE51,
    0xDE52, 0xDE53, 0xDE54, 0xDE55, 0xDE56, 0xDE57, 0xDE58, 0xDE59,
    0xDE5A, 0xDE5B, 0xDE5C, 0xDE5D, 0xDE5E, 0xDE5F, 0xDE60, 0xDE61,
    0xDE62, 0xDE63, 0xDE64, 0xDE65, 0xDE66, 0xDE67, 0xDE68, 0xDE69,
    0xDE6A, 0xDE6B, 0xDE6C, 0xDE6D, 0xDE6E, 0xDE6F, 0xDE70, 0xDE71,
    0xDE72, 0xDE73, 0xDE74, 0xDE75, 0xDE76, 0xDE77, 0xDE78, 0xDE79,
    0xDE7A, 0xDE7B, 0xDE7C, 0xDE7D, 0xDE7E, 0xDE80, 0xDE81, 0xDE82,
    0xDE83, 0xDE84, 0xDE85, 0xDE86, 0xDE87, 0xDE88, 0xDE89, 0xDE8A,
    0xDE8B, 0xDE8C, 0xDE8D, 0xDE8E, 0xDE8F, 0xDE90, 0xDE91, 0xDE92,
    0xDE93, 0xDE94, 0xDE95, 0xDE96, 0xDE97, 0xDE98, 0xDE99, 0xDE9A,
    0xDE9B, 0xDE9C, 0xDE9D, 0xDE9E, 0xDE9F, 0xDEA0, 0xDF40, 0xDF41,
    0xDF42, 0xDF43, 0xDF44, 0xDF45, 0xDF46, 0xDF47, 0xDF48, 0xDF49,
    0xDF4A, 0xDF4B, 0xDF4C, 0xDF4D, 0xDF4E, 0xDF4F, 0xDF50, 0xDF51,
    0xDF52, 0xDF53, 0xDF54, 0xDF55, 0xDF56, 0xDF57, 0xDF58, 0xDF59,
    0xDF5A, 0xDF5B, 0xDF5C, 0xDF5D, 0xDF5E, 0xDF5F, 0xDF60, 0xDF61,
    0xDF62, 0xDF63, 0xDF64, 0xDF65, 0xDF66, 0xDF67, 0xDF68, 0xDF69,
    0xDF6A, 0xDF6B, 0xDF6C, 0xDF6D, 0xDF6E, 0xDF6F, 0xDF70, 0xDF71,
    0xDF72, 0xDF73, 0xDF74, 0xDF75, 0xDF76, 0xDF77, 0xDF78, 0xDF79,
    0xDF7A, 0xDF7B, 0xDF7C, 0xDF7D, 0xDF7E, 0xDF80, 0xDF81, 0xDF82,
    0xDF83, 0xDF84, 0xDF85, 0xDF86, 0xDF87, 0xDF88, 0xDF89, 0xDF8A,
    0xDF8B, 0xDF8C, 0xDF8D, 0xDF8E, 0xDF8F, 0xDF90, 0xDF91, 0xDF92,
    0xDF93, 0xDF94, 0xDF95, 0xDF96, 0xDF97, 0xDF98, 0xDF99, 0xDF9A,
    0xDF9B, 0xDF9C, 0xDF9D, 0xDF9E, 0xDF9F, 0xDFA0, 0xE040, 0xE041,
    0xE042, 0xE043, 0xE044, 0xE045, 0xE046, 0xE047, 0xE048, 0xE049,
    0xE04A, 0xE04B, 0xE04C, 0xE04D, 0xE04E, 0xE04F, 0xE050, 0xE051,
    0xE052, 0xE053, 0xE054, 0xE055, 0xE056, 0xE057, 0xE058, 0xE059,
    0xE05A, 0xE05B, 0xE05C, 0xE05D, 0xE05E, 0xE05F, 0xE060, 0xE061,
    0xE062, 0xE063, 0xE064, 0xE065, 0xE066, 0xE067, 0xE068, 0xE069,
    0xE06A, 0xE06B, 0xE06C, 0xE06D, 0xE06E, 0xE06F, 0xE070, 0xE071,
    0xE072, 0xE073, 0xE074, 0xE075, 0xE076, 0xE077, 0xE078, 0xE079,
    0xE07A, 0xE07B, 0xE07C, 0xE07D, 0xE07E, 0xE080, 0xE081, 0xE082,
    0xE083, 0xE084, 0xE085, 0xE086, 0xE087, 0xE088, 0xE089, 0xE08A,
    0xE08B, 0xE08C, 0xE08D, 0xE08E, 0xE08F, 0xE090, 0xE091, 0xE092,
    0xE093, 0xE094, 0xE095, 0xE096, 0xE097, 0xE098, 0xE099, 0xE09A,
    0xE09B, 0xE09C, 0xE09D, 0xE09E, 0xE09F, 0xE0A0, 0xE140, 0xE141,
    0xE142, 0xE143, 0xE144, 0xE145, 0xE146, 0xE147, 0xE148, 0xE149,
    0xE14A, 0xE14B, 0xE14C, 0xE14D, 0xE14E, 0xE14F, 0xE150, 0xE151,
    0xE152, 0xE153, 0xE154, 0xE155, 0xE156, 0xE157, 0xE158, 0xE159,
    0xE15A, 0xE15B, 0xE15C, 0xE15D, 0xE15E, 0xE15F, 0xE160, 0xE161,
    0xE162, 0xE163, 0xE164, 0xE165, 0xE166, 0xE167, 0xE168, 0xE169,
    0xE16A, 0xE16B, 0xE16C, 0xE16D, 0xE16E, 0xE16F, 0xE170, 0xE171,
    0xE172, 0xE173, 0xE174, 0xE175, 0xE176, 0xE177, 0xE178, 0xE179,
    0xE17A, 0xE17B, 0xE17C, 0xE17D, 0xE17E, 0xE180, 0xE181, 0xE182,
    0xE183, 0xE184, 0xE185, 0xE186, 0xE187, 0xE188, 0xE189, 0xE18A,
    0xE18B, 0xE18C, 0xE18D, 0xE18E, 0xE18F, 0xE190, 0xE191, 0xE192,
    0xE193, 0xE194, 0xE195, 0xE196, 0xE197, 0xE198, 0xE199, 0xE19A,
    0xE19B, 0xE19C, 0xE19D, 0xE19E, 0xE19F, 0xE1A0, 0xE240, 0xE241,
    0xE242, 0xE243, 0xE244, 0xE245, 0xE246, 0xE247, 0xE248, 0xE249,
    0xE24A, 0xE24B, 0xE24C, 0xE24D, 0xE24E, 0xE24F, 0xE250, 0xE251,
    0xE252, 0xE253, 0xE254, 0xE255, 0xE256, 0xE257, 0xE258, 0xE259,
    0xE25A, 0xE25B, 0xE25C, 0xE25D, 0xE25E, 0xE25F, 0xE260, 0xE261,
    0xE262, 0xE263, 0xE264, 0xE265, 0xE266, 0xE267, 0xE268, 0xE269,
    0xE26A, 0xE26B, 0xE26C, 0xE26D, 0xE26E, 0xE26F, 0xE270, 0xE271,
    0xE272, 0xE273, 0xE274, 0xE275, 0xE276, 0xE277, 0xE278, 0xE279,
    0xE27A, 0xE27B, 0xE27C, 0xE27D, 0xE27E, 0xE280, 0xE281, 0xE282,
    0xE283, 0xE284, 0xE285, 0xE286, 0xE287, 0xE288, 0xE289, 0xE28A,
    0xE28B, 0xE28C, 0xE28D, 0xE28E, 0xE28F, 0xE290, 0xE291, 0xE292,
    0xE293, 0xE294, 0xE295, 0xE296, 0xE297, 0xE298, 0xE299, 0xE29A,
    0xE29B, 0xE29C, 0xE29D, 0xE29E, 0xE29F, 0xE2A0, 0xE340, 0xE341,
    0xE342, 0xE343, 0xE344, 0xE345, 0xE346, 0xE347, 0xE348, 0xE349,
    0xE34A, 0xE34B, 0xE34C, 0xE34D, 0xE34E, 0xE34F, 0xE350, 0xE351,
    0xE352, 0xE353, 0xE354, 0xE355, 0xE356, 0xE357, 0xE358, 0xE359,
    0xE35A, 0xE35B, 0xE35C, 0xE35D, 0xE35E, 0xE35F, 0xE360, 0xE361,
    0xE362, 0xE363, 0xE364, 0xE365, 0xE366, 0xE367, 0xE368, 0xE369,
    0xE36A, 0xE36B, 0xE36C, 0xE36D, 0xE36E, 0xE36F, 0xE370, 0xE371,
    0xE372, 0xE373, 0xE374, 0xE375, 0xE376, 0xE377, 0xE378, 0xE379,
    0xE37A, 0xE37B, 0xE37C, 0xE37D, 0xE37E, 0xE380, 0xE381, 0xE382,
    0xE383, 0xE384, 0xE385, 0xE386, 0xE387, 0xE388, 0xE389, 0xE38A,
    0xE38B, 0xE38C, 0xE38D, 0xE38E, 0xE38F, 0xE390, 0xE391, 0xE392,
    0xE393, 0xE394, 0xE395, 0xE396, 0xE397, 0xE398, 0xE399, 0xE39A,
    0xE39B, 0xE39C, 0xE39D, 0xE39E, 0xE39F, 0xE3A0, 0xE440, 0xE441,
    0xE442, 0xE443, 0xE444, 0xE445, 0xE446, 0xE447, 0xE448, 0xE449,
    0xE44A, 0xE44B, 0xE44C, 0xE44D, 0xE44E, 0xE44F, 0xE450, 0xE451,
    0xE452, 0xE453, 0xE454, 0xE455, 0xE456, 0xE457, 0xE458, 0xE459,
    0xE45A, 0xE45B, 0xE45C, 0xE45D, 0xE45E, 0xE45F, 0xE460, 0xE461,
    0xE462, 0xE463, 0xE464, 0xE465, 0xE466, 0xE467, 0xE468, 0xE469,
    0xE46A, 0xE46B, 0xE46C, 0xE46D, 0xE46E, 0xE46F, 0xE470, 0xE471,
    0xE472, 0xE473, 0xE474, 0xE475, 0xE476, 0xE477, 0xE478, 0xE479,
    0xE47A, 0xE47B, 0xE47C, 0xE47D, 0xE47E, 0xE480, 0xE481, 0xE482,
    0xE483, 0xE484, 0xE485, 0xE486, 0xE487, 0xE488, 0xE489, 0xE48A,
    0xE48B, 0xE48C, 0xE48D, 0xE48E, 0xE48F, 0xE490, 0xE491, 0xE492,
    0xE493, 0xE494, 0xE495, 0xE496, 0xE497, 0xE498, 0xE499, 0xE49A,
    0xE49B, 0xE49C, 0xE49D, 0xE49E, 0xE49F, 0xE4A0, 0xE540, 0xE541,
    0xE542, 0xE543, 0xE544, 0xE545, 0xE546, 0xE547, 0xE548, 0xE549,
    0xE54A, 0xE54B, 0xE54C, 0xE54D, 0xE54E, 0xE54F, 0xE550, 0xE551,
    0xE552, 0xE553, 0xE554, 0xE555, 0xE556, 0xE557, 0xE558, 0xE559,
    0xE55A, 0xE55B, 0xE55C, 0xE55D, 0xE55E, 0xE55F, 0xE560, 0xE561,
    0xE562, 0xE563, 0xE564, 0xE565, 0xE566, 0xE567, 0xE568, 0xE569,
    0xE56A, 0xE56B, 0xE56C, 0xE56D, 0xE56E, 0xE56F, 0xE570, 0xE571,
    0xE572, 0xE573, 0xE574, 0xE575, 0xE576, 0xE577, 0xE578, 0xE579,
    0xE57A, 0xE57B, 0xE57C, 0xE57D, 0xE57E, 0xE580, 0xE581, 0xE582,
    0xE583, 0xE584, 0xE585, 0xE586, 0xE587, 0xE588, 0xE589, 0xE58A,
    0xE58B, 0xE58C, 0xE58D, 0xE58E, 0xE58F, 0xE590, 0xE591, 0xE592,
    0xE593, 0xE594, 0xE595, 0xE596, 0xE597, 0xE598, 0xE599, 0xE59A,
    0xE59B, 0xE59C, 0xE59D, 0xE59E, 0xE59F, 0xE5A0, 0xE640, 0xE641,
    0xE642, 0xE643, 0xE644, 0xE645, 0xE646, 0xE647, 0xE648, 0xE649,
    0xE64A, 0xE64B, 0xE64C, 0xE64D, 0xE64E, 0xE64F, 0xE650, 0xE651,
    0xE652, 0xE653, 0xE654, 0xE655, 0xE656, 0xE657, 0xE658, 0xE659,
    0xE65A, 0xE65B, 0xE65C, 0xE65D, 0xE65E, 0xE65F, 0xE660, 0xE661,
    0xE662, 0xE663, 0xE664, 0xE665, 0xE666, 0xE667, 0xE668, 0xE669,
    0xE66A, 0xE66B, 0xE66C, 0xE66D, 0xE66E, 0xE66F, 0xE670, 0xE671,
    0xE672, 0xE673, 0xE674, 0xE675, 0xE676, 0xE677, 0xE678, 0xE679,
    0xE67A, 0xE67B, 0xE67C, 0xE67D, 0xE67E, 0xE680, 0xE681, 0xE682,
    0xE683, 0xE684, 0xE685, 0xE686, 0xE687, 0xE688, 0xE689, 0xE68A,
    0xE68B, 0xE68C, 0xE68D, 0xE68E, 0xE68F, 0xE690, 0xE691, 0xE692,
    0xE693, 0xE694, 0xE695, 0xE696, 0xE697, 0xE698, 0xE699, 0xE69A,
    0xE69B, 0xE69C, 0xE69D, 0xE69E, 0xE69F, 0xE6A0, 0xE740, 0xE741,
    0xE742, 0xE743, 0xE744, 0xE745, 0xE746, 0xE747, 0xE748, 0xE749,
    0xE74A, 0xE74B, 0xE74C, 0xE74D, 0xE74E, 0xE74F, 0xE750, 0xE751,
    0xE752, 0xE753, 0xE754, 0xE755, 0xE756, 0xE757, 0xE758, 0xE759,
    0xE75A, 0xE75B, 0xE75C, 0xE75D, 0xE75E, 0xE75F, 0xE760, 0xE761,
    0xE762, 0xE763, 0xE764, 0xE765, 0xE766, 0xE767, 0xE768, 0xE769,
    0xE76A, 0xE76B, 0xE76C, 0xE76D, 0xE76E, 0xE76F, 0xE770, 0xE771,
    0xE772, 0xE773, 0xE774, 0xE775, 0xE776, 0xE777, 0xE778, 0xE779,
    0xE77A, 0xE77B, 0xE77C, 0xE77D, 0xE77E, 0xE780, 0xE781, 0xE782,
    0xE783, 0xE784, 0xE785, 0xE786, 0xE787, 0xE788, 0xE789, 0xE78A,
    0xE78B, 0xE78C, 0xE78D, 0xE78E, 0xE78F, 0xE790, 0xE791, 0xE792,
    0xE793, 0xE794, 0xE795, 0xE796, 0xE797, 0xE798, 0xE799, 0xE79A,
    0xE79B, 0xE79C, 0xE79D, 0xE79E, 0xE79F, 0xE7A0, 0xE840, 0xE841,
    0xE842, 0xE843, 0xE844, 0xE845, 0xE846, 0xE847, 0xE848, 0xE849,
    0xE84A, 0xE84B, 0xE84C, 0xE84D, 0xE84E, 0xE84F, 0xE850, 0xE851,
    0xE852, 0xE853, 0xE854, 0xE855, 0xE856, 0xE857, 0xE858, 0xE859,
    0xE85A, 0xE85B, 0xE85C, 0xE85D, 0xE85E, 0xE85F, 0xE860, 0xE861,
    0xE862, 0xE863, 0xE864, 0xE865, 0xE866, 0xE867, 0xE868, 0xE869,
    0xE86A, 0xE86B, 0xE86C, 0xE86D, 0xE86E, 0xE86F, 0xE870, 0xE871,
    0xE872, 0xE873, 0xE874, 0xE875, 0xE876, 0xE877, 0xE878, 0xE879,
    0xE87A, 0xE87B, 0xE87C, 0xE87D, 0xE87E, 0xE880, 0xE881, 0xE882,
    0xE883, 0xE884, 0xE885, 0xE886, 0xE887, 0xE888, 0xE889, 0xE88A,
    0xE88B, 0xE88C, 0xE88D, 0xE88E, 0xE88F, 0xE890, 0xE891, 0xE892,
    0xE893, 0xE894, 0xE895, 0xE896, 0xE897, 0xE898, 0xE899, 0xE89A,
    0xE89B, 0xE89C, 0xE89D, 0xE89E, 0xE89F, 0xE8A0, 0xE940, 0xE941,
    0xE942, 0xE943, 0xE944, 0xE945, 0xE946, 0xE947, 0xE948, 0xE949,
    0xE94A, 0xE94B, 0xE94C, 0xE94D, 0xE94E, 0xE94F, 0xE950, 0xE951,
    0xE952, 0xE953, 0xE954, 0xE955, 0xE956, 0xE957, 0xE958, 0xE959,
    0xE95A, 0xE95B, 0xE95C, 0xE95D, 0xE95E, 0xE95F, 0xE960, 0xE961,
    0xE962, 0xE963, 0xE964, 0xE965, 0xE966, 0xE967, 0xE968, 0xE969,
    0xE96A, 0xE96B, 0xE96C, 0xE96D, 0xE96E, 0xE96F, 0xE970, 0xE971,
    0xE972, 0xE973, 0xE974, 0xE975, 0xE976, 0xE977, 0xE978, 0xE979,
    0xE97A, 0xE97B, 0xE97C, 0xE97D, 0xE97E, 0xE980, 0xE981, 0xE982,
    0xE983, 0xE984, 0xE985, 0xE986, 0xE987, 0xE988, 0xE989, 0xE98A,
    0xE98B, 0xE98C, 0xE98D, 0xE98E, 0xE98F, 0xE990, 0xE991, 0xE992,
    0xE993, 0xE994, 0xE995, 0xE996, 0xE997, 0xE998, 0xE999, 0xE99A,
    0xE99B, 0xE99C, 0xE99D, 0xE99E, 0xE99F, 0xE9A0, 0xEA40, 0xEA41,
    0xEA42, 0xEA43, 0xEA44, 0xEA45, 0xEA46, 0xEA47, 0xEA48, 0xEA49,
    0xEA4A, 0xEA4B, 0xEA4C, 0xEA4D, 0xEA4E, 0xEA4F, 0xEA50, 0xEA51,
    0xEA52, 0xEA53, 0xEA54, 0xEA55, 0xEA56, 0xEA57, 0xEA58, 0xEA59,
    0xEA5A, 0xEA5B, 0xEA5C, 0xEA5D, 0xEA5E, 0xEA5F, 0xEA60, 0xEA61,
    0xEA62, 0xEA63, 0xEA64, 0xEA65, 0xEA66, 0xEA67, 0xEA68, 0xEA69,
    0xEA6A, 0xEA6B, 0xEA6C, 0xEA6D, 0xEA6E, 0xEA6F, 0xEA70, 0xEA71,
    0xEA72, 0xEA73, 0xEA74, 0xEA75, 0xEA76, 0xEA77, 0xEA78, 0xEA79,
    0xEA7A, 0xEA7B, 0xEA7C, 0xEA7D, 0xEA7E, 0xEA80, 0xEA81, 0xEA82,
    0xEA83, 0xEA84, 0xEA85, 0xEA86, 0xEA87, 0xEA88, 0xEA89, 0xEA8A,
    0xEA8B, 0xEA8C, 0xEA8D, 0xEA8E, 0xEA8F, 0xEA90, 0xEA91, 0xEA92,
    0xEA93, 0xEA94, 0xEA95, 0xEA96, 0xEA97, 0xEA98, 0xEA99, 0xEA9A,
    0xEA9B, 0xEA9C, 0xEA9D, 0xEA9E, 0xEA9F, 0xEAA0, 0xEB40, 0xEB41,
    0xEB42, 0xEB43, 0xEB44, 0xEB45, 0xEB46, 0xEB47, 0xEB48, 0xEB49,
    0xEB4A, 0xEB4B, 0xEB4C, 0xEB4D, 0xEB4E, 0xEB4F, 0xEB50, 0xEB51,
    0xEB52, 0xEB53, 0xEB54, 0xEB55, 0xEB56, 0xEB57, 0xEB58, 0xEB59,
    0xEB5A, 0xEB5B, 0xEB5C, 0xEB5D, 0xEB5E, 0xEB5F, 0xEB60, 0xEB61,
    0xEB62, 0xEB63, 0xEB64, 0xEB65, 0xEB66, 0xEB67, 0xEB68, 0xEB69,
    0xEB6A, 0xEB6B, 0xEB6C, 0xEB6D, 0xEB6E, 0xEB6F, 0xEB70, 0xEB71,
    0xEB72, 0xEB73, 0xEB74, 0xEB75, 0xEB76, 0xEB77, 0xEB78, 0xEB79,
    0xEB7A, 0xEB7B, 0xEB7C, 0xEB7D, 0xEB7E, 0xEB80, 0xEB81, 0xEB82,
    0xEB83, 0xEB84, 0xEB85, 0xEB86, 0xEB87, 0xEB88, 0xEB89, 0xEB8A,
    0xEB8B, 0xEB8C, 0xEB8D, 0xEB8E, 0xEB8F, 0xEB90, 0xEB91, 0xEB92,
    0xEB93, 0xEB94, 0xEB95, 0xEB96, 0xEB97, 0xEB98, 0xEB99, 0xEB9A,
    0xEB9B, 0xEB9C, 0xEB9D, 0xEB9E, 0xEB9F, 0xEBA0, 0xEC40, 0xEC41,
    0xEC42, 0xEC43, 0xEC44, 0xEC45, 0xEC46, 0xEC47, 0xEC48, 0xEC49,
    0xEC4A, 0xEC4B, 0xEC4C, 0xEC4D, 0xEC4E, 0xEC4F, 0xEC50, 0xEC51,
    0xEC52, 0xEC53, 0xEC54, 0xEC55, 0xEC56, 0xEC57, 0xEC58, 0xEC59,
    0xEC5A, 0xEC5B, 0xEC5C, 0xEC5D, 0xEC5E, 0xEC5F, 0xEC60, 0xEC61,
    0xEC62, 0xEC63, 0xEC64, 0xEC65, 0xEC66, 0xEC67, 0xEC68, 0xEC69,
    0xEC6A, 0xEC6B, 0xEC6C, 0xEC6D, 0xEC6E, 0xEC6F, 0xEC70, 0xEC71,
    0xEC72, 0xEC73, 0xEC74, 0xEC75, 0xEC76, 0xEC77, 0xEC78, 0xEC79,
    0xEC7A, 0xEC7B, 0xEC7C, 0xEC7D, 0xEC7E, 0xEC80, 0xEC81, 0xEC82,
    0xEC83, 0xEC84, 0xEC85, 0xEC86, 0xEC87, 0xEC88, 0xEC89, 0xEC8A,
    0xEC8B, 0xEC8C, 0xEC8D, 0xEC8E, 0xEC8F, 0xEC90, 0xEC91, 0xEC92,
    0xEC93, 0xEC94, 0xEC95, 0xEC96, 0xEC97, 0xEC98, 0xEC99, 0xEC9A,
    0xEC9B, 0xEC9C, 0xEC9D, 0xEC9E, 0xEC9F, 0xECA0, 0xED40, 0xED41,
    0xED42, 0xED43, 0xED44, 0xED45, 0xED46, 0xED47, 0xED48, 0xED49,
    0xED4A, 0xED4B, 0xED4C, 0xED4D, 0xED4E, 0xED4F, 0xED50, 0xED51,
    0xED52, 0xED53, 0xED54, 0xED55, 0xED56, 0xED57, 0xED58, 0xED59,
    0xED5A, 0xED5B, 0xED5C, 0xED5D, 0xED5E, 0xED5F, 0xED60, 0xED61,
    0xED62, 0xED63, 0xED64, 0xED65, 0xED66, 0xED67, 0xED68, 0xED69,
    0xED6A, 0xED6B, 0xED6C, 0xED6D, 0xED6E, 0xED6F, 0xED70, 0xED71,
    0xED72, 0xED73, 0xED74, 0xED75, 0xED76, 0xED77, 0xED78, 0xED79,
    0xED7A, 0xED7B, 0xED7C, 0xED7D, 0xED7E, 0xED80, 0xED81, 0xED82,
    0xED83, 0xED84, 0xED85, 0xED86, 0xED87, 0xED88, 0xED89, 0xED8A,
    0xED8B, 0xED8C, 0xED8D, 0xED8E, 0xED8F, 0xED90, 0xED91, 0xED92,
    0xED93, 0xED94, 0xED95, 0xED96, 0xED97, 0xED98, 0xED99, 0xED9A,
    0xED9B, 0xED9C, 0xED9D, 0xED9E, 0xED9F, 0xEDA0, 0xEE40, 0xEE41,
    0xEE42, 0xEE43, 0xEE44, 0xEE45, 0xEE46, 0xEE47, 0xEE48, 0xEE49,
    0xEE4A, 0xEE4B, 0xEE4C, 0xEE4D, 0xEE4E, 0xEE4F, 0xEE50, 0xEE51,
    0xEE52, 0xEE53, 0xEE54, 0xEE55, 0xEE56, 0xEE57, 0xEE58, 0xEE59,
    0xEE5A, 0xEE5B, 0xEE5C, 0xEE5D, 0xEE5E, 0xEE5F, 0xEE60, 0xEE61,
    0xEE62, 0xEE63, 0xEE64, 0xEE65, 0xEE66, 0xEE67, 0xEE68, 0xEE69,
    0xEE6A, 0xEE6B, 0xEE6C, 0xEE6D, 0xEE6E, 0xEE6F, 0xEE70, 0xEE71,
    0xEE72, 0xEE73, 0xEE74, 0xEE75, 0xEE76, 0xEE77, 0xEE78, 0xEE79,
    0xEE7A, 0xEE7B, 0xEE7C, 0xEE7D, 0xEE7E, 0xEE80, 0xEE81, 0xEE82,
    0xEE83, 0xEE84, 0xEE85, 0xEE86, 0xEE87, 0xEE88, 0xEE89, 0xEE8A,
    0xEE8B, 0xEE8C, 0xEE8D, 0xEE8E, 0xEE8F, 0xEE90, 0xEE91, 0xEE92,
    0xEE93, 0xEE94, 0xEE95, 0xEE96, 0xEE97, 0xEE98, 0xEE99, 0xEE9A,
    0xEE9B, 0xEE9C, 0xEE9D, 0xEE9E, 0xEE9F, 0xEEA0, 0xEF40, 0xEF41,
    0xEF42, 0xEF43, 0xEF44, 0xEF45, 0xEF46, 0xEF47, 0xEF48, 0xEF49,
    0xEF4A, 0xEF4B, 0xEF4C, 0xEF4D, 0xEF4E, 0xEF4F, 0xEF50, 0xEF51,
    0xEF52, 0xEF53, 0xEF54, 0xEF55, 0xEF56, 0xEF57, 0xEF58, 0xEF59,
    0xEF5A, 0xEF5B, 0xEF5C, 0xEF5D, 0xEF5E, 0xEF5F, 0xEF60, 0xEF61,
    0xEF62, 0xEF63, 0xEF64, 0xEF65, 0xEF66, 0xEF67, 0xEF68, 0xEF69,
    0xEF6A, 0xEF6B, 0xEF6C, 0xEF6D, 0xEF6E, 0xEF6F, 0xEF70, 0xEF71,
    0xEF72, 0xEF73, 0xEF74, 0xEF75, 0xEF76, 0xEF77, 0xEF78, 0xEF79,
    0xEF7A, 0xEF7B, 0xEF7C, 0xEF7D, 0xEF7E, 0xEF80, 0xEF81, 0xEF82,
    0xEF83, 0xEF84, 0xEF85, 0xEF86, 0xEF87, 0xEF88, 0xEF89, 0xEF8A,
    0xEF8B, 0xEF8C, 0xEF8D, 0xEF8E, 0xEF8F, 0xEF90, 0xEF91, 0xEF92,
    0xEF93, 0xEF94, 0xEF95, 0xEF96, 0xEF97, 0xEF98, 0xEF99, 0xEF9A,
    0xEF9B, 0xEF9C, 0xEF9D, 0xEF9E, 0xEF9F, 0xEFA0, 0xF040, 0xF041,
    0xF042, 0xF043, 0xF044, 0xF045, 0xF046, 0xF047, 0xF048, 0xF049,
    0xF04A, 0xF04B, 0xF04C, 0xF04D, 0xF04E, 0xF04F, 0xF050, 0xF051,
    0xF052, 0xF053, 0xF054, 0xF055, 0xF056, 0xF057, 0xF058, 0xF059,
    0xF05A, 0xF05B, 0xF05C, 0xF05D, 0xF05E, 0xF05F, 0xF060, 0xF061,
    0xF062, 0xF063, 0xF064, 0xF065, 0xF066, 0xF067, 0xF068, 0xF069,
    0xF06A, 0xF06B, 0xF06C, 0xF06D, 0xF06E, 0xF06F, 0xF070, 0xF071,
    0xF072, 0xF073, 0xF074, 0xF075, 0xF076, 0xF077, 0xF078, 0xF079,
    0xF07A, 0xF07B, 0xF07C, 0xF07D, 0xF07E, 0xF080, 0xF081, 0xF082,
    0xF083, 0xF084, 0xF085, 0xF086, 0xF087, 0xF088, 0xF089, 0xF08A,
    0xF08B, 0xF08C, 0xF08D, 0xF08E, 0xF08F, 0xF090, 0xF091, 0xF092,
    0xF093, 0xF094, 0xF095, 0xF096, 0xF097, 0xF098, 0xF099, 0xF09A,
    0xF09B, 0xF09C, 0xF09D, 0xF09E, 0xF09F, 0xF0A0, 0xF140, 0xF141,
    0xF142, 0xF143, 0xF144, 0xF145, 0xF146, 0xF147, 0xF148, 0xF149,
    0xF14A, 0xF14B, 0xF14C, 0xF14D, 0xF14E, 0xF14F, 0xF150, 0xF151,
    0xF152, 0xF153, 0xF154, 0xF155, 0xF156, 0xF157, 0xF158, 0xF159,
    0xF15A, 0xF15B, 0xF15C, 0xF15D, 0xF15E, 0xF15F, 0xF160, 0xF161,
    0xF162, 0xF163, 0xF164, 0xF165, 0xF166, 0xF167, 0xF168, 0xF169,
    0xF16A, 0xF16B, 0xF16C, 0xF16D, 0xF16E, 0xF16F, 0xF170, 0xF171,
    0xF172, 0xF173, 0xF174, 0xF175, 0xF176, 0xF177, 0xF178, 0xF179,
    0xF17A, 0xF17B, 0xF17C, 0xF17D, 0xF17E, 0xF180, 0xF181, 0xF182,
    0xF183, 0xF184, 0xF185, 0xF186, 0xF187, 0xF188, 0xF189, 0xF18A,
    0xF18B, 0xF18C, 0xF18D, 0xF18E, 0xF18F, 0xF190, 0xF191, 0xF192,
    0xF193, 0xF194, 0xF195, 0xF196, 0xF197, 0xF198, 0xF199, 0xF19A,
    0xF19B, 0xF19C, 0xF19D, 0xF19E, 0xF19F, 0xF1A0, 0xF240, 0xF241,
    0xF242, 0xF243, 0xF244, 0xF245, 0xF246, 0xF247, 0xF248, 0xF249,
    0xF24A, 0xF24B, 0xF24C, 0xF24D, 0xF24E, 0xF24F, 0xF250, 0xF251,
    0xF252, 0xF253, 0xF254, 0xF255, 0xF256, 0xF257, 0xF258, 0xF259,
    0xF25A, 0xF25B, 0xF25C, 0xF25D, 0xF25E, 0xF25F, 0xF260, 0xF261,
    0xF262, 0xF263, 0xF264, 0xF265, 0xF266, 0xF267, 0xF268, 0xF269,
    0xF26A, 0xF26B, 0xF26C, 0xF26D, 0xF26E, 0xF26F, 0xF270, 0xF271,
    0xF272, 0xF273, 0xF274, 0xF275, 0xF276, 0xF277, 0xF278, 0xF279,
    0xF27A, 0xF27B, 0xF27C, 0xF27D, 0xF27E, 0xF280, 0xF281, 0xF282,
    0xF283, 0xF284, 0xF285, 0xF286, 0xF287, 0xF288, 0xF289, 0xF28A,
    0xF28B, 0xF28C, 0xF28D, 0xF28E, 0xF28F, 0xF290, 0xF291, 0xF292,
    0xF293, 0xF294, 0xF295, 0xF296, 0xF297, 0xF298, 0xF299, 0xF29A,
    0xF29B, 0xF29C, 0xF29D, 0xF29E, 0xF29F, 0xF2A0, 0xF340, 0xF341,
    0xF342, 0xF343, 0xF344, 0xF345, 0xF346, 0xF347, 0xF348, 0xF349,
    0xF34A, 0xF34B, 0xF34C, 0xF34D, 0xF34E, 0xF34F, 0xF350, 0xF351,
    0xF352, 0xF353, 0xF354, 0xF355, 0xF356, 0xF357, 0xF358, 0xF359,
    0xF35A, 0xF35B, 0xF35C, 0xF35D, 0xF35E, 0xF35F, 0xF360, 0xF361,
    0xF362, 0xF363, 0xF364, 0xF365, 0xF366, 0xF367, 0xF368, 0xF369,
    0xF36A, 0xF36B, 0xF36C, 0xF36D, 0xF36E, 0xF36F, 0xF370, 0xF371,
    0xF372, 0xF373, 0xF374, 0xF375, 0xF376, 0xF377, 0xF378, 0xF379,
    0xF37A, 0xF37B, 0xF37C, 0xF37D, 0xF37E, 0xF380, 0xF381, 0xF382,
    0xF383, 0xF384, 0xF385, 0xF386, 0xF387, 0xF388, 0xF389, 0xF38A,
    0xF38B, 0xF38C, 0xF38D, 0xF38E, 0xF38F, 0xF390, 0xF391, 0xF392,
    0xF393, 0xF394, 0xF395, 0xF396, 0xF397, 0xF398, 0xF399, 0xF39A,
    0xF39B, 0xF39C, 0xF39D, 0xF39E, 0xF39F, 0xF3A0, 0xF440, 0xF441,
    0xF442, 0xF443, 0xF444, 0xF445, 0xF446, 0xF447, 0xF448, 0xF449,
    0xF44A, 0xF44B, 0xF44C, 0xF44D, 0xF44E, 0xF44F, 0xF450, 0xF451,
    0xF452, 0xF453, 0xF454, 0xF455, 0xF456, 0xF457, 0xF458, 0xF459,
    0xF45A, 0xF45B, 0xF45C, 0xF45D, 0xF45E, 0xF45F, 0xF460, 0xF461,
    0xF462, 0xF463, 0xF464, 0xF465, 0xF466, 0xF467, 0xF468, 0xF469,
    0xF46A, 0xF46B, 0xF46C, 0xF46D, 0xF46E, 0xF46F, 0xF470, 0xF471,
    0xF472, 0xF473, 0xF474, 0xF475, 0xF476, 0xF477, 0xF478, 0xF479,
    0xF47A, 0xF47B, 0xF47C, 0xF47D, 0xF47E, 0xF480, 0xF481, 0xF482,
    0xF483, 0xF484, 0xF485, 0xF486, 0xF487, 0xF488, 0xF489, 0xF48A,
    0xF48B, 0xF48C, 0xF48D, 0xF48E, 0xF48F, 0xF490, 0xF491, 0xF492,
    0xF493, 0xF494, 0xF495, 0xF496, 0xF497, 0xF498, 0xF499, 0xF49A,
    0xF49B, 0xF49C, 0xF49D, 0xF49E, 0xF49F, 0xF4A0, 0xF540, 0xF541,
    0xF542, 0xF543, 0xF544, 0xF545, 0xF546, 0xF547, 0xF548, 0xF549,
    0xF54A, 0xF54B, 0xF54C, 0xF54D, 0xF54E, 0xF54F, 0xF550, 0xF551,
    0xF552, 0xF553, 0xF554, 0xF555, 0xF556, 0xF557, 0xF558, 0xF559,
    0xF55A, 0xF55B, 0xF55C, 0xF55D, 0xF55E, 0xF55F, 0xF560, 0xF561,
    0xF562, 0xF563, 0xF564, 0xF565, 0xF566, 0xF567, 0xF568, 0xF569,
    0xF56A, 0xF56B, 0xF56C, 0xF56D, 0xF56E, 0xF56F, 0xF570, 0xF571,
    0xF572, 0xF573, 0xF574, 0xF575, 0xF576, 0xF577, 0xF578, 0xF579,
    0xF57A, 0xF57B, 0xF57C, 0xF57D, 0xF57E, 0xF580, 0xF581, 0xF582,
    0xF583, 0xF584, 0xF585, 0xF586, 0xF587, 0xF588, 0xF589, 0xF58A,
    0xF58B, 0xF58C, 0xF58D, 0xF58E, 0xF58F, 0xF590, 0xF591, 0xF592,
    0xF593, 0xF594, 0xF595, 0xF596, 0xF597, 0xF598, 0xF599, 0xF59A,
    0xF59B, 0xF59C, 0xF59D, 0xF59E, 0xF59F, 0xF5A0, 0xF640, 0xF641,
    0xF642, 0xF643, 0xF644, 0xF645, 0xF646, 0xF647, 0xF648, 0xF649,
    0xF64A, 0xF64B, 0xF64C, 0xF64D, 0xF64E, 0xF64F, 0xF650, 0xF651,
    0xF652, 0xF653, 0xF654, 0xF655, 0xF656, 0xF657, 0xF658, 0xF659,
    0xF65A, 0xF65B, 0xF65C, 0xF65D, 0xF65E, 0xF65F, 0xF660, 0xF661,
    0xF662, 0xF663, 0xF664, 0xF665, 0xF666, 0xF667, 0xF668, 0xF669,
    0xF66A, 0xF66B, 0xF66C, 0xF66D, 0xF66E, 0xF66F, 0xF670, 0xF671,
    0xF672, 0xF673, 0xF674, 0xF675, 0xF676, 0xF677, 0xF678, 0xF679,
    0xF67A, 0xF67B, 0xF67C, 0xF67D, 0xF67E, 0xF680, 0xF681, 0xF682,
    0xF683, 0xF684, 0xF685, 0xF686, 0xF687, 0xF688, 0xF689, 0xF68A,
    0xF68B, 0xF68C, 0xF68D, 0xF68E, 0xF68F, 0xF690, 0xF691, 0xF692,
    0xF693, 0xF694, 0xF695, 0xF696, 0xF697, 0xF698, 0xF699, 0xF69A,
    0xF69B, 0xF69C, 0xF69D, 0xF69E, 0xF69F, 0xF6A0, 0xF740, 0xF741,
    0xF742, 0xF743, 0xF744, 0xF745, 0xF746, 0xF747, 0xF748, 0xF749,
    0xF74A, 0xF74B, 0xF74C, 0xF74D, 0xF74E, 0xF74F, 0xF750, 0xF751,
    0xF752, 0xF753, 0xF754, 0xF755, 0xF756, 0xF757, 0xF758, 0xF759,
    0xF75A, 0xF75B, 0xF75C, 0xF75D, 0xF75E, 0xF75F, 0xF760, 0xF761,
    0xF762, 0xF763, 0xF764, 0xF765, 0xF766, 0xF767, 0xF768, 0xF769,
    0xF76A, 0xF76B, 0xF76C, 0xF76D, 0xF76E, 0xF76F, 0xF770, 0xF771,
    0xF772, 0xF773, 0xF774, 0xF775, 0xF776, 0xF777, 0xF778, 0xF779,
    0xF77A, 0xF77B, 0xF77C, 0xF77D, 0xF77E, 0xF780, 0xF781, 0xF782,
    0xF783, 0xF784, 0xF785, 0xF786, 0xF787, 0xF788, 0xF789, 0xF78A,
    0xF78B, 0xF78C, 0xF78D, 0xF78E, 0xF78F, 0xF790, 0xF791, 0xF792,
    0xF793, 0xF794, 0xF795, 0xF796, 0xF797, 0xF798, 0xF799, 0xF79A,
    0xF79B, 0xF79C, 0xF79D, 0xF79E, 0xF79F, 0xF7A0, 0xF840, 0xF841,
    0xF842, 0xF843, 0xF844, 0xF845, 0xF846, 0xF847, 0xF848, 0xF849,
    0xF84A, 0xF84B, 0xF84C, 0xF84D, 0xF84E, 0xF84F, 0xF850, 0xF851,
    0xF852, 0xF853, 0xF854, 0xF855, 0xF856, 0xF857, 0xF858, 0xF859,
    0xF85A, 0xF85B, 0xF85C, 0xF85D, 0xF85E, 0xF85F, 0xF860, 0xF861,
    0xF862, 0xF863, 0xF864, 0xF865, 0xF866, 0xF867, 0xF868, 0xF869,
    0xF86A, 0xF86B, 0xF86C, 0xF86D, 0xF86E, 0xF86F, 0xF870, 0xF871,
    0xF872, 0xF873, 0xF874, 0xF875, 0xF876, 0xF877, 0xF878, 0xF879,
    0xF87A, 0xF87B, 0xF87C, 0xF87D, 0xF87E, 0xF880, 0xF881, 0xF882,
    0xF883, 0xF884, 0xF885, 0xF886, 0xF887, 0xF888, 0xF889, 0xF88A,
    0xF88B, 0xF88C, 0xF88D, 0xF88E, 0xF88F, 0xF890, 0xF891, 0xF892,
    0xF893, 0xF894, 0xF895, 0xF896, 0xF897, 0xF898, 0xF899, 0xF89A,
    0xF89B, 0xF89C, 0xF89D, 0xF89E, 0xF89F, 0xF8A0, 0xF940, 0xF941,
    0xF942, 0xF943, 0xF944, 0xF945, 0xF946, 0xF947, 0xF948, 0xF949,
    0xF94A, 0xF94B, 0xF94C, 0xF94D, 0xF94E, 0xF94F, 0xF950, 0xF951,
    0xF952, 0xF953, 0xF954, 0xF955, 0xF956, 0xF957, 0xF958, 0xF959,
    0xF95A, 0xF95B, 0xF95C, 0xF95D, 0xF95E, 0xF95F, 0xF960, 0xF961,
    0xF962, 0xF963, 0xF964, 0xF965, 0xF966, 0xF967, 0xF968, 0xF969,
    0xF96A, 0xF96B, 0xF96C, 0xF96D, 0xF96E, 0xF96F, 0xF970, 0xF971,
    0xF972, 0xF973, 0xF974, 0xF975, 0xF976, 0xF977, 0xF978, 0xF979,
    0xF97A, 0xF97B, 0xF97C, 0xF97D, 0xF97E, 0xF980, 0xF981, 0xF982,
    0xF983, 0xF984, 0xF985, 0xF986, 0xF987, 0xF988, 0xF989, 0xF98A,
    0xF98B, 0xF98C, 0xF98D, 0xF98E, 0xF98F, 0xF990, 0xF991, 0xF992,
    0xF993, 0xF994, 0xF995, 0xF996, 0xF997, 0xF998, 0xF999, 0xF99A,
    0xF99B, 0xF99C, 0xF99D, 0xF99E, 0xF99F, 0xF9A0, 0xFA40, 0xFA41,
    0xFA42, 0xFA43, 0xFA44, 0xFA45, 0xFA46, 0xFA47, 0xFA48, 0xFA49,
    0xFA4A, 0xFA4B, 0xFA4C, 0xFA4D, 0xFA4E, 0xFA4F, 0xFA50, 0xFA51,
    0xFA52, 0xFA53, 0xFA54, 0xFA55, 0xFA56, 0xFA57, 0xFA58, 0xFA59,
    0xFA5A, 0xFA5B, 0xFA5C, 0xFA5D, 0xFA5E, 0xFA5F, 0xFA60, 0xFA61,
    0xFA62, 0xFA63, 0xFA64, 0xFA65, 0xFA66, 0xFA67, 0xFA68, 0xFA69,
    0xFA6A, 0xFA6B, 0xFA6C, 0xFA6D, 0xFA6E, 0xFA6F, 0xFA70, 0xFA71,
    0xFA72, 0xFA73, 0xFA74, 0xFA75, 0xFA76, 0xFA77, 0xFA78, 0xFA79,
    0xFA7A, 0xFA7B, 0xFA7C, 0xFA7D, 0xFA7E, 0xFA80, 0xFA81, 0xFA82,
    0xFA83, 0xFA84, 0xFA85, 0xFA86, 0xFA87, 0xFA88, 0xFA89, 0xFA8A,
    0xFA8B, 0xFA8C, 0xFA8D, 0xFA8E, 0xFA8F, 0xFA90, 0xFA91, 0xFA92,
    0xFA93, 0xFA94, 0xFA95, 0xFA96, 0xFA97, 0xFA98, 0xFA99, 0xFA9A,
    0xFA9B, 0xFA9C, 0xFA9D, 0xFA9E, 0xFA9F, 0xFAA0, 0xFB40, 0xFB41,
    0xFB42, 0xFB43, 0xFB44, 0xFB45, 0xFB46, 0xFB47, 0xFB48, 0xFB49,
    0xFB4A, 0xFB4B, 0xFB4C, 0xFB4D, 0xFB4E, 0xFB4F, 0xFB50, 0xFB51,
    0xFB52, 0xFB53, 0xFB54, 0xFB55, 0xFB56, 0xFB57, 0xFB58, 0xFB59,
    0xFB5A, 0xFB5B, 0xFB5C, 0xFB5D, 0xFB5E, 0xFB5F, 0xFB60, 0xFB61,
    0xFB62, 0xFB63, 0xFB64, 0xFB65, 0xFB66, 0xFB67, 0xFB68, 0xFB69,
    0xFB6A, 0xFB6B, 0xFB6C, 0xFB6D, 0xFB6E, 0xFB6F, 0xFB70, 0xFB71,
    0xFB72, 0xFB73, 0xFB74, 0xFB75, 0xFB76, 0xFB77, 0xFB78, 0xFB79,
    0xFB7A, 0xFB7B, 0xFB7C, 0xFB7D, 0xFB7E, 0xFB80, 0xFB81, 0xFB82,
    0xFB83, 0xFB84, 0xFB85, 0xFB86, 0xFB87, 0xFB88, 0xFB89, 0xFB8A,
    0xFB8B, 0xFB8C, 0xFB8D, 0xFB8E, 0xFB8F, 0xFB90, 0xFB91, 0xFB92,
    0xFB93, 0xFB94, 0xFB95, 0xFB96, 0xFB97, 0xFB98, 0xFB99, 0xFB9A,
    0xFB9B, 0xFB9C, 0xFB9D, 0xFB9E, 0xFB9F, 0xFBA0, 0xFC40, 0xFC41,
    0xFC42, 0xFC43, 0xFC44, 0xFC45, 0xFC46, 0xFC47, 0xFC48, 0xFC49,
    0xFC4A, 0xFC4B, 0xFC4C, 0xFC4D, 0xFC4E, 0xFC4F, 0xFC50, 0xFC51,
    0xFC52, 0xFC53, 0xFC54, 0xFC55, 0xFC56, 0xFC57, 0xFC58, 0xFC59,
    0xFC5A, 0xFC5B, 0xFC5C, 0xFC5D, 0xFC5E, 0xFC5F, 0xFC60, 0xFC61,
    0xFC62, 0xFC63, 0xFC64, 0xFC65, 0xFC66, 0xFC67, 0xFC68, 0xFC69,
    0xFC6A, 0xFC6B, 0xFC6C, 0xFC6D, 0xFC6E, 0xFC6F, 0xFC70, 0xFC71,
    0xFC72, 0xFC73, 0xFC74, 0xFC75, 0xFC76, 0xFC77, 0xFC78, 0xFC79,
    0xFC7A, 0xFC7B, 0xFC7C, 0xFC7D, 0xFC7E, 0xFC80, 0xFC81, 0xFC82,
    0xFC83, 0xFC84, 0xFC85, 0xFC86, 0xFC87, 0xFC88, 0xFC89, 0xFC8A,
    0xFC8B, 0xFC8C, 0xFC8D, 0xFC8E, 0xFC8F, 0xFC90, 0xFC91, 0xFC92,
    0xFC93, 0xFC94, 0xFC95, 0xFC96, 0xFC97, 0xFC98, 0xFC99, 0xFC9A,
    0xFC9B, 0xFC9C, 0xFC9D, 0xFC9E, 0xFC9F, 0xFCA0, 0xFD40, 0xFD41,
    0xFD42, 0xFD43, 0xFD44, 0xFD45, 0xFD46, 0xFD47, 0xFD48, 0xFD49,
    0xFD4A, 0xFD4B, 0xFD4C, 0xFD4D, 0xFD4E, 0xFD4F, 0xFD50, 0xFD51,
    0xFD52, 0xFD53, 0xFD54, 0xFD55, 0xFD56, 0xFD57, 0xFD58, 0xFD59,
    0xFD5A, 0xFD5B, 0xFD5C, 0xFD5D, 0xFD5E, 0xFD5F, 0xFD60, 0xFD61,
    0xFD62, 0xFD63, 0xFD64, 0xFD65, 0xFD66, 0xFD67, 0xFD68, 0xFD69,
    0xFD6A, 0xFD6B, 0xFD6C, 0xFD6D, 0xFD6E, 0xFD6F, 0xFD70, 0xFD71,
    0xFD72, 0xFD73, 0xFD74, 0xFD75, 0xFD76, 0xFD77, 0xFD78, 0xFD79,
    0xFD7A, 0xFD7B, 0xFD7C, 0xFD7D, 0xFD7E, 0xFD80, 0xFD81, 0xFD82,
    0xFD83, 0xFD84, 0xFD85, 0xFD86, 0xFD87, 0xFD88, 0xFD89, 0xFD8A,
    0xFD8B, 0xFD8C, 0xFD8D, 0xFD8E, 0xFD8F, 0xFD90, 0xFD91, 0xFD92,
    0xFD93, 0xFD94, 0xFD95, 0xFD96, 0xFD97, 0xFD98, 0xFD99, 0xFD9A,
    0xFD9B, 0xFD9C, 0xFD9D, 0xFD9E, 0xFD9F, 0xFDA0, 0xFE40, 0xFE41,
    0xFE42, 0xFE43, 0xFE44, 0xFE45, 0xFE46, 0xFE47, 0xFE48, 0xFE49,
    0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D, 0xFE4E, 0xFE4F, 0xA955, 0xA6F2,
    0xA6F4, 0xA6F5, 0xA6E0, 0xA6E1, 0xA6F0, 0xA6F1, 0xA6E2, 0xA6E3,
    0xA6EE, 0xA6EF, 0xA6E6, 0xA6E7, 0xA6E4, 0xA6E5, 0xA6E8, 0xA6E9,
    0xA6EA, 0xA6EB, 0xA968, 0xA969, 0xA96A, 0xA96B, 0xA96C, 0xA96D,
    0xA96E, 0xA96F, 0xA970, 0xA971, 0xA972, 0xA973, 0xA974, 0xA975,
    0xA976, 0xA977, 0xA978, 0xA979, 0xA97A, 0xA97B, 0xA97C, 0xA97D,
    0xA97E, 0xA980, 0xA981, 0xA982, 0xA983, 0xA984, 0xA985, 0xA986,
    0xA987, 0xA988, 0xA956, 0xA957,
};
#endif /* ZUECI_EMBED_NO_TO_ECI */

#ifndef ZUECI_EMBED_NO_TO_UTF8
/* Unicode values in multibyte order */
static const zueci_u16 zueci_gbk_mb_u[14352] = {
    0x4E02, 0x4E04, 0x4E05, 0x4E06, 0x4E0F, 0x4E12, 0x4E17, 0x4E1F,
    0x4E20, 0x4E21, 0x4E23, 0x4E26, 0x4E29, 0x4E2E, 0x4E2F, 0x4E31,
    0x4E33, 0x4E35, 0x4E37, 0x4E3C, 0x4E40, 0x4E41, 0x4E42, 0x4E44,
    0x4E46, 0x4E4A, 0x4E51, 0x4E55, 0x4E57, 0x4E5A, 0x4E5B, 0x4E62,
    0x4E63, 0x4E64, 0x4E65, 0x4E67, 0x4E68, 0x4E6A, 0x4E6B, 0x4E6C,
    0x4E6D, 0x4E6E, 0x4E6F, 0x4E72, 0x4E74, 0x4E75, 0x4E76, 0x4E77,
    0x4E78, 0x4E79, 0x4E7A, 0x4E7B, 0x4E7C, 0x4E7D, 0x4E7F, 0x4E80,
    0x4E81, 0x4E82, 0x4E83, 0x4E84, 0x4E85, 0x4E87, 0x4E8A, 0x4E90,
    0x4E96, 0x4E97, 0x4E99, 0x4E9C, 0x4E9D, 0x4E9E, 0x4EA3, 0x4EAA,
    0x4EAF, 0x4EB0, 0x4EB1, 0x4EB4, 0x4EB6, 0x4EB7, 0x4EB8, 0x4EB9,
    0x4EBC, 0x4EBD, 0x4EBE, 0x4EC8, 0x4ECC, 0x4ECF, 0x4ED0, 0x4ED2,
    0x4EDA, 0x4EDB, 0x4EDC, 0x4EE0, 0x4EE2, 0x4EE6, 0x4EE7, 0x4EE9,
    0x4EED, 0x4EEE, 0x4EEF, 0x4EF1, 0x4EF4, 0x4EF8, 0x4EF9, 0x4EFA,
    0x4EFC, 0x4EFE, 0x4F00, 0x4F02, 0x4F03, 0x4F04, 0x4F05, 0x4F06,
    0x4F07, 0x4F08, 0x4F0B, 0x4F0C, 0x4F12, 0x4F13, 0x4F14, 0x4F15,
    0x4F16, 0x4F1C, 0x4F1D, 0x4F21, 0x4F23, 0x4F28, 0x4F29, 0x4F2C,
    0x4F2D, 0x4F2E, 0x4F31, 0x4F33, 0x4F35, 0x4F37, 0x4F39, 0x4F3B,
    0x4F3E, 0x4F3F, 0x4F40, 0x4F41, 0x4F42, 0x4F44, 0x4F45, 0x4F47,
    0x4F48, 0x4F49, 0x4F4A, 0x4F4B, 0x4F4C, 0x4F52, 0x4F54, 0x4F56,
    0x4F61, 0x4F62, 0x4F66, 0x4F68, 0x4F6A, 0x4F6B, 0x4F6D, 0x4F6E,
    0x4F71, 0x4F72, 0x4F75, 0x4F77, 0x4F78, 0x4F79, 0x4F7A, 0x4F7D,
    0x4F80, 0x4F81, 0x4F82, 0x4F85, 0x4F86, 0x4F87, 0x4F8A, 0x4F8C,
    0x4F8E, 0x4F90, 0x4F92, 0x4F93, 0x4F95, 0x4F96, 0x4F98, 0x4F99,
    0x4F9A, 0x4F9C, 0x4F9E, 0x4F9F, 0x4FA1, 0x4FA2, 0x4FA4, 0x4FAB,
    0x4FAD, 0x4FB0, 0x4FB1, 0x4FB2, 0x4FB3, 0x4FB4, 0x4FB6, 0x4FB7,
    0x4FB8, 0x4FB9, 0x4FBA, 0x4FBB, 0x4FBC, 0x4FBD, 0x4FBE, 0x4FC0,
    0x4FC1, 0x4FC2, 0x4FC6, 0x4FC7, 0x4FC8, 0x4FC9, 0x4FCB, 0x4FCC,
    0x4FCD, 0x4FD2, 0x4FD3, 0x4FD4, 0x4FD5, 0x4FD6, 0x4FD9, 0x4FDB,
    0x4FE0, 0x4FE2, 0x4FE4, 0x4FE5, 0x4FE7, 0x4FEB, 0x4FEC, 0x4FF0,
    0x4FF2, 0x4FF4, 0x4FF5, 0x4FF6, 0x4FF7, 0x4FF9, 0x4FFB, 0x4FFC,
    0x4FFD, 0x4FFF, 0x5000, 0x5001, 0x5002, 0x5003, 0x5004, 0x5005,
    0x5006, 0x5007, 0x5008, 0x5009, 0x500A, 0x500B, 0x500E, 0x5010,
    0x5011, 0x5013, 0x5015, 0x5016, 0x5017, 0x501B, 0x501D, 0x501E,
    0x5020, 0x5022, 0x5023, 0x5024, 0x5027, 0x502B, 0x502F, 0x5030,
    0x5031, 0x5032, 0x5033, 0x5034, 0x5035, 0x5036, 0x5037, 0x5038,
    0x5039, 0x503B, 0x503D, 0x503F, 0x5040, 0x5041, 0x5042, 0x5044,
    0x5045, 0x5046, 0x5049, 0x504A, 0x504B, 0x504D, 0x5050, 0x5051,
    0x5052, 0x5053, 0x5054, 0x5056, 0x5057, 0x5058, 0x5059, 0x505B,
    0x505D, 0x505E, 0x505F, 0x5060, 0x5061, 0x5062, 0x5063, 0x5064,
    0x5066, 0x5067, 0x5068, 0x5069, 0x506A, 0x506B, 0x506D, 0x506E,
    0x506F, 0x5070, 0x5071, 0x5072, 0x5073, 0x5074, 0x5075, 0x5078,
    0x5079, 0x507A, 0x507C, 0x507D, 0x5081, 0x5082, 0x5083, 0x5084,
    0x5086, 0x5087, 0x5089, 0x508A, 0x508B, 0x508C, 0x508E, 0x508F,
    0x5090, 0x5091, 0x5092, 0x5093, 0x5094, 0x5095, 0x5096, 0x5097,
    0x5098, 0x5099, 0x509A, 0x509B, 0x509C, 0x509D, 0x509E, 0x509F,
    0x50A0, 0x50A1, 0x50A2, 0x50A4, 0x50A6, 0x50AA, 0x50AB, 0x50AD,
    0x50AE, 0x50AF, 0x50B0, 0x50B1, 0x50B3, 0x50B4, 0x50B5, 0x50B6,
    0x50B7, 0x50B8, 0x50B9, 0x50BC, 0x50BD, 0x50BE, 0x50BF, 0x50C0,
    0x50C1, 0x50C2, 0x50C3, 0x50C4, 0x50C5, 0x50C6, 0x50C7, 0x50C8,
    0x50C9, 0x50CA, 0x50CB, 0x50CC, 0x50CD, 0x50CE, 0x50D0, 0x50D1,
    0x50D2, 0x50D3, 0x50D4, 0x50D5, 0x50D7, 0x50D8, 0x50D9, 0x50DB,
    0x50DC, 0x50DD, 0x50DE, 0x50DF, 0x50E0, 0x50E1, 0x50E2, 0x50E3,
    0x50E4, 0x50E5, 0x50E8, 0x50E9, 0x50EA, 0x50EB, 0x50EF, 0x50F0,
    0x50F1, 0x50F2, 0x50F4, 0x50F6, 0x50F7, 0x50F8, 0x50F9, 0x50FA,
    0x50FC, 0x50FD, 0x50FE, 0x50FF, 0x5100, 0x5101, 0x5102, 0x5103,
    0x5104, 0x5105, 0x5108, 0x5109, 0x510A, 0x510C, 0x510D, 0x510E,
    0x510F, 0x5110, 0x5111, 0x5113, 0x5114, 0x5115, 0x5116, 0x5117,
    0x5118, 0x5119, 0x511A, 0x511B, 0x511C, 0x511D, 0x511E, 0x511F,
    0x5120, 0x5122, 0x5123, 0x5124, 0x5125, 0x5126, 0x5127, 0x5128,
    0x5129, 0x512A, 0x512B, 0x512C, 0x512D, 0x512E, 0x512F, 0x5130,
    0x5131, 0x5132, 0x5133, 0x5134, 0x5135, 0x5136, 0x5137, 0x5138,
    0x5139, 0x513A, 0x513B, 0x513C, 0x513D, 0x513E, 0x5142, 0x5147,
    0x514A, 0x514C, 0x514E, 0x514F, 0x5150, 0x5152, 0x5153, 0x5157,
    0x5158, 0x5159, 0x515B, 0x515D, 0x515E, 0x515F, 0x5160, 0x5161,
    0x5163, 0x5164, 0x5166, 0x5167, 0x5169, 0x516A, 0x516F, 0x5172,
    0x517A, 0x517E, 0x517F, 0x5183, 0x5184, 0x5186, 0x5187, 0x518A,
    0x518B, 0x518E, 0x518F, 0x5190, 0x5191, 0x5193, 0x5194, 0x5198,
    0x519A, 0x519D, 0x519E, 0x519F, 0x51A1, 0x51A3, 0x51A6, 0x51A7,
    0x51A8, 0x51A9, 0x51AA, 0x51AD, 0x51AE, 0x51B4, 0x51B8, 0x51B9,
    0x51BA, 0x51BE, 0x51BF, 0x51C1, 0x51C2, 0x51C3, 0x51C5, 0x51C8,
    0x51CA, 0x51CD, 0x51CE, 0x51D0, 0x51D2, 0x51D3, 0x51D4, 0x51D5,
    0x51D6, 0x51D7, 0x51D8, 0x51D9, 0x51DA, 0x51DC, 0x51DE, 0x51DF,
    0x51E2, 0x51E3, 0x51E5, 0x51E6, 0x51E7, 0x51E8, 0x51E9, 0x51EA,
    0x51EC, 0x51EE, 0x51F1, 0x51F2, 0x51F4, 0x51F7, 0x51FE, 0x5204,
    0x5205, 0x5209, 0x520B, 0x520C, 0x520F, 0x5210, 0x5213, 0x5214,
    0x5215, 0x521C, 0x521E, 0x521F, 0x5221, 0x5222, 0x5223, 0x5225,
    0x5226, 0x5227, 0x522A, 0x522C, 0x522F, 0x5231, 0x5232, 0x5234,
    0x5235, 0x523C, 0x523E, 0x5244, 0x5245, 0x5246, 0x5247, 0x5248,
    0x5249, 0x524B, 0x524E, 0x524F, 0x5252, 0x5253, 0x5255, 0x5257,
    0x5258, 0x5259, 0x525A, 0x525B, 0x525D, 0x525F, 0x5260, 0x5262,
    0x5263, 0x5264, 0x5266, 0x5268, 0x526B, 0x526C, 0x526D, 0x526E,
    0x5270, 0x5271, 0x5273, 0x5274, 0x5275, 0x5276, 0x5277, 0x5278,
    0x5279, 0x527A, 0x527B, 0x527C, 0x527E, 0x5280, 0x5283, 0x5284,
    0x5285, 0x5286, 0x5287, 0x5289, 0x528A, 0x528B, 0x528C, 0x528D,
    0x528E, 0x528F, 0x5291, 0x5292, 0x5294, 0x5295, 0x5296, 0x5297,
    0x5298, 0x5299, 0x529A, 0x529C, 0x52A4, 0x52A5, 0x52A6, 0x52A7,
    0x52AE, 0x52AF, 0x52B0, 0x52B4, 0x52B5, 0x52B6, 0x52B7, 0x52B8,
    0x52B9, 0x52BA, 0x52BB, 0x52BC, 0x52BD, 0x52C0, 0x52C1, 0x52C2,
    0x52C4, 0x52C5, 0x52C6, 0x52C8, 0x52CA, 0x52CC, 0x52CD, 0x52CE,
    0x52CF, 0x52D1, 0x52D3, 0x52D4, 0x52D5, 0x52D7, 0x52D9, 0x52DA,
    0x52DB, 0x52DC, 0x52DD, 0x52DE, 0x52E0, 0x52E1, 0x52E2, 0x52E3,
    0x52E5, 0x52E6, 0x52E7, 0x52E8, 0x52E9, 0x52EA, 0x52EB, 0x52EC,
    0x52ED, 0x52EE, 0x52EF, 0x52F1, 0x52F2, 0x52F3, 0x52F4, 0x52F5,
    0x52F6, 0x52F7, 0x52F8, 0x52FB, 0x52FC, 0x52FD, 0x5301, 0x5302,
    0x5303, 0x5304, 0x5307, 0x5309, 0x530A, 0x530B, 0x530C, 0x530E,
    0x5311, 0x5312, 0x5313, 0x5314, 0x5318, 0x531B, 0x531C, 0x531E,
    0x531F, 0x5322, 0x5324, 0x5325, 0x5327, 0x5328, 0x5329, 0x532B,
    0x532C, 0x532D, 0x532F, 0x5330, 0x5331, 0x5332, 0x5333, 0x5334,
    0x5335, 0x5336, 0x5337, 0x5338, 0x533C, 0x533D, 0x5340, 0x5342,
    0x5344, 0x5346, 0x534B, 0x534C, 0x534D, 0x5350, 0x5354, 0x5358,
    0x5359, 0x535B, 0x535D, 0x5365, 0x5368, 0x536A, 0x536C, 0x536D,
    0x5372, 0x5376, 0x5379, 0x537B, 0x537C, 0x537D, 0x537E, 0x5380,
    0x5381, 0x5383, 0x5387, 0x5388, 0x538A, 0x538E, 0x538F, 0x5390,
    0x5391, 0x5392, 0x5393, 0x5394, 0x5396, 0x5397, 0x5399, 0x539B,
    0x539C, 0x539E, 0x53A0, 0x53A1, 0x53A4, 0x53A7, 0x53AA, 0x53AB,
    0x53AC, 0x53AD, 0x53AF, 0x53B0, 0x53B1, 0x53B2, 0x53B3, 0x53B4,
    0x53B5, 0x53B7, 0x53B8, 0x53B9, 0x53BA, 0x53BC, 0x53BD, 0x53BE,
    0x53C0, 0x53C3, 0x53C4, 0x53C5, 0x53C6, 0x53C7, 0x53CE, 0x53CF,
    0x53D0, 0x53D2, 0x53D3, 0x53D5, 0x53DA, 0x53DC, 0x53DD, 0x53DE,
    0x53E1, 0x53E2, 0x53E7, 0x53F4, 0x53FA, 0x53FE, 0x53FF, 0x5400,
    0x5402, 0x5405, 0x5407, 0x540B, 0x5414, 0x5418, 0x5419, 0x541A,
    0x541C, 0x5422, 0x5424, 0x5425, 0x542A, 0x5430, 0x5433, 0x5436,
    0x5437, 0x543A, 0x543D, 0x543F, 0x5441, 0x5442, 0x5444, 0x5445,
    0x5447, 0x5449, 0x544C, 0x544D, 0x544E, 0x544F, 0x5451, 0x545A,
    0x545D, 0x545E, 0x545F, 0x5460, 0x5461, 0x5463, 0x5465, 0x5467,
    0x5469, 0x546A, 0x546B, 0x546C, 0x546D, 0x546E, 0x546F, 0x5470,
    0x5474, 0x5479, 0x547A, 0x547E, 0x547F, 0x5481, 0x5483, 0x5485,
    0x5487, 0x5488, 0x5489, 0x548A, 0x548D, 0x5491, 0x5493, 0x5497,
    0x5498, 0x549C, 0x549E, 0x549F, 0x54A0, 0x54A1, 0x54A2, 0x54A5,
    0x54AE, 0x54B0, 0x54B2, 0x54B5, 0x54B6, 0x54B7, 0x54B9, 0x54BA,
    0x54BC, 0x54BE, 0x54C3, 0x54C5, 0x54CA, 0x54CB, 0x54D6, 0x54D8,
    0x54DB, 0x54E0, 0x54E1, 0x54E2, 0x54E3, 0x54E4, 0x54EB, 0x54EC,
    0x54EF, 0x54F0, 0x54F1, 0x54F4, 0x54F5, 0x54F6, 0x54F7, 0x54F8,
    0x54F9, 0x54FB, 0x54FE, 0x5500, 0x5502, 0x5503, 0x5504, 0x5505,
    0x5508, 0x550A, 0x550B, 0x550C, 0x550D, 0x550E, 0x5512, 0x5513,
    0x5515, 0x5516, 0x5517, 0x5518, 0x5519, 0x551A, 0x551C, 0x551D,
    0x551E, 0x551F, 0x5521, 0x5525, 0x5526, 0x5528, 0x5529, 0x552B,
    0x552D, 0x5532, 0x5534, 0x5535, 0x5536, 0x5538, 0x5539, 0x553A,
    0x553B, 0x553D, 0x5540, 0x5542, 0x5545, 0x5547, 0x5548, 0x554B,
    0x554C, 0x554D, 0x554E, 0x554F, 0x5551, 0x5552, 0x5553, 0x5554,
    0x5557, 0x5558, 0x5559, 0x555A, 0x555B, 0x555D, 0x555E, 0x555F,
    0x5560, 0x5562, 0x5563, 0x5568, 0x5569, 0x556B, 0x556F, 0x5570,
    0x5571, 0x5572, 0x5573, 0x5574, 0x5579, 0x557A, 0x557D, 0x557F,
    0x5585, 0x5586, 0x558C, 0x558D, 0x558E, 0x5590, 0x5592, 0x5593,
    0x5595, 0x5596, 0x5597, 0x559A, 0x559B, 0x559E, 0x55A0, 0x55A1,
    0x55A2, 0x55A3, 0x55A4, 0x55A5, 0x55A6, 0x55A8, 0x55A9, 0x55AA,
    0x55AB, 0x55AC, 0x55AD, 0x55AE, 0x55AF, 0x55B0, 0x55B2, 0x55B4,
    0x55B6, 0x55B8, 0x55BA, 0x55BC, 0x55BF, 0x55C0, 0x55C1, 0x55C2,
    0x55C3, 0x55C6, 0x55C7, 0x55C8, 0x55CA, 0x55CB, 0x55CE, 0x55CF,
    0x55D0, 0x55D5, 0x55D7, 0x55D8, 0x55D9, 0x55DA, 0x55DB, 0x55DE,
    0x55E0, 0x55E2, 0x55E7, 0x55E9, 0x55ED, 0x55EE, 0x55F0, 0x55F1,
    0x55F4, 0x55F6, 0x55F8, 0x55F9, 0x55FA, 0x55FB, 0x55FC, 0x55FF,
    0x5602, 0x5603, 0x5604, 0x5605, 0x5606, 0x5607, 0x560A, 0x560B,
    0x560D, 0x5610, 0x5611, 0x5612, 0x5613, 0x5614, 0x5615, 0x5616,
    0x5617, 0x5619, 0x561A, 0x561C, 0x561D, 0x5620, 0x5621, 0x5622,
    0x5625, 0x5626, 0x5628, 0x5629, 0x562A, 0x562B, 0x562E, 0x562F,
    0x5630, 0x5633, 0x5635, 0x5637, 0x5638, 0x563A, 0x563C, 0x563D,
    0x563E, 0x5640, 0x5641, 0x5642, 0x5643, 0x5644, 0x5645, 0x5646,
    0x5647, 0x5648, 0x5649, 0x564A, 0x564B, 0x564F, 0x5650, 0x5651,
    0x5652, 0x5653, 0x5655, 0x5656, 0x565A, 0x565B, 0x565D, 0x565E,
    0x565F, 0x5660, 0x5661, 0x5663, 0x5665, 0x5666, 0x5667, 0x566D,
    0x566E, 0x566F, 0x5670, 0x5672, 0x5673, 0x5674, 0x5675, 0x5677,
    0x5678, 0x5679, 0x567A, 0x567D, 0x567E, 0x567F, 0x5680, 0x5681,
    0x5682, 0x5683, 0x5684, 0x5687, 0x5688, 0x5689, 0x568A, 0x568B,
    0x568C, 0x568D, 0x5690, 0x5691, 0x5692, 0x5694, 0x5695, 0x5696,
    0x5697, 0x5698, 0x5699, 0x569A, 0x569B, 0x569C, 0x569D, 0x569E,
    0x569F, 0x56A0, 0x56A1, 0x56A2, 0x56A4, 0x56A5, 0x56A6, 0x56A7,
    0x56A8, 0x56A9, 0x56AA, 0x56AB, 0x56AC, 0x56AD, 0x56AE, 0x56B0,
    0x56B1, 0x56B2, 0x56B3, 0x56B4, 0x56B5, 0x56B6, 0x56B8, 0x56B9,
    0x56BA, 0x56BB, 0x56BD, 0x56BE, 0x56BF, 0x56C0, 0x56C1, 0x56C2,
    0x56C3, 0x56C4, 0x56C5, 0x56C6, 0x56C7, 0x56C8, 0x56C9, 0x56CB,
    0x56CC, 0x56CD, 0x56CE, 0x56CF, 0x56D0, 0x56D1, 0x56D2, 0x56D3,
    0x56D5, 0x56D6, 0x56D8, 0x56D9, 0x56DC, 0x56E3, 0x56E5, 0x56E6,
    0x56E7, 0x56E8, 0x56E9, 0x56EA, 0x56EC, 0x56EE, 0x56EF, 0x56F2,
    0x56F3, 0x56F6, 0x56F7, 0x56F8, 0x56FB, 0x56FC, 0x5700, 0x5701,
    0x5702, 0x5705, 0x5707, 0x570B, 0x570C, 0x570D, 0x570E, 0x570F,
    0x5710, 0x5711, 0x5712, 0x5713, 0x5714, 0x5715, 0x5716, 0x5717,
    0x5718, 0x5719, 0x571A, 0x571B, 0x571D, 0x571E, 0x5720, 0x5721,
    0x5722, 0x5724, 0x5725, 0x5726, 0x5727, 0x572B, 0x5731, 0x5732,
    0x5734, 0x5735, 0x5736, 0x5737, 0x5738, 0x573C, 0x573D, 0x573F,
    0x5741, 0x5743, 0x5744, 0x5745, 0x5746, 0x5748, 0x5749, 0x574B,
    0x5752, 0x5753, 0x5754, 0x5755, 0x5756, 0x5758, 0x5759, 0x5762,
    0x5763, 0x5765, 0x5767, 0x576C, 0x576E, 0x5770, 0x5771, 0x5772,
    0x5774, 0x5775, 0x5778, 0x5779, 0x577A, 0x577D, 0x577E, 0x577F,
    0x5780, 0x5781, 0x5787, 0x5788, 0x5789, 0x578A, 0x578D, 0x578E,
    0x578F, 0x5790, 0x5791, 0x5794, 0x5795, 0x5796, 0x5797, 0x5798,
    0x5799, 0x579A, 0x579C, 0x579D, 0x579E, 0x579F, 0x57A5, 0x57A8,
    0x57AA, 0x57AC, 0x57AF, 0x57B0, 0x57B1, 0x57B3, 0x57B5, 0x57B6,
    0x57B7, 0x57B9, 0x57BA, 0x57BB, 0x57BC, 0x57BD, 0x57BE, 0x57BF,
    0x57C0, 0x57C1, 0x57C4, 0x57C5, 0x57C6, 0x57C7, 0x57C8, 0x57C9,
    0x57CA, 0x57CC, 0x57CD, 0x57D0, 0x57D1, 0x57D3, 0x57D6, 0x57D7,
    0x57DB, 0x57DC, 0x57DE, 0x57E1, 0x57E2, 0x57E3, 0x57E5, 0x57E6,
    0x57E7, 0x57E8, 0x57E9, 0x57EA, 0x57EB, 0x57EC, 0x57EE, 0x57F0,
    0x57F1, 0x57F2, 0x57F3, 0x57F5, 0x57F6, 0x57F7, 0x57FB, 0x57FC,
    0x57FE, 0x57FF, 0x5801, 0x5803, 0x5804, 0x5805, 0x5808, 0x5809,
    0x580A, 0x580C, 0x580E, 0x580F, 0x5810, 0x5812, 0x5813, 0x5814,
    0x5816, 0x5817, 0x5818, 0x581A, 0x581B, 0x581C, 0x581D, 0x581F,
    0x5822, 0x5823, 0x5825, 0x5826, 0x5827, 0x5828, 0x5829, 0x582B,
    0x582C, 0x582D, 0x582E, 0x582F, 0x5831, 0x5832, 0x5833, 0x5834,
    0x5836, 0x5837, 0x5838, 0x5839, 0x583A, 0x583B, 0x583C, 0x583D,
    0x583E, 0x583F, 0x5840, 0x5841, 0x5842, 0x5843, 0x5845, 0x5846,
    0x5847, 0x5848, 0x5849, 0x584A, 0x584B, 0x584E, 0x584F, 0x5850,
    0x5852, 0x5853, 0x5855, 0x5856, 0x5857, 0x5859, 0x585A, 0x585B,
    0x585C, 0x585D, 0x585F, 0x5860, 0x5861, 0x5862, 0x5863, 0x5864,
    0x5866, 0x5867, 0x5868, 0x5869, 0x586A, 0x586D, 0x586E, 0x586F,
    0x5870, 0x5871, 0x5872, 0x5873, 0x5874, 0x5875, 0x5876, 0x5877,
    0x5878, 0x5879, 0x587A, 0x587B, 0x587C, 0x587D, 0x587F, 0x5882,
    0x5884, 0x5886, 0x5887, 0x5888, 0x588A, 0x588B, 0x588C, 0x588D,
    0x588E, 0x588F, 0x5890, 0x5891, 0x5894, 0x5895, 0x5896, 0x5897,
    0x5898, 0x589B, 0x589C, 0x589D, 0x58A0, 0x58A1, 0x58A2, 0x58A3,
    0x58A4, 0x58A5, 0x58A6, 0x58A7, 0x58AA, 0x58AB, 0x58AC, 0x58AD,
    0x58AE, 0x58AF, 0x58B0, 0x58B1, 0x58B2, 0x58B3, 0x58B4, 0x58B5,
    0x58B6, 0x58B7, 0x58B8, 0x58B9, 0x58BA, 0x58BB, 0x58BD, 0x58BE,
    0x58BF, 0x58C0, 0x58C2, 0x58C3, 0x58C4, 0x58C6, 0x58C7, 0x58C8,
    0x58C9, 0x58CA, 0x58CB, 0x58CC, 0x58CD, 0x58CE, 0x58CF, 0x58D0,
    0x58D2, 0x58D3, 0x58D4, 0x58D6, 0x58D7, 0x58D8, 0x58D9, 0x58DA,
    0x58DB, 0x58DC, 0x58DD, 0x58DE, 0x58DF, 0x58E0, 0x58E1, 0x58E2,
    0x58E3, 0x58E5, 0x58E6, 0x58E7, 0x58E8, 0x58E9, 0x58EA, 0x58ED,
    0x58EF, 0x58F1, 0x58F2, 0x58F4, 0x58F5, 0x58F7, 0x58F8, 0x58FA,
    0x58FB, 0x58FC, 0x58FD, 0x58FE, 0x58FF, 0x5900, 0x5901, 0x5903,
    0x5905, 0x5906, 0x5908, 0x5909, 0x590A, 0x590B, 0x590C, 0x590E,
    0x5910, 0x5911, 0x5912, 0x5913, 0x5917, 0x5918, 0x591B, 0x591D,
    0x591E, 0x5920, 0x5921, 0x5922, 0x5923, 0x5926, 0x5928, 0x592C,
    0x5930, 0x5932, 0x5933, 0x5935, 0x5936, 0x593B, 0x593D, 0x593E,
    0x593F, 0x5940, 0x5943, 0x5945, 0x5946, 0x594A, 0x594C, 0x594D,
    0x5950, 0x5952, 0x5953, 0x5959, 0x595B, 0x595C, 0x595D, 0x595E,
    0x595F, 0x5961, 0x5963, 0x5964, 0x5966, 0x5967, 0x5968, 0x5969,
    0x596A, 0x596B, 0x596C, 0x596D, 0x596E, 0x596F, 0x5970, 0x5971,
    0x5972, 0x5975, 0x5977, 0x597A, 0x597B, 0x597C, 0x597E, 0x597F,
    0x5980, 0x5985, 0x5989, 0x598B, 0x598C, 0x598E, 0x598F, 0x5990,
    0x5991, 0x5994, 0x5995, 0x5998, 0x599A, 0x599B, 0x599C, 0x599D,
    0x599F, 0x59A0, 0x59A1, 0x59A2, 0x59A6, 0x59A7, 0x59AC, 0x59AD,
    0x59B0, 0x59B1, 0x59B3, 0x59B4, 0x59B5, 0x59B6, 0x59B7, 0x59B8,
    0x59BA, 0x59BC, 0x59BD, 0x59BF, 0x59C0, 0x59C1, 0x59C2, 0x59C3,
    0x59C4, 0x59C5, 0x59C7, 0x59C8, 0x59C9, 0x59CC, 0x59CD, 0x59CE,
    0x59CF, 0x59D5, 0x59D6, 0x59D9, 0x59DB, 0x59DE, 0x59DF, 0x59E0,
    0x59E1, 0x59E2, 0x59E4, 0x59E6, 0x59E7, 0x59E9, 0x59EA, 0x59EB,
    0x59ED, 0x59EE, 0x59EF, 0x59F0, 0x59F1, 0x59F2, 0x59F3, 0x59F4,
    0x59F5, 0x59F6, 0x59F7, 0x59F8, 0x59FA, 0x59FC, 0x59FD, 0x59FE,
    0x5A00, 0x5A02, 0x5A0A, 0x5A0B, 0x5A0D, 0x5A0E, 0x5A0F, 0x5A10,
    0x5A12, 0x5A14, 0x5A15, 0x5A16, 0x5A17, 0x5A19, 0x5A1A, 0x5A1B,
    0x5A1D, 0x5A1E, 0x5A21, 0x5A22, 0x5A24, 0x5A26, 0x5A27, 0x5A28,
    0x5A2A, 0x5A2B, 0x5A2C, 0x5A2D, 0x5A2E, 0x5A2F, 0x5A30, 0x5A33,
    0x5A35, 0x5A37, 0x5A38, 0x5A39, 0x5A3A, 0x5A3B, 0x5A3D, 0x5A3E,
    0x5A3F, 0x5A41, 0x5A42, 0x5A43, 0x5A44, 0x5A45, 0x5A47, 0x5A48,
    0x5A4B, 0x5A4C, 0x5A4D, 0x5A4E, 0x5A4F, 0x5A50, 0x5A51, 0x5A52,
    0x5A53, 0x5A54, 0x5A56, 0x5A57, 0x5A58, 0x5A59, 0x5A5B, 0x5A5C,
    0x5A5D, 0x5A5E, 0x5A5F, 0x5A60, 0x5A61, 0x5A63, 0x5A64, 0x5A65,
    0x5A66, 0x5A68, 0x5A69, 0x5A6B, 0x5A6C, 0x5A6D, 0x5A6E, 0x5A6F,
    0x5A70, 0x5A71, 0x5A72, 0x5A73, 0x5A78, 0x5A79, 0x5A7B, 0x5A7C,
    0x5A7D, 0x5A7E, 0x5A80, 0x5A81, 0x5A82, 0x5A83, 0x5A84, 0x5A85,
    0x5A86, 0x5A87, 0x5A88, 0x5A89, 0x5A8A, 0x5A8B, 0x5A8C, 0x5A8D,
    0x5A8E, 0x5A8F, 0x5A90, 0x5A91, 0x5A93, 0x5A94, 0x5A95, 0x5A96,
    0x5A97, 0x5A98, 0x5A99, 0x5A9C, 0x5A9D, 0x5A9E, 0x5A9F, 0x5AA0,
    0x5AA1, 0x5AA2, 0x5AA3, 0x5AA4, 0x5AA5, 0x5AA6, 0x5AA7, 0x5AA8,
    0x5AA9, 0x5AAB, 0x5AAC, 0x5AAD, 0x5AAE, 0x5AAF, 0x5AB0, 0x5AB1,
    0x5AB4, 0x5AB6, 0x5AB7, 0x5AB9, 0x5ABA, 0x5ABB, 0x5ABC, 0x5ABD,
    0x5ABF, 0x5AC0, 0x5AC3, 0x5AC4, 0x5AC5, 0x5AC6, 0x5AC7, 0x5AC8,
    0x5ACA, 0x5ACB, 0x5ACD, 0x5ACE, 0x5ACF, 0x5AD0, 0x5AD1, 0x5AD3,
    0x5AD5, 0x5AD7, 0x5AD9, 0x5ADA, 0x5ADB, 0x5ADD, 0x5ADE, 0x5ADF,
    0x5AE2, 0x5AE4, 0x5AE5, 0x5AE7, 0x5AE8, 0x5AEA, 0x5AEC, 0x5AED,
    0x5AEE, 0x5AEF, 0x5AF0, 0x5AF2, 0x5AF3, 0x5AF4, 0x5AF5, 0x5AF6,
    0x5AF7, 0x5AF8, 0x5AF9, 0x5AFA, 0x5AFB, 0x5AFC, 0x5AFD, 0x5AFE,
    0x5AFF, 0x5B00, 0x5B01, 0x5B02, 0x5B03, 0x5B04, 0x5B05, 0x5B06,
    0x5B07, 0x5B08, 0x5B0A, 0x5B0B, 0x5B0C, 0x5B0D, 0x5B0E, 0x5B0F,
    0x5B10, 0x5B11, 0x5B12, 0x5B13, 0x5B14, 0x5B15, 0x5B18, 0x5B19,
    0x5B1A, 0x5B1B, 0x5B1C, 0x5B1D, 0x5B1E, 0x5B1F, 0x5B20, 0x5B21,
    0x5B22, 0x5B23, 0x5B24, 0x5B25, 0x5B26, 0x5B27, 0x5B28, 0x5B29,
    0x5B2A, 0x5B2B, 0x5B2C, 0x5B2D, 0x5B2E, 0x5B2F, 0x5B30, 0x5B31,
    0x5B33, 0x5B35, 0x5B36, 0x5B38, 0x5B39, 0x5B3A, 0x5B3B, 0x5B3C,
    0x5B3D, 0x5B3E, 0x5B3F, 0x5B41, 0x5B42, 0x5B43, 0x5B44, 0x5B45,
    0x5B46, 0x5B47, 0x5B48, 0x5B49, 0x5B4A, 0x5B4B, 0x5B4C, 0x5B4D,
    0x5B4E, 0x5B4F, 0x5B52, 0x5B56, 0x5B5E, 0x5B60, 0x5B61, 0x5B67,
    0x5B68, 0x5B6B, 0x5B6D, 0x5B6E, 0x5B6F, 0x5B72, 0x5B74, 0x5B76,
    0x5B77, 0x5B78, 0x5B79, 0x5B7B, 0x5B7C, 0x5B7E, 0x5B7F, 0x5B82,
    0x5B86, 0x5B8A, 0x5B8D, 0x5B8E, 0x5B90, 0x5B91, 0x5B92, 0x5B94,
    0x5B96, 0x5B9F, 0x5BA7, 0x5BA8, 0x5BA9, 0x5BAC, 0x5BAD, 0x5BAE,
    0x5BAF, 0x5BB1, 0x5BB2, 0x5BB7, 0x5BBA, 0x5BBB, 0x5BBC, 0x5BC0,
    0x5BC1, 0x5BC3, 0x5BC8, 0x5BC9, 0x5BCA, 0x5BCB, 0x5BCD, 0x5BCE,
    0x5BCF, 0x5BD1, 0x5BD4, 0x5BD5, 0x5BD6, 0x5BD7, 0x5BD8, 0x5BD9,
    0x5BDA, 0x5BDB, 0x5BDC, 0x5BE0, 0x5BE2, 0x5BE3, 0x5BE6, 0x5BE7,
    0x5BE9, 0x5BEA, 0x5BEB, 0x5BEC, 0x5BED, 0x5BEF, 0x5BF1, 0x5BF2,
    0x5BF3, 0x5BF4, 0x5BF5, 0x5BF6, 0x5BF7, 0x5BFD, 0x5BFE, 0x5C00,
    0x5C02, 0x5C03, 0x5C05, 0x5C07, 0x5C08, 0x5C0B, 0x5C0C, 0x5C0D,
    0x5C0E, 0x5C10, 0x5C12, 0x5C13, 0x5C17, 0x5C19, 0x5C1B, 0x5C1E,
    0x5C1F, 0x5C20, 0x5C21, 0x5C23, 0x5C26, 0x5C28, 0x5C29, 0x5C2A,
    0x5C2B, 0x5C2D, 0x5C2E, 0x5C2F, 0x5C30, 0x5C32, 0x5C33, 0x5C35,
    0x5C36, 0x5C37, 0x5C43, 0x5C44, 0x5C46, 0x5C47, 0x5C4C, 0x5C4D,
    0x5C52, 0x5C53, 0x5C54, 0x5C56, 0x5C57, 0x5C58, 0x5C5A, 0x5C5B,
    0x5C5C, 0x5C5D, 0x5C5F, 0x5C62, 0x5C64, 0x5C67, 0x5C68, 0x5C69,
    0x5C6A, 0x5C6B, 0x5C6C, 0x5C6D, 0x5C70, 0x5C72, 0x5C73, 0x5C74,
    0x5C75, 0x5C76, 0x5C77, 0x5C78, 0x5C7B, 0x5C7C, 0x5C7D, 0x5C7E,
    0x5C80, 0x5C83, 0x5C84, 0x5C85, 0x5C86, 0x5C87, 0x5C89, 0x5C8A,
    0x5C8B, 0x5C8E, 0x5C8F, 0x5C92, 0x5C93, 0x5C95, 0x5C9D, 0x5C9E,
    0x5C9F, 0x5CA0, 0x5CA1, 0x5CA4, 0x5CA5, 0x5CA6, 0x5CA7, 0x5CA8,
    0x5CAA, 0x5CAE, 0x5CAF, 0x5CB0, 0x5CB2, 0x5CB4, 0x5CB6, 0x5CB9,
    0x5CBA, 0x5CBB, 0x5CBC, 0x5CBE, 0x5CC0, 0x5CC2, 0x5CC3, 0x5CC5,
    0x5CC6, 0x5CC7, 0x5CC8, 0x5CC9, 0x5CCA, 0x5CCC, 0x5CCD, 0x5CCE,
    0x5CCF, 0x5CD0, 0x5CD1, 0x5CD3, 0x5CD4, 0x5CD5, 0x5CD6, 0x5CD7,
    0x5CD8, 0x5CDA, 0x5CDB, 0x5CDC, 0x5CDD, 0x5CDE, 0x5CDF, 0x5CE0,
    0x5CE2, 0x5CE3, 0x5CE7, 0x5CE9, 0x5CEB, 0x5CEC, 0x5CEE, 0x5CEF,
    0x5CF1, 0x5CF2, 0x5CF3, 0x5CF4, 0x5CF5, 0x5CF6, 0x5CF7, 0x5CF8,
    0x5CF9, 0x5CFA, 0x5CFC, 0x5CFD, 0x5CFE, 0x5CFF, 0x5D00, 0x5D01,
    0x5D04, 0x5D05, 0x5D08, 0x5D09, 0x5D0A, 0x5D0B, 0x5D0C, 0x5D0D,
    0x5D0F, 0x5D10, 0x5D11, 0x5D12, 0x5D13, 0x5D15, 0x5D17, 0x5D18,
    0x5D19, 0x5D1A, 0x5D1C, 0x5D1D, 0x5D1F, 0x5D20, 0x5D21, 0x5D22,
    0x5D23, 0x5D25, 0x5D28, 0x5D2A, 0x5D2B, 0x5D2C, 0x5D2F, 0x5D30,
    0x5D31, 0x5D32, 0x5D33, 0x5D35, 0x5D36, 0x5D37, 0x5D38, 0x5D39,
    0x5D3A, 0x5D3B, 0x5D3C, 0x5D3F, 0x5D40, 0x5D41, 0x5D42, 0x5D43,
    0x5D44, 0x5D45, 0x5D46, 0x5D48, 0x5D49, 0x5D4D, 0x5D4E, 0x5D4F,
    0x5D50, 0x5D51, 0x5D52, 0x5D53, 0x5D54, 0x5D55, 0x5D56, 0x5D57,
    0x5D59, 0x5D5A, 0x5D5C, 0x5D5E, 0x5D5F, 0x5D60, 0x5D61, 0x5D62,
    0x5D63, 0x5D64, 0x5D65, 0x5D66, 0x5D67, 0x5D68, 0x5D6A, 0x5D6D,
    0x5D6E, 0x5D70, 0x5D71, 0x5D72, 0x5D73, 0x5D75, 0x5D76, 0x5D77,
    0x5D78, 0x5D79, 0x5D7A, 0x5D7B, 0x5D7C, 0x5D7D, 0x5D7E, 0x5D7F,
    0x5D80, 0x5D81, 0x5D83, 0x5D84, 0x5D85, 0x5D86, 0x5D87, 0x5D88,
    0x5D89, 0x5D8A, 0x5D8B, 0x5D8C, 0x5D8D, 0x5D8E, 0x5D8F, 0x5D90,
    0x5D91, 0x5D92, 0x5D93, 0x5D94, 0x5D95, 0x5D96, 0x5D97, 0x5D98,
    0x5D9A, 0x5D9B, 0x5D9C, 0x5D9E, 0x5D9F, 0x5DA0, 0x5DA1, 0x5DA2,
    0x5DA3, 0x5DA4, 0x5DA5, 0x5DA6, 0x5DA7, 0x5DA8, 0x5DA9, 0x5DAA,
    0x5DAB, 0x5DAC, 0x5DAD, 0x5DAE, 0x5DAF, 0x5DB0, 0x5DB1, 0x5DB2,
    0x5DB3, 0x5DB4, 0x5DB5, 0x5DB6, 0x5DB8, 0x5DB9, 0x5DBA, 0x5DBB,
    0x5DBC, 0x5DBD, 0x5DBE, 0x5DBF, 0x5DC0, 0x5DC1, 0x5DC2, 0x5DC3,
    0x5DC4, 0x5DC6, 0x5DC7, 0x5DC8, 0x5DC9, 0x5DCA, 0x5DCB, 0x5DCC,
    0x5DCE, 0x5DCF, 0x5DD0, 0x5DD1, 0x5DD2, 0x5DD3, 0x5DD4, 0x5DD5,
    0x5DD6, 0x5DD7, 0x5DD8, 0x5DD9, 0x5DDA, 0x5DDC, 0x5DDF, 0x5DE0,
    0x5DE3, 0x5DE4, 0x5DEA, 0x5DEC, 0x5DED, 0x5DF0, 0x5DF5, 0x5DF6,
    0x5DF8, 0x5DF9, 0x5DFA, 0x5DFB, 0x5DFC, 0x5DFF, 0x5E00, 0x5E04,
    0x5E07, 0x5E09, 0x5E0A, 0x5E0B, 0x5E0D, 0x5E0E, 0x5E12, 0x5E13,
    0x5E17, 0x5E1E, 0x5E1F, 0x5E20, 0x5E21, 0x5E22, 0x5E23, 0x5E24,
    0x5E25, 0x5E28, 0x5E29, 0x5E2A, 0x5E2B, 0x5E2C, 0x5E2F, 0x5E30,
    0x5E32, 0x5E33, 0x5E34, 0x5E35, 0x5E36, 0x5E39, 0x5E3A, 0x5E3E,
    0x5E3F, 0x5E40, 0x5E41, 0x5E43, 0x5E46, 0x5E47, 0x5E48, 0x5E49,
    0x5E4A, 0x5E4B, 0x5E4D, 0x5E4E, 0x5E4F, 0x5E50, 0x5E51, 0x5E52,
    0x5E53, 0x5E56, 0x5E57, 0x5E58, 0x5E59, 0x5E5A, 0x5E5C, 0x5E5D,
    0x5E5F, 0x5E60, 0x5E63, 0x5E64, 0x5E65, 0x5E66, 0x5E67, 0x5E68,
    0x5E69, 0x5E6A, 0x5E6B, 0x5E6C, 0x5E6D, 0x5E6E, 0x5E6F, 0x5E70,
    0x5E71, 0x5E75, 0x5E77, 0x5E79, 0x5E7E, 0x5E81, 0x5E82, 0x5E83,
    0x5E85, 0x5E88, 0x5E89, 0x5E8C, 0x5E8D, 0x5E8E, 0x5E92, 0x5E98,
    0x5E9B, 0x5E9D, 0x5EA1, 0x5EA2, 0x5EA3, 0x5EA4, 0x5EA8, 0x5EA9,
    0x5EAA, 0x5EAB, 0x5EAC, 0x5EAE, 0x5EAF, 0x5EB0, 0x5EB1, 0x5EB2,
    0x5EB4, 0x5EBA, 0x5EBB, 0x5EBC, 0x5EBD, 0x5EBF, 0x5EC0, 0x5EC1,
    0x5EC2, 0x5EC3, 0x5EC4, 0x5EC5, 0x5EC6, 0x5EC7, 0x5EC8, 0x5ECB,
    0x5ECC, 0x5ECD, 0x5ECE, 0x5ECF, 0x5ED0, 0x5ED4, 0x5ED5, 0x5ED7,
    0x5ED8, 0x5ED9, 0x5EDA, 0x5EDC, 0x5EDD, 0x5EDE, 0x5EDF, 0x5EE0,
    0x5EE1, 0x5EE2, 0x5EE3, 0x5EE4, 0x5EE5, 0x5EE6, 0x5EE7, 0x5EE9,
    0x5EEB, 0x5EEC, 0x5EED, 0x5EEE, 0x5EEF, 0x5EF0, 0x5EF1, 0x5EF2,
    0x5EF3, 0x5EF5, 0x5EF8, 0x5EF9, 0x5EFB, 0x5EFC, 0x5EFD, 0x5F05,
    0x5F06, 0x5F07, 0x5F09, 0x5F0C, 0x5F0D, 0x5F0E, 0x5F10, 0x5F12,
    0x5F14, 0x5F16, 0x5F19, 0x5F1A, 0x5F1C, 0x5F1D, 0x5F1E, 0x5F21,
    0x5F22, 0x5F23, 0x5F24, 0x5F28, 0x5F2B, 0x5F2C, 0x5F2E, 0x5F30,
    0x5F32, 0x5F33, 0x5F34, 0x5F35, 0x5F36, 0x5F37, 0x5F38, 0x5F3B,
    0x5F3D, 0x5F3E, 0x5F3F, 0x5F41, 0x5F42, 0x5F43, 0x5F44, 0x5F45,
    0x5F46, 0x5F47, 0x5F48, 0x5F49, 0x5F4A, 0x5F4B, 0x5F4C, 0x5F4D,
    0x5F4E, 0x5F4F, 0x5F51, 0x5F54, 0x5F59, 0x5F5A, 0x5F5B, 0x5F5C,
    0x5F5E, 0x5F5F, 0x5F60, 0x5F63, 0x5F65, 0x5F67, 0x5F68, 0x5F6B,
    0x5F6E, 0x5F6F, 0x5F72, 0x5F74, 0x5F75, 0x5F76, 0x5F78, 0x5F7A,
    0x5F7D, 0x5F7E, 0x5F7F, 0x5F83, 0x5F86, 0x5F8D, 0x5F8E, 0x5F8F,
    0x5F91, 0x5F93, 0x5F94, 0x5F96, 0x5F9A, 0x5F9B, 0x5F9D, 0x5F9E,
    0x5F9F, 0x5FA0, 0x5FA2, 0x5FA3, 0x5FA4, 0x5FA5, 0x5FA6, 0x5FA7,
    0x5FA9, 0x5FAB, 0x5FAC, 0x5FAF, 0x5FB0, 0x5FB1, 0x5FB2, 0x5FB3,
    0x5FB4, 0x5FB6, 0x5FB8, 0x5FB9, 0x5FBA, 0x5FBB, 0x5FBE, 0x5FBF,
    0x5FC0, 0x5FC1, 0x5FC2, 0x5FC7, 0x5FC8, 0x5FCA, 0x5FCB, 0x5FCE,
    0x5FD3, 0x5FD4, 0x5FD5, 0x5FDA, 0x5FDB, 0x5FDC, 0x5FDE, 0x5FDF,
    0x5FE2, 0x5FE3, 0x5FE5, 0x5FE6, 0x5FE8, 0x5FE9, 0x5FEC, 0x5FEF,
    0x5FF0, 0x5FF2, 0x5FF3, 0x5FF4, 0x5FF6, 0x5FF7, 0x5FF9, 0x5FFA,
    0x5FFC, 0x6007, 0x6008, 0x6009, 0x600B, 0x600C, 0x6010, 0x6011,
    0x6013, 0x6017, 0x6018, 0x601A, 0x601E, 0x601F, 0x6022, 0x6023,
    0x6024, 0x602C, 0x602D, 0x602E, 0x6030, 0x6031, 0x6032, 0x6033,
    0x6034, 0x6036, 0x6037, 0x6038, 0x6039, 0x603A, 0x603D, 0x603E,
    0x6040, 0x6044, 0x6045, 0x6046, 0x6047, 0x6048, 0x6049, 0x604A,
    0x604C, 0x604E, 0x604F, 0x6051, 0x6053, 0x6054, 0x6056, 0x6057,
    0x6058, 0x605B, 0x605C, 0x605E, 0x605F, 0x6060, 0x6061, 0x6065,
    0x6066, 0x606E, 0x6071, 0x6072, 0x6074, 0x6075, 0x6077, 0x607E,
    0x6080, 0x6081, 0x6082, 0x6085, 0x6086, 0x6087, 0x6088, 0x608A,
    0x608B, 0x608E, 0x608F, 0x6090, 0x6091, 0x6093, 0x6095, 0x6097,
    0x6098, 0x6099, 0x609C, 0x609E, 0x60A1, 0x60A2, 0x60A4, 0x60A5,
    0x60A7, 0x60A9, 0x60AA, 0x60AE, 0x60B0, 0x60B3, 0x60B5, 0x60B6,
    0x60B7, 0x60B9, 0x60BA, 0x60BD, 0x60BE, 0x60BF, 0x60C0, 0x60C1,
    0x60C2, 0x60C3, 0x60C4, 0x60C7, 0x60C8, 0x60C9, 0x60CC, 0x60CD,
    0x60CE, 0x60CF, 0x60D0, 0x60D2, 0x60D3, 0x60D4, 0x60D6, 0x60D7,
    0x60D9, 0x60DB, 0x60DE, 0x60E1, 0x60E2, 0x60E3, 0x60E4, 0x60E5,
    0x60EA, 0x60F1, 0x60F2, 0x60F5, 0x60F7, 0x60F8, 0x60FB, 0x60FC,
    0x60FD, 0x60FE, 0x60FF, 0x6102, 0x6103, 0x6104, 0x6105, 0x6107,
    0x610A, 0x610B, 0x610C, 0x6110, 0x6111, 0x6112, 0x6113, 0x6114,
    0x6116, 0x6117, 0x6118, 0x6119, 0x611B, 0x611C, 0x611D, 0x611E,
    0x6121, 0x6122, 0x6125, 0x6128, 0x6129, 0x612A, 0x612C, 0x612D,
    0x612E, 0x612F, 0x6130, 0x6131, 0x6132, 0x6133, 0x6134, 0x6135,
    0x6136, 0x6137, 0x6138, 0x6139, 0x613A, 0x613B, 0x613C, 0x613D,
    0x613E, 0x6140, 0x6141, 0x6142, 0x6143, 0x6144, 0x6145, 0x6146,
    0x6147, 0x6149, 0x614B, 0x614D, 0x614F, 0x6150, 0x6152, 0x6153,
    0x6154, 0x6156, 0x6157, 0x6158, 0x6159, 0x615A, 0x615B, 0x615C,
    0x615E, 0x615F, 0x6160, 0x6161, 0x6163, 0x6164, 0x6165, 0x6166,
    0x6169, 0x616A, 0x616B, 0x616C, 0x616D, 0x616E, 0x616F, 0x6171,
    0x6172, 0x6173, 0x6174, 0x6176, 0x6178, 0x6179, 0x617A, 0x617B,
    0x617C, 0x617D, 0x617E, 0x617F, 0x6180, 0x6181, 0x6182, 0x6183,
    0x6184, 0x6185, 0x6186, 0x6187, 0x6188, 0x6189, 0x618A, 0x618C,
    0x618D, 0x618F, 0x6190, 0x6191, 0x6192, 0x6193, 0x6195, 0x6196,
    0x6197, 0x6198, 0x6199, 0x619A, 0x619B, 0x619C, 0x619E, 0x619F,
    0x61A0, 0x61A1, 0x61A2, 0x61A3, 0x61A4, 0x61A5, 0x61A6, 0x61AA,
    0x61AB, 0x61AD, 0x61AE, 0x61AF, 0x61B0, 0x61B1, 0x61B2, 0x61B3,
    0x61B4, 0x61B5, 0x61B6, 0x61B8, 0x61B9, 0x61BA, 0x61BB, 0x61BC,
    0x61BD, 0x61BF, 0x61C0, 0x61C1, 0x61C3, 0x61C4, 0x61C5, 0x61C6,
    0x61C7, 0x61C9, 0x61CC, 0x61CD, 0x61CE, 0x61CF, 0x61D0, 0x61D3,
    0x61D5, 0x61D6, 0x61D7, 0x61D8, 0x61D9, 0x61DA, 0x61DB, 0x61DC,
    0x61DD, 0x61DE, 0x61DF, 0x61E0, 0x61E1, 0x61E2, 0x61E3, 0x61E4,
    0x61E5, 0x61E7, 0x61E8, 0x61E9, 0x61EA, 0x61EB, 0x61EC, 0x61ED,
    0x61EE, 0x61EF, 0x61F0, 0x61F1, 0x61F2, 0x61F3, 0x61F4, 0x61F6,
    0x61F7, 0x61F8, 0x61F9, 0x61FA, 0x61FB, 0x61FC, 0x61FD, 0x61FE,
    0x6200, 0x6201, 0x6202, 0x6203, 0x6204, 0x6205, 0x6207, 0x6209,
    0x6213, 0x6214, 0x6219, 0x621C, 0x621D, 0x621E, 0x6220, 0x6223,
    0x6226, 0x6227, 0x6228, 0x6229, 0x622B, 0x622D, 0x622F, 0x6230,
    0x6231, 0x6232, 0x6235, 0x6236, 0x6238, 0x6239, 0x623A, 0x623B,
    0x623C, 0x6242, 0x6244, 0x6245, 0x6246, 0x624A, 0x624F, 0x6250,
    0x6255, 0x6256, 0x6257, 0x6259, 0x625A, 0x625C, 0x625D, 0x625E,
    0x625F, 0x6260, 0x6261, 0x6262, 0x6264, 0x6265, 0x6268, 0x6271,
    0x6272, 0x6274, 0x6275, 0x6277, 0x6278, 0x627A, 0x627B, 0x627D,
    0x6281, 0x6282, 0x6283, 0x6285, 0x6286, 0x6287, 0x6288, 0x628B,
    0x628C, 0x628D, 0x628E, 0x628F, 0x6290, 0x6294, 0x6299, 0x629C,
    0x629D, 0x629E, 0x62A3, 0x62A6, 0x62A7, 0x62A9, 0x62AA, 0x62AD,
    0x62AE, 0x62AF, 0x62B0, 0x62B2, 0x62B3, 0x62B4, 0x62B6, 0x62B7,
    0x62B8, 0x62BA, 0x62BE, 0x62C0, 0x62C1, 0x62C3, 0x62CB, 0x62CF,
    0x62D1, 0x62D5, 0x62DD, 0x62DE, 0x62E0, 0x62E1, 0x62E4, 0x62EA,
    0x62EB, 0x62F0, 0x62F2, 0x62F5, 0x62F8, 0x62F9, 0x62FA, 0x62FB,
    0x6300, 0x6303, 0x6304, 0x6305, 0x6306, 0x630A, 0x630B, 0x630C,
    0x630D, 0x630F, 0x6310, 0x6312, 0x6313, 0x6314, 0x6315, 0x6317,
    0x6318, 0x6319, 0x631C, 0x6326, 0x6327, 0x6329, 0x632C, 0x632D,
    0x632E, 0x6330, 0x6331, 0x6333, 0x6334, 0x6335, 0x6336, 0x6337,
    0x6338, 0x633B, 0x633C, 0x633E, 0x633F, 0x6340, 0x6341, 0x6344,
    0x6347, 0x6348, 0x634A, 0x6351, 0x6352, 0x6353, 0x6354, 0x6356,
    0x6357, 0x6358, 0x6359, 0x635A, 0x635B, 0x635C, 0x635D, 0x6360,
    0x6364, 0x6365, 0x6366, 0x6368, 0x636A, 0x636B, 0x636C, 0x636F,
    0x6370, 0x6372, 0x6373, 0x6374, 0x6375, 0x6378, 0x6379, 0x637C,
    0x637D, 0x637E, 0x637F, 0x6381, 0x6383, 0x6384, 0x6385, 0x6386,
    0x638B, 0x638D, 0x6391, 0x6393, 0x6394, 0x6395, 0x6397, 0x6399,
    0x639A, 0x639B, 0x639C, 0x639D, 0x639E, 0x639F, 0x63A1, 0x63A4,
    0x63A6, 0x63AB, 0x63AF, 0x63B1, 0x63B2, 0x63B5, 0x63B6, 0x63B9,
    0x63BB, 0x63BD, 0x63BF, 0x63C0, 0x63C1, 0x63C2, 0x63C3, 0x63C5,
    0x63C7, 0x63C8, 0x63CA, 0x63CB, 0x63CC, 0x63D1, 0x63D3, 0x63D4,
    0x63D5, 0x63D7, 0x63D8, 0x63D9, 0x63DA, 0x63DB, 0x63DC, 0x63DD,
    0x63DF, 0x63E2, 0x63E4, 0x63E5, 0x63E6, 0x63E7, 0x63E8, 0x63EB,
    0x63EC, 0x63EE, 0x63EF, 0x63F0, 0x63F1, 0x63F3, 0x63F5, 0x63F7,
    0x63F9, 0x63FA, 0x63FB, 0x63FC, 0x63FE, 0x6403, 0x6404, 0x6406,
    0x6407, 0x6408, 0x6409, 0x640A, 0x640D, 0x640E, 0x6411, 0x6412,
    0x6415, 0x6416, 0x6417, 0x6418, 0x6419, 0x641A, 0x641D, 0x641F,
    0x6422, 0x6423, 0x6424, 0x6425, 0x6427, 0x6428, 0x6429, 0x642B,
    0x642E, 0x642F, 0x6430, 0x6431, 0x6432, 0x6433, 0x6435, 0x6436,
    0x6437, 0x6438, 0x6439, 0x643B, 0x643C, 0x643E, 0x6440, 0x6442,
    0x6443, 0x6449, 0x644B, 0x644C, 0x644D, 0x644E, 0x644F, 0x6450,
    0x6451, 0x6453, 0x6455, 0x6456, 0x6457, 0x6459, 0x645A, 0x645B,
    0x645C, 0x645D, 0x645F, 0x6460, 0x6461, 0x6462, 0x6463, 0x6464,
    0x6465, 0x6466, 0x6468, 0x646A, 0x646B, 0x646C, 0x646E, 0x646F,
    0x6470, 0x6471, 0x6472, 0x6473, 0x6474, 0x6475, 0x6476, 0x6477,
    0x647B, 0x647C, 0x647D, 0x647E, 0x647F, 0x6480, 0x6481, 0x6483,
    0x6486, 0x6488, 0x6489, 0x648A, 0x648B, 0x648C, 0x648D, 0x648E,
    0x648F, 0x6490, 0x6493, 0x6494, 0x6497, 0x6498, 0x649A, 0x649B,
    0x649C, 0x649D, 0x649F, 0x64A0, 0x64A1, 0x64A2, 0x64A3, 0x64A5,
    0x64A6, 0x64A7, 0x64A8, 0x64AA, 0x64AB, 0x64AF, 0x64B1, 0x64B2,
    0x64B3, 0x64B4, 0x64B6, 0x64B9, 0x64BB, 0x64BD, 0x64BE, 0x64BF,
    0x64C1, 0x64C3, 0x64C4, 0x64C6, 0x64C7, 0x64C8, 0x64C9, 0x64CA,
    0x64CB, 0x64CC, 0x64CF, 0x64D1, 0x64D3, 0x64D4, 0x64D5, 0x64D6,
    0x64D9, 0x64DA, 0x64DB, 0x64DC, 0x64DD, 0x64DF, 0x64E0, 0x64E1,
    0x64E3, 0x64E5, 0x64E7, 0x64E8, 0x64E9, 0x64EA, 0x64EB, 0x64EC,
    0x64ED, 0x64EE, 0x64EF, 0x64F0, 0x64F1, 0x64F2, 0x64F3, 0x64F4,
    0x64F5, 0x64F6, 0x64F7, 0x64F8, 0x64F9, 0x64FA, 0x64FB, 0x64FC,
    0x64FD, 0x64FE, 0x64FF, 0x6501, 0x6502, 0x6503, 0x6504, 0x6505,
    0x6506, 0x6507, 0x6508, 0x650A, 0x650B, 0x650C, 0x650D, 0x650E,
    0x650F, 0x6510, 0x6511, 0x6513, 0x6514, 0x6515, 0x6516, 0x6517,
    0x6519, 0x651A, 0x651B, 0x651C, 0x651D, 0x651E, 0x651F, 0x6520,
    0x6521, 0x6522, 0x6523, 0x6524, 0x6526, 0x6527, 0x6528, 0x6529,
    0x652A, 0x652C, 0x652D, 0x6530, 0x6531, 0x6532, 0x6533, 0x6537,
    0x653A, 0x653C, 0x653D, 0x6540, 0x6541, 0x6542, 0x6543, 0x6544,
    0x6546, 0x6547, 0x654A, 0x654B, 0x654D, 0x654E, 0x6550, 0x6552,
    0x6553, 0x6554, 0x6557, 0x6558, 0x655A, 0x655C, 0x655F, 0x6560,
    0x6561, 0x6564, 0x6565, 0x6567, 0x6568, 0x6569, 0x656A, 0x656D,
    0x656E, 0x656F, 0x6571, 0x6573, 0x6575, 0x6576, 0x6578, 0x6579,
    0x657A, 0x657B, 0x657C, 0x657D, 0x657E, 0x657F, 0x6580, 0x6581,
    0x6582, 0x6583, 0x6584, 0x6585, 0x6586, 0x6588, 0x6589, 0x658A,
    0x658D, 0x658E, 0x658F, 0x6592, 0x6594, 0x6595, 0x6596, 0x6598,
    0x659A, 0x659D, 0x659E, 0x65A0, 0x65A2, 0x65A3, 0x65A6, 0x65A8,
    0x65AA, 0x65AC, 0x65AE, 0x65B1, 0x65B2, 0x65B3, 0x65B4, 0x65B5,
    0x65B6, 0x65B7, 0x65B8, 0x65BA, 0x65BB, 0x65BE, 0x65BF, 0x65C0,
    0x65C2, 0x65C7, 0x65C8, 0x65C9, 0x65CA, 0x65CD, 0x65D0, 0x65D1,
    0x65D3, 0x65D4, 0x65D5, 0x65D8, 0x65D9, 0x65DA, 0x65DB, 0x65DC,
    0x65DD, 0x65DE, 0x65DF, 0x65E1, 0x65E3, 0x65E4, 0x65EA, 0x65EB,
    0x65F2, 0x65F3, 0x65F4, 0x65F5, 0x65F8, 0x65F9, 0x65FB, 0x65FC,
    0x65FD, 0x65FE, 0x65FF, 0x6601, 0x6604, 0x6605, 0x6607, 0x6608,
    0x6609, 0x660B, 0x660D, 0x6610, 0x6611, 0x6612, 0x6616, 0x6617,
    0x6618, 0x661A, 0x661B, 0x661C, 0x661E, 0x6621, 0x6622, 0x6623,
    0x6624, 0x6626, 0x6629, 0x662A, 0x662B, 0x662C, 0x662E, 0x6630,
    0x6632, 0x6633, 0x6637, 0x6638, 0x6639, 0x663A, 0x663B, 0x663D,
    0x663F, 0x6640, 0x6642, 0x6644, 0x6645, 0x6646, 0x6647, 0x6648,
    0x6649, 0x664A, 0x664D, 0x664E, 0x6650, 0x6651, 0x6658, 0x6659,
    0x665B, 0x665C, 0x665D, 0x665E, 0x6660, 0x6662, 0x6663, 0x6665,
    0x6667, 0x6669, 0x666A, 0x666B, 0x666C, 0x666D, 0x6671, 0x6672,
    0x6673, 0x6675, 0x6678, 0x6679, 0x667B, 0x667C, 0x667D, 0x667F,
    0x6680, 0x6681, 0x6683, 0x6685, 0x6686, 0x6688, 0x6689, 0x668A,
    0x668B, 0x668D, 0x668E, 0x668F, 0x6690, 0x6692, 0x6693, 0x6694,
    0x6695, 0x6698, 0x6699, 0x669A, 0x669B, 0x669C, 0x669E, 0x669F,
    0x66A0, 0x66A1, 0x66A2, 0x66A3, 0x66A4, 0x66A5, 0x66A6, 0x66A9,
    0x66AA, 0x66AB, 0x66AC, 0x66AD, 0x66AF, 0x66B0, 0x66B1, 0x66B2,
    0x66B3, 0x66B5, 0x66B6, 0x66B7, 0x66B8, 0x66BA, 0x66BB, 0x66BC,
    0x66BD, 0x66BF, 0x66C0, 0x66C1, 0x66C2, 0x66C3, 0x66C4, 0x66C5,
    0x66C6, 0x66C7, 0x66C8, 0x66C9, 0x66CA, 0x66CB, 0x66CC, 0x66CD,
    0x66CE, 0x66CF, 0x66D0, 0x66D1, 0x66D2, 0x66D3, 0x66D4, 0x66D5,
    0x66D6, 0x66D7, 0x66D8, 0x66DA, 0x66DE, 0x66DF, 0x66E0, 0x66E1,
    0x66E2, 0x66E3, 0x66E4, 0x66E5, 0x66E7, 0x66E8, 0x66EA, 0x66EB,
    0x66EC, 0x66ED, 0x66EE, 0x66EF, 0x66F1, 0x66F5, 0x66F6, 0x66F8,
    0x66FA, 0x66FB, 0x66FD, 0x6701, 0x6702, 0x6703, 0x6704, 0x6705,
    0x6706, 0x6707, 0x670C, 0x670E, 0x670F, 0x6711, 0x6712, 0x6713,
    0x6716, 0x6718, 0x6719, 0x671A, 0x671C, 0x671E, 0x6720, 0x6721,
    0x6722, 0x6723, 0x6724, 0x6725, 0x6727, 0x6729, 0x672E, 0x6730,
    0x6732, 0x6733, 0x6736, 0x6737, 0x6738, 0x6739, 0x673B, 0x673C,
    0x673E, 0x673F, 0x6741, 0x6744, 0x6745, 0x6747, 0x674A, 0x674B,
    0x674D, 0x6752, 0x6754, 0x6755, 0x6757, 0x6758, 0x6759, 0x675A,
    0x675B, 0x675D, 0x6762, 0x6763, 0x6764, 0x6766, 0x6767, 0x676B,
    0x676C, 0x676E, 0x6771, 0x6774, 0x6776, 0x6778, 0x6779, 0x677A,
    0x677B, 0x677D, 0x6780, 0x6782, 0x6783, 0x6785, 0x6786, 0x6788,
    0x678A, 0x678C, 0x678D, 0x678E, 0x678F, 0x6791, 0x6792, 0x6793,
    0x6794, 0x6796, 0x6799, 0x679B, 0x679F, 0x67A0, 0x67A1, 0x67A4,
    0x67A6, 0x67A9, 0x67AC, 0x67AE, 0x67B1, 0x67B2, 0x67B4, 0x67B9,
    0x67BA, 0x67BB, 0x67BC, 0x67BD, 0x67BE, 0x67BF, 0x67C0, 0x67C2,
    0x67C5, 0x67C6, 0x67C7, 0x67C8, 0x67C9, 0x67CA, 0x67CB, 0x67CC,
    0x67CD, 0x67CE, 0x67D5, 0x67D6, 0x67D7, 0x67DB, 0x67DF, 0x67E1,
    0x67E3, 0x67E4, 0x67E6, 0x67E7, 0x67E8, 0x67EA, 0x67EB, 0x67ED,
    0x67EE, 0x67F2, 0x67F5, 0x67F6, 0x67F7, 0x67F8, 0x67F9, 0x67FA,
    0x67FB, 0x67FC, 0x67FE, 0x6801, 0x6802, 0x6803, 0x6804, 0x6806,
    0x680D, 0x6810, 0x6812, 0x6814, 0x6815, 0x6818, 0x6819, 0x681A,
    0x681B, 0x681C, 0x681E, 0x681F, 0x6820, 0x6822, 0x6823, 0x6824,
    0x6825, 0x6826, 0x6827, 0x6828, 0x682B, 0x682C, 0x682D, 0x682E,
    0x682F, 0x6830, 0x6831, 0x6834, 0x6835, 0x6836, 0x683A, 0x683B,
    0x683F, 0x6847, 0x684B, 0x684D, 0x684F, 0x6852, 0x6856, 0x6857,
    0x6858, 0x6859, 0x685A, 0x685B, 0x685C, 0x685D, 0x685E, 0x685F,
    0x686A, 0x686C, 0x686D, 0x686E, 0x686F, 0x6870, 0x6871, 0x6872,
    0x6873, 0x6875, 0x6878, 0x6879, 0x687A, 0x687B, 0x687C, 0x687D,
    0x687E, 0x687F, 0x6880, 0x6882, 0x6884, 0x6887, 0x6888, 0x6889,
    0x688A, 0x688B, 0x688C, 0x688D, 0x688E, 0x6890, 0x6891, 0x6892,
    0x6894, 0x6895, 0x6896, 0x6898, 0x6899, 0x689A, 0x689B, 0x689C,
    0x689D, 0x689E, 0x689F, 0x68A0, 0x68A1, 0x68A3, 0x68A4, 0x68A5,
    0x68A9, 0x68AA, 0x68AB, 0x68AC, 0x68AE, 0x68B1, 0x68B2, 0x68B4,
    0x68B6, 0x68B7, 0x68B8, 0x68B9, 0x68BA, 0x68BB, 0x68BC, 0x68BD,
    0x68BE, 0x68BF, 0x68C1, 0x68C3, 0x68C4, 0x68C5, 0x68C6, 0x68C7,
    0x68C8, 0x68CA, 0x68CC, 0x68CE, 0x68CF, 0x68D0, 0x68D1, 0x68D3,
    0x68D4, 0x68D6, 0x68D7, 0x68D9, 0x68DB, 0x68DC, 0x68DD, 0x68DE,
    0x68DF, 0x68E1, 0x68E2, 0x68E4, 0x68E5, 0x68E6, 0x68E7, 0x68E8,
    0x68E9, 0x68EA, 0x68EB, 0x68EC, 0x68ED, 0x68EF, 0x68F2, 0x68F3,
    0x68F4, 0x68F6, 0x68F7, 0x68F8, 0x68FB, 0x68FD, 0x68FE, 0x68FF,
    0x6900, 0x6902, 0x6903, 0x6904, 0x6906, 0x6907, 0x6908, 0x6909,
    0x690A, 0x690C, 0x690F, 0x6911, 0x6913, 0x6914, 0x6915, 0x6916,
    0x6917, 0x6918, 0x6919, 0x691A, 0x691B, 0x691C, 0x691D, 0x691E,
    0x6921, 0x6922, 0x6923, 0x6925, 0x6926, 0x6927, 0x6928, 0x6929,
    0x692A, 0x692B, 0x692C, 0x692E, 0x692F, 0x6931, 0x6932, 0x6933,
    0x6935, 0x6936, 0x6937, 0x6938, 0x693A, 0x693B, 0x693C, 0x693E,
    0x6940, 0x6941, 0x6943, 0x6944, 0x6945, 0x6946, 0x6947, 0x6948,
    0x6949, 0x694A, 0x694B, 0x694C, 0x694D, 0x694E, 0x694F, 0x6950,
    0x6951, 0x6952, 0x6953, 0x6955, 0x6956, 0x6958, 0x6959, 0x695B,
    0x695C, 0x695F, 0x6961, 0x6962, 0x6964, 0x6965, 0x6967, 0x6968,
    0x6969, 0x696A, 0x696C, 0x696D, 0x696F, 0x6970, 0x6972, 0x6973,
    0x6974, 0x6975, 0x6976, 0x697A, 0x697B, 0x697D, 0x697E, 0x697F,
    0x6981, 0x6983, 0x6985, 0x698A, 0x698B, 0x698C, 0x698E, 0x698F,
    0x6990, 0x6991, 0x6992, 0x6993, 0x6996, 0x6997, 0x6999, 0x699A,
    0x699D, 0x699E, 0x699F, 0x69A0, 0x69A1, 0x69A2, 0x69A3, 0x69A4,
    0x69A5, 0x69A6, 0x69A9, 0x69AA, 0x69AC, 0x69AE, 0x69AF, 0x69B0,
    0x69B2, 0x69B3, 0x69B5, 0x69B6, 0x69B8, 0x69B9, 0x69BA, 0x69BC,
    0x69BD, 0x69BE, 0x69BF, 0x69C0, 0x69C2, 0x69C3, 0x69C4, 0x69C5,
    0x69C6, 0x69C7, 0x69C8, 0x69C9, 0x69CB, 0x69CD, 0x69CF, 0x69D1,
    0x69D2, 0x69D3, 0x69D5, 0x69D6, 0x69D7, 0x69D8, 0x69D9, 0x69DA,
    0x69DC, 0x69DD, 0x69DE, 0x69E1, 0x69E2, 0x69E3, 0x69E4, 0x69E5,
    0x69E6, 0x69E7, 0x69E8, 0x69E9, 0x69EA, 0x69EB, 0x69EC, 0x69EE,
    0x69EF, 0x69F0, 0x69F1, 0x69F3, 0x69F4, 0x69F5, 0x69F6, 0x69F7,
    0x69F8, 0x69F9, 0x69FA, 0x69FB, 0x69FC, 0x69FE, 0x6A00, 0x6A01,
    0x6A02, 0x6A03, 0x6A04, 0x6A05, 0x6A06, 0x6A07, 0x6A08, 0x6A09,
    0x6A0B, 0x6A0C, 0x6A0D, 0x6A0E, 0x6A0F, 0x6A10, 0x6A11, 0x6A12,
    0x6A13, 0x6A14, 0x6A15, 0x6A16, 0x6A19, 0x6A1A, 0x6A1B, 0x6A1C,
    0x6A1D, 0x6A1E, 0x6A20, 0x6A22, 0x6A23, 0x6A24, 0x6A25, 0x6A26,
    0x6A27, 0x6A29, 0x6A2B, 0x6A2C, 0x6A2D, 0x6A2E, 0x6A30, 0x6A32,
    0x6A33, 0x6A34, 0x6A36, 0x6A37, 0x6A38, 0x6A39, 0x6A3A, 0x6A3B,
    0x6A3C, 0x6A3F, 0x6A40, 0x6A41, 0x6A42, 0x6A43, 0x6A45, 0x6A46,
    0x6A48, 0x6A49, 0x6A4A, 0x6A4B, 0x6A4C, 0x6A4D, 0x6A4E, 0x6A4F,
    0x6A51, 0x6A52, 0x6A53, 0x6A54, 0x6A55, 0x6A56, 0x6A57, 0x6A5A,
    0x6A5C, 0x6A5D, 0x6A5E, 0x6A5F, 0x6A60, 0x6A62, 0x6A63, 0x6A64,
    0x6A66, 0x6A67, 0x6A68, 0x6A69, 0x6A6A, 0x6A6B, 0x6A6C, 0x6A6D,
    0x6A6E, 0x6A6F, 0x6A70, 0x6A72, 0x6A73, 0x6A74, 0x6A75, 0x6A76,
    0x6A77, 0x6A78, 0x6A7A, 0x6A7B, 0x6A7D, 0x6A7E, 0x6A7F, 0x6A81,
    0x6A82, 0x6A83, 0x6A85, 0x6A86, 0x6A87, 0x6A88, 0x6A89, 0x6A8A,
    0x6A8B, 0x6A8C, 0x6A8D, 0x6A8F, 0x6A92, 0x6A93, 0x6A94, 0x6A95,
    0x6A96, 0x6A98, 0x6A99, 0x6A9A, 0x6A9B, 0x6A9C, 0x6A9D, 0x6A9E,
    0x6A9F, 0x6AA1, 0x6AA2, 0x6AA3, 0x6AA4, 0x6AA5, 0x6AA6, 0x6AA7,
    0x6AA8, 0x6AAA, 0x6AAD, 0x6AAE, 0x6AAF, 0x6AB0, 0x6AB1, 0x6AB2,
    0x6AB3, 0x6AB4, 0x6AB5, 0x6AB6, 0x6AB7, 0x6AB8, 0x6AB9, 0x6ABA,
    0x6ABB, 0x6ABC, 0x6ABD, 0x6ABE, 0x6ABF, 0x6AC0, 0x6AC1, 0x6AC2,
    0x6AC3, 0x6AC4, 0x6AC5, 0x6AC6, 0x6AC7, 0x6AC8, 0x6AC9, 0x6ACA,
    0x6ACB, 0x6ACC, 0x6ACD, 0x6ACE, 0x6ACF, 0x6AD0, 0x6AD1, 0x6AD2,
    0x6AD3, 0x6AD4, 0x6AD5, 0x6AD6, 0x6AD7, 0x6AD8, 0x6AD9, 0x6ADA,
    0x6ADB, 0x6ADC, 0x6ADD, 0x6ADE, 0x6ADF, 0x6AE0, 0x6AE1, 0x6AE2,
    0x6AE3, 0x6AE4, 0x6AE5, 0x6AE6, 0x6AE7, 0x6AE8, 0x6AE9, 0x6AEA,
    0x6AEB, 0x6AEC, 0x6AED, 0x6AEE, 0x6AEF, 0x6AF0, 0x6AF1, 0x6AF2,
    0x6AF3, 0x6AF4, 0x6AF5, 0x6AF6, 0x6AF7, 0x6AF8, 0x6AF9, 0x6AFA,
    0x6AFB, 0x6AFC, 0x6AFD, 0x6AFE, 0x6AFF, 0x6B00, 0x6B01, 0x6B02,
    0x6B03, 0x6B04, 0x6B05, 0x6B06, 0x6B07, 0x6B08, 0x6B09, 0x6B0A,
    0x6B0B, 0x6B0C, 0x6B0D, 0x6B0E, 0x6B0F, 0x6B10, 0x6B11, 0x6B12,
    0x6B13, 0x6B14, 0x6B15, 0x6B16, 0x6B17, 0x6B18, 0x6B19, 0x6B1A,
    0x6B1B, 0x6B1C, 0x6B1D, 0x6B1E, 0x6B1F, 0x6B25, 0x6B26, 0x6B28,
    0x6B29, 0x6B2A, 0x6B2B, 0x6B2C, 0x6B2D, 0x6B2E, 0x6B2F, 0x6B30,
    0x6B31, 0x6B33, 0x6B34, 0x6B35, 0x6B36, 0x6B38, 0x6B3B, 0x6B3C,
    0x6B3D, 0x6B3F, 0x6B40, 0x6B41, 0x6B42, 0x6B44, 0x6B45, 0x6B48,
    0x6B4A, 0x6B4B, 0x6B4D, 0x6B4E, 0x6B4F, 0x6B50, 0x6B51, 0x6B52,
    0x6B53, 0x6B54, 0x6B55, 0x6B56, 0x6B57, 0x6B58, 0x6B5A, 0x6B5B,
    0x6B5C, 0x6B5D, 0x6B5E, 0x6B5F, 0x6B60, 0x6B61, 0x6B68, 0x6B69,
    0x6B6B, 0x6B6C, 0x6B6D, 0x6B6E, 0x6B6F, 0x6B70, 0x6B71, 0x6B72,
    0x6B73, 0x6B74, 0x6B75, 0x6B76, 0x6B77, 0x6B78, 0x6B7A, 0x6B7D,
    0x6B7E, 0x6B7F, 0x6B80, 0x6B85, 0x6B88, 0x6B8C, 0x6B8E, 0x6B8F,
    0x6B90, 0x6B91, 0x6B94, 0x6B95, 0x6B97, 0x6B98, 0x6B99, 0x6B9C,
    0x6B9D, 0x6B9E, 0x6B9F, 0x6BA0, 0x6BA2, 0x6BA3, 0x6BA4, 0x6BA5,
    0x6BA6, 0x6BA7, 0x6BA8, 0x6BA9, 0x6BAB, 0x6BAC, 0x6BAD, 0x6BAE,
    0x6BAF, 0x6BB0, 0x6BB1, 0x6BB2, 0x6BB6, 0x6BB8, 0x6BB9, 0x6BBA,
    0x6BBB, 0x6BBC, 0x6BBD, 0x6BBE, 0x6BC0, 0x6BC3, 0x6BC4, 0x6BC6,
    0x6BC7, 0x6BC8, 0x6BC9, 0x6BCA, 0x6BCC, 0x6BCE, 0x6BD0, 0x6BD1,
    0x6BD8, 0x6BDA, 0x6BDC, 0x6BDD, 0x6BDE, 0x6BDF, 0x6BE0, 0x6BE2,
    0x6BE3, 0x6BE4, 0x6BE5, 0x6BE6, 0x6BE7, 0x6BE8, 0x6BE9, 0x6BEC,
    0x6BED, 0x6BEE, 0x6BF0, 0x6BF1, 0x6BF2, 0x6BF4, 0x6BF6, 0x6BF7,
    0x6BF8, 0x6BFA, 0x6BFB, 0x6BFC, 0x6BFE, 0x6BFF, 0x6C00, 0x6C01,
    0x6C02, 0x6C03, 0x6C04, 0x6C08, 0x6C09, 0x6C0A, 0x6C0B, 0x6C0C,
    0x6C0E, 0x6C12, 0x6C17, 0x6C1C, 0x6C1D, 0x6C1E, 0x6C20, 0x6C23,
    0x6C25, 0x6C2B, 0x6C2C, 0x6C2D, 0x6C31, 0x6C33, 0x6C36, 0x6C37,
    0x6C39, 0x6C3A, 0x6C3B, 0x6C3C, 0x6C3E, 0x6C3F, 0x6C43, 0x6C44,
    0x6C45, 0x6C48, 0x6C4B, 0x6C4C, 0x6C4D, 0x6C4E, 0x6C4F, 0x6C51,
    0x6C52, 0x6C53, 0x6C56, 0x6C58, 0x6C59, 0x6C5A, 0x6C62, 0x6C63,
    0x6C65, 0x6C66, 0x6C67, 0x6C6B, 0x6C6C, 0x6C6D, 0x6C6E, 0x6C6F,
    0x6C71, 0x6C73, 0x6C75, 0x6C77, 0x6C78, 0x6C7A, 0x6C7B, 0x6C7C,
    0x6C7F, 0x6C80, 0x6C84, 0x6C87, 0x6C8A, 0x6C8B, 0x6C8D, 0x6C8E,
    0x6C91, 0x6C92, 0x6C95, 0x6C96, 0x6C97, 0x6C98, 0x6C9A, 0x6C9C,
    0x6C9D, 0x6C9E, 0x6CA0, 0x6CA2, 0x6CA8, 0x6CAC, 0x6CAF, 0x6CB0,
    0x6CB4, 0x6CB5, 0x6CB6, 0x6CB7, 0x6CBA, 0x6CC0, 0x6CC1, 0x6CC2,
    0x6CC3, 0x6CC6, 0x6CC7, 0x6CC8, 0x6CCB, 0x6CCD, 0x6CCE, 0x6CCF,
    0x6CD1, 0x6CD2, 0x6CD8, 0x6CD9, 0x6CDA, 0x6CDC, 0x6CDD, 0x6CDF,
    0x6CE4, 0x6CE6, 0x6CE7, 0x6CE9, 0x6CEC, 0x6CED, 0x6CF2, 0x6CF4,
    0x6CF9, 0x6CFF, 0x6D00, 0x6D02, 0x6D03, 0x6D05, 0x6D06, 0x6D08,
    0x6D09, 0x6D0A, 0x6D0D, 0x6D0F, 0x6D10, 0x6D11, 0x6D13, 0x6D14,
    0x6D15, 0x6D16, 0x6D18, 0x6D1C, 0x6D1D, 0x6D1F, 0x6D20, 0x6D21,
    0x6D22, 0x6D23, 0x6D24, 0x6D26, 0x6D28, 0x6D29, 0x6D2C, 0x6D2D,
    0x6D2F, 0x6D30, 0x6D34, 0x6D36, 0x6D37, 0x6D38, 0x6D3A, 0x6D3F,
    0x6D40, 0x6D42, 0x6D44, 0x6D49, 0x6D4C, 0x6D50, 0x6D55, 0x6D56,
    0x6D57, 0x6D58, 0x6D5B, 0x6D5D, 0x6D5F, 0x6D61, 0x6D62, 0x6D64,
    0x6D65, 0x6D67, 0x6D68, 0x6D6B, 0x6D6C, 0x6D6D, 0x6D70, 0x6D71,
    0x6D72, 0x6D73, 0x6D75, 0x6D76, 0x6D79, 0x6D7A, 0x6D7B, 0x6D7D,
    0x6D7E, 0x6D7F, 0x6D80, 0x6D81, 0x6D83, 0x6D84, 0x6D86, 0x6D87,
    0x6D8A, 0x6D8B, 0x6D8D, 0x6D8F, 0x6D90, 0x6D92, 0x6D96, 0x6D97,
    0x6D98, 0x6D99, 0x6D9A, 0x6D9C, 0x6DA2, 0x6DA5, 0x6DAC, 0x6DAD,
    0x6DB0, 0x6DB1, 0x6DB3, 0x6DB4, 0x6DB6, 0x6DB7, 0x6DB9, 0x6DBA,
    0x6DBB, 0x6DBC, 0x6DBD, 0x6DBE, 0x6DC1, 0x6DC2, 0x6DC3, 0x6DC8,
    0x6DC9, 0x6DCA, 0x6DCD, 0x6DCE, 0x6DCF, 0x6DD0, 0x6DD2, 0x6DD3,
    0x6DD4, 0x6DD5, 0x6DD7, 0x6DDA, 0x6DDB, 0x6DDC, 0x6DDF, 0x6DE2,
    0x6DE3, 0x6DE5, 0x6DE7, 0x6DE8, 0x6DE9, 0x6DEA, 0x6DED, 0x6DEF,
    0x6DF0, 0x6DF2, 0x6DF4, 0x6DF5, 0x6DF6, 0x6DF8, 0x6DFA, 0x6DFD,
    0x6DFE, 0x6DFF, 0x6E00, 0x6E01, 0x6E02, 0x6E03, 0x6E04, 0x6E06,
    0x6E07, 0x6E08, 0x6E09, 0x6E0B, 0x6E0F, 0x6E12, 0x6E13, 0x6E15,
    0x6E18, 0x6E19, 0x6E1B, 0x6E1C, 0x6E1E, 0x6E1F, 0x6E22, 0x6E26,
    0x6E27, 0x6E28, 0x6E2A, 0x6E2C, 0x6E2E, 0x6E30, 0x6E31, 0x6E33,
    0x6E35, 0x6E36, 0x6E37, 0x6E39, 0x6E3B, 0x6E3C, 0x6E3D, 0x6E3E,
    0x6E3F, 0x6E40, 0x6E41, 0x6E42, 0x6E45, 0x6E46, 0x6E47, 0x6E48,
    0x6E49, 0x6E4A, 0x6E4B, 0x6E4C, 0x6E4F, 0x6E50, 0x6E51, 0x6E52,
    0x6E55, 0x6E57, 0x6E59, 0x6E5A, 0x6E5C, 0x6E5D, 0x6E5E, 0x6E60,
    0x6E61, 0x6E62, 0x6E63, 0x6E64, 0x6E65, 0x6E66, 0x6E67, 0x6E68,
    0x6E69, 0x6E6A, 0x6E6C, 0x6E6D, 0x6E6F, 0x6E70, 0x6E71, 0x6E72,
    0x6E73, 0x6E74, 0x6E75, 0x6E76, 0x6E77, 0x6E78, 0x6E79, 0x6E7A,
    0x6E7B, 0x6E7C, 0x6E7D, 0x6E80, 0x6E81, 0x6E82, 0x6E84, 0x6E87,
    0x6E88, 0x6E8A, 0x6E8B, 0x6E8C, 0x6E8D, 0x6E8E, 0x6E91, 0x6E92,
    0x6E93, 0x6E94, 0x6E95, 0x6E96, 0x6E97, 0x6E99, 0x6E9A, 0x6E9B,
    0x6E9D, 0x6E9E, 0x6EA0, 0x6EA1, 0x6EA3, 0x6EA4, 0x6EA6, 0x6EA8,
    0x6EA9, 0x6EAB, 0x6EAC, 0x6EAD, 0x6EAE, 0x6EB0, 0x6EB3, 0x6EB5,
    0x6EB8, 0x6EB9, 0x6EBC, 0x6EBE, 0x6EBF, 0x6EC0, 0x6EC3, 0x6EC4,
    0x6EC5, 0x6EC6, 0x6EC8, 0x6EC9, 0x6ECA, 0x6ECC, 0x6ECD, 0x6ECE,
    0x6ED0, 0x6ED2, 0x6ED6, 0x6ED8, 0x6ED9, 0x6EDB, 0x6EDC, 0x6EDD,
    0x6EE3, 0x6EE7, 0x6EEA, 0x6EEB, 0x6EEC, 0x6EED, 0x6EEE, 0x6EEF,
    0x6EF0, 0x6EF1, 0x6EF2, 0x6EF3, 0x6EF5, 0x6EF6, 0x6EF7, 0x6EF8,
    0x6EFA, 0x6EFB, 0x6EFC, 0x6EFD, 0x6EFE, 0x6EFF, 0x6F00, 0x6F01,
    0x6F03, 0x6F04, 0x6F05, 0x6F07, 0x6F08, 0x6F0A, 0x6F0B, 0x6F0C,
    0x6F0D, 0x6F0E, 0x6F10, 0x6F11, 0x6F12, 0x6F16, 0x6F17, 0x6F18,
    0x6F19, 0x6F1A, 0x6F1B, 0x6F1C, 0x6F1D, 0x6F1E, 0x6F1F, 0x6F21,
    0x6F22, 0x6F23, 0x6F25, 0x6F26, 0x6F27, 0x6F28, 0x6F2C, 0x6F2E,
    0x6F30, 0x6F32, 0x6F34, 0x6F35, 0x6F37, 0x6F38, 0x6F39, 0x6F3A,
    0x6F3B, 0x6F3C, 0x6F3D, 0x6F3F, 0x6F40, 0x6F41, 0x6F42, 0x6F43,
    0x6F44, 0x6F45, 0x6F48, 0x6F49, 0x6F4A, 0x6F4C, 0x6F4E, 0x6F4F,
    0x6F50, 0x6F51, 0x6F52, 0x6F53, 0x6F54, 0x6F55, 0x6F56, 0x6F57,
    0x6F59, 0x6F5A, 0x6F5B, 0x6F5D, 0x6F5F, 0x6F60, 0x6F61, 0x6F63,
    0x6F64, 0x6F65, 0x6F67, 0x6F68, 0x6F69, 0x6F6A, 0x6F6B, 0x6F6C,
    0x6F6F, 0x6F70, 0x6F71, 0x6F73, 0x6F75, 0x6F76, 0x6F77, 0x6F79,
    0x6F7B, 0x6F7D, 0x6F7E, 0x6F7F, 0x6F80, 0x6F81, 0x6F82, 0x6F83,
    0x6F85, 0x6F86, 0x6F87, 0x6F8A, 0x6F8B, 0x6F8F, 0x6F90, 0x6F91,
    0x6F92, 0x6F93, 0x6F94, 0x6F95, 0x6F96, 0x6F97, 0x6F98, 0x6F99,
    0x6F9A, 0x6F9B, 0x6F9D, 0x6F9E, 0x6F9F, 0x6FA0, 0x6FA2, 0x6FA3,
    0x6FA4, 0x6FA5, 0x6FA6, 0x6FA8, 0x6FA9, 0x6FAA, 0x6FAB, 0x6FAC,
    0x6FAD, 0x6FAE, 0x6FAF, 0x6FB0, 0x6FB1, 0x6FB2, 0x6FB4, 0x6FB5,
    0x6FB7, 0x6FB8, 0x6FBA, 0x6FBB, 0x6FBC, 0x6FBD, 0x6FBE, 0x6FBF,
    0x6FC1, 0x6FC3, 0x6FC4, 0x6FC5, 0x6FC6, 0x6FC7, 0x6FC8, 0x6FCA,
    0x6FCB, 0x6FCC, 0x6FCD, 0x6FCE, 0x6FCF, 0x6FD0, 0x6FD3, 0x6FD4,
    0x6FD5, 0x6FD6, 0x6FD7, 0x6FD8, 0x6FD9, 0x6FDA, 0x6FDB, 0x6FDC,
    0x6FDD, 0x6FDF, 0x6FE2, 0x6FE3, 0x6FE4, 0x6FE5, 0x6FE6, 0x6FE7,
    0x6FE8, 0x6FE9, 0x6FEA, 0x6FEB, 0x6FEC, 0x6FED, 0x6FF0, 0x6FF1,
    0x6FF2, 0x6FF3, 0x6FF4, 0x6FF5, 0x6FF6, 0x6FF7, 0x6FF8, 0x6FF9,
    0x6FFA, 0x6FFB, 0x6FFC, 0x6FFD, 0x6FFE, 0x6FFF, 0x7000, 0x7001,
    0x7002, 0x7003, 0x7004, 0x7005, 0x7006, 0x7007, 0x7008, 0x7009,
    0x700A, 0x700B, 0x700C, 0x700D, 0x700E, 0x700F, 0x7010, 0x7012,
    0x7013, 0x7014, 0x7015, 0x7016, 0x7017, 0x7018, 0x7019, 0x701C,
    0x701D, 0x701E, 0x701F, 0x7020, 0x7021, 0x7022, 0x7024, 0x7025,
    0x7026, 0x7027, 0x7028, 0x7029, 0x702A, 0x702B, 0x702C, 0x702D,
    0x702E, 0x702F, 0x7030, 0x7031, 0x7032, 0x7033, 0x7034, 0x7036,
    0x7037, 0x7038, 0x703A, 0x703B, 0x703C, 0x703D, 0x703E, 0x703F,
    0x7040, 0x7041, 0x7042, 0x7043, 0x7044, 0x7045, 0x7046, 0x7047,
    0x7048, 0x7049, 0x704A, 0x704B, 0x704D, 0x704E, 0x7050, 0x7051,
    0x7052, 0x7053, 0x7054, 0x7055, 0x7056, 0x7057, 0x7058, 0x7059,
    0x705A, 0x705B, 0x705C, 0x705D, 0x705F, 0x7060, 0x7061, 0x7062,
    0x7063, 0x7064, 0x7065, 0x7066, 0x7067, 0x7068, 0x7069, 0x706A,
    0x706E, 0x7071, 0x7072, 0x7073, 0x7074, 0x7077, 0x7079, 0x707A,
    0x707B, 0x707D, 0x7081, 0x7082, 0x7083, 0x7084, 0x7086, 0x7087,
    0x7088, 0x708B, 0x708C, 0x708D, 0x708F, 0x7090, 0x7091, 0x7093,
    0x7097, 0x7098, 0x709A, 0x709B, 0x709E, 0x709F, 0x70A0, 0x70A1,
    0x70A2, 0x70A3, 0x70A4, 0x70A5, 0x70A6, 0x70A7, 0x70A8, 0x70A9,
    0x70AA, 0x70B0, 0x70B2, 0x70B4, 0x70B5, 0x70B6, 0x70BA, 0x70BE,
    0x70BF, 0x70C4, 0x70C5, 0x70C6, 0x70C7, 0x70C9, 0x70CB, 0x70CC,
    0x70CD, 0x70CE, 0x70CF, 0x70D0, 0x70D1, 0x70D2, 0x70D3, 0x70D4,
    0x70D5, 0x70D6, 0x70D7, 0x70DA, 0x70DC, 0x70DD, 0x70DE, 0x70E0,
    0x70E1, 0x70E2, 0x70E3, 0x70E5, 0x70EA, 0x70EE, 0x70F0, 0x70F1,
    0x70F2, 0x70F3, 0x70F4, 0x70F5, 0x70F6, 0x70F8, 0x70FA, 0x70FB,
    0x70FC, 0x70FE, 0x70FF, 0x7100, 0x7101, 0x7102, 0x7103, 0x7104,
    0x7105, 0x7106, 0x7107, 0x7108, 0x710B, 0x710C, 0x710D, 0x710E,
    0x710F, 0x7111, 0x7112, 0x7114, 0x7117, 0x711B, 0x711C, 0x711D,
    0x711E, 0x711F, 0x7120, 0x7121, 0x7122, 0x7123, 0x7124, 0x7125,
    0x7127, 0x7128, 0x7129, 0x712A, 0x712B, 0x712C, 0x712D, 0x712E,
    0x7132, 0x7133, 0x7134, 0x7135, 0x7137, 0x7138, 0x7139, 0x713A,
    0x713B, 0x713C, 0x713D, 0x713E, 0x713F, 0x7140, 0x7141, 0x7142,
    0x7143, 0x7144, 0x7146, 0x7147, 0x7148, 0x7149, 0x714B, 0x714D,
    0x714F, 0x7150, 0x7151, 0x7152, 0x7153, 0x7154, 0x7155, 0x7156,
    0x7157, 0x7158, 0x7159, 0x715A, 0x715B, 0x715D, 0x715F, 0x7160,
    0x7161, 0x7162, 0x7163, 0x7165, 0x7169, 0x716A, 0x716B, 0x716C,
    0x716D, 0x716F, 0x7170, 0x7171, 0x7174, 0x7175, 0x7176, 0x7177,
    0x7179, 0x717B, 0x717C, 0x717E, 0x717F, 0x7180, 0x7181, 0x7182,
    0x7183, 0x7185, 0x7186, 0x7187, 0x7188, 0x7189, 0x718B, 0x718C,
    0x718D, 0x718E, 0x7190, 0x7191, 0x7192, 0x7193, 0x7195, 0x7196,
    0x7197, 0x719A, 0x719B, 0x719C, 0x719D, 0x719E, 0x71A1, 0x71A2,
    0x71A3, 0x71A4, 0x71A5, 0x71A6, 0x71A7, 0x71A9, 0x71AA, 0x71AB,
    0x71AD, 0x71AE, 0x71AF, 0x71B0, 0x71B1, 0x71B2, 0x71B4, 0x71B6,
    0x71B7, 0x71B8, 0x71BA, 0x71BB, 0x71BC, 0x71BD, 0x71BE, 0x71BF,
    0x71C0, 0x71C1, 0x71C2, 0x71C4, 0x71C5, 0x71C6, 0x71C7, 0x71C8,
    0x71C9, 0x71CA, 0x71CB, 0x71CC, 0x71CD, 0x71CF, 0x71D0, 0x71D1,
    0x71D2, 0x71D3, 0x71D6, 0x71D7, 0x71D8, 0x71D9, 0x71DA, 0x71DB,
    0x71DC, 0x71DD, 0x71DE, 0x71DF, 0x71E1, 0x71E2, 0x71E3, 0x71E4,
    0x71E6, 0x71E8, 0x71E9, 0x71EA, 0x71EB, 0x71EC, 0x71ED, 0x71EF,
    0x71F0, 0x71F1, 0x71F2, 0x71F3, 0x71F4, 0x71F5, 0x71F6, 0x71F7,
    0x71F8, 0x71FA, 0x71FB, 0x71FC, 0x71FD, 0x71FE, 0x71FF, 0x7200,
    0x7201, 0x7202, 0x7203, 0x7204, 0x7205, 0x7207, 0x7208, 0x7209,
    0x720A, 0x720B, 0x720C, 0x720D, 0x720E, 0x720F, 0x7210, 0x7211,
    0x7212, 0x7213, 0x7214, 0x7215, 0x7216, 0x7217, 0x7218, 0x7219,
    0x721A, 0x721B, 0x721C, 0x721E, 0x721F, 0x7220, 0x7221, 0x7222,
    0x7223, 0x7224, 0x7225, 0x7226, 0x7227, 0x7229, 0x722B, 0x722D,
    0x722E, 0x722F, 0x7232, 0x7233, 0x7234, 0x723A, 0x723C, 0x723E,
    0x7240, 0x7241, 0x7242, 0x7243, 0x7244, 0x7245, 0x7246, 0x7249,
    0x724A, 0x724B, 0x724E, 0x724F, 0x7250, 0x7251, 0x7253, 0x7254,
    0x7255, 0x7257, 0x7258, 0x725A, 0x725C, 0x725E, 0x7260, 0x7263,
    0x7264, 0x7265, 0x7268, 0x726A, 0x726B, 0x726C, 0x726D, 0x7270,
    0x7271, 0x7273, 0x7274, 0x7276, 0x7277, 0x7278, 0x727B, 0x727C,
    0x727D, 0x7282, 0x7283, 0x7285, 0x7286, 0x7287, 0x7288, 0x7289,
    0x728C, 0x728E, 0x7290, 0x7291, 0x7293, 0x7294, 0x7295, 0x7296,
    0x7297, 0x7298, 0x7299, 0x729A, 0x729B, 0x729C, 0x729D, 0x729E,
    0x72A0, 0x72A1, 0x72A2, 0x72A3, 0x72A4, 0x72A5, 0x72A6, 0x72A7,
    0x72A8, 0x72A9, 0x72AA, 0x72AB, 0x72AE, 0x72B1, 0x72B2, 0x72B3,
    0x72B5, 0x72BA, 0x72BB, 0x72BC, 0x72BD, 0x72BE, 0x72BF, 0x72C0,
    0x72C5, 0x72C6, 0x72C7, 0x72C9, 0x72CA, 0x72CB, 0x72CC, 0x72CF,
    0x72D1, 0x72D3, 0x72D4, 0x72D5, 0x72D6, 0x72D8, 0x72DA, 0x72DB,
    0x02CA, 0x02CB, 0x02D9, 0x2013, 0x2015, 0x2025, 0x2035, 0x2105,
    0x2109, 0x2196, 0x2197, 0x2198, 0x2199, 0x2215, 0x221F, 0x2223,
    0x2252, 0x2266, 0x2267, 0x22BF, 0x2550, 0x2551, 0x2552, 0x2553,
    0x2554, 0x2555, 0x2556, 0x2557, 0x2558, 0x2559, 0x255A, 0x255B,
    0x255C, 0x255D, 0x255E, 0x255F, 0x2560, 0x2561, 0x2562, 0x2563,
    0x2564, 0x2565, 0x2566, 0x2567, 0x2568, 0x2569, 0x256A, 0x256B,
    0x256C, 0x256D, 0x256E, 0x256F, 0x2570, 0x2571, 0x2572, 0x2573,
    0x2581, 0x2582, 0x2583, 0x2584, 0x2585, 0x2586, 0x2587, 0x2588,
    0x2589, 0x258A, 0x258B, 0x258C, 0x258D, 0x258E, 0x258F, 0x2593,
    0x2594, 0x2595, 0x25BC, 0x25BD, 0x25E2, 0x25E3, 0x25E4, 0x25E5,
    0x2609, 0x2295, 0x3012, 0x301D, 0x301E, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x3021, 0x3022, 0x3023, 0x3024, 0x3025, 0x3026, 0x3027, 0x3028,
    0x3029, 0x32A3, 0x338E, 0x338F, 0x339C, 0x339D, 0x339E, 0x33A1,
    0x33C4, 0x33CE, 0x33D1, 0x33D2, 0x33D5, 0xFE30, 0xFFE2, 0xFFE4,
    0x0000, 0x2121, 0x3231, 0x0000, 0x2010, 0x0000, 0x0000, 0x0000,
    0x30FC, 0x309B, 0x309C, 0x30FD, 0x30FE, 0x3006, 0x309D, 0x309E,
    0xFE49, 0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D, 0xFE4E, 0xFE4F, 0xFE50,
    0xFE51, 0xFE52, 0xFE54, 0xFE55, 0xFE56, 0xFE57, 0xFE59, 0xFE5A,
    0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0xFE5F, 0xFE60, 0xFE61, 0xFE62,
    0xFE63, 0xFE64, 0xFE65, 0xFE66, 0xFE68, 0xFE69, 0xFE6A, 0xFE6B,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3007, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x72DC, 0x72DD, 0x72DF, 0x72E2, 0x72E3, 0x72E4, 0x72E5, 0x72E6,
    0x72E7, 0x72EA, 0x72EB, 0x72F5, 0x72F6, 0x72F9, 0x72FD, 0x72FE,
    0x72FF, 0x7300, 0x7302, 0x7304, 0x7305, 0x7306, 0x7307, 0x7308,
    0x7309, 0x730B, 0x730C, 0x730D, 0x730F, 0x7310, 0x7311, 0x7312,
    0x7314, 0x7318, 0x7319, 0x731A, 0x731F, 0x7320, 0x7323, 0x7324,
    0x7326, 0x7327, 0x7328, 0x732D, 0x732F, 0x7330, 0x7332, 0x7333,
    0x7335, 0x7336, 0x733A, 0x733B, 0x733C, 0x733D, 0x7340, 0x7341,
    0x7342, 0x7343, 0x7344, 0x7345, 0x7346, 0x7347, 0x7348, 0x7349,
    0x734A, 0x734B, 0x734C, 0x734E, 0x734F, 0x7351, 0x7353, 0x7354,
    0x7355, 0x7356, 0x7358, 0x7359, 0x735A, 0x735B, 0x735C, 0x735D,
    0x735E, 0x735F, 0x7361, 0x7362, 0x7363, 0x7364, 0x7365, 0x7366,
    0x7367, 0x7368, 0x7369, 0x736A, 0x736B, 0x736E, 0x7370, 0x7371,
    0x7372, 0x7373, 0x7374, 0x7375, 0x7376, 0x7377, 0x7378, 0x7379,
    0x737A, 0x737B, 0x737C, 0x737D, 0x737F, 0x7380, 0x7381, 0x7382,
    0x7383, 0x7385, 0x7386, 0x7388, 0x738A, 0x738C, 0x738D, 0x738F,
    0x7390, 0x7392, 0x7393, 0x7394, 0x7395, 0x7397, 0x7398, 0x7399,
    0x739A, 0x739C, 0x739D, 0x739E, 0x73A0, 0x73A1, 0x73A3, 0x73A4,
    0x73A5, 0x73A6, 0x73A7, 0x73A8, 0x73AA, 0x73AC, 0x73AD, 0x73B1,
    0x73B4, 0x73B5, 0x73B6, 0x73B8, 0x73B9, 0x73BC, 0x73BD, 0x73BE,
    0x73BF, 0x73C1, 0x73C3, 0x73C4, 0x73C5, 0x73C6, 0x73C7, 0x73CB,
    0x73CC, 0x73CE, 0x73D2, 0x73D3, 0x73D4, 0x73D5, 0x73D6, 0x73D7,
    0x73D8, 0x73DA, 0x73DB, 0x73DC, 0x73DD, 0x73DF, 0x73E1, 0x73E2,
    0x73E3, 0x73E4, 0x73E6, 0x73E8, 0x73EA, 0x73EB, 0x73EC, 0x73EE,
    0x73EF, 0x73F0, 0x73F1, 0x73F3, 0x73F4, 0x73F5, 0x73F6, 0x73F7,
    0x73F8, 0x73F9, 0x73FA, 0x73FB, 0x73FC, 0x73FD, 0x73FE, 0x73FF,
    0x7400, 0x7401, 0x7402, 0x7404, 0x7407, 0x7408, 0x740B, 0x740C,
    0x740D, 0x740E, 0x7411, 0x7412, 0x7413, 0x7414, 0x7415, 0x7416,
    0x7417, 0x7418, 0x7419, 0x741C, 0x741D, 0x741E, 0x741F, 0x7420,
    0x7421, 0x7423, 0x7424, 0x7427, 0x7429, 0x742B, 0x742D, 0x742F,
    0x7431, 0x7432, 0x7437, 0x7438, 0x7439, 0x743A, 0x743B, 0x743D,
    0x743E, 0x743F, 0x7440, 0x7442, 0x7443, 0x7444, 0x7445, 0x7446,
    0x7447, 0x7448, 0x7449, 0x744A, 0x744B, 0x744C, 0x744D, 0x744E,
    0x744F, 0x7450, 0x7451, 0x7452, 0x7453, 0x7454, 0x7456, 0x7458,
    0x745D, 0x7460, 0x7461, 0x7462, 0x7463, 0x7464, 0x7465, 0x7466,
    0x7467, 0x7468, 0x7469, 0x746A, 0x746B, 0x746C, 0x746E, 0x746F,
    0x7471, 0x7472, 0x7473, 0x7474, 0x7475, 0x7478, 0x7479, 0x747A,
    0x747B, 0x747C, 0x747D, 0x747F, 0x7482, 0x7484, 0x7485, 0x7486,
    0x7488, 0x7489, 0x748A, 0x748C, 0x748D, 0x748F, 0x7491, 0x7492,
    0x7493, 0x7494, 0x7495, 0x7496, 0x7497, 0x7498, 0x7499, 0x749A,
    0x749B, 0x749D, 0x749F, 0x74A0, 0x74A1, 0x74A2, 0x74A3, 0x74A4,
    0x74A5, 0x74A6, 0x74AA, 0x74AB, 0x74AC, 0x74AD, 0x74AE, 0x74AF,
    0x74B0, 0x74B1, 0x74B2, 0x74B3, 0x74B4, 0x74B5, 0x74B6, 0x74B7,
    0x74B8, 0x74B9, 0x74BB, 0x74BC, 0x74BD, 0x74BE, 0x74BF, 0x74C0,
    0x74C1, 0x74C2, 0x74C3, 0x74C4, 0x74C5, 0x74C6, 0x74C7, 0x74C8,
    0x74C9, 0x74CA, 0x74CB, 0x74CC, 0x74CD, 0x74CE, 0x74CF, 0x74D0,
    0x74D1, 0x74D3, 0x74D4, 0x74D5, 0x74D6, 0x74D7, 0x74D8, 0x74D9,
    0x74DA, 0x74DB, 0x74DD, 0x74DF, 0x74E1, 0x74E5, 0x74E7, 0x74E8,
    0x74E9, 0x74EA, 0x74EB, 0x74EC, 0x74ED, 0x74F0, 0x74F1, 0x74F2,
    0x74F3, 0x74F5, 0x74F8, 0x74F9, 0x74FA, 0x74FB, 0x74FC, 0x74FD,
    0x74FE, 0x7500, 0x7501, 0x7502, 0x7503, 0x7505, 0x7506, 0x7507,
    0x7508, 0x7509, 0x750A, 0x750B, 0x750C, 0x750E, 0x7510, 0x7512,
    0x7514, 0x7515, 0x7516, 0x7517, 0x751B, 0x751D, 0x751E, 0x7520,
    0x7521, 0x7522, 0x7523, 0x7524, 0x7526, 0x7527, 0x752A, 0x752E,
    0x7534, 0x7536, 0x7539, 0x753C, 0x753D, 0x753F, 0x7541, 0x7542,
    0x7543, 0x7544, 0x7546, 0x7547, 0x7549, 0x754A, 0x754D, 0x7550,
    0x7551, 0x7552, 0x7553, 0x7555, 0x7556, 0x7557, 0x7558, 0x755D,
    0x755E, 0x755F, 0x7560, 0x7561, 0x7562, 0x7563, 0x7564, 0x7567,
    0x7568, 0x7569, 0x756B, 0x756C, 0x756D, 0x756E, 0x756F, 0x7570,
    0x7571, 0x7573, 0x7575, 0x7576, 0x7577, 0x757A, 0x757B, 0x757C,
    0x757D, 0x757E, 0x7580, 0x7581, 0x7582, 0x7584, 0x7585, 0x7587,
    0x7588, 0x7589, 0x758A, 0x758C, 0x758D, 0x758E, 0x7590, 0x7593,
    0x7595, 0x7598, 0x759B, 0x759C, 0x759E, 0x75A2, 0x75A6, 0x75A7,
    0x75A8, 0x75A9, 0x75AA, 0x75AD, 0x75B6, 0x75B7, 0x75BA, 0x75BB,
    0x75BF, 0x75C0, 0x75C1, 0x75C6, 0x75CB, 0x75CC, 0x75CE, 0x75CF,
    0x75D0, 0x75D1, 0x75D3, 0x75D7, 0x75D9, 0x75DA, 0x75DC, 0x75DD,
    0x75DF, 0x75E0, 0x75E1, 0x75E5, 0x75E9, 0x75EC, 0x75ED, 0x75EE,
    0x75EF, 0x75F2, 0x75F3, 0x75F5, 0x75F6, 0x75F7, 0x75F8, 0x75FA,
    0x75FB, 0x75FD, 0x75FE, 0x7602, 0x7604, 0x7606, 0x7607, 0x7608,
    0x7609, 0x760B, 0x760D, 0x760E, 0x760F, 0x7611, 0x7612, 0x7613,
    0x7614, 0x7616, 0x761A, 0x761C, 0x761D, 0x761E, 0x7621, 0x7623,
    0x7627, 0x7628, 0x762C, 0x762E, 0x762F, 0x7631, 0x7632, 0x7636,
    0x7637, 0x7639, 0x763A, 0x763B, 0x763D, 0x7641, 0x7642, 0x7644,
    0x7645, 0x7646, 0x7647, 0x7648, 0x7649, 0x764A, 0x764B, 0x764E,
    0x764F, 0x7650, 0x7651, 0x7652, 0x7653, 0x7655, 0x7657, 0x7658,
    0x7659, 0x765A, 0x765B, 0x765D, 0x765F, 0x7660, 0x7661, 0x7662,
    0x7664, 0x7665, 0x7666, 0x7667, 0x7668, 0x7669, 0x766A, 0x766C,
    0x766D, 0x766E, 0x7670, 0x7671, 0x7672, 0x7673, 0x7674, 0x7675,
    0x7676, 0x7677, 0x7679, 0x767A, 0x767C, 0x767F, 0x7680, 0x7681,
    0x7683, 0x7685, 0x7689, 0x768A, 0x768C, 0x768D, 0x768F, 0x7690,
    0x7692, 0x7694, 0x7695, 0x7697, 0x7698, 0x769A, 0x769B, 0x769C,
    0x769D, 0x769E, 0x769F, 0x76A0, 0x76A1, 0x76A2, 0x76A3, 0x76A5,
    0x76A6, 0x76A7, 0x76A8, 0x76A9, 0x76AA, 0x76AB, 0x76AC, 0x76AD,
    0x76AF, 0x76B0, 0x76B3, 0x76B5, 0x76B6, 0x76B7, 0x76B8, 0x76B9,
    0x76BA, 0x76BB, 0x76BC, 0x76BD, 0x76BE, 0x76C0, 0x76C1, 0x76C3,
    0x76C4, 0x76C7, 0x76C9, 0x76CB, 0x76CC, 0x76D3, 0x76D5, 0x76D9,
    0x76DA, 0x76DC, 0x76DD, 0x76DE, 0x76E0, 0x76E1, 0x76E2, 0x76E3,
    0x76E4, 0x76E6, 0x76E7, 0x76E8, 0x76E9, 0x76EA, 0x76EB, 0x76EC,
    0x76ED, 0x76F0, 0x76F3, 0x76F5, 0x76F6, 0x76F7, 0x76FA, 0x76FB,
    0x76FD, 0x76FF, 0x7700, 0x7702, 0x7703, 0x7705, 0x7706, 0x770A,
    0x770C, 0x770E, 0x770F, 0x7710, 0x7711, 0x7712, 0x7713, 0x7714,
    0x7715, 0x7716, 0x7717, 0x7718, 0x771B, 0x771C, 0x771D, 0x771E,
    0x7721, 0x7723, 0x7724, 0x7725, 0x7727, 0x772A, 0x772B, 0x772C,
    0x772E, 0x7730, 0x7731, 0x7732, 0x7733, 0x7734, 0x7739, 0x773B,
    0x773D, 0x773E, 0x773F, 0x7742, 0x7744, 0x7745, 0x7746, 0x7748,
    0x7749, 0x774A, 0x774B, 0x774C, 0x774D, 0x774E, 0x774F, 0x7752,
    0x7753, 0x7754, 0x7755, 0x7756, 0x7757, 0x7758, 0x7759, 0x775C,
    0x775D, 0x775E, 0x775F, 0x7760, 0x7764, 0x7767, 0x7769, 0x776A,
    0x776D, 0x776E, 0x776F, 0x7770, 0x7771, 0x7772, 0x7773, 0x7774,
    0x7775, 0x7776, 0x7777, 0x7778, 0x777A, 0x777B, 0x777C, 0x7781,
    0x7782, 0x7783, 0x7786, 0x7787, 0x7788, 0x7789, 0x778A, 0x778B,
    0x778F, 0x7790, 0x7793, 0x7794, 0x7795, 0x7796, 0x7797, 0x7798,
    0x7799, 0x779A, 0x779B, 0x779C, 0x779D, 0x779E, 0x77A1, 0x77A3,
    0x77A4, 0x77A6, 0x77A8, 0x77AB, 0x77AD, 0x77AE, 0x77AF, 0x77B1,
    0x77B2, 0x77B4, 0x77B6, 0x77B7, 0x77B8, 0x77B9, 0x77BA, 0x77BC,
    0x77BE, 0x77C0, 0x77C1, 0x77C2, 0x77C3, 0x77C4, 0x77C5, 0x77C6,
    0x77C7, 0x77C8, 0x77C9, 0x77CA, 0x77CB, 0x77CC, 0x77CE, 0x77CF,
    0x77D0, 0x77D1, 0x77D2, 0x77D3, 0x77D4, 0x77D5, 0x77D6, 0x77D8,
    0x77D9, 0x77DA, 0x77DD, 0x77DE, 0x77DF, 0x77E0, 0x77E1, 0x77E4,
    0x77E6, 0x77E8, 0x77EA, 0x77EF, 0x77F0, 0x77F1, 0x77F2, 0x77F4,
    0x77F5, 0x77F7, 0x77F9, 0x77FA, 0x77FB, 0x77FC, 0x7803, 0x7804,
    0x7805, 0x7806, 0x7807, 0x7808, 0x780A, 0x780B, 0x780E, 0x780F,
    0x7810, 0x7813, 0x7815, 0x7819, 0x781B, 0x781E, 0x7820, 0x7821,
    0x7822, 0x7824, 0x7828, 0x782A, 0x782B, 0x782E, 0x782F, 0x7831,
    0x7832, 0x7833, 0x7835, 0x7836, 0x783D, 0x783F, 0x7841, 0x7842,
    0x7843, 0x7844, 0x7846, 0x7848, 0x7849, 0x784A, 0x784B, 0x784D,
    0x784F, 0x7851, 0x7853, 0x7854, 0x7858, 0x7859, 0x785A, 0x785B,
    0x785C, 0x785E, 0x785F, 0x7860, 0x7861, 0x7862, 0x7863, 0x7864,
    0x7865, 0x7866, 0x7867, 0x7868, 0x7869, 0x786F, 0x7870, 0x7871,
    0x7872, 0x7873, 0x7874, 0x7875, 0x7876, 0x7878, 0x7879, 0x787A,
    0x787B, 0x787D, 0x787E, 0x787F, 0x7880, 0x7881, 0x7882, 0x7883,
    0x7884, 0x7885, 0x7886, 0x7888, 0x788A, 0x788B, 0x788F, 0x7890,
    0x7892, 0x7894, 0x7895, 0x7896, 0x7899, 0x789D, 0x789E, 0x78A0,
    0x78A2, 0x78A4, 0x78A6, 0x78A8, 0x78A9, 0x78AA, 0x78AB, 0x78AC,
    0x78AD, 0x78AE, 0x78AF, 0x78B5, 0x78B6, 0x78B7, 0x78B8, 0x78BA,
    0x78BB, 0x78BC, 0x78BD, 0x78BF, 0x78C0, 0x78C2, 0x78C3, 0x78C4,
    0x78C6, 0x78C7, 0x78C8, 0x78CC, 0x78CD, 0x78CE, 0x78CF, 0x78D1,
    0x78D2, 0x78D3, 0x78D6, 0x78D7, 0x78D8, 0x78DA, 0x78DB, 0x78DC,
    0x78DD, 0x78DE, 0x78DF, 0x78E0, 0x78E1, 0x78E2, 0x78E3, 0x78E4,
    0x78E5, 0x78E6, 0x78E7, 0x78E9, 0x78EA, 0x78EB, 0x78ED, 0x78EE,
    0x78EF, 0x78F0, 0x78F1, 0x78F3, 0x78F5, 0x78F6, 0x78F8, 0x78F9,
    0x78FB, 0x78FC, 0x78FD, 0x78FE, 0x78FF, 0x7900, 0x7902, 0x7903,
    0x7904, 0x7906, 0x7907, 0x7908, 0x7909, 0x790A, 0x790B, 0x790C,
    0x790D, 0x790E, 0x790F, 0x7910, 0x7911, 0x7912, 0x7914, 0x7915,
    0x7916, 0x7917, 0x7918, 0x7919, 0x791A, 0x791B, 0x791C, 0x791D,
    0x791F, 0x7920, 0x7921, 0x7922, 0x7923, 0x7925, 0x7926, 0x7927,
    0x7928, 0x7929, 0x792A, 0x792B, 0x792C, 0x792D, 0x792E, 0x792F,
    0x7930, 0x7931, 0x7932, 0x7933, 0x7935, 0x7936, 0x7937, 0x7938,
    0x7939, 0x793D, 0x793F, 0x7942, 0x7943, 0x7944, 0x7945, 0x7947,
    0x794A, 0x794B, 0x794C, 0x794D, 0x794E, 0x794F, 0x7950, 0x7951,
    0x7952, 0x7954, 0x7955, 0x7958, 0x7959, 0x7961, 0x7963, 0x7964,
    0x7966, 0x7969, 0x796A, 0x796B, 0x796C, 0x796E, 0x7970, 0x7971,
    0x7972, 0x7973, 0x7974, 0x7975, 0x7976, 0x7979, 0x797B, 0x797C,
    0x797D, 0x797E, 0x797F, 0x7982, 0x7983, 0x7986, 0x7987, 0x7988,
    0x7989, 0x798B, 0x798C, 0x798D, 0x798E, 0x7990, 0x7991, 0x7992,
    0x7993, 0x7994, 0x7995, 0x7996, 0x7997, 0x7998, 0x7999, 0x799B,
    0x799C, 0x799D, 0x799E, 0x799F, 0x79A0, 0x79A1, 0x79A2, 0x79A3,
    0x79A4, 0x79A5, 0x79A6, 0x79A8, 0x79A9, 0x79AA, 0x79AB, 0x79AC,
    0x79AD, 0x79AE, 0x79AF, 0x79B0, 0x79B1, 0x79B2, 0x79B4, 0x79B5,
    0x79B6, 0x79B7, 0x79B8, 0x79BC, 0x79BF, 0x79C2, 0x79C4, 0x79C5,
    0x79C7, 0x79C8, 0x79CA, 0x79CC, 0x79CE, 0x79CF, 0x79D0, 0x79D3,
    0x79D4, 0x79D6, 0x79D7, 0x79D9, 0x79DA, 0x79DB, 0x79DC, 0x79DD,
    0x79DE, 0x79E0, 0x79E1, 0x79E2, 0x79E5, 0x79E8, 0x79EA, 0x79EC,
    0x79EE, 0x79F1, 0x79F2, 0x79F3, 0x79F4, 0x79F5, 0x79F6, 0x79F7,
    0x79F9, 0x79FA, 0x79FC, 0x79FE, 0x79FF, 0x7A01, 0x7A04, 0x7A05,
    0x7A07, 0x7A08, 0x7A09, 0x7A0A, 0x7A0C, 0x7A0F, 0x7A10, 0x7A11,
    0x7A12, 0x7A13, 0x7A15, 0x7A16, 0x7A18, 0x7A19, 0x7A1B, 0x7A1C,
    0x7A1D, 0x7A1F, 0x7A21, 0x7A22, 0x7A24, 0x7A25, 0x7A26, 0x7A27,
    0x7A28, 0x7A29, 0x7A2A, 0x7A2B, 0x7A2C, 0x7A2D, 0x7A2E, 0x7A2F,
    0x7A30, 0x7A31, 0x7A32, 0x7A34, 0x7A35, 0x7A36, 0x7A38, 0x7A3A,
    0x7A3E, 0x7A40, 0x7A41, 0x7A42, 0x7A43, 0x7A44, 0x7A45, 0x7A47,
    0x7A48, 0x7A49, 0x7A4A, 0x7A4B, 0x7A4C, 0x7A4D, 0x7A4E, 0x7A4F,
    0x7A50, 0x7A52, 0x7A53, 0x7A54, 0x7A55, 0x7A56, 0x7A58, 0x7A59,
    0x7A5A, 0x7A5B, 0x7A5C, 0x7A5D, 0x7A5E, 0x7A5F, 0x7A60, 0x7A61,
    0x7A62, 0x7A63, 0x7A64, 0x7A65, 0x7A66, 0x7A67, 0x7A68, 0x7A69,
    0x7A6A, 0x7A6B, 0x7A6C, 0x7A6D, 0x7A6E, 0x7A6F, 0x7A71, 0x7A72,
    0x7A73, 0x7A75, 0x7A7B, 0x7A7C, 0x7A7D, 0x7A7E, 0x7A82, 0x7A85,
    0x7A87, 0x7A89, 0x7A8A, 0x7A8B, 0x7A8C, 0x7A8E, 0x7A8F, 0x7A90,
    0x7A93, 0x7A94, 0x7A99, 0x7A9A, 0x7A9B, 0x7A9E, 0x7AA1, 0x7AA2,
    0x7AA3, 0x7AA4, 0x7AA7, 0x7AA9, 0x7AAA, 0x7AAB, 0x7AAE, 0x7AAF,
    0x7AB0, 0x7AB1, 0x7AB2, 0x7AB4, 0x7AB5, 0x7AB6, 0x7AB7, 0x7AB8,
    0x7AB9, 0x7ABA, 0x7ABB, 0x7ABC, 0x7ABD, 0x7ABE, 0x7AC0, 0x7AC1,
    0x7AC2, 0x7AC3, 0x7AC4, 0x7AC5, 0x7AC6, 0x7AC7, 0x7AC8, 0x7AC9,
    0x7ACA, 0x7ACC, 0x7ACD, 0x7ACE, 0x7ACF, 0x7AD0, 0x7AD1, 0x7AD2,
    0x7AD3, 0x7AD4, 0x7AD5, 0x7AD7, 0x7AD8, 0x7ADA, 0x7ADB, 0x7ADC,
    0x7ADD, 0x7AE1, 0x7AE2, 0x7AE4, 0x7AE7, 0x7AE8, 0x7AE9, 0x7AEA,
    0x7AEB, 0x7AEC, 0x7AEE, 0x7AF0, 0x7AF1, 0x7AF2, 0x7AF3, 0x7AF4,
    0x7AF5, 0x7AF6, 0x7AF7, 0x7AF8, 0x7AFB, 0x7AFC, 0x7AFE, 0x7B00,
    0x7B01, 0x7B02, 0x7B05, 0x7B07, 0x7B09, 0x7B0C, 0x7B0D, 0x7B0E,
    0x7B10, 0x7B12, 0x7B13, 0x7B16, 0x7B17, 0x7B18, 0x7B1A, 0x7B1C,
    0x7B1D, 0x7B1F, 0x7B21, 0x7B22, 0x7B23, 0x7B27, 0x7B29, 0x7B2D,
    0x7B2F, 0x7B30, 0x7B32, 0x7B34, 0x7B35, 0x7B36, 0x7B37, 0x7B39,
    0x7B3B, 0x7B3D, 0x7B3F, 0x7B40, 0x7B41, 0x7B42, 0x7B43, 0x7B44,
    0x7B46, 0x7B48, 0x7B4A, 0x7B4D, 0x7B4E, 0x7B53, 0x7B55, 0x7B57,
    0x7B59, 0x7B5C, 0x7B5E, 0x7B5F, 0x7B61, 0x7B63, 0x7B64, 0x7B65,
    0x7B66, 0x7B67, 0x7B68, 0x7B69, 0x7B6A, 0x7B6B, 0x7B6C, 0x7B6D,
    0x7B6F, 0x7B70, 0x7B73, 0x7B74, 0x7B76, 0x7B78, 0x7B7A, 0x7B7C,
    0x7B7D, 0x7B7F, 0x7B81, 0x7B82, 0x7B83, 0x7B84, 0x7B86, 0x7B87,
    0x7B88, 0x7B89, 0x7B8A, 0x7B8B, 0x7B8C, 0x7B8E, 0x7B8F, 0x7B91,
    0x7B92, 0x7B93, 0x7B96, 0x7B98, 0x7B99, 0x7B9A, 0x7B9B, 0x7B9E,
    0x7B9F, 0x7BA0, 0x7BA3, 0x7BA4, 0x7BA5, 0x7BAE, 0x7BAF, 0x7BB0,
    0x7BB2, 0x7BB3, 0x7BB5, 0x7BB6, 0x7BB7, 0x7BB9, 0x7BBA, 0x7BBB,
    0x7BBC, 0x7BBD, 0x7BBE, 0x7BBF, 0x7BC0, 0x7BC2, 0x7BC3, 0x7BC4,
    0x7BC5, 0x7BC8, 0x7BC9, 0x7BCA, 0x7BCB, 0x7BCD, 0x7BCE, 0x7BCF,
    0x7BD0, 0x7BD2, 0x7BD4, 0x7BD5, 0x7BD6, 0x7BD7, 0x7BD8, 0x7BDB,
    0x7BDC, 0x7BDE, 0x7BDF, 0x7BE0, 0x7BE2, 0x7BE3, 0x7BE4, 0x7BE7,
    0x7BE8, 0x7BE9, 0x7BEB, 0x7BEC, 0x7BED, 0x7BEF, 0x7BF0, 0x7BF2,
    0x7BF3, 0x7BF4, 0x7BF5, 0x7BF6, 0x7BF8, 0x7BF9, 0x7BFA, 0x7BFB,
    0x7BFD, 0x7BFF, 0x7C00, 0x7C01, 0x7C02, 0x7C03, 0x7C04, 0x7C05,
    0x7C06, 0x7C08, 0x7C09, 0x7C0A, 0x7C0D, 0x7C0E, 0x7C10, 0x7C11,
    0x7C12, 0x7C13, 0x7C14, 0x7C15, 0x7C17, 0x7C18, 0x7C19, 0x7C1A,
    0x7C1B, 0x7C1C, 0x7C1D, 0x7C1E, 0x7C20, 0x7C21, 0x7C22, 0x7C23,
    0x7C24, 0x7C25, 0x7C28, 0x7C29, 0x7C2B, 0x7C2C, 0x7C2D, 0x7C2E,
    0x7C2F, 0x7C30, 0x7C31, 0x7C32, 0x7C33, 0x7C34, 0x7C35, 0x7C36,
    0x7C37, 0x7C39, 0x7C3A, 0x7C3B, 0x7C3C, 0x7C3D, 0x7C3E, 0x7C42,
    0x7C43, 0x7C44, 0x7C45, 0x7C46, 0x7C47, 0x7C48, 0x7C49, 0x7C4A,
    0x7C4B, 0x7C4C, 0x7C4E, 0x7C4F, 0x7C50, 0x7C51, 0x7C52, 0x7C53,
    0x7C54, 0x7C55, 0x7C56, 0x7C57, 0x7C58, 0x7C59, 0x7C5A, 0x7C5B,
    0x7C5C, 0x7C5D, 0x7C5E, 0x7C5F, 0x7C60, 0x7C61, 0x7C62, 0x7C63,
    0x7C64, 0x7C65, 0x7C66, 0x7C67, 0x7C68, 0x7C69, 0x7C6A, 0x7C6B,
    0x7C6C, 0x7C6D, 0x7C6E, 0x7C6F, 0x7C70, 0x7C71, 0x7C72, 0x7C75,
    0x7C76, 0x7C77, 0x7C78, 0x7C79, 0x7C7A, 0x7C7E, 0x7C7F, 0x7C80,
    0x7C81, 0x7C82, 0x7C83, 0x7C84, 0x7C85, 0x7C86, 0x7C87, 0x7C88,
    0x7C8A, 0x7C8B, 0x7C8C, 0x7C8D, 0x7C8E, 0x7C8F, 0x7C90, 0x7C93,
    0x7C94, 0x7C96, 0x7C99, 0x7C9A, 0x7C9B, 0x7CA0, 0x7CA1, 0x7CA3,
    0x7CA6, 0x7CA7, 0x7CA8, 0x7CA9, 0x7CAB, 0x7CAC, 0x7CAD, 0x7CAF,
    0x7CB0, 0x7CB4, 0x7CB5, 0x7CB6, 0x7CB7, 0x7CB8, 0x7CBA, 0x7CBB,
    0x7CBF, 0x7CC0, 0x7CC2, 0x7CC3, 0x7CC4, 0x7CC6, 0x7CC9, 0x7CCB,
    0x7CCE, 0x7CCF, 0x7CD0, 0x7CD1, 0x7CD2, 0x7CD3, 0x7CD4, 0x7CD8,
    0x7CDA, 0x7CDB, 0x7CDD, 0x7CDE, 0x7CE1, 0x7CE2, 0x7CE3, 0x7CE4,
    0x7CE5, 0x7CE6, 0x7CE7, 0x7CE9, 0x7CEA, 0x7CEB, 0x7CEC, 0x7CED,
    0x7CEE, 0x7CF0, 0x7CF1, 0x7CF2, 0x7CF3, 0x7CF4, 0x7CF5, 0x7CF6,
    0x7CF7, 0x7CF9, 0x7CFA, 0x7CFC, 0x7CFD, 0x7CFE, 0x7CFF, 0x7D00,
    0x7D01, 0x7D02, 0x7D03, 0x7D04, 0x7D05, 0x7D06, 0x7D07, 0x7D08,
    0x7D09, 0x7D0B, 0x7D0C, 0x7D0D, 0x7D0E, 0x7D0F, 0x7D10, 0x7D11,
    0x7D12, 0x7D13, 0x7D14, 0x7D15, 0x7D16, 0x7D17, 0x7D18, 0x7D19,
    0x7D1A, 0x7D1B, 0x7D1C, 0x7D1D, 0x7D1E, 0x7D1F, 0x7D21, 0x7D23,
    0x7D24, 0x7D25, 0x7D26, 0x7D28, 0x7D29, 0x7D2A, 0x7D2C, 0x7D2D,
    0x7D2E, 0x7D30, 0x7D31, 0x7D32, 0x7D33, 0x7D34, 0x7D35, 0x7D36,
    0x7D37, 0x7D38, 0x7D39, 0x7D3A, 0x7D3B, 0x7D3C, 0x7D3D, 0x7D3E,
    0x7D3F, 0x7D40, 0x7D41, 0x7D42, 0x7D43, 0x7D44, 0x7D45, 0x7D46,
    0x7D47, 0x7D48, 0x7D49, 0x7D4A, 0x7D4B, 0x7D4C, 0x7D4D, 0x7D4E,
    0x7D4F, 0x7D50, 0x7D51, 0x7D52, 0x7D53, 0x7D54, 0x7D55, 0x7D56,
    0x7D57, 0x7D58, 0x7D59, 0x7D5A, 0x7D5B, 0x7D5C, 0x7D5D, 0x7D5E,
    0x7D5F, 0x7D60, 0x7D61, 0x7D62, 0x7D63, 0x7D64, 0x7D65, 0x7D66,
    0x7D67, 0x7D68, 0x7D69, 0x7D6A, 0x7D6B, 0x7D6C, 0x7D6D, 0x7D6F,
    0x7D70, 0x7D71, 0x7D72, 0x7D73, 0x7D74, 0x7D75, 0x7D76, 0x7D78,
    0x7D79, 0x7D7A, 0x7D7B, 0x7D7C, 0x7D7D, 0x7D7E, 0x7D7F, 0x7D80,
    0x7D81, 0x7D82, 0x7D83, 0x7D84, 0x7D85, 0x7D86, 0x7D87, 0x7D88,
    0x7D89, 0x7D8A, 0x7D8B, 0x7D8C, 0x7D8D, 0x7D8E, 0x7D8F, 0x7D90,
    0x7D91, 0x7D92, 0x7D93, 0x7D94, 0x7D95, 0x7D96, 0x7D97, 0x7D98,
    0x7D99, 0x7D9A, 0x7D9B, 0x7D9C, 0x7D9D, 0x7D9E, 0x7D9F, 0x7DA0,
    0x7DA1, 0x7DA2, 0x7DA3, 0x7DA4, 0x7DA5, 0x7DA7, 0x7DA8, 0x7DA9,
    0x7DAA, 0x7DAB, 0x7DAC, 0x7DAD, 0x7DAF, 0x7DB0, 0x7DB1, 0x7DB2,
    0x7DB3, 0x7DB4, 0x7DB5, 0x7DB6, 0x7DB7, 0x7DB8, 0x7DB9, 0x7DBA,
    0x7DBB, 0x7DBC, 0x7DBD, 0x7DBE, 0x7DBF, 0x7DC0, 0x7DC1, 0x7DC2,
    0x7DC3, 0x7DC4, 0x7DC5, 0x7DC6, 0x7DC7, 0x7DC8, 0x7DC9, 0x7DCA,
    0x7DCB, 0x7DCC, 0x7DCD, 0x7DCE, 0x7DCF, 0x7DD0, 0x7DD1, 0x7DD2,
    0x7DD3, 0x7DD4, 0x7DD5, 0x7DD6, 0x7DD7, 0x7DD8, 0x7DD9, 0x7DDA,
    0x7DDB, 0x7DDC, 0x7DDD, 0x7DDE, 0x7DDF, 0x7DE0, 0x7DE1, 0x7DE2,
    0x7DE3, 0x7DE4, 0x7DE5, 0x7DE6, 0x7DE7, 0x7DE8, 0x7DE9, 0x7DEA,
    0x7DEB, 0x7DEC, 0x7DED, 0x7DEE, 0x7DEF, 0x7DF0, 0x7DF1, 0x7DF2,
    0x7DF3, 0x7DF4, 0x7DF5, 0x7DF6, 0x7DF7, 0x7DF8, 0x7DF9, 0x7DFA,
    0x7DFB, 0x7DFC, 0x7DFD, 0x7DFE, 0x7DFF, 0x7E00, 0x7E01, 0x7E02,
    0x7E03, 0x7E04, 0x7E05, 0x7E06, 0x7E07, 0x7E08, 0x7E09, 0x7E0A,
    0x7E0B, 0x7E0C, 0x7E0D, 0x7E0E, 0x7E0F, 0x7E10, 0x7E11, 0x7E12,
    0x7E13, 0x7E14, 0x7E15, 0x7E16, 0x7E17, 0x7E18, 0x7E19, 0x7E1A,
    0x7E1B, 0x7E1C, 0x7E1D, 0x7E1E, 0x7E1F, 0x7E20, 0x7E21, 0x7E22,
    0x7E23, 0x7E24, 0x7E25, 0x7E26, 0x7E27, 0x7E28, 0x7E29, 0x7E2A,
    0x7E2B, 0x7E2C, 0x7E2D, 0x7E2E, 0x7E2F, 0x7E30, 0x7E31, 0x7E32,
    0x7E33, 0x7E34, 0x7E35, 0x7E36, 0x7E37, 0x7E38, 0x7E39, 0x7E3A,
    0x7E3C, 0x7E3D, 0x7E3E, 0x7E3F, 0x7E40, 0x7E42, 0x7E43, 0x7E44,
    0x7E45, 0x7E46, 0x7E48, 0x7E49, 0x7E4A, 0x7E4B, 0x7E4C, 0x7E4D,
    0x7E4E, 0x7E4F, 0x7E50, 0x7E51, 0x7E52, 0x7E53, 0x7E54, 0x7E55,
    0x7E56, 0x7E57, 0x7E58, 0x7E59, 0x7E5A, 0x7E5B, 0x7E5C, 0x7E5D,
    0x7E5E, 0x7E5F, 0x7E60, 0x7E61, 0x7E62, 0x7E63, 0x7E64, 0x7E65,
    0x7E66, 0x7E67, 0x7E68, 0x7E69, 0x7E6A, 0x7E6B, 0x7E6C, 0x7E6D,
    0x7E6E, 0x7E6F, 0x7E70, 0x7E71, 0x7E72, 0x7E73, 0x7E74, 0x7E75,
    0x7E76, 0x7E77, 0x7E78, 0x7E79, 0x7E7A, 0x7E7B, 0x7E7C, 0x7E7D,
    0x7E7E, 0x7E7F, 0x7E80, 0x7E81, 0x7E83, 0x7E84, 0x7E85, 0x7E86,
    0x7E87, 0x7E88, 0x7E89, 0x7E8A, 0x7E8B, 0x7E8C, 0x7E8D, 0x7E8E,
    0x7E8F, 0x7E90, 0x7E91, 0x7E92, 0x7E93, 0x7E94, 0x7E95, 0x7E96,
    0x7E97, 0x7E98, 0x7E99, 0x7E9A, 0x7E9C, 0x7E9D, 0x7E9E, 0x7EAE,
    0x7EB4, 0x7EBB, 0x7EBC, 0x7ED6, 0x7EE4, 0x7EEC, 0x7EF9, 0x7F0A,
    0x7F10, 0x7F1E, 0x7F37, 0x7F39, 0x7F3B, 0x7F3C, 0x7F3D, 0x7F3E,
    0x7F3F, 0x7F40, 0x7F41, 0x7F43, 0x7F46, 0x7F47, 0x7F48, 0x7F49,
    0x7F4A, 0x7F4B, 0x7F4C, 0x7F4D, 0x7F4E, 0x7F4F, 0x7F52, 0x7F53,
    0x7F56, 0x7F59, 0x7F5B, 0x7F5C, 0x7F5D, 0x7F5E, 0x7F60, 0x7F63,
    0x7F64, 0x7F65, 0x7F66, 0x7F67, 0x7F6B, 0x7F6C, 0x7F6D, 0x7F6F,
    0x7F70, 0x7F73, 0x7F75, 0x7F76, 0x7F77, 0x7F78, 0x7F7A, 0x7F7B,
    0x7F7C, 0x7F7D, 0x7F7F, 0x7F80, 0x7F82, 0x7F83, 0x7F84, 0x7F85,
    0x7F86, 0x7F87, 0x7F88, 0x7F89, 0x7F8B, 0x7F8D, 0x7F8F, 0x7F90,
    0x7F91, 0x7F92, 0x7F93, 0x7F95, 0x7F96, 0x7F97, 0x7F98, 0x7F99,
    0x7F9B, 0x7F9C, 0x7FA0, 0x7FA2, 0x7FA3, 0x7FA5, 0x7FA6, 0x7FA8,
    0x7FA9, 0x7FAA, 0x7FAB, 0x7FAC, 0x7FAD, 0x7FAE, 0x7FB1, 0x7FB3,
    0x7FB4, 0x7FB5, 0x7FB6, 0x7FB7, 0x7FBA, 0x7FBB, 0x7FBE, 0x7FC0,
    0x7FC2, 0x7FC3, 0x7FC4, 0x7FC6, 0x7FC7, 0x7FC8, 0x7FC9, 0x7FCB,
    0x7FCD, 0x7FCF, 0x7FD0, 0x7FD1, 0x7FD2, 0x7FD3, 0x7FD6, 0x7FD7,
    0x7FD9, 0x7FDA, 0x7FDB, 0x7FDC, 0x7FDD, 0x7FDE, 0x7FE2, 0x7FE3,
    0x7FE4, 0x7FE7, 0x7FE8, 0x7FEA, 0x7FEB, 0x7FEC, 0x7FED, 0x7FEF,
    0x7FF2, 0x7FF4, 0x7FF5, 0x7FF6, 0x7FF7, 0x7FF8, 0x7FF9, 0x7FFA,
    0x7FFD, 0x7FFE, 0x7FFF, 0x8002, 0x8007, 0x8008, 0x8009, 0x800A,
    0x800E, 0x800F, 0x8011, 0x8013, 0x801A, 0x801B, 0x801D, 0x801E,
    0x801F, 0x8021, 0x8023, 0x8024, 0x802B, 0x802C, 0x802D, 0x802E,
    0x802F, 0x8030, 0x8032, 0x8034, 0x8039, 0x803A, 0x803C, 0x803E,
    0x8040, 0x8041, 0x8044, 0x8045, 0x8047, 0x8048, 0x8049, 0x804E,
    0x804F, 0x8050, 0x8051, 0x8053, 0x8055, 0x8056, 0x8057, 0x8059,
    0x805B, 0x805C, 0x805D, 0x805E, 0x805F, 0x8060, 0x8061, 0x8062,
    0x8063, 0x8064, 0x8065, 0x8066, 0x8067, 0x8068, 0x806B, 0x806C,
    0x806D, 0x806E, 0x806F, 0x8070, 0x8072, 0x8073, 0x8074, 0x8075,
    0x8076, 0x8077, 0x8078, 0x8079, 0x807A, 0x807B, 0x807C, 0x807D,
    0x807E, 0x8081, 0x8082, 0x8085, 0x8088, 0x808A, 0x808D, 0x808E,
    0x808F, 0x8090, 0x8091, 0x8092, 0x8094, 0x8095, 0x8097, 0x8099,
    0x809E, 0x80A3, 0x80A6, 0x80A7, 0x80A8, 0x80AC, 0x80B0, 0x80B3,
    0x80B5, 0x80B6, 0x80B8, 0x80B9, 0x80BB, 0x80C5, 0x80C7, 0x80C8,
    0x80C9, 0x80CA, 0x80CB, 0x80CF, 0x80D0, 0x80D1, 0x80D2, 0x80D3,
    0x80D4, 0x80D5, 0x80D8, 0x80DF, 0x80E0, 0x80E2, 0x80E3, 0x80E6,
    0x80EE, 0x80F5, 0x80F7, 0x80F9, 0x80FB, 0x80FE, 0x80FF, 0x8100,
    0x8101, 0x8103, 0x8104, 0x8105, 0x8107, 0x8108, 0x810B, 0x810C,
    0x8115, 0x8117, 0x8119, 0x811B, 0x811C, 0x811D, 0x811F, 0x8120,
    0x8121, 0x8122, 0x8123, 0x8124, 0x8125, 0x8126, 0x8127, 0x8128,
    0x8129, 0x812A, 0x812B, 0x812D, 0x812E, 0x8130, 0x8133, 0x8134,
    0x8135, 0x8137, 0x8139, 0x813A, 0x813B, 0x813C, 0x813D, 0x813F,
    0x8140, 0x8141, 0x8142, 0x8143, 0x8144, 0x8145, 0x8147, 0x8149,
    0x814D, 0x814E, 0x814F, 0x8152, 0x8156, 0x8157, 0x8158, 0x815B,
    0x815C, 0x815D, 0x815E, 0x815F, 0x8161, 0x8162, 0x8163, 0x8164,
    0x8166, 0x8168, 0x816A, 0x816B, 0x816C, 0x816F, 0x8172, 0x8173,
    0x8175, 0x8176, 0x8177, 0x8178, 0x8181, 0x8183, 0x8184, 0x8185,
    0x8186, 0x8187, 0x8189, 0x818B, 0x818C, 0x818D, 0x818E, 0x8190,
    0x8192, 0x8193, 0x8194, 0x8195, 0x8196, 0x8197, 0x8199, 0x819A,
    0x819E, 0x819F, 0x81A0, 0x81A1, 0x81A2, 0x81A4, 0x81A5, 0x81A7,
    0x81A9, 0x81AB, 0x81AC, 0x81AD, 0x81AE, 0x81AF, 0x81B0, 0x81B1,
    0x81B2, 0x81B4, 0x81B5, 0x81B6, 0x81B7, 0x81B8, 0x81B9, 0x81BC,
    0x81BD, 0x81BE, 0x81BF, 0x81C4, 0x81C5, 0x81C7, 0x81C8, 0x81C9,
    0x81CB, 0x81CD, 0x81CE, 0x81CF, 0x81D0, 0x81D1, 0x81D2, 0x81D3,
    0x81D4, 0x81D5, 0x81D6, 0x81D7, 0x81D8, 0x81D9, 0x81DA, 0x81DB,
    0x81DC, 0x81DD, 0x81DE, 0x81DF, 0x81E0, 0x81E1, 0x81E2, 0x81E4,
    0x81E5, 0x81E6, 0x81E8, 0x81E9, 0x81EB, 0x81EE, 0x81EF, 0x81F0,
    0x81F1, 0x81F2, 0x81F5, 0x81F6, 0x81F7, 0x81F8, 0x81F9, 0x81FA,
    0x81FD, 0x81FF, 0x8203, 0x8207, 0x8208, 0x8209, 0x820A, 0x820B,
    0x820E, 0x820F, 0x8211, 0x8213, 0x8215, 0x8216, 0x8217, 0x8218,
    0x8219, 0x821A, 0x821D, 0x8220, 0x8224, 0x8225, 0x8226, 0x8227,
    0x8229, 0x822E, 0x8232, 0x823A, 0x823C, 0x823D, 0x823F, 0x8240,
    0x8241, 0x8242, 0x8243, 0x8245, 0x8246, 0x8248, 0x824A, 0x824C,
    0x824D, 0x824E, 0x8250, 0x8251, 0x8252, 0x8253, 0x8254, 0x8255,
    0x8256, 0x8257, 0x8259, 0x825B, 0x825C, 0x825D, 0x825E, 0x8260,
    0x8261, 0x8262, 0x8263, 0x8264, 0x8265, 0x8266, 0x8267, 0x8269,
    0x826A, 0x826B, 0x826C, 0x826D, 0x8271, 0x8275, 0x8276, 0x8277,
    0x8278, 0x827B, 0x827C, 0x8280, 0x8281, 0x8283, 0x8285, 0x8286,
    0x8287, 0x8289, 0x828C, 0x8290, 0x8293, 0x8294, 0x8295, 0x8296,
    0x829A, 0x829B, 0x829E, 0x82A0, 0x82A2, 0x82A3, 0x82A7, 0x82B2,
    0x82B5, 0x82B6, 0x82BA, 0x82BB, 0x82BC, 0x82BF, 0x82C0, 0x82C2,
    0x82C3, 0x82C5, 0x82C6, 0x82C9, 0x82D0, 0x82D6, 0x82D9, 0x82DA,
    0x82DD, 0x82E2, 0x82E7, 0x82E8, 0x82E9, 0x82EA, 0x82EC, 0x82ED,
    0x82EE, 0x82F0, 0x82F2, 0x82F3, 0x82F5, 0x82F6, 0x82F8, 0x82FA,
    0x82FC, 0x82FD, 0x82FE, 0x82FF, 0x8300, 0x830A, 0x830B, 0x830D,
    0x8310, 0x8312, 0x8313, 0x8316, 0x8318, 0x8319, 0x831D, 0x831E,
    0x831F, 0x8320, 0x8321, 0x8322, 0x8323, 0x8324, 0x8325, 0x8326,
    0x8329, 0x832A, 0x832E, 0x8330, 0x8332, 0x8337, 0x833B, 0x833D,
    0x833E, 0x833F, 0x8341, 0x8342, 0x8344, 0x8345, 0x8348, 0x834A,
    0x834B, 0x834C, 0x834D, 0x834E, 0x8353, 0x8355, 0x8356, 0x8357,
    0x8358, 0x8359, 0x835D, 0x8362, 0x8370, 0x8371, 0x8372, 0x8373,
    0x8374, 0x8375, 0x8376, 0x8379, 0x837A, 0x837E, 0x837F, 0x8380,
    0x8381, 0x8382, 0x8383, 0x8384, 0x8387, 0x8388, 0x838A, 0x838B,
    0x838C, 0x838D, 0x838F, 0x8390, 0x8391, 0x8394, 0x8395, 0x8396,
    0x8397, 0x8399, 0x839A, 0x839D, 0x839F, 0x83A1, 0x83A2, 0x83A3,
    0x83A4, 0x83A5, 0x83A6, 0x83A7, 0x83AC, 0x83AD, 0x83AE, 0x83AF,
    0x83B5, 0x83BB, 0x83BE, 0x83BF, 0x83C2, 0x83C3, 0x83C4, 0x83C6,
    0x83C8, 0x83C9, 0x83CB, 0x83CD, 0x83CE, 0x83D0, 0x83D1, 0x83D2,
    0x83D3, 0x83D5, 0x83D7, 0x83D9, 0x83DA, 0x83DB, 0x83DE, 0x83E2,
    0x83E3, 0x83E4, 0x83E6, 0x83E7, 0x83E8, 0x83EB, 0x83EC, 0x83ED,
    0x83EE, 0x83EF, 0x83F3, 0x83F4, 0x83F5, 0x83F6, 0x83F7, 0x83FA,
    0x83FB, 0x83FC, 0x83FE, 0x83FF, 0x8400, 0x8402, 0x8405, 0x8407,
    0x8408, 0x8409, 0x840A, 0x8410, 0x8412, 0x8413, 0x8414, 0x8415,
    0x8416, 0x8417, 0x8419, 0x841A, 0x841B, 0x841E, 0x841F, 0x8420,
    0x8421, 0x8422, 0x8423, 0x8429, 0x842A, 0x842B, 0x842C, 0x842D,
    0x842E, 0x842F, 0x8430, 0x8432, 0x8433, 0x8434, 0x8435, 0x8436,
    0x8437, 0x8439, 0x843A, 0x843B, 0x843E, 0x843F, 0x8440, 0x8441,
    0x8442, 0x8443, 0x8444, 0x8445, 0x8447, 0x8448, 0x8449, 0x844A,
    0x844B, 0x844C, 0x844D, 0x844E, 0x844F, 0x8450, 0x8452, 0x8453,
    0x8454, 0x8455, 0x8456, 0x8458, 0x845D, 0x845E, 0x845F, 0x8460,
    0x8462, 0x8464, 0x8465, 0x8466, 0x8467, 0x8468, 0x846A, 0x846E,
    0x846F, 0x8470, 0x8472, 0x8474, 0x8477, 0x8479, 0x847B, 0x847C,
    0x847D, 0x847E, 0x847F, 0x8480, 0x8481, 0x8483, 0x8484, 0x8485,
    0x8486, 0x848A, 0x848D, 0x848F, 0x8490, 0x8491, 0x8492, 0x8493,
    0x8494, 0x8495, 0x8496, 0x8498, 0x849A, 0x849B, 0x849D, 0x849E,
    0x849F, 0x84A0, 0x84A2, 0x84A3, 0x84A4, 0x84A5, 0x84A6, 0x84A7,
    0x84A8, 0x84A9, 0x84AA, 0x84AB, 0x84AC, 0x84AD, 0x84AE, 0x84B0,
    0x84B1, 0x84B3, 0x84B5, 0x84B6, 0x84B7, 0x84BB, 0x84BC, 0x84BE,
    0x84C0, 0x84C2, 0x84C3, 0x84C5, 0x84C6, 0x84C7, 0x84C8, 0x84CB,
    0x84CC, 0x84CE, 0x84CF, 0x84D2, 0x84D4, 0x84D5, 0x84D7, 0x84D8,
    0x84D9, 0x84DA, 0x84DB, 0x84DC, 0x84DE, 0x84E1, 0x84E2, 0x84E4,
    0x84E7, 0x84E8, 0x84E9, 0x84EA, 0x84EB, 0x84ED, 0x84EE, 0x84EF,
    0x84F1, 0x84F2, 0x84F3, 0x84F4, 0x84F5, 0x84F6, 0x84F7, 0x84F8,
    0x84F9, 0x84FA, 0x84FB, 0x84FD, 0x84FE, 0x8500, 0x8501, 0x8502,
    0x8503, 0x8504, 0x8505, 0x8506, 0x8507, 0x8508, 0x8509, 0x850A,
    0x850B, 0x850D, 0x850E, 0x850F, 0x8510, 0x8512, 0x8514, 0x8515,
    0x8516, 0x8518, 0x8519, 0x851B, 0x851C, 0x851D, 0x851E, 0x8520,
    0x8522, 0x8523, 0x8524, 0x8525, 0x8526, 0x8527, 0x8528, 0x8529,
    0x852A, 0x852D, 0x852E, 0x852F, 0x8530, 0x8531, 0x8532, 0x8533,
    0x8534, 0x8535, 0x8536, 0x853E, 0x853F, 0x8540, 0x8541, 0x8542,
    0x8544, 0x8545, 0x8546, 0x8547, 0x854B, 0x854C, 0x854D, 0x854E,
    0x854F, 0x8550, 0x8551, 0x8552, 0x8553, 0x8554, 0x8555, 0x8557,
    0x8558, 0x855A, 0x855B, 0x855C, 0x855D, 0x855F, 0x8560, 0x8561,
    0x8562, 0x8563, 0x8565, 0x8566, 0x8567, 0x8569, 0x856A, 0x856B,
    0x856C, 0x856D, 0x856E, 0x856F, 0x8570, 0x8571, 0x8573, 0x8575,
    0x8576, 0x8577, 0x8578, 0x857C, 0x857D, 0x857F, 0x8580, 0x8581,
    0x8582, 0x8583, 0x8586, 0x8588, 0x8589, 0x858A, 0x858B, 0x858C,
    0x858D, 0x858E, 0x8590, 0x8591, 0x8592, 0x8593, 0x8594, 0x8595,
    0x8596, 0x8597, 0x8598, 0x8599, 0x859A, 0x859D, 0x859E, 0x859F,
    0x85A0, 0x85A1, 0x85A2, 0x85A3, 0x85A5, 0x85A6, 0x85A7, 0x85A9,
    0x85AB, 0x85AC, 0x85AD, 0x85B1, 0x85B2, 0x85B3, 0x85B4, 0x85B5,
    0x85B6, 0x85B8, 0x85BA, 0x85BB, 0x85BC, 0x85BD, 0x85BE, 0x85BF,
    0x85C0, 0x85C2, 0x85C3, 0x85C4, 0x85C5, 0x85C6, 0x85C7, 0x85C8,
    0x85CA, 0x85CB, 0x85CC, 0x85CD, 0x85CE, 0x85D1, 0x85D2, 0x85D4,
    0x85D6, 0x85D7, 0x85D8, 0x85D9, 0x85DA, 0x85DB, 0x85DD, 0x85DE,
    0x85DF, 0x85E0, 0x85E1, 0x85E2, 0x85E3, 0x85E5, 0x85E6, 0x85E7,
    0x85E8, 0x85EA, 0x85EB, 0x85EC, 0x85ED, 0x85EE, 0x85EF, 0x85F0,
    0x85F1, 0x85F2, 0x85F3, 0x85F4, 0x85F5, 0x85F6, 0x85F7, 0x85F8,
    0x85F9, 0x85FA, 0x85FC, 0x85FD, 0x85FE, 0x8600, 0x8601, 0x8602,
    0x8603, 0x8604, 0x8606, 0x8607, 0x8608, 0x8609, 0x860A, 0x860B,
    0x860C, 0x860D, 0x860E, 0x860F, 0x8610, 0x8612, 0x8613, 0x8614,
    0x8615, 0x8617, 0x8618, 0x8619, 0x861A, 0x861B, 0x861C, 0x861D,
    0x861E, 0x861F, 0x8620, 0x8621, 0x8622, 0x8623, 0x8624, 0x8625,
    0x8626, 0x8628, 0x862A, 0x862B, 0x862C, 0x862D, 0x862E, 0x862F,
    0x8630, 0x8631, 0x8632, 0x8633, 0x8634, 0x8635, 0x8636, 0x8637,
    0x8639, 0x863A, 0x863B, 0x863D, 0x863E, 0x863F, 0x8640, 0x8641,
    0x8642, 0x8643, 0x8644, 0x8645, 0x8646, 0x8647, 0x8648, 0x8649,
    0x864A, 0x864B, 0x864C, 0x8652, 0x8653, 0x8655, 0x8656, 0x8657,
    0x8658, 0x8659, 0x865B, 0x865C, 0x865D, 0x865F, 0x8660, 0x8661,
    0x8663, 0x8664, 0x8665, 0x8666, 0x8667, 0x8668, 0x8669, 0x866A,
    0x866D, 0x866F, 0x8670, 0x8672, 0x8673, 0x8674, 0x8675, 0x8676,
    0x8677, 0x8678, 0x8683, 0x8684, 0x8685, 0x8686, 0x8687, 0x8688,
    0x8689, 0x868E, 0x868F, 0x8690, 0x8691, 0x8692, 0x8694, 0x8696,
    0x8697, 0x8698, 0x8699, 0x869A, 0x869B, 0x869E, 0x869F, 0x86A0,
    0x86A1, 0x86A2, 0x86A5, 0x86A6, 0x86AB, 0x86AD, 0x86AE, 0x86B2,
    0x86B3, 0x86B7, 0x86B8, 0x86B9, 0x86BB, 0x86BC, 0x86BD, 0x86BE,
    0x86BF, 0x86C1, 0x86C2, 0x86C3, 0x86C5, 0x86C8, 0x86CC, 0x86CD,
    0x86D2, 0x86D3, 0x86D5, 0x86D6, 0x86D7, 0x86DA, 0x86DC, 0x86DD,
    0x86E0, 0x86E1, 0x86E2, 0x86E3, 0x86E5, 0x86E6, 0x86E7, 0x86E8,
    0x86EA, 0x86EB, 0x86EC, 0x86EF, 0x86F5, 0x86F6, 0x86F7, 0x86FA,
    0x86FB, 0x86FC, 0x86FD, 0x86FF, 0x8701, 0x8704, 0x8705, 0x8706,
    0x870B, 0x870C, 0x870E, 0x870F, 0x8710, 0x8711, 0x8714, 0x8716,
    0x8719, 0x871B, 0x871D, 0x871F, 0x8720, 0x8724, 0x8726, 0x8727,
    0x8728, 0x872A, 0x872B, 0x872C, 0x872D, 0x872F, 0x8730, 0x8732,
    0x8733, 0x8735, 0x8736, 0x8738, 0x8739, 0x873A, 0x873C, 0x873D,
    0x8740, 0x8741, 0x8742, 0x8743, 0x8744, 0x8745, 0x8746, 0x874A,
    0x874B, 0x874D, 0x874F, 0x8750, 0x8751, 0x8752, 0x8754, 0x8755,
    0x8756, 0x8758, 0x875A, 0x875B, 0x875C, 0x875D, 0x875E, 0x875F,
    0x8761, 0x8762, 0x8766, 0x8767, 0x8768, 0x8769, 0x876A, 0x876B,
    0x876C, 0x876D, 0x876F, 0x8771, 0x8772, 0x8773, 0x8775, 0x8777,
    0x8778, 0x8779, 0x877A, 0x877F, 0x8780, 0x8781, 0x8784, 0x8786,
    0x8787, 0x8789, 0x878A, 0x878C, 0x878E, 0x878F, 0x8790, 0x8791,
    0x8792, 0x8794, 0x8795, 0x8796, 0x8798, 0x8799, 0x879A, 0x879B,
    0x879C, 0x879D, 0x879E, 0x87A0, 0x87A1, 0x87A2, 0x87A3, 0x87A4,
    0x87A5, 0x87A6, 0x87A7, 0x87A9, 0x87AA, 0x87AE, 0x87B0, 0x87B1,
    0x87B2, 0x87B4, 0x87B6, 0x87B7, 0x87B8, 0x87B9, 0x87BB, 0x87BC,
    0x87BE, 0x87BF, 0x87C1, 0x87C2, 0x87C3, 0x87C4, 0x87C5, 0x87C7,
    0x87C8, 0x87C9, 0x87CC, 0x87CD, 0x87CE, 0x87CF, 0x87D0, 0x87D4,
    0x87D5, 0x87D6, 0x87D7, 0x87D8, 0x87D9, 0x87DA, 0x87DC, 0x87DD,
    0x87DE, 0x87DF, 0x87E1, 0x87E2, 0x87E3, 0x87E4, 0x87E6, 0x87E7,
    0x87E8, 0x87E9, 0x87EB, 0x87EC, 0x87ED, 0x87EF, 0x87F0, 0x87F1,
    0x87F2, 0x87F3, 0x87F4, 0x87F5, 0x87F6, 0x87F7, 0x87F8, 0x87FA,
    0x87FB, 0x87FC, 0x87FD, 0x87FF, 0x8800, 0x8801, 0x8802, 0x8804,
    0x8805, 0x8806, 0x8807, 0x8808, 0x8809, 0x880B, 0x880C, 0x880D,
    0x880E, 0x880F, 0x8810, 0x8811, 0x8812, 0x8814, 0x8817, 0x8818,
    0x8819, 0x881A, 0x881C, 0x881D, 0x881E, 0x881F, 0x8820, 0x8823,
    0x8824, 0x8825, 0x8826, 0x8827, 0x8828, 0x8829, 0x882A, 0x882B,
    0x882C, 0x882D, 0x882E, 0x882F, 0x8830, 0x8831, 0x8833, 0x8834,
    0x8835, 0x8836, 0x8837, 0x8838, 0x883A, 0x883B, 0x883D, 0x883E,
    0x883F, 0x8841, 0x8842, 0x8843, 0x8846, 0x8847, 0x8848, 0x8849,
    0x884A, 0x884B, 0x884E, 0x884F, 0x8850, 0x8851, 0x8852, 0x8853,
    0x8855, 0x8856, 0x8858, 0x885A, 0x885B, 0x885C, 0x885D, 0x885E,
    0x885F, 0x8860, 0x8866, 0x8867, 0x886A, 0x886D, 0x886F, 0x8871,
    0x8873, 0x8874, 0x8875, 0x8876, 0x8878, 0x8879, 0x887A, 0x887B,
    0x887C, 0x8880, 0x8883, 0x8886, 0x8887, 0x8889, 0x888A, 0x888C,
    0x888E, 0x888F, 0x8890, 0x8891, 0x8893, 0x8894, 0x8895, 0x8897,
    0x8898, 0x8899, 0x889A, 0x889B, 0x889D, 0x889E, 0x889F, 0x88A0,
    0x88A1, 0x88A3, 0x88A5, 0x88A6, 0x88A7, 0x88A8, 0x88A9, 0x88AA,
    0x88AC, 0x88AE, 0x88AF, 0x88B0, 0x88B2, 0x88B3, 0x88B4, 0x88B5,
    0x88B6, 0x88B8, 0x88B9, 0x88BA, 0x88BB, 0x88BD, 0x88BE, 0x88BF,
    0x88C0, 0x88C3, 0x88C4, 0x88C7, 0x88C8, 0x88CA, 0x88CB, 0x88CC,
    0x88CD, 0x88CF, 0x88D0, 0x88D1, 0x88D3, 0x88D6, 0x88D7, 0x88DA,
    0x88DB, 0x88DC, 0x88DD, 0x88DE, 0x88E0, 0x88E1, 0x88E6, 0x88E7,
    0x88E9, 0x88EA, 0x88EB, 0x88EC, 0x88ED, 0x88EE, 0x88EF, 0x88F2,
    0x88F5, 0x88F6, 0x88F7, 0x88FA, 0x88FB, 0x88FD, 0x88FF, 0x8900,
    0x8901, 0x8903, 0x8904, 0x8905, 0x8906, 0x8907, 0x8908, 0x8909,
    0x890B, 0x890C, 0x890D, 0x890E, 0x890F, 0x8911, 0x8914, 0x8915,
    0x8916, 0x8917, 0x8918, 0x891C, 0x891D, 0x891E, 0x891F, 0x8920,
    0x8922, 0x8923, 0x8924, 0x8926, 0x8927, 0x8928, 0x8929, 0x892C,
    0x892D, 0x892E, 0x892F, 0x8931, 0x8932, 0x8933, 0x8935, 0x8937,
    0x8938, 0x8939, 0x893A, 0x893B, 0x893C, 0x893D, 0x893E, 0x893F,
    0x8940, 0x8942, 0x8943, 0x8945, 0x8946, 0x8947, 0x8948, 0x8949,
    0x894A, 0x894B, 0x894C, 0x894D, 0x894E, 0x894F, 0x8950, 0x8951,
    0x8952, 0x8953, 0x8954, 0x8955, 0x8956, 0x8957, 0x8958, 0x8959,
    0x895A, 0x895B, 0x895C, 0x895D, 0x8960, 0x8961, 0x8962, 0x8963,
    0x8964, 0x8965, 0x8967, 0x8968, 0x8969, 0x896A, 0x896B, 0x896C,
    0x896D, 0x896E, 0x896F, 0x8970, 0x8971, 0x8972, 0x8973, 0x8974,
    0x8975, 0x8976, 0x8977, 0x8978, 0x8979, 0x897A, 0x897C, 0x897D,
    0x897E, 0x8980, 0x8982, 0x8984, 0x8985, 0x8987, 0x8988, 0x8989,
    0x898A, 0x898B, 0x898C, 0x898D, 0x898E, 0x898F, 0x8990, 0x8991,
    0x8992, 0x8993, 0x8994, 0x8995, 0x8996, 0x8997, 0x8998, 0x8999,
    0x899A, 0x899B, 0x899C, 0x899D, 0x899E, 0x899F, 0x89A0, 0x89A1,
    0x89A2, 0x89A3, 0x89A4, 0x89A5, 0x89A6, 0x89A7, 0x89A8, 0x89A9,
    0x89AA, 0x89AB, 0x89AC, 0x89AD, 0x89AE, 0x89AF, 0x89B0, 0x89B1,
    0x89B2, 0x89B3, 0x89B4, 0x89B5, 0x89B6, 0x89B7, 0x89B8, 0x89B9,
    0x89BA, 0x89BB, 0x89BC, 0x89BD, 0x89BE, 0x89BF, 0x89C0, 0x89C3,
    0x89CD, 0x89D3, 0x89D4, 0x89D5, 0x89D7, 0x89D8, 0x89D9, 0x89DB,
    0x89DD, 0x89DF, 0x89E0, 0x89E1, 0x89E2, 0x89E4, 0x89E7, 0x89E8,
    0x89E9, 0x89EA, 0x89EC, 0x89ED, 0x89EE, 0x89F0, 0x89F1, 0x89F2,
    0x89F4, 0x89F5, 0x89F6, 0x89F7, 0x89F8, 0x89F9, 0x89FA, 0x89FB,
    0x89FC, 0x89FD, 0x89FE, 0x89FF, 0x8A01, 0x8A02, 0x8A03, 0x8A04,
    0x8A05, 0x8A06, 0x8A08, 0x8A09, 0x8A0A, 0x8A0B, 0x8A0C, 0x8A0D,
    0x8A0E, 0x8A0F, 0x8A10, 0x8A11, 0x8A12, 0x8A13, 0x8A14, 0x8A15,
    0x8A16, 0x8A17, 0x8A18, 0x8A19, 0x8A1A, 0x8A1B, 0x8A1C, 0x8A1D,
    0x8A1E, 0x8A1F, 0x8A20, 0x8A21, 0x8A22, 0x8A23, 0x8A24, 0x8A25,
    0x8A26, 0x8A27, 0x8A28, 0x8A29, 0x8A2A, 0x8A2B, 0x8A2C, 0x8A2D,
    0x8A2E, 0x8A2F, 0x8A30, 0x8A31, 0x8A32, 0x8A33, 0x8A34, 0x8A35,
    0x8A36, 0x8A37, 0x8A38, 0x8A39, 0x8A3A, 0x8A3B, 0x8A3C, 0x8A3D,
    0x8A3F, 0x8A40, 0x8A41, 0x8A42, 0x8A43, 0x8A44, 0x8A45, 0x8A46,
    0x8A47, 0x8A49, 0x8A4A, 0x8A4B, 0x8A4C, 0x8A4D, 0x8A4E, 0x8A4F,
    0x8A50, 0x8A51, 0x8A52, 0x8A53, 0x8A54, 0x8A55, 0x8A56, 0x8A57,
    0x8A58, 0x8A59, 0x8A5A, 0x8A5B, 0x8A5C, 0x8A5D, 0x8A5E, 0x8A5F,
    0x8A60, 0x8A61, 0x8A62, 0x8A63, 0x8A64, 0x8A65, 0x8A66, 0x8A67,
    0x8A68, 0x8A69, 0x8A6A, 0x8A6B, 0x8A6C, 0x8A6D, 0x8A6E, 0x8A6F,
    0x8A70, 0x8A71, 0x8A72, 0x8A73, 0x8A74, 0x8A75, 0x8A76, 0x8A77,
    0x8A78, 0x8A7A, 0x8A7B, 0x8A7C, 0x8A7D, 0x8A7E, 0x8A7F, 0x8A80,
    0x8A81, 0x8A82, 0x8A83, 0x8A84, 0x8A85, 0x8A86, 0x8A87, 0x8A88,
    0x8A8B, 0x8A8C, 0x8A8D, 0x8A8E, 0x8A8F, 0x8A90, 0x8A91, 0x8A92,
    0x8A94, 0x8A95, 0x8A96, 0x8A97, 0x8A98, 0x8A99, 0x8A9A, 0x8A9B,
    0x8A9C, 0x8A9D, 0x8A9E, 0x8A9F, 0x8AA0, 0x8AA1, 0x8AA2, 0x8AA3,
    0x8AA4, 0x8AA5, 0x8AA6, 0x8AA7, 0x8AA8, 0x8AA9, 0x8AAA, 0x8AAB,
    0x8AAC, 0x8AAD, 0x8AAE, 0x8AAF, 0x8AB0, 0x8AB1, 0x8AB2, 0x8AB3,
    0x8AB4, 0x8AB5, 0x8AB6, 0x8AB7, 0x8AB8, 0x8AB9, 0x8ABA, 0x8ABB,
    0x8ABC, 0x8ABD, 0x8ABE, 0x8ABF, 0x8AC0, 0x8AC1, 0x8AC2, 0x8AC3,
    0x8AC4, 0x8AC5, 0x8AC6, 0x8AC7, 0x8AC8, 0x8AC9, 0x8ACA, 0x8ACB,
    0x8ACC, 0x8ACD, 0x8ACE, 0x8ACF, 0x8AD0, 0x8AD1, 0x8AD2, 0x8AD3,
    0x8AD4, 0x8AD5, 0x8AD6, 0x8AD7, 0x8AD8, 0x8AD9, 0x8ADA, 0x8ADB,
    0x8ADC, 0x8ADD, 0x8ADE, 0x8ADF, 0x8AE0, 0x8AE1, 0x8AE2, 0x8AE3,
    0x8AE4, 0x8AE5, 0x8AE6, 0x8AE7, 0x8AE8, 0x8AE9, 0x8AEA, 0x8AEB,
    0x8AEC, 0x8AED, 0x8AEE, 0x8AEF, 0x8AF0, 0x8AF1, 0x8AF2, 0x8AF3,
    0x8AF4, 0x8AF5, 0x8AF6, 0x8AF7, 0x8AF8, 0x8AF9, 0x8AFA, 0x8AFB,
    0x8AFC, 0x8AFD, 0x8AFE, 0x8AFF, 0x8B00, 0x8B01, 0x8B02, 0x8B03,
    0x8B04, 0x8B05, 0x8B06, 0x8B08, 0x8B09, 0x8B0A, 0x8B0B, 0x8B0C,
    0x8B0D, 0x8B0E, 0x8B0F, 0x8B10, 0x8B11, 0x8B12, 0x8B13, 0x8B14,
    0x8B15, 0x8B16, 0x8B17, 0x8B18, 0x8B19, 0x8B1A, 0x8B1B, 0x8B1C,
    0x8B1D, 0x8B1E, 0x8B1F, 0x8B20, 0x8B21, 0x8B22, 0x8B23, 0x8B24,
    0x8B25, 0x8B27, 0x8B28, 0x8B29, 0x8B2A, 0x8B2B, 0x8B2C, 0x8B2D,
    0x8B2E, 0x8B2F, 0x8B30, 0x8B31, 0x8B32, 0x8B33, 0x8B34, 0x8B35,
    0x8B36, 0x8B37, 0x8B38, 0x8B39, 0x8B3A, 0x8B3B, 0x8B3C, 0x8B3D,
    0x8B3E, 0x8B3F, 0x8B40, 0x8B41, 0x8B42, 0x8B43, 0x8B44, 0x8B45,
    0x8B46, 0x8B47, 0x8B48, 0x8B49, 0x8B4A, 0x8B4B, 0x8B4C, 0x8B4D,
    0x8B4E, 0x8B4F, 0x8B50, 0x8B51, 0x8B52, 0x8B53, 0x8B54, 0x8B55,
    0x8B56, 0x8B57, 0x8B58, 0x8B59, 0x8B5A, 0x8B5B, 0x8B5C, 0x8B5D,
    0x8B5E, 0x8B5F, 0x8B60, 0x8B61, 0x8B62, 0x8B63, 0x8B64, 0x8B65,
    0x8B67, 0x8B68, 0x8B69, 0x8B6A, 0x8B6B, 0x8B6D, 0x8B6E, 0x8B6F,
    0x8B70, 0x8B71, 0x8B72, 0x8B73, 0x8B74, 0x8B75, 0x8B76, 0x8B77,
    0x8B78, 0x8B79, 0x8B7A, 0x8B7B, 0x8B7C, 0x8B7D, 0x8B7E, 0x8B7F,
    0x8B80, 0x8B81, 0x8B82, 0x8B83, 0x8B84, 0x8B85, 0x8B86, 0x8B87,
    0x8B88, 0x8B89, 0x8B8A, 0x8B8B, 0x8B8C, 0x8B8D, 0x8B8E, 0x8B8F,
    0x8B90, 0x8B91, 0x8B92, 0x8B93, 0x8B94, 0x8B95, 0x8B96, 0x8B97,
    0x8B98, 0x8B99, 0x8B9A, 0x8B9B, 0x8B9C, 0x8B9D, 0x8B9E, 0x8B9F,
    0x8BAC, 0x8BB1, 0x8BBB, 0x8BC7, 0x8BD0, 0x8BEA, 0x8C09, 0x8C1E,
    0x8C38, 0x8C39, 0x8C3A, 0x8C3B, 0x8C3C, 0x8C3D, 0x8C3E, 0x8C3F,
    0x8C40, 0x8C42, 0x8C43, 0x8C44, 0x8C45, 0x8C48, 0x8C4A, 0x8C4B,
    0x8C4D, 0x8C4E, 0x8C4F, 0x8C50, 0x8C51, 0x8C52, 0x8C53, 0x8C54,
    0x8C56, 0x8C57, 0x8C58, 0x8C59, 0x8C5B, 0x8C5C, 0x8C5D, 0x8C5E,
    0x8C5F, 0x8C60, 0x8C63, 0x8C64, 0x8C65, 0x8C66, 0x8C67, 0x8C68,
    0x8C69, 0x8C6C, 0x8C6D, 0x8C6E, 0x8C6F, 0x8C70, 0x8C71, 0x8C72,
    0x8C74, 0x8C75, 0x8C76, 0x8C77, 0x8C7B, 0x8C7C, 0x8C7D, 0x8C7E,
    0x8C7F, 0x8C80, 0x8C81, 0x8C83, 0x8C84, 0x8C86, 0x8C87, 0x8C88,
    0x8C8B, 0x8C8D, 0x8C8E, 0x8C8F, 0x8C90, 0x8C91, 0x8C92, 0x8C93,
    0x8C95, 0x8C96, 0x8C97, 0x8C99, 0x8C9A, 0x8C9B, 0x8C9C, 0x8C9D,
    0x8C9E, 0x8C9F, 0x8CA0, 0x8CA1, 0x8CA2, 0x8CA3, 0x8CA4, 0x8CA5,
    0x8CA6, 0x8CA7, 0x8CA8, 0x8CA9, 0x8CAA, 0x8CAB, 0x8CAC, 0x8CAD,
    0x8CAE, 0x8CAF, 0x8CB0, 0x8CB1, 0x8CB2, 0x8CB3, 0x8CB4, 0x8CB5,
    0x8CB6, 0x8CB7, 0x8CB8, 0x8CB9, 0x8CBA, 0x8CBB, 0x8CBC, 0x8CBD,
    0x8CBE, 0x8CBF, 0x8CC0, 0x8CC1, 0x8CC2, 0x8CC3, 0x8CC4, 0x8CC5,
    0x8CC6, 0x8CC7, 0x8CC8, 0x8CC9, 0x8CCA, 0x8CCB, 0x8CCC, 0x8CCD,
    0x8CCE, 0x8CCF, 0x8CD0, 0x8CD1, 0x8CD2, 0x8CD3, 0x8CD4, 0x8CD5,
    0x8CD6, 0x8CD7, 0x8CD8, 0x8CD9, 0x8CDA, 0x8CDB, 0x8CDC, 0x8CDD,
    0x8CDE, 0x8CDF, 0x8CE0, 0x8CE1, 0x8CE2, 0x8CE3, 0x8CE4, 0x8CE5,
    0x8CE6, 0x8CE7, 0x8CE8, 0x8CE9, 0x8CEA, 0x8CEB, 0x8CEC, 0x8CED,
    0x8CEE, 0x8CEF, 0x8CF0, 0x8CF1, 0x8CF2, 0x8CF3, 0x8CF4, 0x8CF5,
    0x8CF6, 0x8CF7, 0x8CF8, 0x8CF9, 0x8CFA, 0x8CFB, 0x8CFC, 0x8CFD,
    0x8CFE, 0x8CFF, 0x8D00, 0x8D01, 0x8D02, 0x8D03, 0x8D04, 0x8D05,
    0x8D06, 0x8D07, 0x8D08, 0x8D09, 0x8D0A, 0x8D0B, 0x8D0C, 0x8D0D,
    0x8D0E, 0x8D0F, 0x8D10, 0x8D11, 0x8D12, 0x8D13, 0x8D14, 0x8D15,
    0x8D16, 0x8D17, 0x8D18, 0x8D19, 0x8D1A, 0x8D1B, 0x8D1C, 0x8D20,
    0x8D51, 0x8D52, 0x8D57, 0x8D5F, 0x8D65, 0x8D68, 0x8D69, 0x8D6A,
    0x8D6C, 0x8D6E, 0x8D6F, 0x8D71, 0x8D72, 0x8D78, 0x8D79, 0x8D7A,
    0x8D7B, 0x8D7C, 0x8D7D, 0x8D7E, 0x8D7F, 0x8D80, 0x8D82, 0x8D83,
    0x8D86, 0x8D87, 0x8D88, 0x8D89, 0x8D8C, 0x8D8D, 0x8D8E, 0x8D8F,
    0x8D90, 0x8D92, 0x8D93, 0x8D95, 0x8D96, 0x8D97, 0x8D98, 0x8D99,
    0x8D9A, 0x8D9B, 0x8D9C, 0x8D9D, 0x8D9E, 0x8DA0, 0x8DA1, 0x8DA2,
    0x8DA4, 0x8DA5, 0x8DA6, 0x8DA7, 0x8DA8, 0x8DA9, 0x8DAA, 0x8DAB,
    0x8DAC, 0x8DAD, 0x8DAE, 0x8DAF, 0x8DB0, 0x8DB2, 0x8DB6, 0x8DB7,
    0x8DB9, 0x8DBB, 0x8DBD, 0x8DC0, 0x8DC1, 0x8DC2, 0x8DC5, 0x8DC7,
    0x8DC8, 0x8DC9, 0x8DCA, 0x8DCD, 0x8DD0, 0x8DD2, 0x8DD3, 0x8DD4,
    0x8DD5, 0x8DD8, 0x8DD9, 0x8DDC, 0x8DE0, 0x8DE1, 0x8DE2, 0x8DE5,
    0x8DE6, 0x8DE7, 0x8DE9, 0x8DED, 0x8DEE, 0x8DF0, 0x8DF1, 0x8DF2,
    0x8DF4, 0x8DF6, 0x8DFC, 0x8DFE, 0x8DFF, 0x8E00, 0x8E01, 0x8E02,
    0x8E03, 0x8E04, 0x8E06, 0x8E07, 0x8E08, 0x8E0B, 0x8E0D, 0x8E0E,
    0x8E10, 0x8E11, 0x8E12, 0x8E13, 0x8E15, 0x8E16, 0x8E17, 0x8E18,
    0x8E19, 0x8E1A, 0x8E1B, 0x8E1C, 0x8E20, 0x8E21, 0x8E24, 0x8E25,
    0x8E26, 0x8E27, 0x8E28, 0x8E2B, 0x8E2D, 0x8E30, 0x8E32, 0x8E33,
    0x8E34, 0x8E36, 0x8E37, 0x8E38, 0x8E3B, 0x8E3C, 0x8E3E, 0x8E3F,
    0x8E43, 0x8E45, 0x8E46, 0x8E4C, 0x8E4D, 0x8E4E, 0x8E4F, 0x8E50,
    0x8E53, 0x8E54, 0x8E55, 0x8E56, 0x8E57, 0x8E58, 0x8E5A, 0x8E5B,
    0x8E5C, 0x8E5D, 0x8E5E, 0x8E5F, 0x8E60, 0x8E61, 0x8E62, 0x8E63,
    0x8E64, 0x8E65, 0x8E67, 0x8E68, 0x8E6A, 0x8E6B, 0x8E6E, 0x8E71,
    0x8E73, 0x8E75, 0x8E77, 0x8E78, 0x8E79, 0x8E7A, 0x8E7B, 0x8E7D,
    0x8E7E, 0x8E80, 0x8E82, 0x8E83, 0x8E84, 0x8E86, 0x8E88, 0x8E89,
    0x8E8A, 0x8E8B, 0x8E8C, 0x8E8D, 0x8E8E, 0x8E91, 0x8E92, 0x8E93,
    0x8E95, 0x8E96, 0x8E97, 0x8E98, 0x8E99, 0x8E9A, 0x8E9B, 0x8E9D,
    0x8E9F, 0x8EA0, 0x8EA1, 0x8EA2, 0x8EA3, 0x8EA4, 0x8EA5, 0x8EA6,
    0x8EA7, 0x8EA8, 0x8EA9, 0x8EAA, 0x8EAD, 0x8EAE, 0x8EB0, 0x8EB1,
    0x8EB3, 0x8EB4, 0x8EB5, 0x8EB6, 0x8EB7, 0x8EB8, 0x8EB9, 0x8EBB,
    0x8EBC, 0x8EBD, 0x8EBE, 0x8EBF, 0x8EC0, 0x8EC1, 0x8EC2, 0x8EC3,
    0x8EC4, 0x8EC5, 0x8EC6, 0x8EC7, 0x8EC8, 0x8EC9, 0x8ECA, 0x8ECB,
    0x8ECC, 0x8ECD, 0x8ECF, 0x8ED0, 0x8ED1, 0x8ED2, 0x8ED3, 0x8ED4,
    0x8ED5, 0x8ED6, 0x8ED7, 0x8ED8, 0x8ED9, 0x8EDA, 0x8EDB, 0x8EDC,
    0x8EDD, 0x8EDE, 0x8EDF, 0x8EE0, 0x8EE1, 0x8EE2, 0x8EE3, 0x8EE4,
    0x8EE5, 0x8EE6, 0x8EE7, 0x8EE8, 0x8EE9, 0x8EEA, 0x8EEB, 0x8EEC,
    0x8EED, 0x8EEE, 0x8EEF, 0x8EF0, 0x8EF1, 0x8EF2, 0x8EF3, 0x8EF4,
    0x8EF5, 0x8EF6, 0x8EF7, 0x8EF8, 0x8EF9, 0x8EFA, 0x8EFB, 0x8EFC,
    0x8EFD, 0x8EFE, 0x8EFF, 0x8F00, 0x8F01, 0x8F02, 0x8F03, 0x8F04,
    0x8F05, 0x8F06, 0x8F07, 0x8F08, 0x8F09, 0x8F0A, 0x8F0B, 0x8F0C,
    0x8F0D, 0x8F0E, 0x8F0F, 0x8F10, 0x8F11, 0x8F12, 0x8F13, 0x8F14,
    0x8F15, 0x8F16, 0x8F17, 0x8F18, 0x8F19, 0x8F1A, 0x8F1B, 0x8F1C,
    0x8F1D, 0x8F1E, 0x8F1F, 0x8F20, 0x8F21, 0x8F22, 0x8F23, 0x8F24,
    0x8F25, 0x8F26, 0x8F27, 0x8F28, 0x8F29, 0x8F2A, 0x8F2B, 0x8F2C,
    0x8F2D, 0x8F2E, 0x8F2F, 0x8F30, 0x8F31, 0x8F32, 0x8F33, 0x8F34,
    0x8F35, 0x8F36, 0x8F37, 0x8F38, 0x8F39, 0x8F3A, 0x8F3B, 0x8F3C,
    0x8F3D, 0x8F3E, 0x8F3F, 0x8F40, 0x8F41, 0x8F42, 0x8F43, 0x8F44,
    0x8F45, 0x8F46, 0x8F47, 0x8F48, 0x8F49, 0x8F4A, 0x8F4B, 0x8F4C,
    0x8F4D, 0x8F4E, 0x8F4F, 0x8F50, 0x8F51, 0x8F52, 0x8F53, 0x8F54,
    0x8F55, 0x8F56, 0x8F57, 0x8F58, 0x8F59, 0x8F5A, 0x8F5B, 0x8F5C,
    0x8F5D, 0x8F5E, 0x8F5F, 0x8F60, 0x8F61, 0x8F62, 0x8F63, 0x8F64,
    0x8F65, 0x8F6A, 0x8F80, 0x8F8C, 0x8F92, 0x8F9D, 0x8FA0, 0x8FA1,
    0x8FA2, 0x8FA4, 0x8FA5, 0x8FA6, 0x8FA7, 0x8FAA, 0x8FAC, 0x8FAD,
    0x8FAE, 0x8FAF, 0x8FB2, 0x8FB3, 0x8FB4, 0x8FB5, 0x8FB7, 0x8FB8,
    0x8FBA, 0x8FBB, 0x8FBC, 0x8FBF, 0x8FC0, 0x8FC3, 0x8FC6, 0x8FC9,
    0x8FCA, 0x8FCB, 0x8FCC, 0x8FCD, 0x8FCF, 0x8FD2, 0x8FD6, 0x8FD7,
    0x8FDA, 0x8FE0, 0x8FE1, 0x8FE3, 0x8FE7, 0x8FEC, 0x8FEF, 0x8FF1,
    0x8FF2, 0x8FF4, 0x8FF5, 0x8FF6, 0x8FFA, 0x8FFB, 0x8FFC, 0x8FFE,
    0x8FFF, 0x9007, 0x9008, 0x900C, 0x900E, 0x9013, 0x9015, 0x9018,
    0x9019, 0x901C, 0x9023, 0x9024, 0x9025, 0x9027, 0x9028, 0x9029,
    0x902A, 0x902B, 0x902C, 0x9030, 0x9031, 0x9032, 0x9033, 0x9034,
    0x9037, 0x9039, 0x903A, 0x903D, 0x903F, 0x9040, 0x9043, 0x9045,
    0x9046, 0x9048, 0x9049, 0x904A, 0x904B, 0x904C, 0x904E, 0x9054,
    0x9055, 0x9056, 0x9059, 0x905A, 0x905C, 0x905D, 0x905E, 0x905F,
    0x9060, 0x9061, 0x9064, 0x9066, 0x9067, 0x9069, 0x906A, 0x906B,
    0x906C, 0x906F, 0x9070, 0x9071, 0x9072, 0x9073, 0x9076, 0x9077,
    0x9078, 0x9079, 0x907A, 0x907B, 0x907C, 0x907E, 0x9081, 0x9084,
    0x9085, 0x9086, 0x9087, 0x9089, 0x908A, 0x908C, 0x908D, 0x908E,
    0x908F, 0x9090, 0x9092, 0x9094, 0x9096, 0x9098, 0x909A, 0x909C,
    0x909E, 0x909F, 0x90A0, 0x90A4, 0x90A5, 0x90A7, 0x90A8, 0x90A9,
    0x90AB, 0x90AD, 0x90B2, 0x90B7, 0x90BC, 0x90BD, 0x90BF, 0x90C0,
    0x90C2, 0x90C3, 0x90C6, 0x90C8, 0x90C9, 0x90CB, 0x90CC, 0x90CD,
    0x90D2, 0x90D4, 0x90D5, 0x90D6, 0x90D8, 0x90D9, 0x90DA, 0x90DE,
    0x90DF, 0x90E0, 0x90E3, 0x90E4, 0x90E5, 0x90E9, 0x90EA, 0x90EC,
    0x90EE, 0x90F0, 0x90F1, 0x90F2, 0x90F3, 0x90F5, 0x90F6, 0x90F7,
    0x90F9, 0x90FA, 0x90FB, 0x90FC, 0x90FF, 0x9100, 0x9101, 0x9103,
    0x9105, 0x9106, 0x9107, 0x9108, 0x9109, 0x910A, 0x910B, 0x910C,
    0x910D, 0x910E, 0x910F, 0x9110, 0x9111, 0x9112, 0x9113, 0x9114,
    0x9115, 0x9116, 0x9117, 0x9118, 0x911A, 0x911B, 0x911C, 0x911D,
    0x911F, 0x9120, 0x9121, 0x9124, 0x9125, 0x9126, 0x9127, 0x9128,
    0x9129, 0x912A, 0x912B, 0x912C, 0x912D, 0x912E, 0x9130, 0x9132,
    0x9133, 0x9134, 0x9135, 0x9136, 0x9137, 0x9138, 0x913A, 0x913B,
    0x913C, 0x913D, 0x913E, 0x913F, 0x9140, 0x9141, 0x9142, 0x9144,
    0x9145, 0x9147, 0x9148, 0x9151, 0x9153, 0x9154, 0x9155, 0x9156,
    0x9158, 0x9159, 0x915B, 0x915C, 0x915F, 0x9160, 0x9166, 0x9167,
    0x9168, 0x916B, 0x916D, 0x9173, 0x917A, 0x917B, 0x917C, 0x9180,
    0x9181, 0x9182, 0x9183, 0x9184, 0x9186, 0x9188, 0x918A, 0x918E,
    0x918F, 0x9193, 0x9194, 0x9195, 0x9196, 0x9197, 0x9198, 0x9199,
    0x919C, 0x919D, 0x919E, 0x919F, 0x91A0, 0x91A1, 0x91A4, 0x91A5,
    0x91A6, 0x91A7, 0x91A8, 0x91A9, 0x91AB, 0x91AC, 0x91B0, 0x91B1,
    0x91B2, 0x91B3, 0x91B6, 0x91B7, 0x91B8, 0x91B9, 0x91BB, 0x91BC,
    0x91BD, 0x91BE, 0x91BF, 0x91C0, 0x91C1, 0x91C2, 0x91C3, 0x91C4,
    0x91C5, 0x91C6, 0x91C8, 0x91CB, 0x91D0, 0x91D2, 0x91D3, 0x91D4,
    0x91D5, 0x91D6, 0x91D7, 0x91D8, 0x91D9, 0x91DA, 0x91DB, 0x91DD,
    0x91DE, 0x91DF, 0x91E0, 0x91E1, 0x91E2, 0x91E3, 0x91E4, 0x91E5,
    0x91E6, 0x91E7, 0x91E8, 0x91E9, 0x91EA, 0x91EB, 0x91EC, 0x91ED,
    0x91EE, 0x91EF, 0x91F0, 0x91F1, 0x91F2, 0x91F3, 0x91F4, 0x91F5,
    0x91F6, 0x91F7, 0x91F8, 0x91F9, 0x91FA, 0x91FB, 0x91FC, 0x91FD,
    0x91FE, 0x91FF, 0x9200, 0x9201, 0x9202, 0x9203, 0x9204, 0x9205,
    0x9206, 0x9207, 0x9208, 0x9209, 0x920A, 0x920B, 0x920C, 0x920D,
    0x920E, 0x920F, 0x9210, 0x9211, 0x9212, 0x9213, 0x9214, 0x9215,
    0x9216, 0x9217, 0x9218, 0x9219, 0x921A, 0x921B, 0x921C, 0x921D,
    0x921E, 0x921F, 0x9220, 0x9221, 0x9222, 0x9223, 0x9224, 0x9225,
    0x9226, 0x9227, 0x9228, 0x9229, 0x922A, 0x922B, 0x922C, 0x922D,
    0x922E, 0x922F, 0x9230, 0x9231, 0x9232, 0x9233, 0x9234, 0x9235,
    0x9236, 0x9237, 0x9238, 0x9239, 0x923A, 0x923B, 0x923C, 0x923D,
    0x923E, 0x923F, 0x9240, 0x9241, 0x9242, 0x9243, 0x9244, 0x9245,
    0x9246, 0x9247, 0x9248, 0x9249, 0x924A, 0x924B, 0x924C, 0x924D,
    0x924E, 0x924F, 0x9250, 0x9251, 0x9252, 0x9253, 0x9254, 0x9255,
    0x9256, 0x9257, 0x9258, 0x9259, 0x925A, 0x925B, 0x925C, 0x925D,
    0x925E, 0x925F, 0x9260, 0x9261, 0x9262, 0x9263, 0x9264, 0x9265,
    0x9266, 0x9267, 0x9268, 0x9269, 0x926A, 0x926B, 0x926C, 0x926D,
    0x926E, 0x926F, 0x9270, 0x9271, 0x9272, 0x9273, 0x9275, 0x9276,
    0x9277, 0x9278, 0x9279, 0x927A, 0x927B, 0x927C, 0x927D, 0x927E,
    0x927F, 0x9280, 0x9281, 0x9282, 0x9283, 0x9284, 0x9285, 0x9286,
    0x9287, 0x9288, 0x9289, 0x928A, 0x928B, 0x928C, 0x928D, 0x928F,
    0x9290, 0x9291, 0x9292, 0x9293, 0x9294, 0x9295, 0x9296, 0x9297,
    0x9298, 0x9299, 0x929A, 0x929B, 0x929C, 0x929D, 0x929E, 0x929F,
    0x92A0, 0x92A1, 0x92A2, 0x92A3, 0x92A4, 0x92A5, 0x92A6, 0x92A7,
    0x92A8, 0x92A9, 0x92AA, 0x92AB, 0x92AC, 0x92AD, 0x92AF, 0x92B0,
    0x92B1, 0x92B2, 0x92B3, 0x92B4, 0x92B5, 0x92B6, 0x92B7, 0x92B8,
    0x92B9, 0x92BA, 0x92BB, 0x92BC, 0x92BD, 0x92BE, 0x92BF, 0x92C0,
    0x92C1, 0x92C2, 0x92C3, 0x92C4, 0x92C5, 0x92C6, 0x92C7, 0x92C9,
    0x92CA, 0x92CB, 0x92CC, 0x92CD, 0x92CE, 0x92CF, 0x92D0, 0x92D1,
    0x92D2, 0x92D3, 0x92D4, 0x92D5, 0x92D6, 0x92D7, 0x92D8, 0x92D9,
    0x92DA, 0x92DB, 0x92DC, 0x92DD, 0x92DE, 0x92DF, 0x92E0, 0x92E1,
    0x92E2, 0x92E3, 0x92E4, 0x92E5, 0x92E6, 0x92E7, 0x92E8, 0x92E9,
    0x92EA, 0x92EB, 0x92EC, 0x92ED, 0x92EE, 0x92EF, 0x92F0, 0x92F1,
    0x92F2, 0x92F3, 0x92F4, 0x92F5, 0x92F6, 0x92F7, 0x92F8, 0x92F9,
    0x92FA, 0x92FB, 0x92FC, 0x92FD, 0x92FE, 0x92FF, 0x9300, 0x9301,
    0x9302, 0x9303, 0x9304, 0x9305, 0x9306, 0x9307, 0x9308, 0x9309,
    0x930A, 0x930B, 0x930C, 0x930D, 0x930E, 0x930F, 0x9310, 0x9311,
    0x9312, 0x9313, 0x9314, 0x9315, 0x9316, 0x9317, 0x9318, 0x9319,
    0x931A, 0x931B, 0x931C, 0x931D, 0x931E, 0x931F, 0x9320, 0x9321,
    0x9322, 0x9323, 0x9324, 0x9325, 0x9326, 0x9327, 0x9328, 0x9329,
    0x932A, 0x932B, 0x932C, 0x932D, 0x932E, 0x932F, 0x9330, 0x9331,
    0x9332, 0x9333, 0x9334, 0x9335, 0x9336, 0x9337, 0x9338, 0x9339,
    0x933A, 0x933B, 0x933C, 0x933D, 0x933F, 0x9340, 0x9341, 0x9342,
    0x9343, 0x9344, 0x9345, 0x9346, 0x9347, 0x9348, 0x9349, 0x934A,
    0x934B, 0x934C, 0x934D, 0x934E, 0x934F, 0x9350, 0x9351, 0x9352,
    0x9353, 0x9354, 0x9355, 0x9356, 0x9357, 0x9358, 0x9359, 0x935A,
    0x935B, 0x935C, 0x935D, 0x935E, 0x935F, 0x9360, 0x9361, 0x9362,
    0x9363, 0x9364, 0x9365, 0x9366, 0x9367, 0x9368, 0x9369, 0x936B,
    0x936C, 0x936D, 0x936E, 0x936F, 0x9370, 0x9371, 0x9372, 0x9373,
    0x9374, 0x9375, 0x9376, 0x9377, 0x9378, 0x9379, 0x937A, 0x937B,
    0x937C, 0x937D, 0x937E, 0x937F, 0x9380, 0x9381, 0x9382, 0x9383,
    0x9384, 0x9385, 0x9386, 0x9387, 0x9388, 0x9389, 0x938A, 0x938B,
    0x938C, 0x938D, 0x938E, 0x9390, 0x9391, 0x9392, 0x9393, 0x9394,
    0x9395, 0x9396, 0x9397, 0x9398, 0x9399, 0x939A, 0x939B, 0x939C,
    0x939D, 0x939E, 0x939F, 0x93A0, 0x93A1, 0x93A2, 0x93A3, 0x93A4,
    0x93A5, 0x93A6, 0x93A7, 0x93A8, 0x93A9, 0x93AA, 0x93AB, 0x93AC,
    0x93AD, 0x93AE, 0x93AF, 0x93B0, 0x93B1, 0x93B2, 0x93B3, 0x93B4,
    0x93B5, 0x93B6, 0x93B7, 0x93B8, 0x93B9, 0x93BA, 0x93BB, 0x93BC,
    0x93BD, 0x93BE, 0x93BF, 0x93C0, 0x93C1, 0x93C2, 0x93C3, 0x93C4,
    0x93C5, 0x93C6, 0x93C7, 0x93C8, 0x93C9, 0x93CB, 0x93CC, 0x93CD,
    0x93CE, 0x93CF, 0x93D0, 0x93D1, 0x93D2, 0x93D3, 0x93D4, 0x93D5,
    0x93D7, 0x93D8, 0x93D9, 0x93DA, 0x93DB, 0x93DC, 0x93DD, 0x93DE,
    0x93DF, 0x93E0, 0x93E1, 0x93E2, 0x93E3, 0x93E4, 0x93E5, 0x93E6,
    0x93E7, 0x93E8, 0x93E9, 0x93EA, 0x93EB, 0x93EC, 0x93ED, 0x93EE,
    0x93EF, 0x93F0, 0x93F1, 0x93F2, 0x93F3, 0x93F4, 0x93F5, 0x93F6,
    0x93F7, 0x93F8, 0x93F9, 0x93FA, 0x93FB, 0x93FC, 0x93FD, 0x93FE,
    0x93FF, 0x9400, 0x9401, 0x9402, 0x9403, 0x9404, 0x9405, 0x9406,
    0x9407, 0x9408, 0x9409, 0x940A, 0x940B, 0x940C, 0x940D, 0x940E,
    0x940F, 0x9410, 0x9411, 0x9412, 0x9413, 0x9414, 0x9415, 0x9416,
    0x9417, 0x9418, 0x9419, 0x941A, 0x941B, 0x941C, 0x941D, 0x941E,
    0x941F, 0x9420, 0x9421, 0x9422, 0x9423, 0x9424, 0x9425, 0x9426,
    0x9427, 0x9428, 0x9429, 0x942A, 0x942B, 0x942C, 0x942D, 0x942E,
    0x942F, 0x9430, 0x9431, 0x9432, 0x9433, 0x9434, 0x9435, 0x9436,
    0x9437, 0x9438, 0x9439, 0x943A, 0x943B, 0x943C, 0x943D, 0x943F,
    0x9440, 0x9441, 0x9442, 0x9443, 0x9444, 0x9445, 0x9446, 0x9447,
    0x9448, 0x9449, 0x944A, 0x944B, 0x944C, 0x944D, 0x944E, 0x944F,
    0x9450, 0x9451, 0x9452, 0x9453, 0x9454, 0x9455, 0x9456, 0x9457,
    0x9458, 0x9459, 0x945A, 0x945B, 0x945C, 0x945D, 0x945E, 0x945F,
    0x9460, 0x9461, 0x9462, 0x9463, 0x9464, 0x9465, 0x9466, 0x9467,
    0x9468, 0x9469, 0x946A, 0x946C, 0x946D, 0x946E, 0x946F, 0x9470,
    0x9471, 0x9472, 0x9473, 0x9474, 0x9475, 0x9476, 0x9477, 0x9478,
    0x9479, 0x947A, 0x947B, 0x947C, 0x947D, 0x947E, 0x947F, 0x9480,
    0x9481, 0x9482, 0x9483, 0x9484, 0x9491, 0x9496, 0x9498, 0x94C7,
    0x94CF, 0x94D3, 0x94D4, 0x94DA, 0x94E6, 0x94FB, 0x951C, 0x9520,
    0x9527, 0x9533, 0x953D, 0x9543, 0x9548, 0x954B, 0x9555, 0x955A,
    0x9560, 0x956E, 0x9574, 0x9575, 0x9577, 0x9578, 0x9579, 0x957A,
    0x957B, 0x957C, 0x957D, 0x957E, 0x9580, 0x9581, 0x9582, 0x9583,
    0x9584, 0x9585, 0x9586, 0x9587, 0x9588, 0x9589, 0x958A, 0x958B,
    0x958C, 0x958D, 0x958E, 0x958F, 0x9590, 0x9591, 0x9592, 0x9593,
    0x9594, 0x9595, 0x9596, 0x9597, 0x9598, 0x9599, 0x959A, 0x959B,
    0x959C, 0x959D, 0x959E, 0x959F, 0x95A0, 0x95A1, 0x95A2, 0x95A3,
    0x95A4, 0x95A5, 0x95A6, 0x95A7, 0x95A8, 0x95A9, 0x95AA, 0x95AB,
    0x95AC, 0x95AD, 0x95AE, 0x95AF, 0x95B0, 0x95B1, 0x95B2, 0x95B3,
    0x95B4, 0x95B5, 0x95B6, 0x95B7, 0x95B8, 0x95B9, 0x95BA, 0x95BB,
    0x95BC, 0x95BD, 0x95BE, 0x95BF, 0x95C0, 0x95C1, 0x95C2, 0x95C3,
    0x95C4, 0x95C5, 0x95C6, 0x95C7, 0x95C8, 0x95C9, 0x95CA, 0x95CB,
    0x95CC, 0x95CD, 0x95CE, 0x95CF, 0x95D0, 0x95D1, 0x95D2, 0x95D3,
    0x95D4, 0x95D5, 0x95D6, 0x95D7, 0x95D8, 0x95D9, 0x95DA, 0x95DB,
    0x95DC, 0x95DD, 0x95DE, 0x95DF, 0x95E0, 0x95E1, 0x95E2, 0x95E3,
    0x95E4, 0x95E5, 0x95E6, 0x95E7, 0x95EC, 0x95FF, 0x9607, 0x9613,
    0x9618, 0x961B, 0x961E, 0x9620, 0x9623, 0x9624, 0x9625, 0x9626,
    0x9627, 0x9628, 0x9629, 0x962B, 0x962C, 0x962D, 0x962F, 0x9630,
    0x9637, 0x9638, 0x9639, 0x963A, 0x963E, 0x9641, 0x9643, 0x964A,
    0x964E, 0x964F, 0x9651, 0x9652, 0x9653, 0x9656, 0x9657, 0x9658,
    0x9659, 0x965A, 0x965C, 0x965D, 0x965E, 0x9660, 0x9663, 0x9665,
    0x9666, 0x966B, 0x966D, 0x966E, 0x966F, 0x9670, 0x9671, 0x9673,
    0x9678, 0x9679, 0x967A, 0x967B, 0x967C, 0x967D, 0x967E, 0x967F,
    0x9680, 0x9681, 0x9682, 0x9683, 0x9684, 0x9687, 0x9689, 0x968A,
    0x968C, 0x968E, 0x9691, 0x9692, 0x9693, 0x9695, 0x9696, 0x969A,
    0x969B, 0x969D, 0x969E, 0x969F, 0x96A0, 0x96A1, 0x96A2, 0x96A3,
    0x96A4, 0x96A5, 0x96A6, 0x96A8, 0x96A9, 0x96AA, 0x96AB, 0x96AC,
    0x96AD, 0x96AE, 0x96AF, 0x96B1, 0x96B2, 0x96B4, 0x96B5, 0x96B7,
    0x96B8, 0x96BA, 0x96BB, 0x96BF, 0x96C2, 0x96C3, 0x96C8, 0x96CA,
    0x96CB, 0x96D0, 0x96D1, 0x96D3, 0x96D4, 0x96D6, 0x96D7, 0x96D8,
    0x96D9, 0x96DA, 0x96DB, 0x96DC, 0x96DD, 0x96DE, 0x96DF, 0x96E1,
    0x96E2, 0x96E3, 0x96E4, 0x96E5, 0x96E6, 0x96E7, 0x96EB, 0x96EC,
    0x96ED, 0x96EE, 0x96F0, 0x96F1, 0x96F2, 0x96F4, 0x96F5, 0x96F8,
    0x96FA, 0x96FB, 0x96FC, 0x96FD, 0x96FF, 0x9702, 0x9703, 0x9705,
    0x970A, 0x970B, 0x970C, 0x9710, 0x9711, 0x9712, 0x9714, 0x9715,
    0x9717, 0x9718, 0x9719, 0x971A, 0x971B, 0x971D, 0x971F, 0x9720,
    0x9721, 0x9722, 0x9723, 0x9724, 0x9725, 0x9726, 0x9727, 0x9728,
    0x9729, 0x972B, 0x972C, 0x972E, 0x972F, 0x9731, 0x9733, 0x9734,
    0x9735, 0x9736, 0x9737, 0x973A, 0x973B, 0x973C, 0x973D, 0x973F,
    0x9740, 0x9741, 0x9742, 0x9743, 0x9744, 0x9745, 0x9746, 0x9747,
    0x9748, 0x9749, 0x974A, 0x974B, 0x974C, 0x974D, 0x974E, 0x974F,
    0x9750, 0x9751, 0x9754, 0x9755, 0x9757, 0x9758, 0x975A, 0x975C,
    0x975D, 0x975F, 0x9763, 0x9764, 0x9766, 0x9767, 0x9768, 0x976A,
    0x976B, 0x976C, 0x976D, 0x976E, 0x976F, 0x9770, 0x9771, 0x9772,
    0x9775, 0x9777, 0x9778, 0x9779, 0x977A, 0x977B, 0x977D, 0x977E,
    0x977F, 0x9780, 0x9781, 0x9782, 0x9783, 0x9784, 0x9786, 0x9787,
    0x9788, 0x9789, 0x978A, 0x978C, 0x978E, 0x978F, 0x9790, 0x9793,
    0x9795, 0x9796, 0x9797, 0x9799, 0x979A, 0x979B, 0x979C, 0x979D,
    0x979E, 0x979F, 0x97A1, 0x97A2, 0x97A4, 0x97A5, 0x97A6, 0x97A7,
    0x97A8, 0x97A9, 0x97AA, 0x97AC, 0x97AE, 0x97B0, 0x97B1, 0x97B3,
    0x97B5, 0x97B6, 0x97B7, 0x97B8, 0x97B9, 0x97BA, 0x97BB, 0x97BC,
    0x97BD, 0x97BE, 0x97BF, 0x97C0, 0x97C1, 0x97C2, 0x97C3, 0x97C4,
    0x97C5, 0x97C6, 0x97C7, 0x97C8, 0x97C9, 0x97CA, 0x97CB, 0x97CC,
    0x97CD, 0x97CE, 0x97CF, 0x97D0, 0x97D1, 0x97D2, 0x97D3, 0x97D4,
    0x97D5, 0x97D6, 0x97D7, 0x97D8, 0x97D9, 0x97DA, 0x97DB, 0x97DC,
    0x97DD, 0x97DE, 0x97DF, 0x97E0, 0x97E1, 0x97E2, 0x97E3, 0x97E4,
    0x97E5, 0x97E8, 0x97EE, 0x97EF, 0x97F0, 0x97F1, 0x97F2, 0x97F4,
    0x97F7, 0x97F8, 0x97F9, 0x97FA, 0x97FB, 0x97FC, 0x97FD, 0x97FE,
    0x97FF, 0x9800, 0x9801, 0x9802, 0x9803, 0x9804, 0x9805, 0x9806,
    0x9807, 0x9808, 0x9809, 0x980A, 0x980B, 0x980C, 0x980D, 0x980E,
    0x980F, 0x9810, 0x9811, 0x9812, 0x9813, 0x9814, 0x9815, 0x9816,
    0x9817, 0x9818, 0x9819, 0x981A, 0x981B, 0x981C, 0x981D, 0x981E,
    0x981F, 0x9820, 0x9821, 0x9822, 0x9823, 0x9824, 0x9825, 0x9826,
    0x9827, 0x9828, 0x9829, 0x982A, 0x982B, 0x982C, 0x982D, 0x982E,
    0x982F, 0x9830, 0x9831, 0x9832, 0x9833, 0x9834, 0x9835, 0x9836,
    0x9837, 0x9838, 0x9839, 0x983A, 0x983B, 0x983C, 0x983D, 0x983E,
    0x983F, 0x9840, 0x9841, 0x9842, 0x9843, 0x9844, 0x9845, 0x9846,
    0x9847, 0x9848, 0x9849, 0x984A, 0x984B, 0x984C, 0x984D, 0x984E,
    0x984F, 0x9850, 0x9851, 0x9852, 0x9853, 0x9854, 0x9855, 0x9856,
    0x9857, 0x9858, 0x9859, 0x985A, 0x985B, 0x985C, 0x985D, 0x985E,
    0x985F, 0x9860, 0x9861, 0x9862, 0x9863, 0x9864, 0x9865, 0x9866,
    0x9867, 0x9868, 0x9869, 0x986A, 0x986B, 0x986C, 0x986D, 0x986E,
    0x986F, 0x9870, 0x9871, 0x9872, 0x9873, 0x9874, 0x988B, 0x988E,
    0x9892, 0x9895, 0x9899, 0x98A3, 0x98A8, 0x98A9, 0x98AA, 0x98AB,
    0x98AC, 0x98AD, 0x98AE, 0x98AF, 0x98B0, 0x98B1, 0x98B2, 0x98B3,
    0x98B4, 0x98B5, 0x98B6, 0x98B7, 0x98B8, 0x98B9, 0x98BA, 0x98BB,
    0x98BC, 0x98BD, 0x98BE, 0x98BF, 0x98C0, 0x98C1, 0x98C2, 0x98C3,
    0x98C4, 0x98C5, 0x98C6, 0x98C7, 0x98C8, 0x98C9, 0x98CA, 0x98CB,
    0x98CC, 0x98CD, 0x98CF, 0x98D0, 0x98D4, 0x98D6, 0x98D7, 0x98DB,
    0x98DC, 0x98DD, 0x98E0, 0x98E1, 0x98E2, 0x98E3, 0x98E4, 0x98E5,
    0x98E6, 0x98E9, 0x98EA, 0x98EB, 0x98EC, 0x98ED, 0x98EE, 0x98EF,
    0x98F0, 0x98F1, 0x98F2, 0x98F3, 0x98F4, 0x98F5, 0x98F6, 0x98F7,
    0x98F8, 0x98F9, 0x98FA, 0x98FB, 0x98FC, 0x98FD, 0x98FE, 0x98FF,
    0x9900, 0x9901, 0x9902, 0x9903, 0x9904, 0x9905, 0x9906, 0x9907,
    0x9908, 0x9909, 0x990A, 0x990B, 0x990C, 0x990E, 0x990F, 0x9911,
    0x9912, 0x9913, 0x9914, 0x9915, 0x9916, 0x9917, 0x9918, 0x9919,
    0x991A, 0x991B, 0x991C, 0x991D, 0x991E, 0x991F, 0x9920, 0x9921,
    0x9922, 0x9923, 0x9924, 0x9925, 0x9926, 0x9927, 0x9928, 0x9929,
    0x992A, 0x992B, 0x992C, 0x992D, 0x992F, 0x9930, 0x9931, 0x9932,
    0x9933, 0x9934, 0x9935, 0x9936, 0x9937, 0x9938, 0x9939, 0x993A,
    0x993B, 0x993C, 0x993D, 0x993E, 0x993F, 0x9940, 0x9941, 0x9942,
    0x9943, 0x9944, 0x9945, 0x9946, 0x9947, 0x9948, 0x9949, 0x994A,
    0x994B, 0x994C, 0x994D, 0x994E, 0x994F, 0x9950, 0x9951, 0x9952,
    0x9953, 0x9956, 0x9957, 0x9958, 0x9959, 0x995A, 0x995B, 0x995C,
    0x995D, 0x995E, 0x995F, 0x9960, 0x9961, 0x9962, 0x9964, 0x9966,
    0x9973, 0x9978, 0x9979, 0x997B, 0x997E, 0x9982, 0x9983, 0x9989,
    0x998C, 0x998E, 0x999A, 0x999B, 0x999C, 0x999D, 0x999E, 0x999F,
    0x99A0, 0x99A1, 0x99A2, 0x99A3, 0x99A4, 0x99A6, 0x99A7, 0x99A9,
    0x99AA, 0x99AB, 0x99AC, 0x99AD, 0x99AE, 0x99AF, 0x99B0, 0x99B1,
    0x99B2, 0x99B3, 0x99B4, 0x99B5, 0x99B6, 0x99B7, 0x99B8, 0x99B9,
    0x99BA, 0x99BB, 0x99BC, 0x99BD, 0x99BE, 0x99BF, 0x99C0, 0x99C1,
    0x99C2, 0x99C3, 0x99C4, 0x99C5, 0x99C6, 0x99C7, 0x99C8, 0x99C9,
    0x99CA, 0x99CB, 0x99CC, 0x99CD, 0x99CE, 0x99CF, 0x99D0, 0x99D1,
    0x99D2, 0x99D3, 0x99D4, 0x99D5, 0x99D6, 0x99D7, 0x99D8, 0x99D9,
    0x99DA, 0x99DB, 0x99DC, 0x99DD, 0x99DE, 0x99DF, 0x99E0, 0x99E1,
    0x99E2, 0x99E3, 0x99E4, 0x99E5, 0x99E6, 0x99E7, 0x99E8, 0x99E9,
    0x99EA, 0x99EB, 0x99EC, 0x99ED, 0x99EE, 0x99EF, 0x99F0, 0x99F1,
    0x99F2, 0x99F3, 0x99F4, 0x99F5, 0x99F6, 0x99F7, 0x99F8, 0x99F9,
    0x99FA, 0x99FB, 0x99FC, 0x99FD, 0x99FE, 0x99FF, 0x9A00, 0x9A01,
    0x9A02, 0x9A03, 0x9A04, 0x9A05, 0x9A06, 0x9A07, 0x9A08, 0x9A09,
    0x9A0A, 0x9A0B, 0x9A0C, 0x9A0D, 0x9A0E, 0x9A0F, 0x9A10, 0x9A11,
    0x9A12, 0x9A13, 0x9A14, 0x9A15, 0x9A16, 0x9A17, 0x9A18, 0x9A19,
    0x9A1A, 0x9A1B, 0x9A1C, 0x9A1D, 0x9A1E, 0x9A1F, 0x9A20, 0x9A21,
    0x9A22, 0x9A23, 0x9A24, 0x9A25, 0x9A26, 0x9A27, 0x9A28, 0x9A29,
    0x9A2A, 0x9A2B, 0x9A2C, 0x9A2D, 0x9A2E, 0x9A2F, 0x9A30, 0x9A31,
    0x9A32, 0x9A33, 0x9A34, 0x9A35, 0x9A36, 0x9A37, 0x9A38, 0x9A39,
    0x9A3A, 0x9A3B, 0x9A3C, 0x9A3D, 0x9A3E, 0x9A3F, 0x9A40, 0x9A41,
    0x9A42, 0x9A43, 0x9A44, 0x9A45, 0x9A46, 0x9A47, 0x9A48, 0x9A49,
    0x9A4A, 0x9A4B, 0x9A4C, 0x9A4D, 0x9A4E, 0x9A4F, 0x9A50, 0x9A51,
    0x9A52, 0x9A53, 0x9A54, 0x9A55, 0x9A56, 0x9A57, 0x9A58, 0x9A59,
    0x9A5A, 0x9A5B, 0x9A5C, 0x9A5D, 0x9A5E, 0x9A5F, 0x9A60, 0x9A61,
    0x9A62, 0x9A63, 0x9A64, 0x9A65, 0x9A66, 0x9A67, 0x9A68, 0x9A69,
    0x9A6A, 0x9A6B, 0x9A72, 0x9A83, 0x9A89, 0x9A8D, 0x9A8E, 0x9A94,
    0x9A95, 0x9A99, 0x9AA6, 0x9AA9, 0x9AAA, 0x9AAB, 0x9AAC, 0x9AAD,
    0x9AAE, 0x9AAF, 0x9AB2, 0x9AB3, 0x9AB4, 0x9AB5, 0x9AB9, 0x9ABB,
    0x9ABD, 0x9ABE, 0x9ABF, 0x9AC3, 0x9AC4, 0x9AC6, 0x9AC7, 0x9AC8,
    0x9AC9, 0x9ACA, 0x9ACD, 0x9ACE, 0x9ACF, 0x9AD0, 0x9AD2, 0x9AD4,
    0x9AD5, 0x9AD6, 0x9AD7, 0x9AD9, 0x9ADA, 0x9ADB, 0x9ADC, 0x9ADD,
    0x9ADE, 0x9AE0, 0x9AE2, 0x9AE3, 0x9AE4, 0x9AE5, 0x9AE7, 0x9AE8,
    0x9AE9, 0x9AEA, 0x9AEC, 0x9AEE, 0x9AF0, 0x9AF1, 0x9AF2, 0x9AF3,
    0x9AF4, 0x9AF5, 0x9AF6, 0x9AF7, 0x9AF8, 0x9AFA, 0x9AFC, 0x9AFD,
    0x9AFE, 0x9AFF, 0x9B00, 0x9B01, 0x9B02, 0x9B04, 0x9B05, 0x9B06,
    0x9B07, 0x9B09, 0x9B0A, 0x9B0B, 0x9B0C, 0x9B0D, 0x9B0E, 0x9B10,
    0x9B11, 0x9B12, 0x9B14, 0x9B15, 0x9B16, 0x9B17, 0x9B18, 0x9B19,
    0x9B1A, 0x9B1B, 0x9B1C, 0x9B1D, 0x9B1E, 0x9B20, 0x9B21, 0x9B22,
    0x9B24, 0x9B25, 0x9B26, 0x9B27, 0x9B28, 0x9B29, 0x9B2A, 0x9B2B,
    0x9B2C, 0x9B2D, 0x9B2E, 0x9B30, 0x9B31, 0x9B33, 0x9B34, 0x9B35,
    0x9B36, 0x9B37, 0x9B38, 0x9B39, 0x9B3A, 0x9B3D, 0x9B3E, 0x9B3F,
    0x9B40, 0x9B46, 0x9B4A, 0x9B4B, 0x9B4C, 0x9B4E, 0x9B50, 0x9B52,
    0x9B53, 0x9B55, 0x9B56, 0x9B57, 0x9B58, 0x9B59, 0x9B5A, 0x9B5B,
    0x9B5C, 0x9B5D, 0x9B5E, 0x9B5F, 0x9B60, 0x9B61, 0x9B62, 0x9B63,
    0x9B64, 0x9B65, 0x9B66, 0x9B67, 0x9B68, 0x9B69, 0x9B6A, 0x9B6B,
    0x9B6C, 0x9B6D, 0x9B6E, 0x9B6F, 0x9B70, 0x9B71, 0x9B72, 0x9B73,
    0x9B74, 0x9B75, 0x9B76, 0x9B77, 0x9B78, 0x9B79, 0x9B7A, 0x9B7B,
    0x9B7C, 0x9B7D, 0x9B7E, 0x9B7F, 0x9B80, 0x9B81, 0x9B82, 0x9B83,
    0x9B84, 0x9B85, 0x9B86, 0x9B87, 0x9B88, 0x9B89, 0x9B8A, 0x9B8B,
    0x9B8C, 0x9B8D, 0x9B8E, 0x9B8F, 0x9B90, 0x9B91, 0x9B92, 0x9B93,
    0x9B94, 0x9B95, 0x9B96, 0x9B97, 0x9B98, 0x9B99, 0x9B9A, 0x9B9B,
    0x9B9C, 0x9B9D, 0x9B9E, 0x9B9F, 0x9BA0, 0x9BA1, 0x9BA2, 0x9BA3,
    0x9BA4, 0x9BA5, 0x9BA6, 0x9BA7, 0x9BA8, 0x9BA9, 0x9BAA, 0x9BAB,
    0x9BAC, 0x9BAD, 0x9BAE, 0x9BAF, 0x9BB0, 0x9BB1, 0x9BB2, 0x9BB3,
    0x9BB4, 0x9BB5, 0x9BB6, 0x9BB7, 0x9BB8, 0x9BB9, 0x9BBA, 0x9BBB,
    0x9BBC, 0x9BBD, 0x9BBE, 0x9BBF, 0x9BC0, 0x9BC1, 0x9BC2, 0x9BC3,
    0x9BC4, 0x9BC5, 0x9BC6, 0x9BC7, 0x9BC8, 0x9BC9, 0x9BCA, 0x9BCB,
    0x9BCC, 0x9BCD, 0x9BCE, 0x9BCF, 0x9BD0, 0x9BD1, 0x9BD2, 0x9BD3,
    0x9BD4, 0x9BD5, 0x9BD6, 0x9BD7, 0x9BD8, 0x9BD9, 0x9BDA, 0x9BDB,
    0x9BDC, 0x9BDD, 0x9BDE, 0x9BDF, 0x9BE0, 0x9BE1, 0x9BE2, 0x9BE3,
    0x9BE4, 0x9BE5, 0x9BE6, 0x9BE7, 0x9BE8, 0x9BE9, 0x9BEA, 0x9BEB,
    0x9BEC, 0x9BED, 0x9BEE, 0x9BEF, 0x9BF0, 0x9BF1, 0x9BF2, 0x9BF3,
    0x9BF4, 0x9BF5, 0x9BF6, 0x9BF7, 0x9BF8, 0x9BF9, 0x9BFA, 0x9BFB,
    0x9BFC, 0x9BFD, 0x9BFE, 0x9BFF, 0x9C00, 0x9C01, 0x9C02, 0x9C03,
    0x9C04, 0x9C05, 0x9C06, 0x9C07, 0x9C08, 0x9C09, 0x9C0A, 0x9C0B,
    0x9C0C, 0x9C0D, 0x9C0E, 0x9C0F, 0x9C10, 0x9C11, 0x9C12, 0x9C13,
    0x9C14, 0x9C15, 0x9C16, 0x9C17, 0x9C18, 0x9C19, 0x9C1A, 0x9C1B,
    0x9C1C, 0x9C1D, 0x9C1E, 0x9C1F, 0x9C20, 0x9C21, 0x9C22, 0x9C23,
    0x9C24, 0x9C25, 0x9C26, 0x9C27, 0x9C28, 0x9C29, 0x9C2A, 0x9C2B,
    0x9C2C, 0x9C2D, 0x9C2E, 0x9C2F, 0x9C30, 0x9C31, 0x9C32, 0x9C33,
    0x9C34, 0x9C35, 0x9C36, 0x9C37, 0x9C38, 0x9C39, 0x9C3A, 0x9C3B,
    0x9C3C, 0x9C3D, 0x9C3E, 0x9C3F, 0x9C40, 0x9C41, 0x9C42, 0x9C43,
    0x9C44, 0x9C45, 0x9C46, 0x9C47, 0x9C48, 0x9C49, 0x9C4A, 0x9C4B,
    0x9C4C, 0x9C4D, 0x9C4E, 0x9C4F, 0x9C50, 0x9C51, 0x9C52, 0x9C53,
    0x9C54, 0x9C55, 0x9C56, 0x9C57, 0x9C58, 0x9C59, 0x9C5A, 0x9C5B,
    0x9C5C, 0x9C5D, 0x9C5E, 0x9C5F, 0x9C60, 0x9C61, 0x9C62, 0x9C63,
    0x9C64, 0x9C65, 0x9C66, 0x9C67, 0x9C68, 0x9C69, 0x9C6A, 0x9C6B,
    0x9C6C, 0x9C6D, 0x9C6E, 0x9C6F, 0x9C70, 0x9C71, 0x9C72, 0x9C73,
    0x9C74, 0x9C75, 0x9C76, 0x9C77, 0x9C78, 0x9C79, 0x9C7A, 0x9C7B,
    0x9C7D, 0x9C7E, 0x9C80, 0x9C83, 0x9C84, 0x9C89, 0x9C8A, 0x9C8C,
    0x9C8F, 0x9C93, 0x9C96, 0x9C97, 0x9C98, 0x9C99, 0x9C9D, 0x9CAA,
    0x9CAC, 0x9CAF, 0x9CB9, 0x9CBE, 0x9CBF, 0x9CC0, 0x9CC1, 0x9CC2,
    0x9CC8, 0x9CC9, 0x9CD1, 0x9CD2, 0x9CDA, 0x9CDB, 0x9CE0, 0x9CE1,
    0x9CE3, 0x9CE4, 0x9CE5, 0x9CE6, 0x9CE7, 0x9CE8, 0x9CE9, 0x9CEA,
    0x9CEB, 0x9CEC, 0x9CED, 0x9CEE, 0x9CEF, 0x9CF0, 0x9CF1, 0x9CF2,
    0x9CF3, 0x9CF4, 0x9CF5, 0x9CF6, 0x9CF7, 0x9CF8, 0x9CF9, 0x9CFA,
    0x9CFB, 0x9CFC, 0x9CFD, 0x9CFE, 0x9CFF, 0x9D00, 0x9D01, 0x9D02,
    0x9D03, 0x9D04, 0x9D05, 0x9D06, 0x9D07, 0x9D08, 0x9D09, 0x9D0A,
    0x9D0B, 0x9D0C, 0x9D0D, 0x9D0E, 0x9D0F, 0x9D10, 0x9D11, 0x9D12,
    0x9D13, 0x9D14, 0x9D15, 0x9D16, 0x9D17, 0x9D18, 0x9D19, 0x9D1A,
    0x9D1B, 0x9D1C, 0x9D1D, 0x9D1E, 0x9D1F, 0x9D20, 0x9D21, 0x9D22,
    0x9D23, 0x9D24, 0x9D25, 0x9D26, 0x9D27, 0x9D28, 0x9D29, 0x9D2A,
    0x9D2B, 0x9D2C, 0x9D2D, 0x9D2E, 0x9D2F, 0x9D30, 0x9D31, 0x9D32,
    0x9D33, 0x9D34, 0x9D35, 0x9D36, 0x9D37, 0x9D38, 0x9D39, 0x9D3A,
    0x9D3B, 0x9D3C, 0x9D3D, 0x9D3E, 0x9D3F, 0x9D40, 0x9D41, 0x9D42,
    0x9D43, 0x9D44, 0x9D45, 0x9D46, 0x9D47, 0x9D48, 0x9D49, 0x9D4A,
    0x9D4B, 0x9D4C, 0x9D4D, 0x9D4E, 0x9D4F, 0x9D50, 0x9D51, 0x9D52,
    0x9D53, 0x9D54, 0x9D55, 0x9D56, 0x9D57, 0x9D58, 0x9D59, 0x9D5A,
    0x9D5B, 0x9D5C, 0x9D5D, 0x9D5E, 0x9D5F, 0x9D60, 0x9D61, 0x9D62,
    0x9D63, 0x9D64, 0x9D65, 0x9D66, 0x9D67, 0x9D68, 0x9D69, 0x9D6A,
    0x9D6B, 0x9D6C, 0x9D6D, 0x9D6E, 0x9D6F, 0x9D70, 0x9D71, 0x9D72,
    0x9D73, 0x9D74, 0x9D75, 0x9D76, 0x9D77, 0x9D78, 0x9D79, 0x9D7A,
    0x9D7B, 0x9D7C, 0x9D7D, 0x9D7E, 0x9D7F, 0x9D80, 0x9D81, 0x9D82,
    0x9D83, 0x9D84, 0x9D85, 0x9D86, 0x9D87, 0x9D88, 0x9D89, 0x9D8A,
    0x9D8B, 0x9D8C, 0x9D8D, 0x9D8E, 0x9D8F, 0x9D90, 0x9D91, 0x9D92,
    0x9D93, 0x9D94, 0x9D95, 0x9D96, 0x9D97, 0x9D98, 0x9D99, 0x9D9A,
    0x9D9B, 0x9D9C, 0x9D9D, 0x9D9E, 0x9D9F, 0x9DA0, 0x9DA1, 0x9DA2,
    0x9DA3, 0x9DA4, 0x9DA5, 0x9DA6, 0x9DA7, 0x9DA8, 0x9DA9, 0x9DAA,
    0x9DAB, 0x9DAC, 0x9DAD, 0x9DAE, 0x9DAF, 0x9DB0, 0x9DB1, 0x9DB2,
    0x9DB3, 0x9DB4, 0x9DB5, 0x9DB6, 0x9DB7, 0x9DB8, 0x9DB9, 0x9DBA,
    0x9DBB, 0x9DBC, 0x9DBD, 0x9DBE, 0x9DBF, 0x9DC0, 0x9DC1, 0x9DC2,
    0x9DC3, 0x9DC4, 0x9DC5, 0x9DC6, 0x9DC7, 0x9DC8, 0x9DC9, 0x9DCA,
    0x9DCB, 0x9DCC, 0x9DCD, 0x9DCE, 0x9DCF, 0x9DD0, 0x9DD1, 0x9DD2,
    0x9DD3, 0x9DD4, 0x9DD5, 0x9DD6, 0x9DD7, 0x9DD8, 0x9DD9, 0x9DDA,
    0x9DDB, 0x9DDC, 0x9DDD, 0x9DDE, 0x9DDF, 0x9DE0, 0x9DE1, 0x9DE2,
    0x9DE3, 0x9DE4, 0x9DE5, 0x9DE6, 0x9DE7, 0x9DE8, 0x9DE9, 0x9DEA,
    0x9DEB, 0x9DEC, 0x9DED, 0x9DEE, 0x9DEF, 0x9DF0, 0x9DF1, 0x9DF2,
    0x9DF3, 0x9DF4, 0x9DF5, 0x9DF6, 0x9DF7, 0x9DF8, 0x9DF9, 0x9DFA,
    0x9DFB, 0x9DFC, 0x9DFD, 0x9DFE, 0x9DFF, 0x9E00, 0x9E01, 0x9E02,
    0x9E03, 0x9E04, 0x9E05, 0x9E06, 0x9E07, 0x9E08, 0x9E09, 0x9E0A,
    0x9E0B, 0x9E0C, 0x9E0D, 0x9E0E, 0x9E0F, 0x9E10, 0x9E11, 0x9E12,
    0x9E13, 0x9E14, 0x9E15, 0x9E16, 0x9E17, 0x9E18, 0x9E19, 0x9E1A,
    0x9E1B, 0x9E1C, 0x9E1D, 0x9E1E, 0x9E24, 0x9E27, 0x9E2E, 0x9E30,
    0x9E34, 0x9E3B, 0x9E3C, 0x9E40, 0x9E4D, 0x9E50, 0x9E52, 0x9E53,
    0x9E54, 0x9E56, 0x9E59, 0x9E5D, 0x9E5F, 0x9E60, 0x9E61, 0x9E62,
    0x9E65, 0x9E6E, 0x9E6F, 0x9E72, 0x9E74, 0x9E75, 0x9E76, 0x9E77,
    0x9E78, 0x9E79, 0x9E7A, 0x9E7B, 0x9E7C, 0x9E7D, 0x9E80, 0x9E81,
    0x9E83, 0x9E84, 0x9E85, 0x9E86, 0x9E89, 0x9E8A, 0x9E8C, 0x9E8D,
    0x9E8E, 0x9E8F, 0x9E90, 0x9E91, 0x9E94, 0x9E95, 0x9E96, 0x9E97,
    0x9E98, 0x9E99, 0x9E9A, 0x9E9B, 0x9E9C, 0x9E9E, 0x9EA0, 0x9EA1,
    0x9EA2, 0x9EA3, 0x9EA4, 0x9EA5, 0x9EA7, 0x9EA8, 0x9EA9, 0x9EAA,
    0x9EAB, 0x9EAC, 0x9EAD, 0x9EAE, 0x9EAF, 0x9EB0, 0x9EB1, 0x9EB2,
    0x9EB3, 0x9EB5, 0x9EB6, 0x9EB7, 0x9EB9, 0x9EBA, 0x9EBC, 0x9EBF,
    0x9EC0, 0x9EC1, 0x9EC2, 0x9EC3, 0x9EC5, 0x9EC6, 0x9EC7, 0x9EC8,
    0x9ECA, 0x9ECB, 0x9ECC, 0x9ED0, 0x9ED2, 0x9ED3, 0x9ED5, 0x9ED6,
    0x9ED7, 0x9ED9, 0x9EDA, 0x9EDE, 0x9EE1, 0x9EE3, 0x9EE4, 0x9EE6,
    0x9EE8, 0x9EEB, 0x9EEC, 0x9EED, 0x9EEE, 0x9EF0, 0x9EF1, 0x9EF2,
    0x9EF3, 0x9EF4, 0x9EF5, 0x9EF6, 0x9EF7, 0x9EF8, 0x9EFA, 0x9EFD,
    0x9EFF, 0x9F00, 0x9F01, 0x9F02, 0x9F03, 0x9F04, 0x9F05, 0x9F06,
    0x9F07, 0x9F08, 0x9F09, 0x9F0A, 0x9F0C, 0x9F0F, 0x9F11, 0x9F12,
    0x9F14, 0x9F15, 0x9F16, 0x9F18, 0x9F1A, 0x9F1B, 0x9F1C, 0x9F1D,
    0x9F1E, 0x9F1F, 0x9F21, 0x9F23, 0x9F24, 0x9F25, 0x9F26, 0x9F27,
    0x9F28, 0x9F29, 0x9F2A, 0x9F2B, 0x9F2D, 0x9F2E, 0x9F30, 0x9F31,
    0x9F32, 0x9F33, 0x9F34, 0x9F35, 0x9F36, 0x9F38, 0x9F3A, 0x9F3C,
    0x9F3F, 0x9F40, 0x9F41, 0x9F42, 0x9F43, 0x9F45, 0x9F46, 0x9F47,
    0x9F48, 0x9F49, 0x9F4A, 0x9F4B, 0x9F4C, 0x9F4D, 0x9F4E, 0x9F4F,
    0x9F52, 0x9F53, 0x9F54, 0x9F55, 0x9F56, 0x9F57, 0x9F58, 0x9F59,
    0x9F5A, 0x9F5B, 0x9F5C, 0x9F5D, 0x9F5E, 0x9F5F, 0x9F60, 0x9F61,
    0x9F62, 0x9F63, 0x9F64, 0x9F65, 0x9F66, 0x9F67, 0x9F68, 0x9F69,
    0x9F6A, 0x9F6B, 0x9F6C, 0x9F6D, 0x9F6E, 0x9F6F, 0x9F70, 0x9F71,
    0x9F72, 0x9F73, 0x9F74, 0x9F75, 0x9F76, 0x9F77, 0x9F78, 0x9F79,
    0x9F7A, 0x9F7B, 0x9F7C, 0x9F7D, 0x9F7E, 0x9F81, 0x9F82, 0x9F8D,
    0x9F8E, 0x9F8F, 0x9F90, 0x9F91, 0x9F92, 0x9F93, 0x9F94, 0x9F95,
    0x9F96, 0x9F97, 0x9F98, 0x9F9C, 0x9F9D, 0x9F9E, 0x9FA1, 0x9FA2,
    0x9FA3, 0x9FA4, 0x9FA5, 0xF92C, 0xF979, 0xF995, 0xF9E7, 0xF9F1,
    0xFA0C, 0xFA0D, 0xFA0E, 0xFA0F, 0xFA11, 0xFA13, 0xFA14, 0xFA18,
    0xFA1F, 0xFA20, 0xFA21, 0xFA23, 0xFA24, 0xFA27, 0xFA28, 0xFA29,
};
#endif /* ZUECI_EMBED_NO_TO_UTF8 */

#ifndef ZUECI_EMBED_NO_TO_UTF8
/* Non-URO multibyte values in multibyte order */
static const zueci_u16 zueci_gbk_nonuro_mb[209] = {
    0xA1A4, 0xA1AA, 0xA2A1, 0xA2A2, 0xA2A3, 0xA2A4, 0xA2A5, 0xA2A6,
    0xA2A7, 0xA2A8, 0xA2A9, 0xA2AA, 0xA6E0, 0xA6E1, 0xA6E2, 0xA6E3,
    0xA6E4, 0xA6E5, 0xA6E6, 0xA6E7, 0xA6E8, 0xA6E9, 0xA6EA, 0xA6EB,
    0xA6EE, 0xA6EF, 0xA6F0, 0xA6F1, 0xA6F2, 0xA6F4, 0xA6F5, 0xA840,
    0xA841, 0xA842, 0xA843, 0xA844, 0xA845, 0xA846, 0xA847, 0xA848,
    0xA849, 0xA84A, 0xA84B, 0xA84C, 0xA84D, 0xA84E, 0xA84F, 0xA850,
    0xA851, 0xA852, 0xA853, 0xA854, 0xA855, 0xA856, 0xA857, 0xA858,
    0xA859, 0xA85A, 0xA85B, 0xA85C, 0xA85D, 0xA85E, 0xA85F, 0xA860,
    0xA861, 0xA862, 0xA863, 0xA864, 0xA865, 0xA866, 0xA867, 0xA868,
    0xA869, 0xA86A, 0xA86B, 0xA86C, 0xA86D, 0xA86E, 0xA86F, 0xA870,
    0xA871, 0xA872, 0xA873, 0xA874, 0xA875, 0xA876, 0xA877, 0xA878,
    0xA879, 0xA87A, 0xA87B, 0xA87C, 0xA87D, 0xA87E, 0xA880, 0xA881,
    0xA882, 0xA883, 0xA884, 0xA885, 0xA886, 0xA887, 0xA888, 0xA889,
    0xA88A, 0xA88B, 0xA88C, 0xA88D, 0xA88E, 0xA88F, 0xA890, 0xA891,
    0xA892, 0xA893, 0xA894, 0xA895, 0xA8BB, 0xA8BD, 0xA8BE, 0xA8C0,
    0xA940, 0xA941, 0xA942, 0xA943, 0xA944, 0xA945, 0xA946, 0xA947,
    0xA948, 0xA949, 0xA94A, 0xA94B, 0xA94C, 0xA94D, 0xA94E, 0xA94F,
    0xA950, 0xA951, 0xA952, 0xA953, 0xA954, 0xA955, 0xA956, 0xA957,
    0xA959, 0xA95A, 0xA95C, 0xA960, 0xA961, 0xA962, 0xA963, 0xA964,
    0xA965, 0xA966, 0xA967, 0xA968, 0xA969, 0xA96A, 0xA96B, 0xA96C,
    0xA96D, 0xA96E, 0xA96F, 0xA970, 0xA971, 0xA972, 0xA973, 0xA974,
    0xA975, 0xA976, 0xA977, 0xA978, 0xA979, 0xA97A, 0xA97B, 0xA97C,
    0xA97D, 0xA97E, 0xA980, 0xA981, 0xA982, 0xA983, 0xA984, 0xA985,
    0xA986, 0xA987, 0xA988, 0xA996, 0xFD9C, 0xFD9D, 0xFD9E, 0xFD9F,
    0xFDA0, 0xFE40, 0xFE41, 0xFE42, 0xFE43, 0xFE44, 0xFE45, 0xFE46,
    0xFE47, 0xFE48, 0xFE49, 0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D, 0xFE4E,
    0xFE4F,
};

/* Non-URO Unicode values in multibyte order */
static const zueci_u16 zueci_gbk_nonuro_u[209] = {
    0x00B7, 0x2014, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175,
    0x2176, 0x2177, 0x2178, 0x2179, 0xFE35, 0xFE36, 0xFE39, 0xFE3A,
    0xFE3F, 0xFE40, 0xFE3D, 0xFE3E, 0xFE41, 0xFE42, 0xFE43, 0xFE44,
    0xFE3B, 0xFE3C, 0xFE37, 0xFE38, 0xFE31, 0xFE33, 0xFE34, 0x02CA,
    0x02CB, 0x02D9, 0x2013, 0x2015, 0x2025, 0x2035, 0x2105, 0x2109,
    0x2196, 0x2197, 0x2198, 0x2199, 0x2215, 0x221F, 0x2223, 0x2252,
    0x2266, 0x2267, 0x22BF, 0x2550, 0x2551, 0x2552, 0x2553, 0x2554,
    0x2555, 0x2556, 0x2557, 0x2558, 0x2559, 0x255A, 0x255B, 0x255C,
    0x255D, 0x255E, 0x255F, 0x2560, 0x2561, 0x2562, 0x2563, 0x2564,
    0x2565, 0x2566, 0x2567, 0x2568, 0x2569, 0x256A, 0x256B, 0x256C,
    0x256D, 0x256E, 0x256F, 0x2570, 0x2571, 0x2572, 0x2573, 0x2581,
    0x2582, 0x2583, 0x2584, 0x2585, 0x2586, 0x2587, 0x2588, 0x2589,
    0x258A, 0x258B, 0x258C, 0x258D, 0x258E, 0x258F, 0x2593, 0x2594,
    0x2595, 0x25BC, 0x25BD, 0x25E2, 0x25E3, 0x25E4, 0x25E5, 0x2609,
    0x2295, 0x3012, 0x301D, 0x301E, 0x0251, 0x0144, 0x0148, 0x0261,
    0x3021, 0x3022, 0x3023, 0x3024, 0x3025, 0x3026, 0x3027, 0x3028,
    0x3029, 0x32A3, 0x338E, 0x338F, 0x339C, 0x339D, 0x339E, 0x33A1,
    0x33C4, 0x33CE, 0x33D1, 0x33D2, 0x33D5, 0xFE30, 0xFFE2, 0xFFE4,
    0x2121, 0x3231, 0x2010, 0x30FC, 0x309B, 0x309C, 0x30FD, 0x30FE,
    0x3006, 0x309D, 0x309E, 0xFE49, 0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D,
    0xFE4E, 0xFE4F, 0xFE50, 0xFE51, 0xFE52, 0xFE54, 0xFE55, 0xFE56,
    0xFE57, 0xFE59, 0xFE5A, 0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0xFE5F,
    0xFE60, 0xFE61, 0xFE62, 0xFE63, 0xFE64, 0xFE65, 0xFE66, 0xFE68,
    0xFE69, 0xFE6A, 0xFE6B, 0x3007, 0xF92C, 0xF979, 0xF995, 0xF9E7,
    0xF9F1, 0xFA0C, 0xFA0D, 0xFA0E, 0xFA0F, 0xFA11, 0xFA13, 0xFA14,
    0xFA18, 0xFA1F, 0xFA20, 0xFA21, 0xFA23, 0xFA24, 0xFA27, 0xFA28,
    0xFA29,
};
#endif /* ZUECI_EMBED_NO_TO_UTF8 */

#endif /* ZUECI_GBK_H */
