/* SPDX-License-Identifier: BSD-3-Clause */
/*
 * Cadence DDR Driver
 *
 * Copyright (C) 2012-2022 Cadence Design Systems, Inc.
 * Copyright (C) 2018-2022 Texas Instruments Incorporated - https://www.ti.com/
 */

#ifndef LPDDR4_AM64_IF_H
#define LPDDR4_AM64_IF_H

#include <linux/types.h>

#define LPDDR4_INTR_MAX_CS (2U)

#define LPDDR4_INTR_CTL_REG_COUNT (423U)

#define LPDDR4_INTR_PHY_INDEP_REG_COUNT (345U)

#define LPDDR4_INTR_PHY_REG_COUNT (1406U)

typedef enum {
	LPDDR4_INTR_TIMEOUT_ZQ_CAL_INIT			= 0U,
	LPDDR4_INTR_TIMEOUT_ZQ_CALLATCH			= 1U,
	LPDDR4_INTR_TIMEOUT_ZQ_CALSTART			= 2U,
	LPDDR4_INTR_TIMEOUT_MRR_TEMP			= 3U,
	LPDDR4_INTR_TIMEOUT_DQS_OSC_REQ			= 4U,
	LPDDR4_INTR_TIMEOUT_DFI_UPDATE			= 5U,
	LPDDR4_INTR_TIMEOUT_LP_WAKEUP			= 6U,
	LPDDR4_INTR_TIMEOUT_AUTO_REFRESH_MAX		= 7U,
	LPDDR4_INTR_ECC_ERROR				= 8U,
	LPDDR4_INTR_LP_DONE				= 9U,
	LPDDR4_INTR_LP_TIMEOUT				= 10U,
	LPDDR4_INTR_PORT_TIMEOUT			= 11U,
	LPDDR4_INTR_RFIFO_TIMEOUT			= 12U,
	LPDDR4_INTR_TRAINING_ZQ_STATUS			= 13U,
	LPDDR4_INTR_TRAINING_DQS_OSC_DONE		= 14U,
	LPDDR4_INTR_TRAINING_DQS_OSC_UPDATE_DONE	= 15U,
	LPDDR4_INTR_TRAINING_DQS_OSC_OVERFLOW		= 16U,
	LPDDR4_INTR_TRAINING_DQS_OSC_VAR_OUT		= 17U,
	LPDDR4_INTR_USERIF_OUTSIDE_MEM_ACCESS		= 18U,
	LPDDR4_INTR_USERIF_MULTI_OUTSIDE_MEM_ACCESS	= 19U,
	LPDDR4_INTR_USERIF_PORT_CMD_ERROR		= 20U,
	LPDDR4_INTR_USERIF_WRAP				= 21U,
	LPDDR4_INTR_USERIF_INVAL_SETTING		= 22U,
	LPDDR4_INTR_MISC_MRR_TRAFFIC			= 23U,
	LPDDR4_INTR_MISC_SW_REQ_MODE			= 24U,
	LPDDR4_INTR_MISC_CHANGE_TEMP_REFRESH		= 25U,
	LPDDR4_INTR_MISC_TEMP_ALERT			= 26U,
	LPDDR4_INTR_MISC_REFRESH_STATUS			= 27U,
	LPDDR4_INTR_BIST_DONE				= 28U,
	LPDDR4_INTR_CRC					= 29U,
	LPDDR4_INTR_DFI_UPDATE_ERROR			= 30U,
	LPDDR4_INTR_DFI_PHY_ERROR			= 31U,
	LPDDR4_INTR_DFI_BUS_ERROR			= 32U,
	LPDDR4_INTR_DFI_STATE_CHANGE			= 33U,
	LPDDR4_INTR_DFI_DLL_SYNC_DONE			= 34U,
	LPDDR4_INTR_DFI_TIMEOUT				= 35U,
	LPDDR4_INTR_DIMM				= 36U,
	LPDDR4_INTR_FREQ_DFS_REQ_HW_IGNORE		= 37U,
	LPDDR4_INTR_FREQ_DFS_HW_TERMINATE		= 38U,
	LPDDR4_INTR_FREQ_DFS_HW_DONE			= 39U,
	LPDDR4_INTR_FREQ_DFS_REQ_SW_IGNORE		= 40U,
	LPDDR4_INTR_FREQ_DFS_SW_TERMINATE		= 41U,
	LPDDR4_INTR_FREQ_DFS_SW_DONE			= 42U,
	LPDDR4_INTR_INIT_MEM_RESET_DONE			= 43U,
	LPDDR4_INTR_MC_INIT_DONE			= 44U,
	LPDDR4_INTR_INIT_POWER_ON_STATE			= 45U,
	LPDDR4_INTR_MRR_ERROR				= 46U,
	LPDDR4_INTR_MR_READ_DONE			= 47U,
	LPDDR4_INTR_MR_WRITE_DONE			= 48U,
	LPDDR4_INTR_PARITY_ERROR			= 49U,
	LPDDR4_INTR_LOR_BITS				= 50U
} lpddr4_intr_ctlinterrupt;

typedef enum {
	LPDDR4_INTR_PHY_INDEP_INIT_DONE_BIT		= 0U,
	LPDDR4_INTR_PHY_INDEP_CA_PARITY_ERR_BIT		= 1U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_ERROR_BIT		= 2U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_G_ERROR_BIT		= 3U,
	LPDDR4_INTR_PHY_INDEP_WRLVL_ERROR_BIT		= 4U,
	LPDDR4_INTR_PHY_INDEP_CALVL_ERROR_BIT		= 5U,
	LPDDR4_INTR_PHY_INDEP_WDQLVL_ERROR_BIT		= 6U,
	LPDDR4_INTR_PHY_INDEP_UPDATE_ERROR_BIT		= 7U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_REQ_BIT		= 8U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_GATE_REQ_BIT	= 9U,
	LPDDR4_INTR_PHY_INDEP_WRLVL_REQ_BIT		= 10U,
	LPDDR4_INTR_PHY_INDEP_CALVL_REQ_BIT		= 11U,
	LPDDR4_INTR_PHY_INDEP_WDQLVL_REQ_BIT		= 12U,
	LPDDR4_INTR_PHY_INDEP_LVL_DONE_BIT		= 13U,
	LPDDR4_INTR_PHY_INDEP_BIST_DONE_BIT		= 14U,
	LPDDR4_INTR_PHY_INDEP_TDFI_INIT_TIME_OUT_BIT	= 15U,
	LPDDR4_INTR_PHY_INDEP_DLL_LOCK_STATE_CHANGE_BIT = 16U,
	LPDDR4_INTR_PHY_INDEP_MEM_RST_VALID_BIT		= 17U,
	LPDDR4_INTR_PHY_INDEP_ZQ_STATUS_BIT		= 18U,
	LPDDR4_INTR_PHY_INDEP_PERIPHERAL_MRR_DONE_BIT	= 19U,
	LPDDR4_INTR_PHY_INDEP_WRITE_NODEREG_DONE_BIT	= 20U,
	LPDDR4_INTR_PHY_INDEP_FREQ_CHANGE_DONE_BIT	= 21U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_G_DONE_BIT		= 22U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_DONE_BIT		= 23U,
	LPDDR4_INTR_PHY_INDEP_WRLVL_DONE_BIT		= 24U,
	LPDDR4_INTR_PHY_INDEP_CALVL_DONE__BIT		= 25U,
	LPDDR4_INTR_PHY_INDEP_WDQLVL_DONE_BIT		= 26U,
	LPDDR4_INTR_PHY_INDEP_VREF_DONE_BIT		= 27U,
	LPDDR4_INTR_PHY_INDEP_ANY_VALID_BIT		= 28U
} lpddr4_intr_phyindepinterrupt;

#endif  /* LPDDR4_AM64_IF_H */
