"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginForm = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const Form_1 = require("../Form");
const TextInput_1 = require("../TextInput");
const Button_1 = require("../Button");
const Checkbox_1 = require("../Checkbox");
const constants_1 = require("../../helpers/constants");
const InputGroup_1 = require("../InputGroup");
const eye_slash_icon_1 = tslib_1.__importDefault(require('@patternfly/react-icons/dist/js/icons/eye-slash-icon'));
const eye_icon_1 = tslib_1.__importDefault(require('@patternfly/react-icons/dist/js/icons/eye-icon'));
const HelperText_1 = require("../HelperText");
const LoginForm = (_a) => {
    var { noAutoFocus = false, className = '', showHelperText = false, helperText = null, helperTextIcon = null, usernameLabel = 'Username', usernameValue = '', onChangeUsername = () => undefined, isValidUsername = true, isPasswordRequired = true, passwordLabel = 'Password', passwordValue = '', onChangePassword = () => undefined, isShowPasswordEnabled = false, hidePasswordAriaLabel = 'Hide password', showPasswordAriaLabel = 'Show password', isValidPassword = true, loginButtonLabel = 'Log In', isLoginButtonDisabled = false, onLoginButtonClick = () => undefined, rememberMeLabel = '', isRememberMeChecked = false, onChangeRememberMe = () => undefined } = _a, props = tslib_1.__rest(_a, ["noAutoFocus", "className", "showHelperText", "helperText", "helperTextIcon", "usernameLabel", "usernameValue", "onChangeUsername", "isValidUsername", "isPasswordRequired", "passwordLabel", "passwordValue", "onChangePassword", "isShowPasswordEnabled", "hidePasswordAriaLabel", "showPasswordAriaLabel", "isValidPassword", "loginButtonLabel", "isLoginButtonDisabled", "onLoginButtonClick", "rememberMeLabel", "isRememberMeChecked", "onChangeRememberMe"]);
    const [passwordHidden, setPasswordHidden] = (0, react_1.useState)(true);
    const passwordInput = ((0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { isRequired: isPasswordRequired, type: passwordHidden ? 'password' : 'text', id: "pf-login-password-id", name: "pf-login-password-id", validated: isValidPassword ? constants_1.ValidatedOptions.default : constants_1.ValidatedOptions.error, value: passwordValue, onChange: onChangePassword }));
    return ((0, jsx_runtime_1.jsxs)(Form_1.Form, Object.assign({ className: className }, props, { children: [showHelperText && ((0, jsx_runtime_1.jsx)(Form_1.FormHelperText, { children: (0, jsx_runtime_1.jsx)(HelperText_1.HelperText, { children: (0, jsx_runtime_1.jsx)(HelperText_1.HelperTextItem, { variant: !isValidUsername || !isValidPassword ? 'error' : 'default', icon: helperTextIcon, children: helperText }) }) })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, { label: usernameLabel, isRequired: true, fieldId: "pf-login-username-id", children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { autoFocus: !noAutoFocus, id: "pf-login-username-id", isRequired: true, validated: isValidUsername ? constants_1.ValidatedOptions.default : constants_1.ValidatedOptions.error, type: "text", name: "pf-login-username-id", value: usernameValue, onChange: onChangeUsername }) }), (0, jsx_runtime_1.jsxs)(Form_1.FormGroup, { label: passwordLabel, isRequired: isPasswordRequired, fieldId: "pf-login-password-id", children: [isShowPasswordEnabled && ((0, jsx_runtime_1.jsxs)(InputGroup_1.InputGroup, { children: [(0, jsx_runtime_1.jsx)(InputGroup_1.InputGroupItem, { isFill: true, children: passwordInput }), (0, jsx_runtime_1.jsx)(InputGroup_1.InputGroupItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, { variant: "control", onClick: () => setPasswordHidden(!passwordHidden), "aria-label": passwordHidden ? showPasswordAriaLabel : hidePasswordAriaLabel, icon: passwordHidden ? (0, jsx_runtime_1.jsx)(eye_icon_1.default, {}) : (0, jsx_runtime_1.jsx)(eye_slash_icon_1.default, {}) }) })] })), !isShowPasswordEnabled && passwordInput] }), rememberMeLabel.length > 0 && ((0, jsx_runtime_1.jsx)(Form_1.FormGroup, { fieldId: "pf-login-remember-me-id", children: (0, jsx_runtime_1.jsx)(Checkbox_1.Checkbox, { id: "pf-login-remember-me-id", label: rememberMeLabel, isChecked: isRememberMeChecked, onChange: onChangeRememberMe }) })), (0, jsx_runtime_1.jsx)(Form_1.ActionGroup, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, { variant: "primary", type: "submit", onClick: onLoginButtonClick, isBlock: true, isDisabled: isLoginButtonDisabled, children: loginButtonLabel }) })] })));
};
exports.LoginForm = LoginForm;
exports.LoginForm.displayName = 'LoginForm';
//# sourceMappingURL=LoginForm.js.map