require "spec"
require "crypto/bcrypt/base64"

describe "Crypto::Bcrypt::Base64" do
  vectors = [
    {UInt8[0x25], "HO"},
    {UInt8[0x6b, 0x11], "YvC"},
    {UInt8[0x54, 0xe0, 0x19], "TM.X"},
    {UInt8[0xb7, 0xf4, 0x24, 0x20], "r9OiG."},
    {UInt8[0xee, 0x98, 0xfb, 0xf3, 0x6c], "5nh560u"},
    {UInt8[0xfc, 0x4f, 0x0a, 0x3d, 0x78, 0x22], "9C6INVeg"},
    {UInt8[0x72, 0x4b, 0x0d, 0x7b, 0xd5, 0xae, 0xda], "aiqLc7Us0e"},
    {UInt8[0xe4, 0x58, 0x0e, 0xff, 0xb8, 0x33, 0xab, 0x56], "3DeM95exozW"},
    {UInt8[0x67, 0xf8, 0x86, 0x87, 0x99, 0xd1, 0x47, 0xcb, 0x86], "X9gEf3lPP6sE"},
    {UInt8[0x69, 0x5e, 0x82, 0x7f, 0xb1, 0x52, 0x47, 0x95, 0x6d, 0x57], "YT4Ad5DQP3TrTu"},
    {UInt8[0xa3, 0x33, 0x9b, 0xa9, 0x2b, 0x27, 0xfd, 0x07, 0xc2, 0x86, 0xc9], "mxMZoQql9OdAfqi"},
    {UInt8[0xae, 0x1f, 0xa7, 0xc6, 0xe2, 0x90, 0x76, 0x27, 0x51, 0x6d, 0xfc, 0x8e], "pf8lvsIObgbPZdwM"},
    {UInt8[0xaa, 0xab, 0x0d, 0xcc, 0x66, 0x98, 0x2d, 0xaa, 0x23, 0x6e, 0x7d, 0xac, 0xae], "ooqLxEYWJYmhZl0qpe"},
    {UInt8[0x71, 0xc5, 0x7d, 0x5a, 0x84, 0x1b, 0x24, 0xdd, 0x8c, 0xaa, 0xe0, 0xc6, 0xe3, 0xd1], "aaT7UmOZHL0KosBE27C"},
    {UInt8[0xb9, 0x6d, 0xa5, 0x22, 0x72, 0xa5, 0xb5, 0xa4, 0xfd, 0x1b, 0x55, 0xac, 0x94, 0x3c, 0xc1], "sU0jGlIjrYR7EzUqjBx/"},
    {UInt8[0x21, 0xc4, 0x14, 0x2b, 0xe6, 0xba, 0xdd, 0xf2, 0xb4, 0x7b, 0xee, 0x16, 0xae, 0x7b, 0xf2, 0x73], "GaOSI8Y41dIyc82Upltwau"},
    {UInt8[0x00, 0x3f, 0xf4, 0x21, 0x6a, 0x58, 0x43, 0xf5, 0x9e, 0x73, 0x45, 0xbd, 0xe1, 0x05, 0x88, 0x1b, 0x94], ".B9yGUnWO9UcayU72OUGE3O"},
    {UInt8[0x89, 0xc4, 0x46, 0x1e, 0x18, 0xe3, 0x25, 0xd6, 0x1a, 0xcc, 0x84, 0x2c, 0xb1, 0x11, 0x91, 0x13, 0x2d, 0x61], "gaPEFfhhHbWYxGOqqPEPCwzf"},
    {UInt8[0x2b, 0x37, 0x94, 0xaf, 0xc6, 0x52, 0x60, 0x15, 0x92, 0x03, 0x3f, 0x36, 0x64, 0x34, 0xa6, 0xf0, 0xc9, 0x6d, 0xfa], "IxcSp6XQW/UQ.x60XBQk6Kjr8e"},
    {UInt8[0x4e, 0x22, 0xdc, 0x36, 0xa3, 0xd6, 0x6f, 0x14, 0x1b, 0x56, 0xb6, 0x26, 0x72, 0x3b, 0x23, 0xa1, 0x3f, 0x6f, 0x2f, 0xaa], "RgJaLoNUZvOZTpWkahqhmR7tJ4m"},
    {UInt8[0x18, 0x42, 0x6b, 0x5e, 0x6b, 0xff, 0x02, 0x88, 0x9c, 0x7f, 0xcb, 0xb5, 0xb7, 0x0e, 0x9c, 0xdb, 0x5a, 0x26, 0x79, 0x2a, 0x6d], "ECHpVkt9.mgad6szru4a0zmkcQnr"},
    {UInt8[0x4c, 0x3c, 0x8d, 0x04, 0xab, 0xf2, 0xb1, 0x9c, 0xbc, 0xb5, 0x33, 0xe1, 0x24, 0xf3, 0x0a, 0x69, 0x6c, 0xcc, 0xec, 0xf5, 0xd4, 0x21], "RBwL/ItwqXw6rRNfHNKIYUxK5NVSGO"},
    {UInt8[0xe1, 0x2a, 0x52, 0x02, 0xeb, 0x8a, 0x40, 0x85, 0x5f, 0xba, 0xdb, 0x13, 0x1e, 0x94, 0x9b, 0xb9, 0x55, 0x54, 0xe9, 0x9c, 0x87, 0x9c, 0xbf], "2QnQ.ssIOGTdsrqRFnQZsTTS4XwFlJ6"},
  ]

  it "encodes" do
    vectors.each do |vector|
      decoded, encoded = vector
      Crypto::Bcrypt::Base64.encode(decoded, decoded.size).should eq(encoded)
    end
  end

  it "decodes" do
    vectors.each do |vector|
      decoded, encoded = vector
      Crypto::Bcrypt::Base64.decode(encoded, decoded.size).to_a.should eq(decoded)
    end
  end
end
