#include <u.h>
#include <libc.h>
#include <libsec.h>

static void
printblock(uchar *b, usize n)
{
	int i;

	for(i=0; i+8<=n; i+=8){
		print("%#.2ux %#.2ux %#.2ux %#.2ux %#.2ux %#.2ux %#.2ux %#.2ux\n",
			b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7]);
		b += 8;
	}
	if(i < n){
		print("%#.2ux", *b++);
		while(++i < n)
			print(" %#.2ux", *b++);
		print("\n");
	}
}

/* test vector from RFC7539 */
uchar	rfckey[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f};
uchar	rfcnonce[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x00};
u32int	rfccount = 1;
char	rfctext[] = "Ladies and Gentlemen of the class of '99: If I could offer you only one tip for the future, "
	"sunscreen would be it.";
uchar	rfcout[3*ChachaBsize];
uchar	rfcref[3*ChachaBsize] = {
	0x6e, 0x2e, 0x35, 0x9a, 0x25, 0x68, 0xf9, 0x80, 0x41, 0xba, 0x07, 0x28, 0xdd, 0x0d, 0x69, 0x81,
	0xe9, 0x7e, 0x7a, 0xec, 0x1d, 0x43, 0x60, 0xc2, 0x0a, 0x27, 0xaf, 0xcc, 0xfd, 0x9f, 0xae, 0x0b,
	0xf9, 0x1b, 0x65, 0xc5, 0x52, 0x47, 0x33, 0xab, 0x8f, 0x59, 0x3d, 0xab, 0xcd, 0x62, 0xb3, 0x57,
	0x16, 0x39, 0xd6, 0x24, 0xe6, 0x51, 0x52, 0xab, 0x8f, 0x53, 0x0c, 0x35, 0x9f, 0x08, 0x61, 0xd8,
	0x07, 0xca, 0x0d, 0xbf, 0x50, 0x0d, 0x6a, 0x61, 0x56, 0xa3, 0x8e, 0x08, 0x8a, 0x22, 0xb6, 0x5e,
	0x52, 0xbc, 0x51, 0x4d, 0x16, 0xcc, 0xf8, 0x06, 0x81, 0x8c, 0xe9, 0x1a, 0xb7, 0x79, 0x37, 0x36,
	0x5a, 0xf9, 0x0b, 0xbf, 0x74, 0xa3, 0x5b, 0xe6, 0xb4, 0x0b, 0x8e, 0xed, 0xf2, 0x78, 0x5e, 0x42,
	0x87, 0x4d
};

void
main(int argc, char **argv)
{
	Chachastate s;
	int n;

	ARGBEGIN{
	}ARGEND
	print("rfc7539:\n");
	print("key:\n");
	printblock(rfckey, sizeof(rfckey));
	n = strlen(rfctext);
	setupChachastate(&s, rfckey, sizeof(rfckey), rfcnonce, 0);
	chacha_setblock(&s, rfccount);
	print("rfc in:\n");
	printblock((uchar*)rfctext, n);
	chacha_encrypt2((uchar*)rfctext, rfcout, n, &s);
	print("rfc out:\n");
	printblock(rfcout, n);
	if(memcmp(rfcout, rfcref, sizeof(rfcout)) != 0){
		print("failure of vision\n");
		exits("wrong");
	}
	print("passed\n");
	exits(nil);
}
