import { BinaryView, Frag } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Gdef, GsubGpos } from "@ot-builder/ot-layout";
import { Data } from "@ot-builder/prelude";
import { ReadTimeIVS, WriteTimeIVS } from "@ot-builder/var-store";
import { OtVar } from "@ot-builder/variance";
import { LayoutCfg } from "../cfg";
import { OtlStat } from "../stat";
import { LookupReaderFactory, LookupWriterFactory } from "./general";
export interface TableReadContext {
    gOrd: Data.Order<OtGlyph>;
    gdef?: Data.Maybe<Gdef.Table>;
    designSpace?: Data.Maybe<OtVar.DesignSpace>;
    ivs?: Data.Maybe<ReadTimeIVS>;
}
export interface TableWriteContext {
    gOrd: Data.Order<OtGlyph>;
    designSpace?: Data.Maybe<OtVar.DesignSpace>;
    gdef?: Data.Maybe<Gdef.Table>;
    ivs?: Data.Maybe<WriteTimeIVS>;
    stat?: Data.Maybe<OtlStat>;
}
export declare class CGsubGposTable<L extends GsubGpos.LookupProp> {
    read(view: BinaryView, cfg: LayoutCfg, lrf: LookupReaderFactory<L>, trc: TableReadContext): {
        scripts: Map<string, GsubGpos.GeneralGsubGpos.ScriptT<OtGlyph, OtVar.Value, L>>;
        features: GsubGpos.FeatureT<L>[];
        lookups: L[];
        featureVariations: GsubGpos.GeneralGsubGpos.FeatureVariationT<OtVar.Dim, OtGlyph, OtVar.Value, L>[] | null;
    };
    write(frag: Frag, table: GsubGpos.TableT<L>, cfg: LayoutCfg, lwf: LookupWriterFactory<L>, twc: TableWriteContext): void;
}
//# sourceMappingURL=table.d.ts.map