// --- BEGIN COPYRIGHT BLOCK ---
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//
// (C) 2007 Red Hat, Inc.
// All rights reserved.
// --- END COPYRIGHT BLOCK ---
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;

import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;

/**
 * This class implements the RFC822Name as required by the GeneralNames
 * ASN.1 object.
 *
 * @author Amit Kapoor
 * @author Hemma Prafullchandra
 * @version 1.3
 * @see GeneralName
 * @see GeneralNames
 * @see GeneralNameInterface
 */
public class RFC822Name implements GeneralNameInterface {
    /**
     *
     */
    private static final long serialVersionUID = -1453025303548809007L;
    private String name;

    /**
     * Create the RFC822Name object from the passed encoded Der value.
     *
     * @param derValue the encoded DER RFC822Name.
     * @exception IOException on error.
     */
    public RFC822Name(DerValue derValue) throws IOException {
        name = derValue.getIA5String();
    }

    /**
     * Create the RFC822Name object with the specified name.
     *
     * @param name the RFC822Name.
     */
    public RFC822Name(String name) {
        this.name = name;
    }

    /**
     * Return the type of the GeneralName.
     */
    @Override
    public int getType() {
        return (GeneralNameInterface.NAME_RFC822);
    }

    /**
     * Encode the RFC822 name into the DerOutputStream.
     *
     * @param out the DER stream to encode the RFC822Name to.
     * @exception IOException on encoding errors.
     */
    @Override
    public void encode(DerOutputStream out) throws IOException {
        out.putIA5String(name);
    }

    /**
     * Convert the name into user readable string.
     */
    @Override
    public String toString() {
        return ("RFC822Name: " + name);
    }
}
