%feature("docstring") OT::IndicatorFunction
R"RAW(Indicator function of a :class:`~openturns.Domain` :math:`\mathcal{D}`.

.. math::

    l = 1_{\mathcal{D}}

Parameters
----------
domain : :class:`~openturns.Domain`
    The indicator function checks whether a point belongs to this domain.

Examples
--------
Indicator function of an :class:`~openturns.Interval`:

>>> import openturns as ot
>>> domain = ot.Interval(0.0, 1.0)
>>> indicator = ot.IndicatorFunction(domain)
>>> print(indicator([1.2]))
[0]

Indicator function of a :class:`~openturns.LevelSet`:

>>> analytical = ot.SymbolicFunction(['x'], ['2*x-8'])
>>> levelset = ot.LevelSet(analytical, ot.Less(), 0.0)
>>> f = ot.IndicatorFunction(levelset)
>>> print(f([1.3]))
[1])RAW"
