# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AssociatedIdentity(_Model):
    """Identity details to be used for an operation.

    :ivar operation_identity_type: Identity type that should be used for an operation. Known values
     are: "SystemAssigned" and "UserAssigned".
    :vartype operation_identity_type: str or ~azure.mgmt.recoveryservices.models.IdentityType
    :ivar user_assigned_identity: User assigned identity to be used for an operation if
     operationIdentityType is UserAssigned.
    :vartype user_assigned_identity: str
    """

    operation_identity_type: Optional[Union[str, "_models.IdentityType"]] = rest_field(
        name="operationIdentityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity type that should be used for an operation. Known values are: \"SystemAssigned\" and
     \"UserAssigned\"."""
    user_assigned_identity: Optional[str] = rest_field(
        name="userAssignedIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """User assigned identity to be used for an operation if operationIdentityType is UserAssigned."""

    @overload
    def __init__(
        self,
        *,
        operation_identity_type: Optional[Union[str, "_models.IdentityType"]] = None,
        user_assigned_identity: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureMonitorAlertSettings(_Model):
    """Settings for Azure Monitor based alerts.

    :ivar alerts_for_all_job_failures: Known values are: "Enabled" and "Disabled".
    :vartype alerts_for_all_job_failures: str or ~azure.mgmt.recoveryservices.models.AlertsState
    :ivar alerts_for_all_replication_issues: Known values are: "Enabled" and "Disabled".
    :vartype alerts_for_all_replication_issues: str or
     ~azure.mgmt.recoveryservices.models.AlertsState
    :ivar alerts_for_all_failover_issues: Known values are: "Enabled" and "Disabled".
    :vartype alerts_for_all_failover_issues: str or ~azure.mgmt.recoveryservices.models.AlertsState
    """

    alerts_for_all_job_failures: Optional[Union[str, "_models.AlertsState"]] = rest_field(
        name="alertsForAllJobFailures", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Enabled\" and \"Disabled\"."""
    alerts_for_all_replication_issues: Optional[Union[str, "_models.AlertsState"]] = rest_field(
        name="alertsForAllReplicationIssues", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Enabled\" and \"Disabled\"."""
    alerts_for_all_failover_issues: Optional[Union[str, "_models.AlertsState"]] = rest_field(
        name="alertsForAllFailoverIssues", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        alerts_for_all_job_failures: Optional[Union[str, "_models.AlertsState"]] = None,
        alerts_for_all_replication_issues: Optional[Union[str, "_models.AlertsState"]] = None,
        alerts_for_all_failover_issues: Optional[Union[str, "_models.AlertsState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CapabilitiesProperties(_Model):
    """Capabilities information.

    :ivar dns_zones:
    :vartype dns_zones: list[~azure.mgmt.recoveryservices.models.DNSZone]
    """

    dns_zones: Optional[list["_models.DNSZone"]] = rest_field(
        name="dnsZones", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        dns_zones: Optional[list["_models.DNSZone"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceCapabilitiesBase(_Model):
    """Base class for request and response capabilities information for Microsoft.RecoveryServices.

    :ivar type: Describes the Resource type: Microsoft.RecoveryServices/Vaults. Required.
    :vartype type: str
    """

    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Describes the Resource type: Microsoft.RecoveryServices/Vaults. Required."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CapabilitiesResponse(ResourceCapabilitiesBase):
    """Capabilities response for Microsoft.RecoveryServices.

    :ivar type: Describes the Resource type: Microsoft.RecoveryServices/Vaults. Required.
    :vartype type: str
    :ivar properties: Capabilities properties in response.
    :vartype properties: ~azure.mgmt.recoveryservices.models.CapabilitiesResponseProperties
    """

    properties: Optional["_models.CapabilitiesResponseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Capabilities properties in response."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        properties: Optional["_models.CapabilitiesResponseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CapabilitiesResponseProperties(_Model):
    """Capabilities properties in response.

    :ivar dns_zones:
    :vartype dns_zones: list[~azure.mgmt.recoveryservices.models.DNSZoneResponse]
    """

    dns_zones: Optional[list["_models.DNSZoneResponse"]] = rest_field(
        name="dnsZones", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        dns_zones: Optional[list["_models.DNSZoneResponse"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateRequest(_Model):
    """Details of the certificate to be uploaded to the vault.

    :ivar properties: Raw certificate data.
    :vartype properties: ~azure.mgmt.recoveryservices.models.RawCertificateData
    """

    properties: Optional["_models.RawCertificateData"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Raw certificate data."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.RawCertificateData"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityParameters(_Model):
    """Resource Name availability input parameters - Resource type and resource name.

    :ivar type: Describes the Resource type: Microsoft.RecoveryServices/Vaults.
    :vartype type: str
    :ivar name: Resource name for which availability needs to be checked.
    :vartype name: str
    """

    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Describes the Resource type: Microsoft.RecoveryServices/Vaults."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name for which availability needs to be checked."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[str] = None,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityResult(_Model):
    """Response for check name availability API. Resource provider will set availability as true |
    false.

    :ivar name_available:
    :vartype name_available: bool
    :ivar reason:
    :vartype reason: str
    :ivar message:
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(
        name="nameAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    reason: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClassicAlertSettings(_Model):
    """Settings for classic alerts.

    :ivar alerts_for_critical_operations: Known values are: "Enabled" and "Disabled".
    :vartype alerts_for_critical_operations: str or ~azure.mgmt.recoveryservices.models.AlertsState
    :ivar email_notifications_for_site_recovery: Known values are: "Enabled" and "Disabled".
    :vartype email_notifications_for_site_recovery: str or
     ~azure.mgmt.recoveryservices.models.AlertsState
    """

    alerts_for_critical_operations: Optional[Union[str, "_models.AlertsState"]] = rest_field(
        name="alertsForCriticalOperations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Enabled\" and \"Disabled\"."""
    email_notifications_for_site_recovery: Optional[Union[str, "_models.AlertsState"]] = rest_field(
        name="emailNotificationsForSiteRecovery", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        alerts_for_critical_operations: Optional[Union[str, "_models.AlertsState"]] = None,
        email_notifications_for_site_recovery: Optional[Union[str, "_models.AlertsState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientDiscoveryDisplay(_Model):
    """Localized display information of an operation.

    :ivar provider: Name of the provider for display purposes.
    :vartype provider: str
    :ivar resource: ResourceType for which this Operation can be performed.
    :vartype resource: str
    :ivar operation: Operations Name itself.
    :vartype operation: str
    :ivar description: Description of the operation having details of what operation is about.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the provider for display purposes."""
    resource: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """ResourceType for which this Operation can be performed."""
    operation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operations Name itself."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the operation having details of what operation is about."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientDiscoveryForLogSpecification(_Model):
    """Class to represent shoebox log specification in json client discovery.

    :ivar name: Name of the log.
    :vartype name: str
    :ivar display_name: Localized display name.
    :vartype display_name: str
    :ivar blob_duration: Blobs created in customer storage account per hour.
    :vartype blob_duration: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the log."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display name."""
    blob_duration: Optional[str] = rest_field(
        name="blobDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Blobs created in customer storage account per hour."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientDiscoveryForProperties(_Model):
    """Class to represent shoebox properties in json client discovery.

    :ivar service_specification: Operation properties.
    :vartype service_specification:
     ~azure.mgmt.recoveryservices.models.ClientDiscoveryForServiceSpecification
    """

    service_specification: Optional["_models.ClientDiscoveryForServiceSpecification"] = rest_field(
        name="serviceSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """Operation properties."""

    @overload
    def __init__(
        self,
        *,
        service_specification: Optional["_models.ClientDiscoveryForServiceSpecification"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientDiscoveryForServiceSpecification(_Model):
    """Class to represent shoebox service specification in json client discovery.

    :ivar log_specifications: List of log specifications of this operation.
    :vartype log_specifications:
     list[~azure.mgmt.recoveryservices.models.ClientDiscoveryForLogSpecification]
    """

    log_specifications: Optional[list["_models.ClientDiscoveryForLogSpecification"]] = rest_field(
        name="logSpecifications", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of log specifications of this operation."""

    @overload
    def __init__(
        self,
        *,
        log_specifications: Optional[list["_models.ClientDiscoveryForLogSpecification"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientDiscoveryValueForSingleApi(_Model):
    """Available operation details.

    :ivar name: Name of the Operation.
    :vartype name: str
    :ivar display: Contains the localized display information for this particular operation.
    :vartype display: ~azure.mgmt.recoveryservices.models.ClientDiscoveryDisplay
    :ivar origin: The intended executor of the operation;governs the display of the operation in
     the RBAC UX and the audit logs UX.
    :vartype origin: str
    :ivar properties: ShoeBox properties for the given operation.
    :vartype properties: ~azure.mgmt.recoveryservices.models.ClientDiscoveryForProperties
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the Operation."""
    display: Optional["_models.ClientDiscoveryDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the localized display information for this particular operation."""
    origin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The intended executor of the operation;governs the display of the operation in the RBAC UX and
     the audit logs UX."""
    properties: Optional["_models.ClientDiscoveryForProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """ShoeBox properties for the given operation."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.ClientDiscoveryDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.ClientDiscoveryForProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudError(_Model):
    """An error response from Azure Backup.

    :ivar error: The resource management error response.
    :vartype error: ~azure.mgmt.recoveryservices.models.Error
    """

    error: Optional["_models.Error"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource management error response."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.Error"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CmkKekIdentity(_Model):
    """The details of the identity used for CMK.

    :ivar use_system_assigned_identity: Indicate that system assigned identity should be used.
     Mutually exclusive with 'userAssignedIdentity' field.
    :vartype use_system_assigned_identity: bool
    :ivar user_assigned_identity: The user assigned identity to be used to grant permissions in
     case the type of identity used is UserAssigned.
    :vartype user_assigned_identity: str
    """

    use_system_assigned_identity: Optional[bool] = rest_field(
        name="useSystemAssignedIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicate that system assigned identity should be used. Mutually exclusive with
     'userAssignedIdentity' field."""
    user_assigned_identity: Optional[str] = rest_field(
        name="userAssignedIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user assigned identity to be used to grant permissions in case the type of identity used is
     UserAssigned."""

    @overload
    def __init__(
        self,
        *,
        use_system_assigned_identity: Optional[bool] = None,
        user_assigned_identity: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CmkKeyVaultProperties(_Model):
    """The properties of the Key Vault which hosts CMK.

    :ivar key_uri: The key uri of the Customer Managed Key.
    :vartype key_uri: str
    """

    key_uri: Optional[str] = rest_field(name="keyUri", visibility=["read", "create", "update", "delete", "query"])
    """The key uri of the Customer Managed Key."""

    @overload
    def __init__(
        self,
        *,
        key_uri: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CrossSubscriptionRestoreSettings(_Model):
    """Settings for Cross Subscription Restore Settings.

    :ivar cross_subscription_restore_state: Known values are: "Enabled", "Disabled", and
     "PermanentlyDisabled".
    :vartype cross_subscription_restore_state: str or
     ~azure.mgmt.recoveryservices.models.CrossSubscriptionRestoreState
    """

    cross_subscription_restore_state: Optional[Union[str, "_models.CrossSubscriptionRestoreState"]] = rest_field(
        name="crossSubscriptionRestoreState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Enabled\", \"Disabled\", and \"PermanentlyDisabled\"."""

    @overload
    def __init__(
        self,
        *,
        cross_subscription_restore_state: Optional[Union[str, "_models.CrossSubscriptionRestoreState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    """


class DeletedVault(ProxyResource):
    """DeletedVault information as returned by the resource provider.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.recoveryservices.models.DeletedVaultProperties
    """

    properties: Optional["_models.DeletedVaultProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DeletedVaultProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeletedVaultProperties(_Model):
    """Properties of the DeletedVault.

    :ivar vault_id: ARM Id of the Vault which was deleted.
    :vartype vault_id: str
    :ivar vault_deletion_time: Time in UTC at which the Vault was deleted.
    :vartype vault_deletion_time: ~datetime.datetime
    :ivar purge_at: Time in UTC at which the DeletedVault will be purged.
    :vartype purge_at: ~datetime.datetime
    """

    vault_id: Optional[str] = rest_field(name="vaultId", visibility=["read"])
    """ARM Id of the Vault which was deleted."""
    vault_deletion_time: Optional[datetime.datetime] = rest_field(
        name="vaultDeletionTime", visibility=["read"], format="rfc3339"
    )
    """Time in UTC at which the Vault was deleted."""
    purge_at: Optional[datetime.datetime] = rest_field(name="purgeAt", visibility=["read"], format="rfc3339")
    """Time in UTC at which the DeletedVault will be purged."""


class DeletedVaultUndeleteInput(_Model):
    """Input definition for DeletedVault undelete.

    :ivar properties: Undelete input properties. Required.
    :vartype properties: ~azure.mgmt.recoveryservices.models.DeletedVaultUndeleteInputProperties
    """

    properties: "_models.DeletedVaultUndeleteInputProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Undelete input properties. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.DeletedVaultUndeleteInputProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeletedVaultUndeleteInputProperties(_Model):
    """Input definition for DeletedVault undelete properties.

    :ivar recovery_resource_group_id: Recovery resource group Id. Required.
    :vartype recovery_resource_group_id: str
    """

    recovery_resource_group_id: str = rest_field(
        name="recoveryResourceGroupId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Recovery resource group Id. Required."""

    @overload
    def __init__(
        self,
        *,
        recovery_resource_group_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DNSZone(_Model):
    """DNSZone information.

    :ivar sub_resource: Subresource type for vault AzureBackup, AzureBackup_secondary or
     AzureSiteRecovery. Known values are: "AzureBackup", "AzureBackup_secondary", and
     "AzureSiteRecovery".
    :vartype sub_resource: str or ~azure.mgmt.recoveryservices.models.VaultSubResourceType
    """

    sub_resource: Optional[Union[str, "_models.VaultSubResourceType"]] = rest_field(
        name="subResource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Subresource type for vault AzureBackup, AzureBackup_secondary or AzureSiteRecovery. Known
     values are: \"AzureBackup\", \"AzureBackup_secondary\", and \"AzureSiteRecovery\"."""

    @overload
    def __init__(
        self,
        *,
        sub_resource: Optional[Union[str, "_models.VaultSubResourceType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DNSZoneResponse(DNSZone):
    """DNSZone information for Microsoft.RecoveryServices.

    :ivar sub_resource: Subresource type for vault AzureBackup, AzureBackup_secondary or
     AzureSiteRecovery. Known values are: "AzureBackup", "AzureBackup_secondary", and
     "AzureSiteRecovery".
    :vartype sub_resource: str or ~azure.mgmt.recoveryservices.models.VaultSubResourceType
    :ivar required_zone_names: The private link resource Private link DNS zone names.
    :vartype required_zone_names: list[str]
    """

    required_zone_names: Optional[list[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private link resource Private link DNS zone names."""

    @overload
    def __init__(
        self,
        *,
        sub_resource: Optional[Union[str, "_models.VaultSubResourceType"]] = None,
        required_zone_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Error(_Model):
    """The resource management error response.

    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.recoveryservices.models.ErrorAdditionalInfo]
    :ivar code: The error code.
    :vartype code: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.recoveryservices.models.Error]
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    """

    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""
    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    details: Optional[list["_models.Error"]] = rest_field(visibility=["read"])
    """The error details."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.recoveryservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.recoveryservices.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.recoveryservices.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IdentityData(_Model):
    """Identity for the resource.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes
     both an implicitly created identity and a set of user-assigned identities. The type 'None' will
     remove any identities. Required. Known values are: "SystemAssigned", "None", "UserAssigned",
     and "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.recoveryservices.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user-assigned identities associated with the
     resource. The user-assigned identity dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.recoveryservices.models.UserIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of resource identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of resource."""
    type: Union[str, "_models.ResourceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an
     implicitly created identity and a set of user-assigned identities. The type 'None' will remove
     any identities. Required. Known values are: \"SystemAssigned\", \"None\", \"UserAssigned\", and
     \"SystemAssigned, UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user-assigned identities associated with the resource. The user-assigned identity
     dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ResourceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImmutabilitySettings(_Model):
    """Immutability Settings of vault.

    :ivar state: Known values are: "Disabled", "Unlocked", and "Locked".
    :vartype state: str or ~azure.mgmt.recoveryservices.models.ImmutabilityState
    """

    state: Optional[Union[str, "_models.ImmutabilityState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Disabled\", \"Unlocked\", and \"Locked\"."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.ImmutabilityState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobsSummary(_Model):
    """Summary of the replication job data for this vault.

    :ivar failed_jobs: Count of failed jobs.
    :vartype failed_jobs: int
    :ivar suspended_jobs: Count of suspended jobs.
    :vartype suspended_jobs: int
    :ivar in_progress_jobs: Count of in-progress jobs.
    :vartype in_progress_jobs: int
    """

    failed_jobs: Optional[int] = rest_field(
        name="failedJobs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of failed jobs."""
    suspended_jobs: Optional[int] = rest_field(
        name="suspendedJobs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of suspended jobs."""
    in_progress_jobs: Optional[int] = rest_field(
        name="inProgressJobs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of in-progress jobs."""

    @overload
    def __init__(
        self,
        *,
        failed_jobs: Optional[int] = None,
        suspended_jobs: Optional[int] = None,
        in_progress_jobs: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MonitoringSettings(_Model):
    """Monitoring Settings of the vault.

    :ivar azure_monitor_alert_settings: Settings for Azure Monitor based alerts.
    :vartype azure_monitor_alert_settings:
     ~azure.mgmt.recoveryservices.models.AzureMonitorAlertSettings
    :ivar classic_alert_settings: Settings for classic alerts.
    :vartype classic_alert_settings: ~azure.mgmt.recoveryservices.models.ClassicAlertSettings
    """

    azure_monitor_alert_settings: Optional["_models.AzureMonitorAlertSettings"] = rest_field(
        name="azureMonitorAlertSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for Azure Monitor based alerts."""
    classic_alert_settings: Optional["_models.ClassicAlertSettings"] = rest_field(
        name="classicAlertSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for classic alerts."""

    @overload
    def __init__(
        self,
        *,
        azure_monitor_alert_settings: Optional["_models.AzureMonitorAlertSettings"] = None,
        classic_alert_settings: Optional["_models.ClassicAlertSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MonitoringSummary(_Model):
    """Summary of the replication monitoring data for this vault.

    :ivar un_healthy_vm_count: Count of unhealthy VMs.
    :vartype un_healthy_vm_count: int
    :ivar un_healthy_provider_count: Count of unhealthy replication providers.
    :vartype un_healthy_provider_count: int
    :ivar events_count: Count of all critical warnings.
    :vartype events_count: int
    :ivar deprecated_provider_count: Count of all deprecated recovery service providers.
    :vartype deprecated_provider_count: int
    :ivar supported_provider_count: Count of all the supported recovery service providers.
    :vartype supported_provider_count: int
    :ivar unsupported_provider_count: Count of all the unsupported recovery service providers.
    :vartype unsupported_provider_count: int
    """

    un_healthy_vm_count: Optional[int] = rest_field(
        name="unHealthyVmCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of unhealthy VMs."""
    un_healthy_provider_count: Optional[int] = rest_field(
        name="unHealthyProviderCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of unhealthy replication providers."""
    events_count: Optional[int] = rest_field(
        name="eventsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of all critical warnings."""
    deprecated_provider_count: Optional[int] = rest_field(
        name="deprecatedProviderCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of all deprecated recovery service providers."""
    supported_provider_count: Optional[int] = rest_field(
        name="supportedProviderCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of all the supported recovery service providers."""
    unsupported_provider_count: Optional[int] = rest_field(
        name="unsupportedProviderCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Count of all the unsupported recovery service providers."""

    @overload
    def __init__(
        self,
        *,
        un_healthy_vm_count: Optional[int] = None,
        un_healthy_provider_count: Optional[int] = None,
        events_count: Optional[int] = None,
        deprecated_provider_count: Optional[int] = None,
        supported_provider_count: Optional[int] = None,
        unsupported_provider_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NameInfo(_Model):
    """The name of usage.

    :ivar value: Value of usage.
    :vartype value: str
    :ivar localized_value: Localized value of usage.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Value of usage."""
    localized_value: Optional[str] = rest_field(
        name="localizedValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized value of usage."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationResource(_Model):
    """Operation Resource.

    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: Required if status == failed or status == canceled. This is the OData v4 error
     format, used by the RPC and will go into the v2.2 Azure REST API guidelines.
    :vartype error: ~azure.mgmt.recoveryservices.models.Error
    :ivar id: It should match what is used to GET the operation result.
    :vartype id: str
    :ivar name: It must match the last segment of the "id" field, and will typically be a GUID /
     system generated value.
    :vartype name: str
    :ivar status: The status of the operation. (InProgress/Success/Failed/Cancelled).
    :vartype status: str
    :ivar start_time: Start time of the operation.
    :vartype start_time: ~datetime.datetime
    """

    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time of the operation."""
    error: Optional["_models.Error"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required if status == failed or status == canceled. This is the OData v4 error format, used by
     the RPC and will go into the v2.2 Azure REST API guidelines."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """It should match what is used to GET the operation result."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """It must match the last segment of the \"id\" field, and will typically be a GUID / system
     generated value."""
    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The status of the operation. (InProgress/Success/Failed/Cancelled)."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time of the operation."""

    @overload
    def __init__(
        self,
        *,
        end_time: Optional[datetime.datetime] = None,
        error: Optional["_models.Error"] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatchTrackedResource(Resource):
    """Tracked resource with location.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Optional ETag.
    :vartype etag: str
    """

    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource location."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional ETag."""

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        etag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatchVault(PatchTrackedResource):
    """Patch Resource information, as returned by the resource provider.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Optional ETag.
    :vartype etag: str
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.recoveryservices.models.VaultProperties
    :ivar sku: Identifies the unique system identifier for each Azure resource.
    :vartype sku: ~azure.mgmt.recoveryservices.models.Sku
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.recoveryservices.models.IdentityData
    """

    properties: Optional["_models.VaultProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the vault."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Identifies the unique system identifier for each Azure resource."""
    identity: Optional["_models.IdentityData"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Identity for the resource."""

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        etag: Optional[str] = None,
        properties: Optional["_models.VaultProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.IdentityData"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_Model):
    """The Private Endpoint network resource that is linked to the Private Endpoint connection.

    :ivar id: Gets or sets id.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets id."""


class PrivateEndpointConnection(_Model):
    """Private Endpoint Connection Response Properties.

    :ivar provisioning_state: Gets or sets provisioning state of the private endpoint connection.
     Known values are: "Succeeded", "Deleting", "Failed", and "Pending".
    :vartype provisioning_state: str or ~azure.mgmt.recoveryservices.models.ProvisioningState
    :ivar private_endpoint: The Private Endpoint network resource that is linked to the Private
     Endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.recoveryservices.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Gets or sets private link service connection
     state.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.recoveryservices.models.PrivateLinkServiceConnectionState
    :ivar group_ids: Group Ids for the Private Endpoint.
    :vartype group_ids: list[str or ~azure.mgmt.recoveryservices.models.VaultSubResourceType]
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets or sets provisioning state of the private endpoint connection. Known values are:
     \"Succeeded\", \"Deleting\", \"Failed\", and \"Pending\"."""
    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(name="privateEndpoint", visibility=["read"])
    """The Private Endpoint network resource that is linked to the Private Endpoint connection."""
    private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read"]
    )
    """Gets or sets private link service connection state."""
    group_ids: Optional[list[Union[str, "_models.VaultSubResourceType"]]] = rest_field(
        name="groupIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Group Ids for the Private Endpoint."""

    @overload
    def __init__(
        self,
        *,
        group_ids: Optional[list[Union[str, "_models.VaultSubResourceType"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionVaultProperties(_Model):
    """Information to be stored in Vault properties as an element of privateEndpointConnections List.

    :ivar id: Format of id
     subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
    :vartype id: str
    :ivar properties: Private Endpoint Connection Response Properties.
    :vartype properties: ~azure.mgmt.recoveryservices.models.PrivateEndpointConnection
    :ivar name: The name of the private Endpoint Connection.
    :vartype name: str
    :ivar type: The type, which will be of the format,
     Microsoft.RecoveryServices/vaults/privateEndpointConnections.
    :vartype type: str
    :ivar location: The location of the private Endpoint connection.
    :vartype location: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Format of id
     subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}."""
    properties: Optional["_models.PrivateEndpointConnection"] = rest_field(visibility=["read"])
    """Private Endpoint Connection Response Properties."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the private Endpoint Connection."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type, which will be of the format,
     Microsoft.RecoveryServices/vaults/privateEndpointConnections."""
    location: Optional[str] = rest_field(visibility=["read"])
    """The location of the private Endpoint connection."""


class PrivateLinkResource(ProxyResource):
    """Information of the private link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.recoveryservices.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""

    __flattened_items = ["group_id", "required_members", "required_zone_names"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateLinkResourceProperties(_Model):
    """Properties of the private link resource.

    :ivar group_id: e.g. f9ad6492-33d4-4690-9999-6bfd52a0d081 (Backup) or
     f9ad6492-33d4-4690-9999-6bfd52a0d082 (SiteRecovery).
    :vartype group_id: str
    :ivar required_members: [backup-ecs1, backup-prot1, backup-prot1b, backup-prot1c, backup-id1].
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """e.g. f9ad6492-33d4-4690-9999-6bfd52a0d081 (Backup) or f9ad6492-33d4-4690-9999-6bfd52a0d082
     (SiteRecovery)."""
    required_members: Optional[list[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """[backup-ecs1, backup-prot1, backup-prot1b, backup-prot1c, backup-id1]."""
    required_zone_names: Optional[list[str]] = rest_field(name="requiredZoneNames", visibility=["read"])
    """The private link resource Private link DNS zone name."""


class PrivateLinkServiceConnectionState(_Model):
    """Gets or sets private link service connection state.

    :ivar status: Gets or sets the status. Known values are: "Pending", "Approved", "Rejected", and
     "Disconnected".
    :vartype status: str or ~azure.mgmt.recoveryservices.models.PrivateEndpointConnectionStatus
    :ivar description: Gets or sets description.
    :vartype description: str
    :ivar actions_required: Gets or sets actions required.
    :vartype actions_required: str
    """

    status: Optional[Union[str, "_models.PrivateEndpointConnectionStatus"]] = rest_field(visibility=["read"])
    """Gets or sets the status. Known values are: \"Pending\", \"Approved\", \"Rejected\", and
     \"Disconnected\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets description."""
    actions_required: Optional[str] = rest_field(name="actionsRequired", visibility=["read"])
    """Gets or sets actions required."""


class RawCertificateData(_Model):
    """Raw certificate data.

    :ivar auth_type: Specifies the authentication type. Known values are: "Invalid", "ACS", "AAD",
     "AccessControlService", and "AzureActiveDirectory".
    :vartype auth_type: str or ~azure.mgmt.recoveryservices.models.AuthType
    :ivar certificate: The base64 encoded certificate raw data string.
    :vartype certificate: bytes
    """

    auth_type: Optional[Union[str, "_models.AuthType"]] = rest_field(
        name="authType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the authentication type. Known values are: \"Invalid\", \"ACS\", \"AAD\",
     \"AccessControlService\", and \"AzureActiveDirectory\"."""
    certificate: Optional[bytes] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="base64"
    )
    """The base64 encoded certificate raw data string."""

    @overload
    def __init__(
        self,
        *,
        auth_type: Optional[Union[str, "_models.AuthType"]] = None,
        certificate: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReplicationUsage(_Model):
    """Replication usages of a vault.

    :ivar monitoring_summary: Summary of the replication monitoring data for this vault.
    :vartype monitoring_summary: ~azure.mgmt.recoveryservices.models.MonitoringSummary
    :ivar jobs_summary: Summary of the replication jobs data for this vault.
    :vartype jobs_summary: ~azure.mgmt.recoveryservices.models.JobsSummary
    :ivar protected_item_count: Number of replication protected items for this vault.
    :vartype protected_item_count: int
    :ivar recovery_plan_count: Number of replication recovery plans for this vault.
    :vartype recovery_plan_count: int
    :ivar registered_servers_count: Number of servers registered to this vault.
    :vartype registered_servers_count: int
    :ivar recovery_services_provider_auth_type: The authentication type of recovery service
     providers in the vault.
    :vartype recovery_services_provider_auth_type: int
    """

    monitoring_summary: Optional["_models.MonitoringSummary"] = rest_field(
        name="monitoringSummary", visibility=["read", "create", "update", "delete", "query"]
    )
    """Summary of the replication monitoring data for this vault."""
    jobs_summary: Optional["_models.JobsSummary"] = rest_field(
        name="jobsSummary", visibility=["read", "create", "update", "delete", "query"]
    )
    """Summary of the replication jobs data for this vault."""
    protected_item_count: Optional[int] = rest_field(
        name="protectedItemCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of replication protected items for this vault."""
    recovery_plan_count: Optional[int] = rest_field(
        name="recoveryPlanCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of replication recovery plans for this vault."""
    registered_servers_count: Optional[int] = rest_field(
        name="registeredServersCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of servers registered to this vault."""
    recovery_services_provider_auth_type: Optional[int] = rest_field(
        name="recoveryServicesProviderAuthType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The authentication type of recovery service providers in the vault."""

    @overload
    def __init__(
        self,
        *,
        monitoring_summary: Optional["_models.MonitoringSummary"] = None,
        jobs_summary: Optional["_models.JobsSummary"] = None,
        protected_item_count: Optional[int] = None,
        recovery_plan_count: Optional[int] = None,
        registered_servers_count: Optional[int] = None,
        recovery_services_provider_auth_type: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceCapabilities(ResourceCapabilitiesBase):
    """Input to get capabilities information for Microsoft.RecoveryServices.

    :ivar type: Describes the Resource type: Microsoft.RecoveryServices/Vaults. Required.
    :vartype type: str
    :ivar properties: Capabilities information.
    :vartype properties: ~azure.mgmt.recoveryservices.models.CapabilitiesProperties
    """

    properties: Optional["_models.CapabilitiesProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Capabilities information."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        properties: Optional["_models.CapabilitiesProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceCertificateDetails(_Model):
    """Certificate details representing the Vault credentials.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResourceCertificateAndAcsDetails, ResourceCertificateAndAadDetails

    :ivar auth_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required. Default value is None.
    :vartype auth_type: str
    :ivar certificate: The base64 encoded certificate raw data string.
    :vartype certificate: bytes
    :ivar friendly_name: Certificate friendly name.
    :vartype friendly_name: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar resource_id: Resource ID of the vault.
    :vartype resource_id: int
    :ivar subject: Certificate Subject Name.
    :vartype subject: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid_from: Certificate Validity start Date time.
    :vartype valid_from: ~datetime.datetime
    :ivar valid_to: Certificate Validity End Date time.
    :vartype valid_to: ~datetime.datetime
    """

    __mapping__: dict[str, _Model] = {}
    auth_type: str = rest_discriminator(name="authType", visibility=["read", "create", "update", "delete", "query"])
    """This property will be used as the discriminator for deciding the specific types in the
     polymorphic chain of types. Required. Default value is None."""
    certificate: Optional[bytes] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="base64"
    )
    """The base64 encoded certificate raw data string."""
    friendly_name: Optional[str] = rest_field(
        name="friendlyName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Certificate friendly name."""
    issuer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Certificate issuer."""
    resource_id: Optional[int] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource ID of the vault."""
    subject: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Certificate Subject Name."""
    thumbprint: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Certificate thumbprint."""
    valid_from: Optional[datetime.datetime] = rest_field(
        name="validFrom", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Certificate Validity start Date time."""
    valid_to: Optional[datetime.datetime] = rest_field(
        name="validTo", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Certificate Validity End Date time."""

    @overload
    def __init__(
        self,
        *,
        auth_type: str,
        certificate: Optional[bytes] = None,
        friendly_name: Optional[str] = None,
        issuer: Optional[str] = None,
        resource_id: Optional[int] = None,
        subject: Optional[str] = None,
        thumbprint: Optional[str] = None,
        valid_from: Optional[datetime.datetime] = None,
        valid_to: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceCertificateAndAadDetails(ResourceCertificateDetails, discriminator="AzureActiveDirectory"):
    """Certificate details representing the Vault credentials for AAD.

    :ivar certificate: The base64 encoded certificate raw data string.
    :vartype certificate: bytes
    :ivar friendly_name: Certificate friendly name.
    :vartype friendly_name: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar resource_id: Resource ID of the vault.
    :vartype resource_id: int
    :ivar subject: Certificate Subject Name.
    :vartype subject: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid_from: Certificate Validity start Date time.
    :vartype valid_from: ~datetime.datetime
    :ivar valid_to: Certificate Validity End Date time.
    :vartype valid_to: ~datetime.datetime
    :ivar aad_authority: AAD tenant authority. Required.
    :vartype aad_authority: str
    :ivar aad_tenant_id: AAD tenant Id. Required.
    :vartype aad_tenant_id: str
    :ivar service_principal_client_id: AAD service principal clientId. Required.
    :vartype service_principal_client_id: str
    :ivar service_principal_object_id: AAD service principal ObjectId. Required.
    :vartype service_principal_object_id: str
    :ivar azure_management_endpoint_audience: Azure Management Endpoint Audience. Required.
    :vartype azure_management_endpoint_audience: str
    :ivar service_resource_id: Service Resource Id.
    :vartype service_resource_id: str
    :ivar aad_audience: AAD audience for the resource.
    :vartype aad_audience: str
    :ivar auth_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required. Default value is "AzureActiveDirectory".
    :vartype auth_type: str
    """

    aad_authority: str = rest_field(name="aadAuthority", visibility=["read", "create", "update", "delete", "query"])
    """AAD tenant authority. Required."""
    aad_tenant_id: str = rest_field(name="aadTenantId", visibility=["read", "create", "update", "delete", "query"])
    """AAD tenant Id. Required."""
    service_principal_client_id: str = rest_field(
        name="servicePrincipalClientId", visibility=["read", "create", "update", "delete", "query"]
    )
    """AAD service principal clientId. Required."""
    service_principal_object_id: str = rest_field(
        name="servicePrincipalObjectId", visibility=["read", "create", "update", "delete", "query"]
    )
    """AAD service principal ObjectId. Required."""
    azure_management_endpoint_audience: str = rest_field(
        name="azureManagementEndpointAudience", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure Management Endpoint Audience. Required."""
    service_resource_id: Optional[str] = rest_field(
        name="serviceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Service Resource Id."""
    aad_audience: Optional[str] = rest_field(
        name="aadAudience", visibility=["read", "create", "update", "delete", "query"]
    )
    """AAD audience for the resource."""
    auth_type: Literal["AzureActiveDirectory"] = rest_discriminator(name="authType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """This property will be used as the discriminator for deciding the specific types in the
     polymorphic chain of types. Required. Default value is \"AzureActiveDirectory\"."""

    @overload
    def __init__(
        self,
        *,
        aad_authority: str,
        aad_tenant_id: str,
        service_principal_client_id: str,
        service_principal_object_id: str,
        azure_management_endpoint_audience: str,
        certificate: Optional[bytes] = None,
        friendly_name: Optional[str] = None,
        issuer: Optional[str] = None,
        resource_id: Optional[int] = None,
        subject: Optional[str] = None,
        thumbprint: Optional[str] = None,
        valid_from: Optional[datetime.datetime] = None,
        valid_to: Optional[datetime.datetime] = None,
        service_resource_id: Optional[str] = None,
        aad_audience: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.auth_type = "AzureActiveDirectory"  # type: ignore


class ResourceCertificateAndAcsDetails(ResourceCertificateDetails, discriminator="AccessControlService"):
    """Certificate details representing the Vault credentials for ACS.

    :ivar certificate: The base64 encoded certificate raw data string.
    :vartype certificate: bytes
    :ivar friendly_name: Certificate friendly name.
    :vartype friendly_name: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar resource_id: Resource ID of the vault.
    :vartype resource_id: int
    :ivar subject: Certificate Subject Name.
    :vartype subject: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid_from: Certificate Validity start Date time.
    :vartype valid_from: ~datetime.datetime
    :ivar valid_to: Certificate Validity End Date time.
    :vartype valid_to: ~datetime.datetime
    :ivar global_acs_namespace: ACS namespace name - tenant for our service. Required.
    :vartype global_acs_namespace: str
    :ivar global_acs_host_name: Acs mgmt host name to connect to. Required.
    :vartype global_acs_host_name: str
    :ivar global_acs_rp_realm: Global ACS namespace RP realm. Required.
    :vartype global_acs_rp_realm: str
    :ivar auth_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required. Default value is "AccessControlService".
    :vartype auth_type: str
    """

    global_acs_namespace: str = rest_field(
        name="globalAcsNamespace", visibility=["read", "create", "update", "delete", "query"]
    )
    """ACS namespace name - tenant for our service. Required."""
    global_acs_host_name: str = rest_field(
        name="globalAcsHostName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Acs mgmt host name to connect to. Required."""
    global_acs_rp_realm: str = rest_field(
        name="globalAcsRPRealm", visibility=["read", "create", "update", "delete", "query"]
    )
    """Global ACS namespace RP realm. Required."""
    auth_type: Literal["AccessControlService"] = rest_discriminator(name="authType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """This property will be used as the discriminator for deciding the specific types in the
     polymorphic chain of types. Required. Default value is \"AccessControlService\"."""

    @overload
    def __init__(
        self,
        *,
        global_acs_namespace: str,
        global_acs_host_name: str,
        global_acs_rp_realm: str,
        certificate: Optional[bytes] = None,
        friendly_name: Optional[str] = None,
        issuer: Optional[str] = None,
        resource_id: Optional[int] = None,
        subject: Optional[str] = None,
        thumbprint: Optional[str] = None,
        valid_from: Optional[datetime.datetime] = None,
        valid_to: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.auth_type = "AccessControlService"  # type: ignore


class RestoreSettings(_Model):
    """Restore Settings  of the vault.

    :ivar cross_subscription_restore_settings: Settings for CrossSubscriptionRestore.
    :vartype cross_subscription_restore_settings:
     ~azure.mgmt.recoveryservices.models.CrossSubscriptionRestoreSettings
    """

    cross_subscription_restore_settings: Optional["_models.CrossSubscriptionRestoreSettings"] = rest_field(
        name="crossSubscriptionRestoreSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for CrossSubscriptionRestore."""

    @overload
    def __init__(
        self,
        *,
        cross_subscription_restore_settings: Optional["_models.CrossSubscriptionRestoreSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecuritySettings(_Model):
    """Security Settings of the vault.

    :ivar immutability_settings: Immutability Settings of a vault.
    :vartype immutability_settings: ~azure.mgmt.recoveryservices.models.ImmutabilitySettings
    :ivar soft_delete_settings: Soft delete Settings of a vault.
    :vartype soft_delete_settings: ~azure.mgmt.recoveryservices.models.SoftDeleteSettings
    :ivar multi_user_authorization: MUA Settings of a vault. Known values are: "Invalid",
     "Enabled", and "Disabled".
    :vartype multi_user_authorization: str or
     ~azure.mgmt.recoveryservices.models.MultiUserAuthorization
    :ivar source_scan_configuration: Source scan configuration of vault.
    :vartype source_scan_configuration: ~azure.mgmt.recoveryservices.models.SourceScanConfiguration
    """

    immutability_settings: Optional["_models.ImmutabilitySettings"] = rest_field(
        name="immutabilitySettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Immutability Settings of a vault."""
    soft_delete_settings: Optional["_models.SoftDeleteSettings"] = rest_field(
        name="softDeleteSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Soft delete Settings of a vault."""
    multi_user_authorization: Optional[Union[str, "_models.MultiUserAuthorization"]] = rest_field(
        name="multiUserAuthorization", visibility=["read"]
    )
    """MUA Settings of a vault. Known values are: \"Invalid\", \"Enabled\", and \"Disabled\"."""
    source_scan_configuration: Optional["_models.SourceScanConfiguration"] = rest_field(
        name="sourceScanConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Source scan configuration of vault."""

    @overload
    def __init__(
        self,
        *,
        immutability_settings: Optional["_models.ImmutabilitySettings"] = None,
        soft_delete_settings: Optional["_models.SoftDeleteSettings"] = None,
        source_scan_configuration: Optional["_models.SourceScanConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Sku(_Model):
    """Identifies the unique system identifier for each Azure resource.

    :ivar name: Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier.
     They do not have affect on backend storage redundancy or any other vault settings. To manage
     storage redundancy, use the backupstorageconfig. Required. Known values are: "Standard" and
     "RS0".
    :vartype name: str or ~azure.mgmt.recoveryservices.models.SkuName
    :ivar tier: The Sku tier.
    :vartype tier: str
    :ivar family: The sku family.
    :vartype family: str
    :ivar size: The sku size.
    :vartype size: str
    :ivar capacity: The sku capacity.
    :vartype capacity: str
    """

    name: Union[str, "_models.SkuName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not
     have affect on backend storage redundancy or any other vault settings. To manage storage
     redundancy, use the backupstorageconfig. Required. Known values are: \"Standard\" and \"RS0\"."""
    tier: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Sku tier."""
    family: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sku family."""
    size: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sku size."""
    capacity: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sku capacity."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        tier: Optional[str] = None,
        family: Optional[str] = None,
        size: Optional[str] = None,
        capacity: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SoftDeleteSettings(_Model):
    """Soft delete Settings of vault.

    :ivar soft_delete_state: Known values are: "Invalid", "Enabled", "Disabled", and "AlwaysON".
    :vartype soft_delete_state: str or ~azure.mgmt.recoveryservices.models.SoftDeleteState
    :ivar soft_delete_retention_period_in_days: Soft delete retention period in days.
    :vartype soft_delete_retention_period_in_days: int
    :ivar enhanced_security_state: Known values are: "Invalid", "Enabled", "Disabled", and
     "AlwaysON".
    :vartype enhanced_security_state: str or
     ~azure.mgmt.recoveryservices.models.EnhancedSecurityState
    """

    soft_delete_state: Optional[Union[str, "_models.SoftDeleteState"]] = rest_field(
        name="softDeleteState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Invalid\", \"Enabled\", \"Disabled\", and \"AlwaysON\"."""
    soft_delete_retention_period_in_days: Optional[int] = rest_field(
        name="softDeleteRetentionPeriodInDays", visibility=["read", "create", "update", "delete", "query"]
    )
    """Soft delete retention period in days."""
    enhanced_security_state: Optional[Union[str, "_models.EnhancedSecurityState"]] = rest_field(
        name="enhancedSecurityState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Invalid\", \"Enabled\", \"Disabled\", and \"AlwaysON\"."""

    @overload
    def __init__(
        self,
        *,
        soft_delete_state: Optional[Union[str, "_models.SoftDeleteState"]] = None,
        soft_delete_retention_period_in_days: Optional[int] = None,
        enhanced_security_state: Optional[Union[str, "_models.EnhancedSecurityState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceScanConfiguration(_Model):
    """Source scan configuration of vault.

    :ivar state: Known values are: "Invalid", "Enabled", and "Disabled".
    :vartype state: str or ~azure.mgmt.recoveryservices.models.State
    :ivar source_scan_identity: Identity details to be used for an operation.
    :vartype source_scan_identity: ~azure.mgmt.recoveryservices.models.AssociatedIdentity
    """

    state: Optional[Union[str, "_models.State"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Invalid\", \"Enabled\", and \"Disabled\"."""
    source_scan_identity: Optional["_models.AssociatedIdentity"] = rest_field(
        name="sourceScanIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity details to be used for an operation."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.State"]] = None,
        source_scan_identity: Optional["_models.AssociatedIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.recoveryservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.recoveryservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpgradeDetails(_Model):
    """Details for upgrading vault.

    :ivar operation_id: ID of the vault upgrade operation.
    :vartype operation_id: str
    :ivar start_time_utc: UTC time at which the upgrade operation has started.
    :vartype start_time_utc: ~datetime.datetime
    :ivar last_updated_time_utc: UTC time at which the upgrade operation status was last updated.
    :vartype last_updated_time_utc: ~datetime.datetime
    :ivar end_time_utc: UTC time at which the upgrade operation has ended.
    :vartype end_time_utc: ~datetime.datetime
    :ivar status: Status of the vault upgrade operation. Known values are: "Unknown", "InProgress",
     "Upgraded", and "Failed".
    :vartype status: str or ~azure.mgmt.recoveryservices.models.VaultUpgradeState
    :ivar message: Message to the user containing information about the upgrade operation.
    :vartype message: str
    :ivar trigger_type: The way the vault upgrade was triggered. Known values are: "UserTriggered"
     and "ForcedUpgrade".
    :vartype trigger_type: str or ~azure.mgmt.recoveryservices.models.TriggerType
    :ivar upgraded_resource_id: Resource ID of the upgraded vault.
    :vartype upgraded_resource_id: str
    :ivar previous_resource_id: Resource ID of the vault before the upgrade.
    :vartype previous_resource_id: str
    """

    operation_id: Optional[str] = rest_field(name="operationId", visibility=["read"])
    """ID of the vault upgrade operation."""
    start_time_utc: Optional[datetime.datetime] = rest_field(name="startTimeUtc", visibility=["read"], format="rfc3339")
    """UTC time at which the upgrade operation has started."""
    last_updated_time_utc: Optional[datetime.datetime] = rest_field(
        name="lastUpdatedTimeUtc", visibility=["read"], format="rfc3339"
    )
    """UTC time at which the upgrade operation status was last updated."""
    end_time_utc: Optional[datetime.datetime] = rest_field(name="endTimeUtc", visibility=["read"], format="rfc3339")
    """UTC time at which the upgrade operation has ended."""
    status: Optional[Union[str, "_models.VaultUpgradeState"]] = rest_field(visibility=["read"])
    """Status of the vault upgrade operation. Known values are: \"Unknown\", \"InProgress\",
     \"Upgraded\", and \"Failed\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Message to the user containing information about the upgrade operation."""
    trigger_type: Optional[Union[str, "_models.TriggerType"]] = rest_field(name="triggerType", visibility=["read"])
    """The way the vault upgrade was triggered. Known values are: \"UserTriggered\" and
     \"ForcedUpgrade\"."""
    upgraded_resource_id: Optional[str] = rest_field(name="upgradedResourceId", visibility=["read"])
    """Resource ID of the upgraded vault."""
    previous_resource_id: Optional[str] = rest_field(name="previousResourceId", visibility=["read"])
    """Resource ID of the vault before the upgrade."""


class UserIdentity(_Model):
    """A resource identity that is managed by the user of the service.

    :ivar principal_id: The principal ID of the user-assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the user-assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the user-assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the user-assigned identity."""


class Vault(TrackedResource):
    """Resource information, as returned by the resource provider.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.recoveryservices.models.VaultProperties
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.recoveryservices.models.IdentityData
    :ivar sku: Identifies the unique system identifier for each Azure resource.
    :vartype sku: ~azure.mgmt.recoveryservices.models.Sku
    :ivar etag: etag for the resource.
    :vartype etag: str
    """

    properties: Optional["_models.VaultProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the vault."""
    identity: Optional["_models.IdentityData"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Identity for the resource."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Identifies the unique system identifier for each Azure resource."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """etag for the resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.VaultProperties"] = None,
        identity: Optional["_models.IdentityData"] = None,
        sku: Optional["_models.Sku"] = None,
        etag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultCertificateResponse(_Model):
    """Certificate corresponding to a vault that can be used by clients to register themselves with
    the vault.

    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar properties: Certificate details representing the Vault credentials.
    :vartype properties: ~azure.mgmt.recoveryservices.models.ResourceCertificateDetails
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name associated with the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/..."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id represents the complete path to the resource."""
    properties: Optional["_models.ResourceCertificateDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Certificate details representing the Vault credentials."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ResourceCertificateDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultExtendedInfo(_Model):
    """Vault extended information.

    :ivar integrity_key: Integrity key.
    :vartype integrity_key: str
    :ivar encryption_key: Encryption key.
    :vartype encryption_key: str
    :ivar encryption_key_thumbprint: Encryption key thumbprint.
    :vartype encryption_key_thumbprint: str
    :ivar algorithm: Algorithm for Vault ExtendedInfo.
    :vartype algorithm: str
    """

    integrity_key: Optional[str] = rest_field(
        name="integrityKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """Integrity key."""
    encryption_key: Optional[str] = rest_field(
        name="encryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """Encryption key."""
    encryption_key_thumbprint: Optional[str] = rest_field(
        name="encryptionKeyThumbprint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Encryption key thumbprint."""
    algorithm: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Algorithm for Vault ExtendedInfo."""

    @overload
    def __init__(
        self,
        *,
        integrity_key: Optional[str] = None,
        encryption_key: Optional[str] = None,
        encryption_key_thumbprint: Optional[str] = None,
        algorithm: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultExtendedInfoResource(ProxyResource):
    """Vault extended information.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.recoveryservices.models.SystemData
    :ivar properties: Vault extended information.
    :vartype properties: ~azure.mgmt.recoveryservices.models.VaultExtendedInfo
    :ivar etag: etag for the resource.
    :vartype etag: str
    """

    properties: Optional["_models.VaultExtendedInfo"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Vault extended information."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """etag for the resource."""

    __flattened_items = ["integrity_key", "encryption_key", "encryption_key_thumbprint", "algorithm"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VaultExtendedInfo"] = None,
        etag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VaultProperties(_Model):
    """Properties of the vault.

    :ivar provisioning_state: Provisioning State.
    :vartype provisioning_state: str
    :ivar upgrade_details: Details for upgrading vault.
    :vartype upgrade_details: ~azure.mgmt.recoveryservices.models.UpgradeDetails
    :ivar private_endpoint_connections: List of private endpoint connection.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.recoveryservices.models.PrivateEndpointConnectionVaultProperties]
    :ivar private_endpoint_state_for_backup: Private endpoint state for backup. Known values are:
     "None" and "Enabled".
    :vartype private_endpoint_state_for_backup: str or
     ~azure.mgmt.recoveryservices.models.VaultPrivateEndpointState
    :ivar private_endpoint_state_for_site_recovery: Private endpoint state for site recovery. Known
     values are: "None" and "Enabled".
    :vartype private_endpoint_state_for_site_recovery: str or
     ~azure.mgmt.recoveryservices.models.VaultPrivateEndpointState
    :ivar encryption: Customer Managed Key details of the resource.
    :vartype encryption: ~azure.mgmt.recoveryservices.models.VaultPropertiesEncryption
    :ivar move_details: The details of the latest move operation performed on the Azure Resource.
    :vartype move_details: ~azure.mgmt.recoveryservices.models.VaultPropertiesMoveDetails
    :ivar move_state: The State of the Resource after the move operation. Known values are:
     "Unknown", "InProgress", "PrepareFailed", "CommitFailed", "PrepareTimedout", "CommitTimedout",
     "MoveSucceeded", "Failure", "CriticalFailure", and "PartialSuccess".
    :vartype move_state: str or ~azure.mgmt.recoveryservices.models.ResourceMoveState
    :ivar backup_storage_version: Backup storage version. Known values are: "V1", "V2", and
     "Unassigned".
    :vartype backup_storage_version: str or
     ~azure.mgmt.recoveryservices.models.BackupStorageVersion
    :ivar public_network_access: property to enable or disable resource provider inbound network
     traffic from public clients. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.recoveryservices.models.PublicNetworkAccess
    :ivar monitoring_settings: Monitoring Settings of the vault.
    :vartype monitoring_settings: ~azure.mgmt.recoveryservices.models.MonitoringSettings
    :ivar restore_settings: Restore Settings of the vault.
    :vartype restore_settings: ~azure.mgmt.recoveryservices.models.RestoreSettings
    :ivar redundancy_settings: The redundancy Settings of a Vault.
    :vartype redundancy_settings:
     ~azure.mgmt.recoveryservices.models.VaultPropertiesRedundancySettings
    :ivar security_settings: Security Settings of the vault.
    :vartype security_settings: ~azure.mgmt.recoveryservices.models.SecuritySettings
    :ivar secure_score: Secure Score of Recovery Services Vault. Known values are: "None",
     "Minimum", "Adequate", and "Maximum".
    :vartype secure_score: str or ~azure.mgmt.recoveryservices.models.SecureScoreLevel
    :ivar bcdr_security_level: Security levels of Recovery Services Vault for business continuity
     and disaster recovery. Known values are: "Poor", "Fair", "Good", and "Excellent".
    :vartype bcdr_security_level: str or ~azure.mgmt.recoveryservices.models.BCDRSecurityLevel
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    """

    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Provisioning State."""
    upgrade_details: Optional["_models.UpgradeDetails"] = rest_field(
        name="upgradeDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Details for upgrading vault."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnectionVaultProperties"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """List of private endpoint connection."""
    private_endpoint_state_for_backup: Optional[Union[str, "_models.VaultPrivateEndpointState"]] = rest_field(
        name="privateEndpointStateForBackup", visibility=["read"]
    )
    """Private endpoint state for backup. Known values are: \"None\" and \"Enabled\"."""
    private_endpoint_state_for_site_recovery: Optional[Union[str, "_models.VaultPrivateEndpointState"]] = rest_field(
        name="privateEndpointStateForSiteRecovery", visibility=["read"]
    )
    """Private endpoint state for site recovery. Known values are: \"None\" and \"Enabled\"."""
    encryption: Optional["_models.VaultPropertiesEncryption"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer Managed Key details of the resource."""
    move_details: Optional["_models.VaultPropertiesMoveDetails"] = rest_field(
        name="moveDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """The details of the latest move operation performed on the Azure Resource."""
    move_state: Optional[Union[str, "_models.ResourceMoveState"]] = rest_field(name="moveState", visibility=["read"])
    """The State of the Resource after the move operation. Known values are: \"Unknown\",
     \"InProgress\", \"PrepareFailed\", \"CommitFailed\", \"PrepareTimedout\", \"CommitTimedout\",
     \"MoveSucceeded\", \"Failure\", \"CriticalFailure\", and \"PartialSuccess\"."""
    backup_storage_version: Optional[Union[str, "_models.BackupStorageVersion"]] = rest_field(
        name="backupStorageVersion", visibility=["read"]
    )
    """Backup storage version. Known values are: \"V1\", \"V2\", and \"Unassigned\"."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """property to enable or disable resource provider inbound network traffic from public clients.
     Known values are: \"Enabled\" and \"Disabled\"."""
    monitoring_settings: Optional["_models.MonitoringSettings"] = rest_field(
        name="monitoringSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Monitoring Settings of the vault."""
    restore_settings: Optional["_models.RestoreSettings"] = rest_field(
        name="restoreSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Restore Settings of the vault."""
    redundancy_settings: Optional["_models.VaultPropertiesRedundancySettings"] = rest_field(
        name="redundancySettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The redundancy Settings of a Vault."""
    security_settings: Optional["_models.SecuritySettings"] = rest_field(
        name="securitySettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Security Settings of the vault."""
    secure_score: Optional[Union[str, "_models.SecureScoreLevel"]] = rest_field(name="secureScore", visibility=["read"])
    """Secure Score of Recovery Services Vault. Known values are: \"None\", \"Minimum\", \"Adequate\",
     and \"Maximum\"."""
    bcdr_security_level: Optional[Union[str, "_models.BCDRSecurityLevel"]] = rest_field(
        name="bcdrSecurityLevel", visibility=["read"]
    )
    """Security levels of Recovery Services Vault for business continuity and disaster recovery. Known
     values are: \"Poor\", \"Fair\", \"Good\", and \"Excellent\"."""
    resource_guard_operation_requests: Optional[list[str]] = rest_field(
        name="resourceGuardOperationRequests", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardOperationRequests on which LAC check will be performed."""

    @overload
    def __init__(
        self,
        *,
        upgrade_details: Optional["_models.UpgradeDetails"] = None,
        encryption: Optional["_models.VaultPropertiesEncryption"] = None,
        move_details: Optional["_models.VaultPropertiesMoveDetails"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        monitoring_settings: Optional["_models.MonitoringSettings"] = None,
        restore_settings: Optional["_models.RestoreSettings"] = None,
        redundancy_settings: Optional["_models.VaultPropertiesRedundancySettings"] = None,
        security_settings: Optional["_models.SecuritySettings"] = None,
        resource_guard_operation_requests: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultPropertiesEncryption(_Model):
    """Customer Managed Key details of the resource.

    :ivar key_vault_properties: The properties of the Key Vault which hosts CMK.
    :vartype key_vault_properties: ~azure.mgmt.recoveryservices.models.CmkKeyVaultProperties
    :ivar kek_identity: The details of the identity used for CMK.
    :vartype kek_identity: ~azure.mgmt.recoveryservices.models.CmkKekIdentity
    :ivar infrastructure_encryption: Enabling/Disabling the Double Encryption state. Known values
     are: "Enabled" and "Disabled".
    :vartype infrastructure_encryption: str or
     ~azure.mgmt.recoveryservices.models.InfrastructureEncryptionState
    """

    key_vault_properties: Optional["_models.CmkKeyVaultProperties"] = rest_field(
        name="keyVaultProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the Key Vault which hosts CMK."""
    kek_identity: Optional["_models.CmkKekIdentity"] = rest_field(
        name="kekIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The details of the identity used for CMK."""
    infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryptionState"]] = rest_field(
        name="infrastructureEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enabling/Disabling the Double Encryption state. Known values are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        key_vault_properties: Optional["_models.CmkKeyVaultProperties"] = None,
        kek_identity: Optional["_models.CmkKekIdentity"] = None,
        infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryptionState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultPropertiesMoveDetails(_Model):
    """The details of the latest move operation performed on the Azure Resource.

    :ivar operation_id: OperationId of the Resource Move Operation.
    :vartype operation_id: str
    :ivar start_time_utc: Start Time of the Resource Move Operation.
    :vartype start_time_utc: ~datetime.datetime
    :ivar completion_time_utc: End Time of the Resource Move Operation.
    :vartype completion_time_utc: ~datetime.datetime
    :ivar source_resource_id: Source Resource of the Resource Move Operation.
    :vartype source_resource_id: str
    :ivar target_resource_id: Target Resource of the Resource Move Operation.
    :vartype target_resource_id: str
    """

    operation_id: Optional[str] = rest_field(name="operationId", visibility=["read"])
    """OperationId of the Resource Move Operation."""
    start_time_utc: Optional[datetime.datetime] = rest_field(name="startTimeUtc", visibility=["read"], format="rfc3339")
    """Start Time of the Resource Move Operation."""
    completion_time_utc: Optional[datetime.datetime] = rest_field(
        name="completionTimeUtc", visibility=["read"], format="rfc3339"
    )
    """End Time of the Resource Move Operation."""
    source_resource_id: Optional[str] = rest_field(name="sourceResourceId", visibility=["read"])
    """Source Resource of the Resource Move Operation."""
    target_resource_id: Optional[str] = rest_field(name="targetResourceId", visibility=["read"])
    """Target Resource of the Resource Move Operation."""


class VaultPropertiesRedundancySettings(_Model):
    """The redundancy Settings of a Vault.

    :ivar standard_tier_storage_redundancy: The storage redundancy setting of a vault. Known values
     are: "Invalid", "LocallyRedundant", "GeoRedundant", and "ZoneRedundant".
    :vartype standard_tier_storage_redundancy: str or
     ~azure.mgmt.recoveryservices.models.StandardTierStorageRedundancy
    :ivar cross_region_restore: Flag to show if Cross Region Restore is enabled on the Vault or
     not. Known values are: "Enabled" and "Disabled".
    :vartype cross_region_restore: str or ~azure.mgmt.recoveryservices.models.CrossRegionRestore
    """

    standard_tier_storage_redundancy: Optional[Union[str, "_models.StandardTierStorageRedundancy"]] = rest_field(
        name="standardTierStorageRedundancy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage redundancy setting of a vault. Known values are: \"Invalid\", \"LocallyRedundant\",
     \"GeoRedundant\", and \"ZoneRedundant\"."""
    cross_region_restore: Optional[Union[str, "_models.CrossRegionRestore"]] = rest_field(
        name="crossRegionRestore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag to show if Cross Region Restore is enabled on the Vault or not. Known values are:
     \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        standard_tier_storage_redundancy: Optional[Union[str, "_models.StandardTierStorageRedundancy"]] = None,
        cross_region_restore: Optional[Union[str, "_models.CrossRegionRestore"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultUsage(_Model):
    """Usages of a vault.

    :ivar unit: Unit of the usage. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", and "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.recoveryservices.models.UsagesUnit
    :ivar quota_period: Quota period of usage.
    :vartype quota_period: str
    :ivar next_reset_time: Next reset time of usage.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: Current value of usage.
    :vartype current_value: int
    :ivar limit: Limit of usage.
    :vartype limit: int
    :ivar name: Name of usage.
    :vartype name: ~azure.mgmt.recoveryservices.models.NameInfo
    """

    unit: Optional[Union[str, "_models.UsagesUnit"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Unit of the usage. Known values are: \"Count\", \"Bytes\", \"Seconds\", \"Percent\",
     \"CountPerSecond\", and \"BytesPerSecond\"."""
    quota_period: Optional[str] = rest_field(
        name="quotaPeriod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Quota period of usage."""
    next_reset_time: Optional[datetime.datetime] = rest_field(
        name="nextResetTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Next reset time of usage."""
    current_value: Optional[int] = rest_field(
        name="currentValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """Current value of usage."""
    limit: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Limit of usage."""
    name: Optional["_models.NameInfo"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of usage."""

    @overload
    def __init__(
        self,
        *,
        unit: Optional[Union[str, "_models.UsagesUnit"]] = None,
        quota_period: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.NameInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
