# TiUp manual

In the installation and management of various system software and application software, the package manager has a wide range of applications, the emergence of package management tools greatly simplifies the installation and upgrade of software maintenance work. For example, almost all Linux using RPM uses Yum for package management, while Anaconda makes it very easy to manage the python environment and related packages. In the early TiDB ecosystem, there was no dedicated package management tool, and users could only manage it manually through the appropriate configuration files and folder names.

Today, TiUP assumes the role of package manager as a new tool in the TiDB 4.0 ecosystem, managing numerous components (e.g. TiDB, PD, TiKV) within the TiDB ecosystem. When you want to run anything in the TiDB ecosystem, you just need to execute a single line of TiUP commands, which is much less difficult to manage than before.

## Installation

As a minimalist, TiUP is also very simple to install, with one command for both Darwin and Linux.

```bash
curl --proto '=https' --tlsv1.2 -sSf https://tiup-mirrors.pingcap.com/install.sh | sh
```

This command installs TiUP in the $HOME/.tiup folder, where the components installed and the data generated by their operation will also be placed. It also automatically adds $HOME/.tiup/bin to the PATH environment variable in the Shell Profile file, so you can use TiUP directly, for example, to see the version of TiUP.

```bash
tiup --version
```

## Key features

The direct function of TiUP is to be a package manager in the TiDB ecosystem, but this is not its ultimate mission. Its vision is to lower the threshold of use of all tools in the TiDB ecosystem to the limit, which cannot be done by package management functions alone.

In the TiUP world, any command can be followed by `--help` to get help information, such as the following command to get help information about TiUP itself:

```bash
$ tiup --help
TiUP is a command-line component management tool that can help to download and install
TiDB platform components to the local system. You can run a specific version of a component via
"tiup <component>[:version]". If no version number is specified, the latest version installed
locally will be used. If the specified component does not have any version installed locally,
the latest stable version will be downloaded from the repository.

Usage:
  tiup [flags] <command> [args...]
  tiup [flags] <component> [args...]

Available Commands:
  install     Install a specific version of a component
  list        List the available TiDB components or versions
  uninstall   Uninstall components or versions of a component
  update      Update tiup components to the latest version
  status      List the status of instantiated components
  clean       Clean the data of instantiated components
  help        Help about any command or component

Available Components:
  playground          Bootstrap a local TiDB cluster
  client              A simple mysql client to connect TiDB
  package             A toolbox to package tiup component
  cluster             Deploy a TiDB cluster for production
  mirrors             Build a local mirrors and download all selected components
  bench               Benchmark database with different workloads
  doc                 Online document for TiDB

Flags:
  -B, --binary <component>[:version]   Print binary path of a specific version of a component <component>[:version]
                                       and the latest version installed will be selected if no version specified
      --binpath string                 Specify the binary path of component instance
  -h, --help                           help for tiup
      --skip-version-check             Skip the strict version check, by default a version must be a valid SemVer string
  -T, --tag string                     Specify a tag for component instance
      --version                        version for tiup

Component instances with the same "tag" will share a data directory ($TIUP_HOME/data/$tag):
  $ tiup --tag mycluster playground

Examples:
  $ tiup playground                    # Quick start
  $ tiup playground nightly            # Start a playground with the latest nightly version
  $ tiup install <component>[:version] # Install a component of specific version
  $ tiup update --all                  # Update all installed components to the latest version
  $ tiup update --nightly              # Update all installed components to the nightly version
  $ tiup update --self                 # Update the "tiup" to the latest version
  $ tiup list                          # Fetch the latest supported components list
  $ tiup status                        # Display all running/terminated instances
  $ tiup clean <name>                  # Clean the data of running/terminated instance (Kill process if it's running)
  $ tiup clean --all                   # Clean the data of all running/terminated instances

Use "tiup [command] --help" for more information about a command.
```

The output of help information is long, but only two parts need to be focused on.
- Available commands
  - install: for installing components
  - list: View the list of available components
  - uninstall: uninstall components
  - update: update component version
  - status: View component run history
  - clean: clears the component run log
  - Help: Output help information.
- Available components
  - playground: Start cluster locally
  - client: cluster connected to the local machine
  - mirrors: cloning a private mirror from an official mirror
  - package: package a new component
  - bench: stress test the database
  - doc: Open online document

> **Note**
>
> The number of available components will continue to increase, depending on the output of the `tiup cluster list`.

The difference between a command and a component is that the command comes with TiUP and is used for package management operations, while the component is a separate package of components that TiUP installs through package management operations. For example, executing the command `tiup list` TiUP will run its own internal code directly, while executing the component `tiup playground` will first check if there is a local package called playground, if not, then download it from the image and run the package.

[Package management](./package-manage.md) chapter will introduce all the commands and the components will be divided into chapters according to the different components:
- [Local Rapid Deployment TiDB Cluster](./playground.md)
- [Online cluster deployment and operation](./cluster.md)
- [build private mirror](./mirrors.md)
- [package command](./package.md)
- [Bench marking](./bench.md)
