#ifndef RENDERSOURCE_H
#define RENDERSOURCE_H

#include "Source.h"
#include <cstddef>



class RenderSource : public Source
{
public:
    RenderSource(uint64_t id = 0);
    ~RenderSource();

    // implementation of source API
    void update (float dt) override;
    bool playing () const override { return !paused_; }
    void play (bool) override;
    void replay () override;
    void reload () override;
    bool playable () const  override { return true; }
    guint64 playtime () const override { return runtime_; }
    Failure failed () const override;
    uint texture() const override;
    void accept (Visitor& v) override;

    inline Session *session () const { return session_; }
    inline void setSession (Session *se) { session_ = se; }

    glm::vec3 resolution() const;

    typedef enum {
        RENDER_TEXTURE = 0,
        RENDER_PROJECTION = 1,
        RENDER_PROJECTION_SOURCE = 2,
        RENDER_CANVAS = 3
    } RenderSourceProvenance;
    static std::vector< std::tuple<int, int, std::string> > ProvenanceMethod;

    void setRenderingProvenance(RenderSourceProvenance m) { provenance_ = m; }
    RenderSourceProvenance renderingProvenance() const { return provenance_; }

    void setCanvasProvenance(size_t c) { canvas_index_ = c; }
    size_t canvasProvenance() const { return canvas_index_; }

    glm::ivec2 icon() const override;
    std::string info() const override;

protected:

    void init() override;
    Session *session_;
    uint64_t runtime_;

    FrameBuffer *rendered_output_;

    // control
    bool paused_;
    bool reset_;
    RenderSourceProvenance provenance_;
    size_t canvas_index_;
};


#endif // RENDERSOURCE_H
