/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javax.vecmath.Point3f;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;
import org.jmol.bspt.Node;

public class CubeIterator {
    Bspt bspt;
    Element[] stack;
    int sp;
    int leafIndex;
    Leaf leaf;
    float radius;
    float[] centerValues;
    private float cx;
    private float cy;
    private float cz;
    protected float dx;
    protected float dy;
    protected float dz;
    boolean tHemisphere;

    CubeIterator(Bspt bspt) {
        this.bspt = bspt;
        this.centerValues = new float[bspt.dimMax];
        this.stack = new Element[bspt.treeDepth];
    }

    public void initialize(Point3f point3f, float f) {
        this.radius = f;
        this.tHemisphere = false;
        this.cx = this.centerValues[0] = point3f.x;
        this.cy = this.centerValues[1] = point3f.y;
        this.cz = this.centerValues[2] = point3f.z;
        this.leaf = null;
        this.stack[0] = this.bspt.eleRoot;
        this.sp = 1;
        this.findLeftLeaf();
    }

    public void initializeHemisphere(Point3f point3f, float f) {
        this.initialize(point3f, f);
        this.tHemisphere = true;
    }

    public void release() {
        int n = this.bspt.treeDepth;
        while (--n >= 0) {
            this.stack[n] = null;
        }
    }

    public boolean hasMoreElements() {
        while (this.leaf != null) {
            while (this.leafIndex < this.leaf.count) {
                if (this.isWithinRadius(this.leaf.tuples[this.leafIndex])) {
                    return true;
                }
                ++this.leafIndex;
            }
            this.findLeftLeaf();
        }
        return false;
    }

    public Point3f nextElement() {
        return this.leaf.tuples[this.leafIndex++];
    }

    public float foundDistance2() {
        return this.dx * this.dx + this.dy * this.dy + this.dz * this.dz;
    }

    private void findLeftLeaf() {
        this.leaf = null;
        if (this.sp == 0) {
            return;
        }
        Element element = this.stack[--this.sp];
        while (element instanceof Node) {
            Node node = (Node)element;
            float f = this.centerValues[node.dim];
            float f2 = f + this.radius;
            float f3 = f;
            if (!this.tHemisphere || node.dim != 0) {
                f3 -= this.radius;
            }
            if (f3 <= node.maxLeft && f2 >= node.minLeft) {
                if (f2 >= node.minRight && f3 <= node.maxRight) {
                    this.stack[this.sp++] = node.eleRight;
                }
                element = node.eleLeft;
                continue;
            }
            if (f2 >= node.minRight && f3 <= node.maxRight) {
                element = node.eleRight;
                continue;
            }
            if (this.sp == 0) {
                return;
            }
            element = this.stack[--this.sp];
        }
        this.leaf = (Leaf)element;
        this.leafIndex = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isWithinRadius(Point3f point3f) {
        float f;
        float f2;
        float f3;
        this.dx = point3f.x - this.cx;
        if (this.tHemisphere) {
            if (!(this.dx >= 0.0f)) return false;
        }
        this.dx = Math.abs(this.dx);
        if (!(f3 <= this.radius)) return false;
        this.dy = Math.abs(point3f.y - this.cy);
        if (!(f2 <= this.radius)) return false;
        this.dz = Math.abs(point3f.z - this.cz);
        if (!(f <= this.radius)) return false;
        return true;
    }
}

